/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.unix;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.concurrent.TimeUnit;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.primitives.otherlibs.unix.Unix;
import org.ocamljava.runtime.util.PermissionsUtils;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="unix", module="Unix", source="otherlibs/unix/stat.c")
public final class Stat {
    private Stat() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.PARTIAL, comment={"The following restrictions apply to data accuracy:", "device number, inode number, number of links and", "device minor number are set to zero; both user and", "group ID are set to one; file kind is set to one if it", "is a directory, to four if is is a link, to zero otherwise;", "modification and status change time are set to", "modification time."}, parameterTypes={"string"}, returnType="Unix.stats")
    public static Value unix_stat(Value path) throws Fail.Exception {
        return Stat.createStats(false, CurrentContext.getFilesState().getRealFile(path));
    }

    @Primitive(compatibility=PrimitiveCompatibility.PARTIAL, comment={"Exact synonym of [unix_stat]."}, parameterTypes={"string"}, returnType="Unix.stats")
    public static Value unix_lstat(Value path) throws Fail.Exception {
        return Stat.unix_stat(path);
    }

    @Primitive(compatibility=PrimitiveCompatibility.NOT_IMPLEMENTED, parameterTypes={"Unix.file_descr"}, returnType="Unix.stats")
    public static Value unix_fstat(Value fd) throws Fail.Exception {
        Fail.invalidArgument("Unix.fstat not implemented");
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.PARTIAL, comment={"The restrictions of [unix_stat] apply."}, parameterTypes={"Unix.file_descr"}, returnType="Unix.stats")
    public static Value unix_stat_64(Value path) throws Fail.Exception {
        return Stat.createStats(true, CurrentContext.getFilesState().getRealFile(path));
    }

    @Primitive(compatibility=PrimitiveCompatibility.PARTIAL, comment={"Exact synonym of [unix_stat_64]."}, parameterTypes={"string"}, returnType="Unix.stats")
    public static Value unix_lstat_64(Value path) throws Fail.Exception {
        return Stat.unix_stat_64(path);
    }

    @Primitive(compatibility=PrimitiveCompatibility.NOT_IMPLEMENTED, parameterTypes={"Unix.file_descr"}, returnType="Unix.stats")
    public static Value unix_fstat_64(Value fd) throws Fail.Exception {
        Fail.invalidArgument("Unix.fstat_64 not implemented");
        return Value.UNIT;
    }

    private static Value createStats(boolean use64, File f) throws Fail.Exception {
        Path p = f.toPath();
        if (!f.exists()) {
            Unix.fail("stat", "file does not exist");
            return Value.UNIT;
        }
        double modifTime = (double)f.lastModified() / 1000.0;
        double accTime = (double)f.lastModified() / 1000.0;
        try {
            BasicFileAttributes bfa = Files.readAttributes(p, BasicFileAttributes.class, new LinkOption[0]);
            modifTime = bfa.lastModifiedTime().to(TimeUnit.SECONDS);
            accTime = bfa.lastAccessTime().to(TimeUnit.SECONDS);
        }
        catch (Exception e) {
            // empty catch block
        }
        Value length = use64 ? Value.createInt64(f.length()) : Value.createLong((int)f.length());
        Value perms = Value.ZERO;
        try {
            perms = Value.createLong(PermissionsUtils.getPermissions(f));
        }
        catch (IOException ioe) {
            // empty catch block
        }
        boolean symLink = false;
        try {
            symLink = Files.readSymbolicLink(p) != null;
        }
        catch (Exception e) {
            // empty catch block
        }
        Value res = Value.createBlock(0, 12L);
        res.set0(Value.ZERO);
        res.set1(Value.ZERO);
        res.set2(symLink ? Value.FOUR : (f.isDirectory() ? Value.ONE : Value.ZERO));
        res.set3(perms);
        res.set4(Value.ZERO);
        res.set5(Value.ONE);
        res.set6(Value.ONE);
        res.set7(Value.ZERO);
        res.set(8, length);
        res.set(9, Value.createDouble(accTime));
        res.set(10, Value.createDouble(modifTime));
        res.set(11, Value.createDouble(modifTime));
        return res;
    }
}

