/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.support.toplevel;

import java.io.File;
import java.io.IOException;
import java.security.AccessControlException;
import org.ocamljava.runtime.support.toplevel.AbstractTopLevel;
import org.ocamljava.runtime.util.RandomAccessInputStream;

public final class TopLevel
extends AbstractTopLevel {
    private TopLevel(File file, String[] args) throws IOException {
        super(file.getAbsolutePath(), new RandomAccessInputStream(file), args, null, true);
    }

    public static void main(String[] args) {
        File ocaml = TopLevel.getOCamlFullPath(".");
        if (ocaml == null) {
            System.out.println("unable to locate ocaml toplevel");
            System.exit(1);
        }
        TopLevel top = null;
        try {
            top = new TopLevel(ocaml, args);
        }
        catch (IOException ioe) {
            System.out.println("unable to load toplevel from file " + ocaml.getAbsolutePath());
            System.exit(1);
        }
        top.createFrame();
    }

    static File getOCamlFullPath(String ... addPath) {
        assert (addPath != null) : "null addPath";
        try {
            String path = System.getenv("PATH");
            for (String pathElement : path.split(File.pathSeparator)) {
                File f = new File(pathElement, "ocaml");
                if (!f.exists() || !f.isFile()) continue;
                return f;
            }
        }
        catch (AccessControlException rp) {
            // empty catch block
        }
        for (String pathElement : addPath) {
            File f = new File(pathElement, "ocaml");
            if (!f.exists() || !f.isFile()) continue;
            return f;
        }
        return null;
    }
}

