/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.kernel;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.ocamljava.runtime.context.CodeState;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.AbstractNativeRunner;
import org.ocamljava.runtime.kernel.ByteCodeRunner;
import org.ocamljava.runtime.kernel.Channel;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.kernel.Misc;
import org.ocamljava.runtime.kernel.OCamlJavaException;
import org.ocamljava.runtime.values.Value;

public final class StandardError {
    private StandardError() {
    }

    public static void reportNativeException(AbstractNativeRunner abstractNativeRunner, Throwable throwable) {
        Context context = CurrentContext.CONTEXT;
        Channel channel = context.getFilesState().getChannel(2);
        if (channel != null) {
            PrintStream printStream = new PrintStream(channel.newOutputStream(), true);
            if (throwable instanceof Fail.Exception) {
                String string = Misc.convertException(((Fail.Exception)throwable).asValue(), null);
                printStream.println("Fatal error: exception " + string);
                if (context.getCodeState().isBacktraceActive()) {
                    abstractNativeRunner.printExceptionBacktrace(printStream);
                }
            } else if (throwable instanceof Fatal.Exception) {
                printStream.println(((Fatal.Exception)throwable).getMessage());
            } else {
                printStream.println(throwable.toString());
            }
        }
    }

    public static void reportBytecodeException(ByteCodeRunner byteCodeRunner, Throwable throwable) throws OCamlJavaException {
        PrintStream printStream;
        ByteArrayOutputStream byteArrayOutputStream;
        Context context = CurrentContext.CONTEXT;
        Channel channel = context.getFilesState().getChannel(2);
        if (channel != null && channel.isOutputChannel()) {
            byteArrayOutputStream = null;
            printStream = new PrintStream(channel.newOutputStream(), true);
        } else {
            byteArrayOutputStream = new ByteArrayOutputStream();
            printStream = new PrintStream(byteArrayOutputStream, true);
        }
        if (throwable instanceof Fail.Exception) {
            CodeState codeState = context.getCodeState();
            Value value = codeState.getGlobalData();
            String string = Misc.convertException(((Fail.Exception)throwable).asValue(value), value);
            printStream.println("Fatal error: exception " + string);
            if (codeState.isBacktraceActive() && !context.getDebuggerState().isDebuggerInUse()) {
                byteCodeRunner.printExceptionBacktrace(printStream);
            }
            if (byteArrayOutputStream == null) {
                printStream.close();
            }
            throw new OCamlJavaException(byteArrayOutputStream != null ? byteArrayOutputStream.toString() : "program exception", throwable);
        }
        if (throwable instanceof Fatal.Exception) {
            printStream.println(((Fatal.Exception)throwable).getMessage());
            if (byteArrayOutputStream == null) {
                printStream.close();
            }
            throw new OCamlJavaException(byteArrayOutputStream != null ? byteArrayOutputStream.toString() : "fatal error", throwable);
        }
        printStream.println(throwable.toString());
        if (byteArrayOutputStream == null) {
            printStream.close();
        }
        throw new OCamlJavaException(byteArrayOutputStream != null ? byteArrayOutputStream.toString() : "internal error", throwable);
    }

    public static void reportThreadException(Thread thread, Throwable throwable) {
        Channel channel = CurrentContext.FILES_STATE.getChannel(2);
        if (channel != null) {
            PrintStream printStream = new PrintStream(channel.newOutputStream(), true);
            printStream.printf("Thread '%s' raised an exception: ", thread.getName());
            if (throwable instanceof Fail.Exception) {
                Value value = ((Fail.Exception)throwable).asValue();
                printStream.println(Misc.convertException(value, null));
            } else {
                printStream.println(throwable.getClass().getName());
            }
        }
    }
}

