/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.unix;

import java.util.Iterator;
import java.util.Map;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="unix", module="Unix", source="otherlibs/unix/envir.c")
public final class Envir {
    private Envir() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="string array")
    public static Value unix_environment(Value value) {
        try {
            Map<String, String> map = System.getenv();
            int n = map.size();
            if (n <= 0) {
                return CurrentContext.CODE_STATE.getAtom(0);
            }
            Value value2 = Value.createBlock(0, n + 1);
            value2.set(0, Value.createString("OCAMLJAVA_VERSION=2.0-early-access11"));
            int n2 = 1;
            Iterator<Map.Entry<String, String>> iterator = map.entrySet().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return value2;
                }
                Map.Entry<String, String> entry = iterator.next();
                value2.set(n2++, Value.createString(entry.getKey() + "=" + entry.getValue()));
            }
        }
        catch (SecurityException securityException) {
            return Value.createBlock(0, 0L);
        }
    }
}

