/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.values;

import java.util.Arrays;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.values.AbstractDoubleArrayValue;
import org.ocamljava.runtime.values.BlockValue;
import org.ocamljava.runtime.values.CustomOperations;
import org.ocamljava.runtime.values.DoubleArrayValue0;
import org.ocamljava.runtime.values.DoubleArrayValue1;
import org.ocamljava.runtime.values.DoubleArrayValue2;
import org.ocamljava.runtime.values.DoubleArrayValue3;
import org.ocamljava.runtime.values.DoubleArrayValue4;
import org.ocamljava.runtime.values.DoubleArrayValue5;
import org.ocamljava.runtime.values.DoubleArrayValue6;
import org.ocamljava.runtime.values.DoubleArrayValue7;
import org.ocamljava.runtime.values.DoubleArrayValue8;
import org.ocamljava.runtime.values.Value;

public final class DoubleArrayValue
extends AbstractDoubleArrayValue {
    private int sizeTagged;
    private int sizeMinusOneTagged;
    private Value sizeWrapped;
    private double[] values;

    DoubleArrayValue(int n) {
        super(254, (long)n * 1L);
        this.values = new double[n];
        this.sizeTagged = n << 1 | 1;
        this.sizeMinusOneTagged = n - 1 << 1 | 1;
        this.sizeWrapped = Value.createLong(n);
    }

    DoubleArrayValue(double[] dArray) {
        super(254, (long)dArray.length * 1L);
        int n = dArray.length;
        this.values = dArray;
        this.sizeTagged = n << 1 | 1;
        this.sizeMinusOneTagged = n - 1 << 1 | 1;
        this.sizeWrapped = Value.createLong(n);
    }

    @Override
    public double getDouble(long l) throws ArrayIndexOutOfBoundsException {
        return this.values[(int)l];
    }

    @Override
    public double getDouble(int n) throws ArrayIndexOutOfBoundsException {
        return this.values[n];
    }

    @Override
    public double getDouble0() {
        return this.values[0];
    }

    @Override
    public double getDouble1() {
        return this.values[1];
    }

    @Override
    public double getDouble2() {
        return this.values[2];
    }

    @Override
    public double getDouble3() {
        return this.values[3];
    }

    @Override
    public double getDouble4() {
        return this.values[4];
    }

    @Override
    public double getDouble5() {
        return this.values[5];
    }

    @Override
    public double getDouble6() {
        return this.values[6];
    }

    @Override
    public double getDouble7() {
        return this.values[7];
    }

    @Override
    public void setDouble(long l, double d) throws ArrayIndexOutOfBoundsException {
        this.values[(int)l] = d;
    }

    @Override
    public void setDouble(int n, double d) throws ArrayIndexOutOfBoundsException {
        this.values[n] = d;
    }

    @Override
    public void setDouble0(double d) {
        this.values[0] = d;
    }

    @Override
    public void setDouble1(double d) {
        this.values[1] = d;
    }

    @Override
    public void setDouble2(double d) {
        this.values[2] = d;
    }

    @Override
    public void setDouble3(double d) {
        this.values[3] = d;
    }

    @Override
    public void setDouble4(double d) {
        this.values[4] = d;
    }

    @Override
    public void setDouble5(double d) {
        this.values[5] = d;
    }

    @Override
    public void setDouble6(double d) {
        this.values[6] = d;
    }

    @Override
    public void setDouble7(double d) {
        this.values[7] = d;
    }

    @Override
    public long sizeDoubles() {
        return this.values.length;
    }

    @Override
    public long arrayLength() {
        return this.values.length;
    }

    @Override
    public long arrayLengthTagged() {
        return this.sizeTagged;
    }

    @Override
    public long arrayLengthMinusOneTagged() {
        return this.sizeMinusOneTagged;
    }

    @Override
    public Value arrayLengthWrapped() {
        return this.sizeWrapped;
    }

    @Override
    protected void truncateInstance(long l) {
        int n = (int)(l / 1L);
        this.values = Arrays.copyOf(this.values, n);
        this.sizeTagged = n << 1 | 1;
        this.sizeMinusOneTagged = n - 1 << 1 | 1;
        this.sizeWrapped = Value.createLong(n);
    }

    @Override
    public void copy(BlockValue blockValue) {
        int n = (int)Math.min((long)this.values.length, blockValue.sizeDoubles());
        for (int i = 0; i < n; ++i) {
            this.values[i] = blockValue.getDouble(i);
        }
    }

    @Override
    public DoubleArrayValue duplicate() {
        int n = this.values.length;
        DoubleArrayValue doubleArrayValue = new DoubleArrayValue(n);
        System.arraycopy(this.values, 0, doubleArrayValue.values, 0, n);
        return doubleArrayValue;
    }

    @Override
    public void copyValuesIntoArray(Value[] valueArray) {
        int n = this.values.length;
        for (int i = 0; i < n; ++i) {
            valueArray[i] = Value.createDouble(this.values[i]);
        }
    }

    @Override
    public void copyValuesIntoArray(Value[] valueArray, int n) {
        int n2 = this.values.length;
        for (int i = 0; i < n2; ++i) {
            valueArray[n + i] = Value.createDouble(this.values[i]);
        }
    }

    @Override
    public void copyDoublesIntoArray(double[] dArray, int n) {
        System.arraycopy(this.values, 0, dArray, n, this.values.length);
    }

    @Override
    public void copyRawLongsIntoArray(long[] lArray, int n) {
        int n2 = this.values.length;
        for (int i = 0; i < n2; ++i) {
            lArray[n + i] = (long)this.values[i];
        }
    }

    @Override
    public Value subArray(long l, long l2) {
        int n = (int)l2;
        int n2 = (int)l;
        switch (n) {
            case 0: {
                return new DoubleArrayValue0();
            }
            case 1: {
                return new DoubleArrayValue1(this.values[n2 + 0]);
            }
            case 2: {
                return new DoubleArrayValue2(this.values[n2 + 0], this.values[n2 + 1]);
            }
            case 3: {
                return new DoubleArrayValue3(this.values[n2 + 0], this.values[n2 + 1], this.values[n2 + 2]);
            }
            case 4: {
                return new DoubleArrayValue4(this.values[n2 + 0], this.values[n2 + 1], this.values[n2 + 2], this.values[n2 + 3]);
            }
            case 5: {
                return new DoubleArrayValue5(this.values[n2 + 0], this.values[n2 + 1], this.values[n2 + 2], this.values[n2 + 3], this.values[n2 + 4]);
            }
            case 6: {
                return new DoubleArrayValue6(this.values[n2 + 0], this.values[n2 + 1], this.values[n2 + 2], this.values[n2 + 3], this.values[n2 + 4], this.values[n2 + 5]);
            }
            case 7: {
                return new DoubleArrayValue7(this.values[n2 + 0], this.values[n2 + 1], this.values[n2 + 2], this.values[n2 + 3], this.values[n2 + 4], this.values[n2 + 5], this.values[n2 + 6]);
            }
            case 8: {
                return new DoubleArrayValue8(this.values[n2 + 0], this.values[n2 + 1], this.values[n2 + 2], this.values[n2 + 3], this.values[n2 + 4], this.values[n2 + 5], this.values[n2 + 6], this.values[n2 + 7]);
            }
        }
        double[] dArray = new double[n];
        System.arraycopy(this.values, n2, dArray, 0, n);
        return new DoubleArrayValue(dArray);
    }

    @Override
    public void blitArray(long l, Value value, long l2, long l3) {
        if (value instanceof DoubleArrayValue) {
            DoubleArrayValue doubleArrayValue = (DoubleArrayValue)value;
            System.arraycopy(this.values, (int)l, doubleArrayValue.values, (int)l2, (int)l3);
        } else if (l2 < l) {
            for (long i = 0L; i < l3; ++i) {
                value.setDouble(l2 + i, this.getDouble(l + i));
            }
        } else {
            for (long i = l3 - 1L; i >= 0L; --i) {
                value.setDouble(l2 + i, this.getDouble(l + i));
            }
        }
    }

    public int hashCode() {
        int n = 0;
        int n2 = Math.min(32, this.values.length);
        for (int i = 0; i < n2; ++i) {
            n += (int)Double.doubleToRawLongBits(this.values[i]);
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object instanceof DoubleArrayValue) {
            DoubleArrayValue doubleArrayValue = (DoubleArrayValue)object;
            return Arrays.equals(this.values, doubleArrayValue.values);
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DoubleArrayValue(");
        int n = this.values.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.values[i]);
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    public void setParent(BlockValue blockValue) {
        assert (false) : "setParent(BlockValue) called on an instance of " + this.getClass();
    }

    @Override
    public BlockValue getParent() {
        assert (false) : "getParent() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public CustomOperations getCustomOperations() {
        assert (false) : "getCustomOperations() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public Object asCustom() {
        assert (false) : "asCustom() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public void setCustom(Object object) {
        assert (false) : "setCustom(Object) called on an instance of " + this.getClass();
    }

    @Override
    public int asInt32() {
        assert (false) : "asInt32() called on an instance of " + this.getClass();
        return 0;
    }

    @Override
    public void setInt32(int n) {
        assert (false) : "setInt32(int) called on an instance of " + this.getClass();
    }

    @Override
    public long asInt64() {
        assert (false) : "asInt64() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public void setInt64(long l) {
        assert (false) : "setInt64(int) called on an instance of " + this.getClass();
    }

    @Override
    public long asNativeInt() {
        assert (false) : "asNativeInt() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public void setNativeInt(long l) {
        assert (false) : "setNativeInt(long) called on an instance of " + this.getClass();
    }

    @Override
    public int asCastedInt() {
        return -1;
    }

    @Override
    public int asBoundedInt() throws Fatal.Exception {
        return -1;
    }

    @Override
    public long getCode() {
        assert (this.getTag() == 247 || this.getTag() == 249) : "getCode() called on an instance of " + this.getClass();
        return this.get0().asCodeOffset();
    }

    @Override
    public void setCode(long l) {
        assert (this.getTag() == 247 || this.getTag() == 249) : "setCode(long) called on an instance of " + this.getClass();
        this.set0(Value.createCodeOffset(l));
    }

    @Override
    public double asDouble() {
        assert (false) : "asDouble() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public void setDouble(double d) {
        assert (false) : "setDouble(double) called on an instance of " + this.getClass();
    }

    @Override
    public Value getWeak(long l) throws ArrayIndexOutOfBoundsException {
        assert (false) : "getWeak(long) called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public void setWeak(long l, Value value) throws ArrayIndexOutOfBoundsException {
        assert (false) : "setWeak(long, Value) called on an instance of " + this.getClass();
    }

    @Override
    public long sizeWeakValues() {
        assert (false) : "sizeWeakValues() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public long sizeBytes() {
        assert (false) : "sizeBytes() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public long sizeBytesTagged() {
        assert (false) : "sizeBytesTagged() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public long sizeBytesMinusOneTagged() {
        assert (false) : "sizeBytesMinusOneTagged() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public Value sizeBytesWrapped() {
        assert (false) : "sizeBytesWrapped() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public String asString() {
        assert (false) : "asString() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public byte[] getBytes() {
        assert (false) : "getBytes() called on an instance of " + this.getClass();
        return new byte[0];
    }

    @Override
    public byte[] getBytesForModification() {
        assert (false) : "getBytesForModification() called on an instance of " + this.getClass();
        return new byte[0];
    }

    @Override
    public int[] getUnsignedBytes() {
        assert (false) : "getUnsignedBytes() called on an instance of " + this.getClass();
        return new int[0];
    }

    @Override
    public byte getByte(long l) throws ArrayIndexOutOfBoundsException {
        assert (false) : "getByte(long) called on an instance of " + this.getClass();
        return 0;
    }

    @Override
    public void setByte(long l, byte by) throws ArrayIndexOutOfBoundsException {
        assert (false) : "setByte(long, byte) called on an instance of " + this.getClass();
    }

    @Override
    public int getUnsignedByte(long l) throws ArrayIndexOutOfBoundsException {
        assert (false) : "getUnsignedByte(long) called on an instance of " + this.getClass();
        return 0;
    }

    @Override
    public void setUnsignedByte(long l, int n) throws ArrayIndexOutOfBoundsException {
        assert (false) : "setUnsignedByte(long, int) called on an instance of " + this.getClass();
    }

    @Override
    public void set(Value value, long l) throws ArrayIndexOutOfBoundsException {
        assert (value != null) : "null x";
        this.values[(int)l] = value.asDouble();
    }

    @Override
    public long sizeLongs() {
        return this.values.length;
    }

    @Override
    public void setRawLong(int n, long l) throws ArrayIndexOutOfBoundsException {
        this.values[n] = l;
    }

    @Override
    public void setRawLong(long l, long l2) throws ArrayIndexOutOfBoundsException {
        this.values[(int)l] = l2;
    }

    @Override
    public long getRawLong(int n) throws ArrayIndexOutOfBoundsException {
        return (long)this.values[n];
    }

    @Override
    public long getRawLong(long l) throws ArrayIndexOutOfBoundsException {
        return (long)this.values[(int)l];
    }

    @Override
    public Value get(int n) throws ArrayIndexOutOfBoundsException {
        return Value.createDouble(this.values[n]);
    }

    @Override
    public Value get(long l) throws ArrayIndexOutOfBoundsException {
        return Value.createDouble(this.values[(int)l]);
    }

    @Override
    public void set(int n, Value value) throws ArrayIndexOutOfBoundsException {
        this.values[n] = value.asDouble();
    }

    @Override
    public void set(long l, Value value) throws ArrayIndexOutOfBoundsException {
        this.values[(int)l] = value.asDouble();
    }

    @Override
    public double getGenericDouble(int n) throws ArrayIndexOutOfBoundsException {
        return this.values[n];
    }

    @Override
    public double getGenericDouble(long l) throws ArrayIndexOutOfBoundsException {
        return this.values[(int)l];
    }

    @Override
    public void setGenericDouble(int n, double d) throws ArrayIndexOutOfBoundsException {
        this.values[n] = d;
    }

    @Override
    public void setGenericDouble(long l, double d) throws ArrayIndexOutOfBoundsException {
        this.values[(int)l] = d;
    }

    @Override
    public void setRawLong0(long l) {
        this.values[0] = l;
    }

    @Override
    public long getRawLong0() {
        return (long)this.values[0];
    }

    @Override
    public void set0(Value value) {
        this.values[0] = value.asDouble();
    }

    @Override
    public Value get0() {
        return Value.createDouble(this.values[0]);
    }

    @Override
    public void setGenericDouble0(double d) {
        this.values[0] = d;
    }

    @Override
    public double getGenericDouble0() {
        return this.values[0];
    }

    @Override
    public void setRawLong1(long l) {
        this.values[1] = l;
    }

    @Override
    public long getRawLong1() {
        return (long)this.values[1];
    }

    @Override
    public void set1(Value value) {
        this.values[1] = value.asDouble();
    }

    @Override
    public Value get1() {
        return Value.createDouble(this.values[1]);
    }

    @Override
    public void setGenericDouble1(double d) {
        this.values[1] = d;
    }

    @Override
    public double getGenericDouble1() {
        return this.values[1];
    }

    @Override
    public void setRawLong2(long l) {
        this.values[2] = l;
    }

    @Override
    public long getRawLong2() {
        return (long)this.values[2];
    }

    @Override
    public void set2(Value value) {
        this.values[2] = value.asDouble();
    }

    @Override
    public Value get2() {
        return Value.createDouble(this.values[2]);
    }

    @Override
    public void setGenericDouble2(double d) {
        this.values[2] = d;
    }

    @Override
    public double getGenericDouble2() {
        return this.values[2];
    }

    @Override
    public void setRawLong3(long l) {
        this.values[3] = l;
    }

    @Override
    public long getRawLong3() {
        return (long)this.values[3];
    }

    @Override
    public void set3(Value value) {
        this.values[3] = value.asDouble();
    }

    @Override
    public Value get3() {
        return Value.createDouble(this.values[3]);
    }

    @Override
    public void setGenericDouble3(double d) {
        this.values[3] = d;
    }

    @Override
    public double getGenericDouble3() {
        return this.values[3];
    }

    @Override
    public void setRawLong4(long l) {
        this.values[4] = l;
    }

    @Override
    public long getRawLong4() {
        return (long)this.values[4];
    }

    @Override
    public void set4(Value value) {
        this.values[4] = value.asDouble();
    }

    @Override
    public Value get4() {
        return Value.createDouble(this.values[4]);
    }

    @Override
    public void setGenericDouble4(double d) {
        this.values[4] = d;
    }

    @Override
    public double getGenericDouble4() {
        return this.values[4];
    }

    @Override
    public void setRawLong5(long l) {
        this.values[5] = l;
    }

    @Override
    public long getRawLong5() {
        return (long)this.values[5];
    }

    @Override
    public void set5(Value value) {
        this.values[5] = value.asDouble();
    }

    @Override
    public Value get5() {
        return Value.createDouble(this.values[5]);
    }

    @Override
    public void setGenericDouble5(double d) {
        this.values[5] = d;
    }

    @Override
    public double getGenericDouble5() {
        return this.values[5];
    }

    @Override
    public void setRawLong6(long l) {
        this.values[6] = l;
    }

    @Override
    public long getRawLong6() {
        return (long)this.values[6];
    }

    @Override
    public void set6(Value value) {
        this.values[6] = value.asDouble();
    }

    @Override
    public Value get6() {
        return Value.createDouble(this.values[6]);
    }

    @Override
    public void setGenericDouble6(double d) {
        this.values[6] = d;
    }

    @Override
    public double getGenericDouble6() {
        return this.values[6];
    }

    @Override
    public void setRawLong7(long l) {
        this.values[7] = l;
    }

    @Override
    public long getRawLong7() {
        return (long)this.values[7];
    }

    @Override
    public void set7(Value value) {
        this.values[7] = value.asDouble();
    }

    @Override
    public Value get7() {
        return Value.createDouble(this.values[7]);
    }

    @Override
    public void setGenericDouble7(double d) {
        this.values[7] = d;
    }

    @Override
    public double getGenericDouble7() {
        return this.values[7];
    }
}

