/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.kernel;

import java.io.PrintStream;
import java.util.LinkedList;
import java.util.List;
import org.ocamljava.runtime.context.CodeState;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.AbstractCodeRunner;
import org.ocamljava.runtime.kernel.AtExit;
import org.ocamljava.runtime.kernel.CodeRunner;
import org.ocamljava.runtime.kernel.Debugger;
import org.ocamljava.runtime.kernel.Dispatcher;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.kernel.Instructions;
import org.ocamljava.runtime.kernel.Interpreter;
import org.ocamljava.runtime.kernel.LocInfo;
import org.ocamljava.runtime.kernel.OCamlJavaException;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.kernel.Signals;
import org.ocamljava.runtime.kernel.ValueStack;
import org.ocamljava.runtime.parameters.ByteCodeParameters;
import org.ocamljava.runtime.primitives.otherlibs.systhreads.ThreadStatus;
import org.ocamljava.runtime.util.IntegerUtils;
import org.ocamljava.runtime.values.BlockValue;
import org.ocamljava.runtime.values.Value;

public final class ByteCodeRunner
extends AbstractCodeRunner
implements Instructions {
    private final Interpreter interpreter;
    private ValueStack stack;
    private Value env;
    private Value result;
    private Throwable exception;
    private final List<Integer> backtraceBuffer;
    private Value backtraceLastException;

    public ByteCodeRunner(Interpreter interpreter, Value value, boolean bl) {
        super(interpreter.getContext());
        assert (interpreter != null) : "null interp";
        this.interpreter = interpreter;
        ByteCodeParameters byteCodeParameters = (ByteCodeParameters)this.context.getParameters();
        this.stack = new ValueStack(bl ? byteCodeParameters.getInitStackSize() : byteCodeParameters.getInitStackSize() / 4);
        this.threadStatus = value;
        this.env = null;
        this.backtraceBuffer = new LinkedList<Integer>();
        this.backtraceLastException = Value.UNIT;
    }

    @Override
    public void clearBacktraceInfo() {
        this.backtraceBuffer.clear();
    }

    @Override
    public CodeRunner createNewThread(Value value) {
        return new ByteCodeRunner(this.interpreter, value, false);
    }

    @Override
    public Value callback(Value value, Value ... valueArray) throws Fail.Exception, Fatal.Exception, OCamlJavaException, FalseExit {
        Throwable throwable;
        assert (value != null) : "null closure";
        assert (valueArray != null) : "null params";
        assert (valueArray.length + 4 <= 256) : "params is too long";
        Thread thread = Thread.currentThread();
        boolean bl = thread instanceof OCamlJavaThread;
        if (!bl) {
            this.context.getThreadsState().addAdditionalThread(thread);
        }
        ByteCodeRunner byteCodeRunner = new ByteCodeRunner(this.interpreter, null, false);
        byteCodeRunner.setup(value, valueArray);
        byteCodeRunner.run();
        if (!bl) {
            this.context.getThreadsState().removeAdditionalThread(thread);
        }
        if ((throwable = byteCodeRunner.getException()) == null) {
            return byteCodeRunner.getResult();
        }
        if (throwable instanceof Fail.Exception) {
            throw (Fail.Exception)throwable;
        }
        if (throwable instanceof Fatal.Exception) {
            throw (Fatal.Exception)throwable;
        }
        if (byteCodeRunner.exception instanceof FalseExit) {
            AtExit.execute(this);
            throw (FalseExit)byteCodeRunner.exception;
        }
        Fatal.raise("error in callback: " + byteCodeRunner.exception);
        return Value.UNIT;
    }

    public Interpreter getInterpreter() {
        return this.interpreter;
    }

    public ValueStack getStack() {
        return this.stack;
    }

    public void resizeStack(int n) throws Fail.Exception {
        block4: {
            ByteCodeParameters byteCodeParameters = (ByteCodeParameters)this.context.getParameters();
            if (n > byteCodeParameters.getMaxStackSize()) {
                Fail.raiseStackOverflow();
            }
            int n2 = this.stack.maxSize();
            if (n2 >= n) break block4;
            try {
                ValueStack valueStack = new ValueStack(n);
                valueStack.pushSlice(this.stack.popSlice(this.stack.size()));
                this.stack = valueStack;
            }
            catch (Throwable throwable) {
                Fail.raiseStackOverflow();
            }
        }
    }

    public Value getEnv() {
        return this.env;
    }

    @Override
    public void run() {
        this.exception = null;
        this.result = null;
        try {
            this.result = this.interprete(this.closure, this.args);
        }
        catch (Throwable throwable) {
            this.exception = throwable;
        }
        if (this.threadStatus != null) {
            ((ThreadStatus)this.threadStatus.get(2L).asCustom()).terminate();
        }
    }

    Throwable getException() {
        return this.exception;
    }

    public Value getResult() {
        return this.result;
    }

    /*
     * Handled duff style switch with additional control
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Value interprete(Value value, Value ... valueArray) throws Fail.Exception, Fatal.Exception, OCamlJavaException {
        int n;
        int n2;
        Value value2 = Value.UNIT;
        CodeState codeState = this.context.getCodeState();
        this.env = codeState.getAtom(0);
        int n3 = 0;
        int n4 = -1;
        this.stack.pop(this.stack.size());
        if (value != null) {
            this.stack.push(value);
            this.stack.push(Value.ZERO);
            this.stack.push(Value.UNIT);
            this.stack.push(Value.createCodeOffset(codeState.getCallbackTail()));
            n2 = valueArray.length;
            for (int i = n2 - 1; i >= 0; --i) {
                this.stack.push(valueArray[i]);
            }
            value2 = this.stack.peek(n2 + 3);
            n3 = n2 - 1;
            n = (int)value2.getCode();
            this.env = value2;
        } else {
            n = 0;
        }
        try {
            Debugger.handleEvent(this, Debugger.EventKind.PROGRAM_START);
        }
        catch (FalseExit falseExit) {
            return Value.createLong(falseExit.getExitCode());
        }
        n2 = 0;
        Fail.Exception exception = null;
        Value value3 = null;
        block169: while (true) {
            exception = null;
            int[] nArray = codeState.getCode();
            Dispatcher dispatcher = codeState.getDispatcher();
            value3 = codeState.getGlobalData();
            int n5 = n2 != 0 ? codeState.getSavedCode()[n++] : nArray[n++];
            n2 = 0;
            int n6 = Integer.MIN_VALUE;
            block170: do {
                switch (n6 == Integer.MIN_VALUE ? n5 : n6) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        value2 = this.stack.peek(n5 - 0);
                        continue block169;
                    }
                    case 8: {
                        value2 = this.stack.peek(nArray[n++]);
                        continue block169;
                    }
                    case 9: 
                    case 10: {
                        this.stack.push(value2);
                        continue block169;
                    }
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: {
                        this.stack.push(value2);
                        value2 = this.stack.peek(n5 - 11 + 1);
                        continue block169;
                    }
                    case 18: {
                        this.stack.push(value2);
                        value2 = this.stack.peek(nArray[n++]);
                        continue block169;
                    }
                    case 19: {
                        this.stack.pop(nArray[n++]);
                        continue block169;
                    }
                    case 20: {
                        this.stack.assign(nArray[n++], value2);
                        value2 = Value.UNIT;
                        continue block169;
                    }
                    case 21: {
                        value2 = this.env.get1();
                        continue block169;
                    }
                    case 22: {
                        value2 = this.env.get2();
                        continue block169;
                    }
                    case 23: {
                        value2 = this.env.get3();
                        continue block169;
                    }
                    case 24: {
                        value2 = this.env.get4();
                        continue block169;
                    }
                    case 25: {
                        value2 = this.env.get(nArray[n++]);
                        continue block169;
                    }
                    case 26: {
                        this.stack.push(value2);
                        value2 = this.env.get1();
                        continue block169;
                    }
                    case 27: {
                        this.stack.push(value2);
                        value2 = this.env.get2();
                        continue block169;
                    }
                    case 28: {
                        this.stack.push(value2);
                        value2 = this.env.get3();
                        continue block169;
                    }
                    case 29: {
                        this.stack.push(value2);
                        value2 = this.env.get4();
                        continue block169;
                    }
                    case 30: {
                        this.stack.push(value2);
                        value2 = this.env.get(nArray[n++]);
                        continue block169;
                    }
                    case 31: {
                        this.stack.push(Value.createLong(n3));
                        this.stack.push(this.env);
                        this.stack.push(Value.createCodeOffset(n + nArray[n++]));
                        continue block169;
                    }
                    case 32: {
                        n3 = nArray[n] - 1;
                        n = (int)value2.getCode();
                        this.env = value2;
                        n6 = 92;
                        continue block170;
                    }
                    case 33: {
                        this.stack.inject(1, Value.createLong(n3), this.env, Value.createCodeOffset(n));
                        n = (int)value2.getCode();
                        this.env = value2;
                        n3 = 0;
                        n6 = 92;
                        continue block170;
                    }
                    case 34: {
                        this.stack.inject(2, Value.createLong(n3), this.env, Value.createCodeOffset(n));
                        n = (int)value2.getCode();
                        this.env = value2;
                        n3 = 1;
                        n6 = 92;
                        continue block170;
                    }
                    case 35: {
                        this.stack.inject(3, Value.createLong(n3), this.env, Value.createCodeOffset(n));
                        n = (int)value2.getCode();
                        this.env = value2;
                        n3 = 2;
                        n6 = 92;
                        continue block170;
                    }
                    case 36: {
                        int n7 = nArray[n++];
                        int n8 = nArray[n];
                        this.stack.slide(n7, n8 - n7);
                        n = (int)value2.getCode();
                        this.env = value2;
                        n3 += n7 - 1;
                        n6 = 92;
                        continue block170;
                    }
                    case 37: {
                        this.stack.slide(1, nArray[n] - 1);
                        n = (int)value2.getCode();
                        this.env = value2;
                        n6 = 92;
                        continue block170;
                    }
                    case 38: {
                        this.stack.slide(2, nArray[n] - 2);
                        n = (int)value2.getCode();
                        this.env = value2;
                        ++n3;
                        n6 = 92;
                        continue block170;
                    }
                    case 39: {
                        this.stack.slide(3, nArray[n] - 3);
                        n = (int)value2.getCode();
                        this.env = value2;
                        n3 += 2;
                        n6 = 92;
                        continue block170;
                    }
                    case 40: {
                        this.stack.pop(nArray[n]);
                        if (n3 > 0) {
                            --n3;
                            n = (int)value2.getCode();
                            this.env = value2;
                            continue block169;
                        }
                        n = (int)this.stack.pop().asCodeOffset();
                        this.env = this.stack.pop();
                        n3 = this.stack.pop().asCastedInt();
                        continue block169;
                    }
                    case 41: {
                        int n9 = (int)this.env.sizeValues() - 2;
                        for (int i = n9 - 1; i >= 0; --i) {
                            this.stack.push(this.env.get(i + 2));
                        }
                        this.env = this.env.get1();
                        n3 += n9;
                        continue block169;
                    }
                    case 42: {
                        int n10;
                        int n11 = nArray[n++];
                        if (n3 >= n11) {
                            n3 -= n11;
                            continue block169;
                        }
                        int n12 = 1 + n3;
                        Value value4 = Value.createClosure(n12 + 2);
                        value4.set1(this.env);
                        for (n10 = 0; n10 < n12; ++n10) {
                            value4.set(n10 + 2, this.stack.pop());
                        }
                        value4.setCode(n - 3);
                        value2 = value4;
                        n = (int)this.stack.pop().asCodeOffset();
                        this.env = this.stack.pop();
                        n3 = this.stack.pop().asCastedInt();
                        continue block169;
                    }
                    case 43: {
                        int n13 = nArray[n++];
                        if (n13 > 0) {
                            this.stack.push(value2);
                        }
                        Value value5 = Value.createClosure(n13 + 1);
                        value5.setCode(n + nArray[n++]);
                        for (int i = 0; i < n13; ++i) {
                            value5.set(i + 1, this.stack.pop());
                        }
                        value2 = value5;
                        continue block169;
                    }
                    case 44: {
                        Value value6;
                        int n10;
                        int n14 = nArray[n++];
                        int n15 = nArray[n++];
                        if (n15 > 0) {
                            this.stack.push(value2);
                        }
                        value2 = value6 = Value.createClosure(2 * n14 - 1 + n15);
                        for (n10 = 0; n10 < n15; ++n10) {
                            value6.set(2 * n14 - 1 + n10, this.stack.pop());
                        }
                        value6.setCode(n + nArray[n]);
                        this.stack.push(value2);
                        BlockValue blockValue = value6.asBlock();
                        for (int i = 1; i < n14; ++i) {
                            Value value7 = Value.createInfix(i * 2);
                            value7.setCode(n + nArray[n + i]);
                            value7.setParent(blockValue);
                            value6.set(2 * i - 1, Value.createFromRawValue(value7.getHeader()));
                            Value value8 = value7;
                            value6.set(2 * i, value8);
                            this.stack.push(value8);
                        }
                        n += n14;
                        continue block169;
                    }
                    case 45: {
                        value2 = this.env.offset(-2L);
                        continue block169;
                    }
                    case 46: {
                        value2 = this.env;
                        continue block169;
                    }
                    case 47: {
                        value2 = this.env.offset(2L);
                        continue block169;
                    }
                    case 48: {
                        value2 = this.env.offset(nArray[n++]);
                        continue block169;
                    }
                    case 49: {
                        this.stack.push(value2);
                        value2 = this.env.offset(-2L);
                        continue block169;
                    }
                    case 50: {
                        this.stack.push(value2);
                        value2 = this.env;
                        continue block169;
                    }
                    case 51: {
                        this.stack.push(value2);
                        value2 = this.env.offset(2L);
                        continue block169;
                    }
                    case 52: {
                        this.stack.push(value2);
                        value2 = this.env.offset(nArray[n++]);
                        continue block169;
                    }
                    case 53: {
                        value2 = codeState.getGlobalData().get(nArray[n++]);
                        continue block169;
                    }
                    case 54: {
                        this.stack.push(value2);
                        value2 = codeState.getGlobalData().get(nArray[n++]);
                        continue block169;
                    }
                    case 55: {
                        value2 = codeState.getGlobalData().get(nArray[n++]);
                        value2 = value2.get(nArray[n++]);
                        continue block169;
                    }
                    case 56: {
                        this.stack.push(value2);
                        value2 = codeState.getGlobalData().get(nArray[n++]);
                        value2 = value2.get(nArray[n++]);
                        continue block169;
                    }
                    case 57: {
                        codeState.getGlobalData().set(nArray[n++], value2);
                        value2 = Value.UNIT;
                        continue block169;
                    }
                    case 58: {
                        value2 = codeState.getAtom(0);
                        continue block169;
                    }
                    case 59: {
                        value2 = codeState.getAtom(nArray[n++]);
                        continue block169;
                    }
                    case 60: {
                        this.stack.push(value2);
                        value2 = codeState.getAtom(0);
                        continue block169;
                    }
                    case 61: {
                        this.stack.push(value2);
                        value2 = codeState.getAtom(nArray[n++]);
                        continue block169;
                    }
                    case 62: {
                        int n10;
                        int n16 = nArray[n++];
                        int n17 = nArray[n++];
                        Value value9 = Value.createBlock(n17, n16);
                        value9.set0(value2);
                        for (n10 = 1; n10 < n16; ++n10) {
                            value9.set(n10, this.stack.pop());
                        }
                        value2 = value9;
                        continue block169;
                    }
                    case 63: {
                        int n18 = nArray[n++];
                        value2 = Value.createBlock(n18, value2);
                        continue block169;
                    }
                    case 64: {
                        int n19 = nArray[n++];
                        Value value10 = this.stack.pop();
                        value2 = Value.createBlock(n19, value2, value10);
                        continue block169;
                    }
                    case 65: {
                        int n20 = nArray[n++];
                        Value value11 = this.stack.pop();
                        Value value12 = this.stack.pop();
                        value2 = Value.createBlock(n20, value2, value11, value12);
                        continue block169;
                    }
                    case 66: {
                        int n21 = nArray[n++];
                        Value value13 = Value.createDoubleArray(n21);
                        value13.setDouble0(value2.asDouble());
                        for (int i = 1; i < n21; ++i) {
                            value13.setDouble(i, this.stack.pop().asDouble());
                        }
                        value2 = value13;
                        continue block169;
                    }
                    case 67: {
                        value2 = value2.get0();
                        continue block169;
                    }
                    case 68: {
                        value2 = value2.get1();
                        continue block169;
                    }
                    case 69: {
                        value2 = value2.get2();
                        continue block169;
                    }
                    case 70: {
                        value2 = value2.get3();
                        continue block169;
                    }
                    case 71: {
                        value2 = value2.get(nArray[n++]);
                        continue block169;
                    }
                    case 72: {
                        value2 = Value.createDouble(value2.isDoubleArray() ? value2.getDouble(nArray[n++]) : value2.get(nArray[n++]).asDouble());
                        continue block169;
                    }
                    case 73: {
                        value2.set0(this.stack.pop());
                        value2 = Value.UNIT;
                        continue block169;
                    }
                    case 74: {
                        value2.set1(this.stack.pop());
                        value2 = Value.UNIT;
                        continue block169;
                    }
                    case 75: {
                        value2.set2(this.stack.pop());
                        value2 = Value.UNIT;
                        continue block169;
                    }
                    case 76: {
                        value2.set3(this.stack.pop());
                        value2 = Value.UNIT;
                        continue block169;
                    }
                    case 77: {
                        value2.set(nArray[n++], this.stack.pop());
                        value2 = Value.UNIT;
                        continue block169;
                    }
                    case 78: {
                        double d = this.stack.pop().asDouble();
                        if (value2.isDoubleArray()) {
                            value2.setDouble(nArray[n++], d);
                        } else {
                            value2.set(nArray[n++], Value.createDouble(d));
                        }
                        value2 = Value.UNIT;
                        continue block169;
                    }
                    case 79: {
                        value2 = value2.arrayLengthWrapped();
                        continue block169;
                    }
                    case 80: {
                        value2 = value2.get(this.stack.pop().asLong());
                        continue block169;
                    }
                    case 81: {
                        long l = this.stack.pop().asLong();
                        Value value14 = this.stack.pop();
                        value2.set(l, value14);
                        value2 = Value.UNIT;
                        continue block169;
                    }
                    case 82: {
                        value2 = Value.createLong(value2.getUnsignedByte(this.stack.pop().asLong()));
                        continue block169;
                    }
                    case 83: {
                        long l = this.stack.pop().asLong();
                        int n22 = this.stack.pop().asCastedInt();
                        value2.setUnsignedByte(l, n22);
                        value2 = Value.UNIT;
                        continue block169;
                    }
                    case 84: {
                        n += nArray[n];
                        continue block169;
                    }
                    case 85: {
                        if (value2 != Value.FALSE) {
                            n += nArray[n];
                            continue block169;
                        }
                        ++n;
                        continue block169;
                    }
                    case 86: {
                        if (value2 == Value.FALSE) {
                            n += nArray[n];
                            continue block169;
                        }
                        ++n;
                        continue block169;
                    }
                    case 87: {
                        long l = IntegerUtils.signedToUnsigned(nArray[n++]);
                        int n23 = (int)(l >> 16);
                        int n10 = (int)(l & 0xFFFFL);
                        if (value2.isBlock()) {
                            int n24 = value2.getTag();
                            assert (n24 >= 0 && n24 < n23) : "invalid switch index";
                            n += nArray[n + n10 + n24];
                            continue block169;
                        }
                        int n25 = value2.asCastedInt();
                        assert (IntegerUtils.signedToUnsigned(n25) < (long)n10) : "invalid switch index";
                        n += nArray[n + n25];
                        continue block169;
                    }
                    case 88: {
                        value2 = value2 == Value.FALSE ? Value.TRUE : Value.FALSE;
                        continue block169;
                    }
                    case 89: {
                        this.stack.push(Value.createLong(n3));
                        this.stack.push(this.env);
                        this.stack.push(Value.createLong(n4));
                        this.stack.push(Value.createCodeOffset(n + nArray[n]));
                        n4 = this.stack.size();
                        ++n;
                        continue block169;
                    }
                    case 90: {
                        boolean bl;
                        try {
                            bl = Signals.processSignal(this);
                        }
                        catch (FalseExit falseExit) {
                            return Value.createLong(falseExit.getExitCode());
                        }
                        catch (Fail.Exception exception2) {
                            boolean bl2 = true;
                            exception = exception2;
                            --n;
                            break;
                        }
                        if (bl) {
                            --n;
                            continue block169;
                        }
                        this.stack.pop();
                        n4 = this.stack.pop().asCastedInt();
                        this.stack.pop(2);
                        continue block169;
                    }
                    case 91: {
                        if (n4 <= this.context.getDebuggerState().getDebuggerTrapBarrier()) {
                            try {
                                Debugger.handleEvent(this, Debugger.EventKind.TRAP_BARRIER);
                            }
                            catch (FalseExit falseExit) {
                                return Value.createLong(falseExit.getExitCode());
                            }
                        }
                        if (codeState.isBacktraceActive()) {
                            this.stashBacktrace(value2, n, n4);
                        }
                        if (n4 == -1) {
                            if (this.context.getDebuggerState().isDebuggerInUse()) {
                                this.stack.push(value2);
                            }
                            Fail.raise(value2);
                        }
                        this.stack.pop(this.stack.size() - n4);
                        n = (int)this.stack.pop().asCodeOffset();
                        n4 = this.stack.pop().asCastedInt();
                        this.env = this.stack.pop();
                        n3 = this.stack.pop().asCastedInt();
                        continue block169;
                    }
                    case 93: {
                        this.stack.push(this.env);
                        int n26 = nArray[n++];
                        try {
                            value2 = dispatcher.invoke(n26, value2);
                            this.env = this.stack.pop();
                            continue block169;
                        }
                        catch (Fail.Exception exception3) {
                            exception = exception3;
                            break;
                        }
                        catch (FalseExit falseExit) {
                            return value2;
                        }
                    }
                    case 94: {
                        this.stack.push(this.env);
                        int n27 = nArray[n++];
                        try {
                            value2 = dispatcher.invoke(n27, value2, this.stack.peek(1));
                            this.env = this.stack.pop();
                            this.stack.pop(1);
                            continue block169;
                        }
                        catch (Fail.Exception exception4) {
                            exception = exception4;
                            break;
                        }
                        catch (FalseExit falseExit) {
                            return value2;
                        }
                    }
                    case 95: {
                        this.stack.push(this.env);
                        int n28 = nArray[n++];
                        try {
                            value2 = dispatcher.invoke(n28, value2, this.stack.peek(1), this.stack.peek(2));
                            this.env = this.stack.pop();
                            this.stack.pop(2);
                            continue block169;
                        }
                        catch (Fail.Exception exception5) {
                            exception = exception5;
                            break;
                        }
                        catch (FalseExit falseExit) {
                            return value2;
                        }
                    }
                    case 96: {
                        this.stack.push(this.env);
                        int n29 = nArray[n++];
                        try {
                            value2 = dispatcher.invoke(n29, value2, this.stack.peek(1), this.stack.peek(2), this.stack.peek(3));
                            this.env = this.stack.pop();
                            this.stack.pop(3);
                            continue block169;
                        }
                        catch (Fail.Exception exception6) {
                            exception = exception6;
                            break;
                        }
                        catch (FalseExit falseExit) {
                            return value2;
                        }
                    }
                    case 97: {
                        this.stack.push(this.env);
                        int n30 = nArray[n++];
                        try {
                            value2 = dispatcher.invoke(n30, value2, this.stack.peek(1), this.stack.peek(2), this.stack.peek(3), this.stack.peek(4));
                            this.env = this.stack.pop();
                            this.stack.pop(4);
                            continue block169;
                        }
                        catch (Fail.Exception exception7) {
                            exception = exception7;
                            break;
                        }
                        catch (FalseExit falseExit) {
                            return value2;
                        }
                    }
                    case 98: {
                        int n31 = nArray[n++];
                        this.stack.push(value2);
                        this.stack.push(this.env);
                        int n32 = nArray[n++];
                        Value[] valueArray2 = new Value[n31];
                        for (int i = 0; i < n31; ++i) {
                            valueArray2[i] = this.stack.peek(i + 1);
                        }
                        try {
                            value2 = dispatcher.invoke(n32, valueArray2);
                            this.env = this.stack.pop();
                            this.stack.pop(n31);
                            continue block169;
                        }
                        catch (Fail.Exception exception8) {
                            exception = exception8;
                            break;
                        }
                        catch (FalseExit falseExit) {
                            return value2;
                        }
                    }
                    case 99: {
                        value2 = Value.ZERO;
                        continue block169;
                    }
                    case 100: {
                        value2 = Value.ONE;
                        continue block169;
                    }
                    case 101: {
                        value2 = Value.TWO;
                        continue block169;
                    }
                    case 102: {
                        value2 = Value.THREE;
                        continue block169;
                    }
                    case 103: {
                        value2 = Value.createLong(nArray[n++]);
                        continue block169;
                    }
                    case 104: {
                        this.stack.push(value2);
                        value2 = Value.ZERO;
                        continue block169;
                    }
                    case 105: {
                        this.stack.push(value2);
                        value2 = Value.ONE;
                        continue block169;
                    }
                    case 106: {
                        this.stack.push(value2);
                        value2 = Value.TWO;
                        continue block169;
                    }
                    case 107: {
                        this.stack.push(value2);
                        value2 = Value.THREE;
                        continue block169;
                    }
                    case 108: {
                        this.stack.push(value2);
                        value2 = Value.createLong(nArray[n++]);
                        continue block169;
                    }
                    case 109: {
                        value2 = Value.createFromRawValue(2L - value2.getRawValue());
                        continue block169;
                    }
                    case 110: {
                        value2 = Value.createFromRawValue(value2.getRawValue() + this.stack.pop().getRawValue() - 1L);
                        continue block169;
                    }
                    case 111: {
                        value2 = Value.createFromRawValue(value2.getRawValue() - this.stack.pop().getRawValue() + 1L);
                        continue block169;
                    }
                    case 112: {
                        value2 = Value.createLong(value2.asLong() * this.stack.pop().asLong());
                        continue block169;
                    }
                    case 113: {
                        long l = this.stack.pop().asLong();
                        if (l != 0L) {
                            value2 = Value.createLong(value2.asLong() / l);
                            continue block169;
                        }
                        exception = Fail.createZeroDivide();
                        break;
                    }
                    case 114: {
                        long l = this.stack.pop().asLong();
                        if (l != 0L) {
                            value2 = Value.createLong(value2.asLong() % l);
                            continue block169;
                        }
                        exception = Fail.createZeroDivide();
                        break;
                    }
                    case 115: {
                        value2 = Value.createFromRawValue(value2.getRawValue() & this.stack.pop().getRawValue());
                        continue block169;
                    }
                    case 116: {
                        value2 = Value.createFromRawValue(value2.getRawValue() | this.stack.pop().getRawValue());
                        continue block169;
                    }
                    case 117: {
                        value2 = Value.createFromRawValue(value2.getRawValue() ^ this.stack.pop().getRawValue() | 1L);
                        continue block169;
                    }
                    case 118: {
                        value2 = Value.createFromRawValue((value2.getRawValue() - 1L << (int)this.stack.pop().asLong()) + 1L);
                        continue block169;
                    }
                    case 119: {
                        value2 = Value.createFromRawValue(value2.getRawValue() - 1L >>> (int)this.stack.pop().asLong() | 1L);
                        continue block169;
                    }
                    case 120: {
                        value2 = Value.createFromRawValue(value2.getRawValue() - 1L >> (int)this.stack.pop().asLong() | 1L);
                        continue block169;
                    }
                    case 121: {
                        value2 = Value.compare(value2, this.stack.pop()) == 0 ? Value.TRUE : Value.FALSE;
                        continue block169;
                    }
                    case 122: {
                        value2 = Value.compare(value2, this.stack.pop()) != 0 ? Value.TRUE : Value.FALSE;
                        continue block169;
                    }
                    case 123: {
                        value2 = Value.compare(value2, this.stack.pop()) < 0 ? Value.TRUE : Value.FALSE;
                        continue block169;
                    }
                    case 124: {
                        value2 = Value.compare(value2, this.stack.pop()) <= 0 ? Value.TRUE : Value.FALSE;
                        continue block169;
                    }
                    case 125: {
                        value2 = Value.compare(value2, this.stack.pop()) > 0 ? Value.TRUE : Value.FALSE;
                        continue block169;
                    }
                    case 126: {
                        value2 = Value.compare(value2, this.stack.pop()) >= 0 ? Value.TRUE : Value.FALSE;
                        continue block169;
                    }
                    case 127: {
                        value2 = Value.createFromRawValue(value2.getRawValue() + (long)(nArray[n++] << 1));
                        continue block169;
                    }
                    case 128: {
                        long l = value2.get0().getRawValue();
                        value2.set0(Value.createFromRawValue(l + (long)(nArray[n++] << 1)));
                        value2 = Value.UNIT;
                        continue block169;
                    }
                    case 129: {
                        value2 = value2.isLong() ? Value.TRUE : Value.FALSE;
                        continue block169;
                    }
                    case 130: {
                        value2 = this.stack.peek(0).get0().get(value2.asLong());
                        continue block169;
                    }
                    case 131: {
                        int n33 = nArray[n++];
                        if (Value.compare(Value.createLong(n33), value2) == 0) {
                            n += nArray[n];
                            continue block169;
                        }
                        ++n;
                        continue block169;
                    }
                    case 132: {
                        int n34 = nArray[n++];
                        if (Value.compare(Value.createLong(n34), value2) != 0) {
                            n += nArray[n];
                            continue block169;
                        }
                        ++n;
                        continue block169;
                    }
                    case 133: {
                        Value value15 = Value.createLong(nArray[n++]);
                        if (Value.compare(value15, value2) < 0) {
                            n += nArray[n];
                            continue block169;
                        }
                        ++n;
                        continue block169;
                    }
                    case 134: {
                        Value value16 = Value.createLong(nArray[n++]);
                        if (Value.compare(value16, value2) <= 0) {
                            n += nArray[n];
                            continue block169;
                        }
                        ++n;
                        continue block169;
                    }
                    case 135: {
                        Value value17 = Value.createLong(nArray[n++]);
                        if (Value.compare(value17, value2) > 0) {
                            n += nArray[n];
                            continue block169;
                        }
                        ++n;
                        continue block169;
                    }
                    case 136: {
                        Value value18 = Value.createLong(nArray[n++]);
                        if (Value.compare(value18, value2) >= 0) {
                            n += nArray[n];
                            continue block169;
                        }
                        ++n;
                        continue block169;
                    }
                    case 137: {
                        if (Value.compareUnsigned(value2, this.stack.pop()) < 0) {
                            value2 = Value.TRUE;
                            continue block169;
                        }
                        value2 = Value.FALSE;
                        continue block169;
                    }
                    case 138: {
                        if (Value.compareUnsigned(value2, this.stack.pop()) >= 0) {
                            value2 = Value.TRUE;
                            continue block169;
                        }
                        value2 = Value.FALSE;
                        continue block169;
                    }
                    case 139: {
                        Value value19 = Value.createLong(nArray[n++]);
                        if (Value.compareUnsigned(value19, value2) < 0) {
                            n += nArray[n];
                            continue block169;
                        }
                        ++n;
                        continue block169;
                    }
                    case 140: {
                        Value value20 = Value.createLong(nArray[n++]);
                        if (Value.compareUnsigned(value20, value2) >= 0) {
                            n += nArray[n];
                            continue block169;
                        }
                        ++n;
                        continue block169;
                    }
                    case 141: {
                        Value value21 = value2.get0();
                        this.stack.push(value2);
                        value2 = Value.createLong(nArray[n++]);
                        long l = ((long)nArray[n] & value21.get1().getRawValue()) >> 2;
                        long l2 = value2.getRawValue();
                        if (value21.get(3L + l).getRawValue() == l2) {
                            value2 = value21.get(2L + l);
                        } else {
                            long l3 = 3L;
                            long l4 = value21.get0().getRawValue();
                            while (l3 < l4) {
                                long l5 = l3 + l4 >> 1 | 1L;
                                if (l2 < value21.get(l5).getRawValue()) {
                                    l4 = l5 - 2L;
                                    continue;
                                }
                                l3 = l5;
                            }
                            nArray[n] = (int)(l3 - 3L);
                            value2 = value21.get(l3 - 1L);
                        }
                        ++n;
                        continue block169;
                    }
                    case 142: {
                        value2 = ByteCodeRunner.getMethod(this.stack.peek(0), value2.getRawValue());
                        continue block169;
                    }
                    case 143: {
                        return value2;
                    }
                    case 144: {
                        if (this.context.getDebuggerState().decrementDebuggerEventCount()) {
                            this.stack.push(Value.createLong(n3));
                            this.stack.push(this.env);
                            this.stack.push(Value.createCodeOffset(n - 1));
                            this.stack.push(value2);
                            try {
                                Debugger.handleEvent(this, Debugger.EventKind.EVENT_COUNT);
                            }
                            catch (FalseExit falseExit) {
                                return Value.createLong(falseExit.getExitCode());
                            }
                            this.stack.pop(4);
                        }
                        --n;
                        n2 = 1;
                        continue block169;
                    }
                    case 145: {
                        this.stack.push(Value.createLong(n3));
                        this.stack.push(this.env);
                        this.stack.push(Value.createCodeOffset(n - 1));
                        this.stack.push(value2);
                        try {
                            Debugger.handleEvent(this, Debugger.EventKind.BREAKPOINT);
                        }
                        catch (FalseExit falseExit) {
                            return Value.createLong(falseExit.getExitCode());
                        }
                        this.stack.pop(4);
                        --n;
                        n2 = 1;
                        continue block169;
                    }
                    default: {
                        Fatal.raise("Fatal error: bad opcode (" + n5 + ")");
                        continue block169;
                    }
                    case 92: {
                        if (Thread.interrupted()) {
                            Exception exception9 = this.context.getSignalsState().getAndClearAsyncException();
                            if (exception9 == null || exception9 instanceof FalseExit) {
                                return value2;
                            }
                            exception = (Fail.Exception)exception9;
                        } else {
                            try {
                                Signals.processSignal(this);
                            }
                            catch (FalseExit falseExit) {
                                return Value.createLong(falseExit.getExitCode());
                            }
                            catch (Fail.Exception exception10) {
                                exception = exception10;
                            }
                        }
                        try {
                            CurrentContext.FINALIZERS_STATE.runFinalizers();
                            continue block169;
                        }
                        catch (FalseExit falseExit) {
                            return Value.createLong(falseExit.getExitCode());
                        }
                    }
                }
                break;
            } while (true);
            value2 = exception.asValue(codeState.getGlobalData());
            if (codeState.isBacktraceActive()) {
                this.stashBacktrace(value2, n, n4);
            }
            if (n4 == -1) {
                if (this.context.getDebuggerState().isDebuggerInUse()) {
                    this.stack.push(value2);
                }
                Fail.raise(value2);
            }
            this.stack.pop(this.stack.size() - n4);
            n = (int)this.stack.pop().asCodeOffset();
            n4 = this.stack.pop().asCastedInt();
            this.env = this.stack.pop();
            n3 = this.stack.pop().asCastedInt();
        }
    }

    private static Value eventForLocation(Value value, int n) {
        Value value2 = null;
        int n2 = n * 4;
        long l = value.sizeValues();
        for (long i = 0L; i < l; ++i) {
            for (Value value3 = value.get(i); value3 != Value.EMPTY_LIST; value3 = value3.get1()) {
                Value value4 = value3.get0();
                int n3 = value4.get(0L).asCastedInt();
                if (n3 == n2) {
                    return value4;
                }
                if (n3 != n2 + 8) continue;
                value2 = value4;
            }
        }
        return value2 != null ? value2 : Value.FALSE;
    }

    private LocInfo extractLocationInfo(Value value, int n) {
        boolean bl;
        Value value2 = ByteCodeRunner.eventForLocation(value, n);
        boolean bl2 = bl = n != -1 && this.context.getCodeState().getCode()[n] == 91;
        if (value2 == Value.FALSE) {
            return new LocInfo(false, bl, "", 0, 0, 0);
        }
        Value value3 = value2.get(2L).get(0L);
        int n2 = value3.get(2L).asCastedInt();
        int n3 = value3.get(3L).asCastedInt();
        return new LocInfo(true, bl, value3.get(0L).asString(), value3.get(1L).asCastedInt(), n3 - n2, value2.get(2L).get(1L).get(3L).asCastedInt() - n2);
    }

    private void printLocation(PrintStream printStream, LocInfo locInfo, int n) {
        assert (printStream != null) : "null err";
        assert (locInfo != null) : "null li";
        if (!locInfo.valid && locInfo.isRaise) {
            return;
        }
        String string = locInfo.isRaise ? (n == 0 ? "Raised at" : "Re-raised at") : (n == 0 ? "Raised by primitive operation at" : "Called from");
        if (!locInfo.valid) {
            printStream.printf("%s unkown location\n", string);
        } else {
            printStream.printf("%s file \"%s\", line %d, characters %d-%d\n", string, locInfo.filename, locInfo.lnum, locInfo.startChr, locInfo.endChr);
        }
    }

    @Override
    public void printExceptionBacktrace(PrintStream printStream) {
        assert (printStream != null) : "null err";
        Value value = this.context.getCodeState().getDebugInfo();
        if (value == Value.ZERO) {
            printStream.println("(Program not linked with -g, cannot print stack backtrace)");
        } else {
            int n = this.backtraceBuffer.size();
            for (int i = 0; i < n; ++i) {
                LocInfo locInfo = this.extractLocationInfo(value, this.backtraceBuffer.get(i));
                this.printLocation(printStream, locInfo, i);
            }
        }
    }

    @Override
    public Value getExceptionBacktrace() {
        Value value = this.context.getCodeState().getDebugInfo();
        if (value == Value.FALSE) {
            return Value.ZERO;
        }
        int n = this.backtraceBuffer.size();
        Value value2 = Value.createBlock(0, n);
        for (int i = 0; i < n; ++i) {
            LocInfo locInfo = this.extractLocationInfo(value, this.backtraceBuffer.get(i));
            Value value3 = locInfo.valid ? Value.createBlock(0, locInfo.isRaise ? Value.TRUE : Value.FALSE, Value.createString(locInfo.filename), Value.createLong(locInfo.lnum), Value.createLong(locInfo.startChr), Value.createLong(locInfo.endChr)) : Value.createBlock(1, locInfo.isRaise ? Value.TRUE : Value.FALSE);
            value2.set(i, value3);
        }
        return Value.createBlock(0, value2);
    }

    private void stashBacktrace(Value value, int n, int n2) throws Fatal.Exception {
        assert (value != null) : "null exception";
        int n3 = n;
        if (value != this.backtraceLastException) {
            this.backtraceBuffer.clear();
            this.backtraceLastException = value;
            if (n3 >= 0 && n3 < this.context.getCodeState().getCode().length) {
                this.backtraceBuffer.add(n3 - 1);
            }
            while (this.stack.size() > 0 && this.stack.size() > n2) {
                Value value2 = this.stack.pop();
                if (!value2.isCodeOffset()) continue;
                this.backtraceBuffer.add((int)value2.asCodeOffset());
            }
        }
    }
}

