/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.kernel;

import java.io.Console;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Set;
import org.ocamljava.runtime.util.EncodingUtils;
import org.ocamljava.runtime.util.MemoryInputStream;
import org.ocamljava.runtime.util.PermissionsUtils;
import org.ocamljava.runtime.util.PlatformUtils;

public final class Channel {
    public static final int STDIN = 0;
    public static final int STDOUT = 1;
    public static final int STDERR = 2;
    public static final int O_RDONLY = 0;
    public static final int O_WRONLY = 1;
    public static final int O_APPEND = 8;
    public static final int O_CREAT = 512;
    public static final int O_TRUNC = 1024;
    public static final int O_EXCL = 2048;
    public static final int O_NONBLOCK = 4;
    public static final int O_BINARY = 0;
    public static final int O_TEXT = 0;
    public static final int BUFFER_SIZE = 65536;
    public static final int SEEK_SET = 0;
    public static final int SEEK_CUR = 1;
    public static final int SEEK_END = 2;
    private static final int NEW_LINE = 10;
    private static final int CARRIAGE_RETURN = 13;
    private static final boolean IS_WINDOWS = PlatformUtils.isWindowPlatform();
    private static final Console CONSOLE = System.console();
    private final Kind kind;
    private int fd;
    private ByteBuffer buffer;
    private int limit;
    private final ByteBuffer writeBuffer;
    private final java.nio.channels.Channel channel;
    private ServerSocketChannel server;
    private InetSocketAddress bindAddress;

    public Channel(File file, int n, int n2) throws IOException {
        assert (file != null) : "null f";
        this.kind = Kind.ORDINARY;
        this.fd = -1;
        this.buffer = ByteBuffer.allocate(65536);
        this.writeBuffer = ByteBuffer.allocate(65536);
        this.limit = 0;
        FileAttribute<?> fileAttribute = PermissionsUtils.intToAttributes(n2);
        this.channel = fileAttribute != null && !IS_WINDOWS ? FileChannel.open(file.toPath(), Channel.openOptions(n), fileAttribute) : FileChannel.open(file.toPath(), Channel.openOptions(n), new FileAttribute[0]);
        this.server = null;
        this.bindAddress = null;
    }

    public Channel(java.nio.channels.Channel channel) {
        assert (channel != null) : "null ch";
        this.kind = Kind.ORDINARY;
        this.fd = -1;
        this.buffer = ByteBuffer.allocate(65536);
        this.writeBuffer = ByteBuffer.allocate(65536);
        this.limit = 0;
        this.channel = channel;
        this.server = null;
        this.bindAddress = null;
    }

    public Channel() throws IOException {
        this.fd = -1;
        this.kind = Kind.ORDINARY;
        this.buffer = ByteBuffer.allocate(65536);
        this.writeBuffer = ByteBuffer.allocate(65536);
        this.limit = 0;
        this.channel = SocketChannel.open();
        this.server = ServerSocketChannel.open();
        this.bindAddress = null;
    }

    public Channel(InputStream inputStream) {
        assert (inputStream != null) : "null in";
        int n = 0;
        try {
            n = inputStream.available();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.kind = inputStream == System.in && n == 0 && CONSOLE != null ? Kind.STANDARD_INPUT : Kind.ORDINARY;
        this.fd = -1;
        this.buffer = ByteBuffer.allocate(65536);
        this.writeBuffer = ByteBuffer.allocate(65536);
        this.limit = 0;
        this.channel = inputStream instanceof MemoryInputStream ? ((MemoryInputStream)inputStream).createChannel() : Channels.newChannel(inputStream);
        this.server = null;
        this.bindAddress = null;
    }

    public Channel(OutputStream outputStream) {
        assert (outputStream != null) : "null out";
        this.kind = outputStream == System.out || outputStream == System.err ? Kind.STANDARD_OUTPUT_OR_ERROR : Kind.ORDINARY;
        this.fd = -1;
        this.buffer = ByteBuffer.allocate(65536);
        this.writeBuffer = ByteBuffer.allocate(65536);
        this.limit = 0;
        this.channel = Channels.newChannel(outputStream);
        this.server = null;
        this.bindAddress = null;
    }

    public boolean isStandardOutputOrError() {
        return this.kind.equals((Object)Kind.STANDARD_OUTPUT_OR_ERROR);
    }

    public int getFD() {
        return this.fd;
    }

    public void setFD(int n) {
        this.fd = n;
    }

    public boolean isOutputChannel() {
        return this.channel instanceof WritableByteChannel;
    }

    public java.nio.channels.Channel asChannel() {
        return this.channel;
    }

    public SocketChannel asSocket() {
        if (this.channel instanceof SocketChannel) {
            return (SocketChannel)this.channel;
        }
        return null;
    }

    public ServerSocketChannel asServerSocket() {
        return this.server;
    }

    public DatagramChannel asDatagramSocket() {
        if (this.channel instanceof DatagramChannel) {
            return (DatagramChannel)this.channel;
        }
        return null;
    }

    public InputStream newInputStream() {
        return Channels.newInputStream((ReadableByteChannel)this.channel);
    }

    public OutputStream newOutputStream() {
        return Channels.newOutputStream((WritableByteChannel)this.channel);
    }

    public void truncate(long l) throws IOException {
        if (!(this.channel instanceof SeekableByteChannel)) {
            throw new IOException("unable to truncate channel");
        }
        ((SeekableByteChannel)this.channel).truncate(l);
    }

    public long position() throws IOException {
        if (this.channel instanceof WritableByteChannel) {
            Channel.writeBufferContents(this.writeBuffer, (WritableByteChannel)this.channel);
        }
        if (this.channel instanceof SeekableByteChannel) {
            return ((SeekableByteChannel)this.channel).position() - (long)this.buffer.position();
        }
        throw new IOException("unable to get channel position");
    }

    public long seek(long l, int n) throws IOException {
        if (this.channel instanceof WritableByteChannel) {
            Channel.writeBufferContents(this.writeBuffer, (WritableByteChannel)this.channel);
        }
        if (this.channel instanceof SeekableByteChannel) {
            long l2;
            SeekableByteChannel seekableByteChannel = (SeekableByteChannel)this.channel;
            switch (n) {
                case 0: {
                    l2 = l;
                    break;
                }
                case 1: {
                    l2 = seekableByteChannel.position() - (long)this.buffer.position() + l;
                    break;
                }
                case 2: {
                    l2 = seekableByteChannel.size() + l;
                    break;
                }
                default: {
                    assert (false) : "invalid seek command";
                    l2 = -1L;
                }
            }
            this.buffer.clear();
            this.writeBuffer.clear();
            this.limit = 0;
            return seekableByteChannel.position(l2).position();
        }
        throw new IOException("unable to set channel position");
    }

    public long size() throws IOException {
        if (this.channel instanceof WritableByteChannel) {
            Channel.writeBufferContents(this.writeBuffer, (WritableByteChannel)this.channel);
        }
        if (this.channel instanceof SeekableByteChannel) {
            return ((SeekableByteChannel)this.channel).size();
        }
        throw new IOException("unable to get channel size");
    }

    public int inputScanline() throws IOException {
        int n;
        int n2 = this.buffer.position();
        if (n2 < (n = this.limit)) {
            return this.getIndexOfEOL();
        }
        boolean bl = this.refillNormal();
        if (bl) {
            return this.getIndexOfEOL();
        }
        return 0;
    }

    private int getIndexOfEOL() {
        int n = this.buffer.position();
        int n2 = this.limit;
        int n3 = n;
        byte by = this.buffer.get(n3++);
        while (!Channel.isEOL(by)) {
            if (n3 == n2) {
                return -(n3 - n);
            }
            by = this.buffer.get(n3++);
        }
        return n3 - n;
    }

    private boolean refillStandardInput() {
        this.buffer.clear();
        String string = CONSOLE.readLine();
        if (string != null) {
            int n = string.length();
            byte[] byArray = new byte[n + 1];
            EncodingUtils.convertStringToBytes(string, byArray, 0);
            byArray[n] = 10;
            if (n + 1 > this.buffer.capacity()) {
                this.buffer = ByteBuffer.allocate(n + 2);
            }
            this.buffer.put(byArray);
            this.buffer.position(0);
            this.limit = n + 1;
            return true;
        }
        this.limit = 0;
        return false;
    }

    private boolean refillNormal() throws IOException {
        this.buffer.clear();
        int n = ((ReadableByteChannel)this.channel).read(this.buffer);
        if (n >= 0) {
            this.buffer.position(0);
            this.limit = n;
            return true;
        }
        this.buffer.clear();
        this.limit = 0;
        return false;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.channel instanceof ReadableByteChannel) {
            int n3 = this.limit - this.buffer.position();
            if (n3 > 0) {
                int n4 = Math.min(n3, n2);
                this.buffer.get(byArray, n, n4);
                if (n4 == n3) {
                    this.buffer.clear();
                    this.limit = 0;
                }
                if (n4 == n2) {
                    return n4;
                }
                return n4 + ((ReadableByteChannel)this.channel).read(ByteBuffer.wrap(byArray, n + n4, n2 - n4));
            }
            return ((ReadableByteChannel)this.channel).read(ByteBuffer.wrap(byArray, n, n2));
        }
        throw new IOException("not an input channel");
    }

    public int read8u() throws IOException {
        byte[] byArray = new byte[1];
        int n = this.read(byArray, 0, 1);
        if (n == 1) {
            byte by = byArray[0];
            return by & 0xFF;
        }
        throw new ClosedChannelException();
    }

    public int read32s() throws IOException {
        byte[] byArray = new byte[4];
        int n = this.read(byArray, 0, 4);
        if (n == 4) {
            return (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
        }
        throw new ClosedChannelException();
    }

    public void write8u(int n) throws IOException {
        if (this.writeBuffer.position() >= this.writeBuffer.limit()) {
            if (this.channel instanceof WritableByteChannel) {
                Channel.writeBufferContents(this.writeBuffer, (WritableByteChannel)this.channel);
            } else {
                throw new IOException("not an output channel");
            }
        }
        this.writeBuffer.put((byte)n);
    }

    public void write32s(int n) throws IOException {
        if (this.writeBuffer.position() + 3 >= this.writeBuffer.limit()) {
            if (this.channel instanceof WritableByteChannel) {
                Channel.writeBufferContents(this.writeBuffer, (WritableByteChannel)this.channel);
            } else {
                throw new IOException("not an output channel");
            }
        }
        this.writeBuffer.put((byte)(0xFF & n >> 24));
        this.writeBuffer.put((byte)(0xFF & n >> 16));
        this.writeBuffer.put((byte)(0xFF & n >> 8));
        this.writeBuffer.put((byte)(0xFF & n));
    }

    public int write(byte[] byArray, int n, int n2) throws IOException {
        assert (byArray != null) : "null b";
        int n3 = this.writeBuffer.limit() - this.writeBuffer.position();
        if (n3 < n2) {
            if (this.channel instanceof WritableByteChannel) {
                WritableByteChannel writableByteChannel = (WritableByteChannel)this.channel;
                Channel.writeBufferContents(this.writeBuffer, (WritableByteChannel)this.channel);
                return writableByteChannel.write(ByteBuffer.wrap(byArray, n, n2));
            }
            throw new IOException("not an output channel");
        }
        this.writeBuffer.put(byArray, n, n2);
        return n2;
    }

    public int write(byte[] byArray) throws IOException {
        assert (byArray != null) : "null b";
        return this.write(byArray, 0, byArray.length);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void tryWrite(Channel channel, String string) {
        assert (string != null) : "null s";
        if (channel == null) return;
        if (!(channel.channel instanceof WritableByteChannel)) return;
        try {
            WritableByteChannel writableByteChannel = (WritableByteChannel)channel.channel;
            if (channel.writeBuffer.position() > 0) {
                writableByteChannel.write(channel.writeBuffer);
                channel.writeBuffer.clear();
            }
            writableByteChannel.write(ByteBuffer.wrap(EncodingUtils.convertStringToBytes(string)));
            return;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void writeBufferContents(ByteBuffer byteBuffer, WritableByteChannel writableByteChannel) throws IOException {
        assert (writableByteChannel != null) : "null wbc";
        assert (byteBuffer != null) : "null b";
        if (byteBuffer.position() > 0) {
            byteBuffer.limit(byteBuffer.position());
            byteBuffer.position(0);
            writableByteChannel.write(byteBuffer);
            byteBuffer.clear();
        }
    }

    public void flush() throws IOException {
        if (this.channel instanceof WritableByteChannel) {
            Channel.writeBufferContents(this.writeBuffer, (WritableByteChannel)this.channel);
        }
        if (this.channel instanceof FileChannel) {
            ((FileChannel)this.channel).force(true);
        }
        if (this.channel instanceof AsynchronousFileChannel) {
            ((AsynchronousFileChannel)this.channel).force(true);
        }
    }

    public void configureBlocking(boolean bl) throws IOException {
        if (this.channel instanceof SelectableChannel) {
            ((SelectableChannel)this.channel).configureBlocking(bl);
        }
    }

    public InetSocketAddress getBindAddress() {
        return this.bindAddress;
    }

    public void bind(InetSocketAddress inetSocketAddress) throws IOException {
        if (this.channel instanceof DatagramChannel) {
            this.bindAddress = inetSocketAddress;
            ((DatagramChannel)this.channel).bind(inetSocketAddress);
        } else if (this.channel instanceof SocketChannel || this.server != null) {
            this.bindAddress = inetSocketAddress;
        } else {
            throw new IOException("not a socket");
        }
    }

    public void connect(InetSocketAddress inetSocketAddress) throws IOException {
        assert (inetSocketAddress != null) : "null a";
        if (this.channel instanceof SocketChannel) {
            SocketChannel socketChannel = (SocketChannel)this.channel;
            socketChannel.bind(this.bindAddress);
            socketChannel.connect(inetSocketAddress);
            this.server = null;
        } else if (this.channel instanceof DatagramChannel) {
            ((DatagramChannel)this.channel).connect(inetSocketAddress);
        } else {
            throw new IOException("not a socket");
        }
    }

    public void listen(int n) throws IOException {
        if (this.server == null) {
            throw new IOException("not a socket");
        }
        this.server.bind(this.bindAddress, n);
    }

    public void close() throws IOException {
        this.channel.close();
        if (this.server != null) {
            this.server.close();
        }
    }

    private static Set<OpenOption> openOptions(int n) {
        HashSet<OpenOption> hashSet = new HashSet<OpenOption>();
        if ((n & 1) != 0) {
            hashSet.add(StandardOpenOption.READ);
            hashSet.add(StandardOpenOption.WRITE);
        } else {
            hashSet.add(StandardOpenOption.READ);
        }
        if ((n & 8) != 0) {
            hashSet.add(StandardOpenOption.APPEND);
        }
        if ((n & 0x200) != 0) {
            hashSet.add(StandardOpenOption.CREATE);
        }
        if ((n & 0x400) != 0) {
            hashSet.add(StandardOpenOption.TRUNCATE_EXISTING);
        }
        return hashSet;
    }

    private static boolean isEOL(int n) {
        switch (n) {
            case 10: {
                return true;
            }
            case 13: {
                return true;
            }
        }
        return false;
    }

    private static enum Kind {
        ORDINARY,
        STANDARD_INPUT,
        STANDARD_OUTPUT_OR_ERROR;

    }
}

