/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank;

import com.onemoonscientific.swank.GetValueOnEventThread;
import com.onemoonscientific.swank.PlacerLayout;
import com.onemoonscientific.swank.SwkWidget;
import com.onemoonscientific.swank.UpdateOnEventThread;
import com.onemoonscientific.swank.Widgets;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JWindow;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.LayoutHandler;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;

public class PlaceCmd
implements Command {
    static Hashtable columnTable = new Hashtable();
    static Hashtable rowTable = new Hashtable();
    private static final String[] validCmds = new String[]{"configure", "forget", "info", "slaves"};
    private static final int OPT_CONFIGURE = 0;
    private static final int OPT_FORGET = 1;
    private static final int OPT_INFO = 2;
    private static final int OPT_SLAVES = 3;
    static TclObject configArg = TclString.newInstance((String)"configure");
    Interp interp;

    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        if (argv.length < 2) {
            throw new TclNumArgsException(interp, 1, argv, "option arg ?arg ...?");
        }
        this.interp = interp;
        int firstWindow = 2;
        boolean debug = false;
        boolean nSlaves = false;
        Object option = null;
        Object masterName = null;
        Object parentName = null;
        Object windowName = null;
        Object placer = null;
        Object parent = null;
        TclObject optionArg = null;
        if (!argv[1].toString().startsWith(".") && !argv[1].toString().startsWith("-")) {
            optionArg = argv[1];
            if (argv.length < 3) {
                throw new TclNumArgsException(interp, 1, argv, "option arg ?arg ...?");
            }
        } else {
            optionArg = configArg;
            firstWindow = 1;
        }
        if (debug) {
            System.out.println("Place option is " + optionArg.toString());
        }
        int opt = TclIndex.get(interp, optionArg, validCmds, "option", 0);
        switch (opt) {
            case 0: {
                this.placeConfigure(interp, argv, firstWindow);
                break;
            }
            case 1: {
                this.placeForget(interp, argv, firstWindow);
                break;
            }
            case 2: {
                this.placeInfo(interp, argv);
                break;
            }
            case 3: {
                this.placeSlaves(interp, argv);
                break;
            }
            default: {
                throw new TclRuntimeError("TclIndex.get() error");
            }
        }
    }

    void placeInfo(Interp interp, TclObject[] argv) throws TclException {
        if (argv.length != 3) {
            throw new TclException(interp, "wrong # args: should be \"place info window\"");
        }
        SwkWidget window = (SwkWidget)Widgets.get(interp, argv[2].toString());
        if (window == null) {
            throw new TclException(interp, "window \"" + argv[2].toString() + "\" doesn't exist");
        }
        String result = new Info().exec(window, argv[2].toString());
        if (result == null) {
            throw new TclException(interp, "window \"" + argv[2].toString() + "\" isn't Placed");
        }
        interp.setResult(result);
    }

    void placeSlaves(Interp interp, TclObject[] argv) throws TclException {
        if (argv.length != 3) {
            throw new TclNumArgsException(interp, 2, argv, "window");
        }
        if (!Widgets.exists(interp, argv[2].toString())) {
            throw new TclException(interp, "bad window path name \"" + argv[2].toString() + "\"");
        }
        String[] names = new Slaves().exec(argv[2].toString());
        TclObject list = TclList.newInstance();
        if (names != null) {
            for (int i = 0; i < names.length; ++i) {
                TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)names[i]));
            }
        }
        interp.setResult(list);
    }

    void placeForget(Interp interp, TclObject[] argv, int firstWindow) throws TclException {
        String[] names = new String[argv.length - firstWindow];
        int j = 0;
        for (int i = firstWindow; i < argv.length; ++i) {
            names[j++] = argv[i].toString();
        }
        new Forget().exec(names);
    }

    int initPlaceingWindow(Interp interp, TclObject[] argv, String[] args, int firstWindow) throws TclException {
        int lastWindow = 0;
        if (args.length <= firstWindow) {
            throw new TclNumArgsException(interp, 1, argv, "slave ?slave ...? ?options?");
        }
        if (!Widgets.exists(interp, args[firstWindow])) {
            if (firstWindow == 1) {
                throw new TclException(interp, "bad window path name \"" + args[firstWindow] + "\"");
            }
            throw new TclException(interp, "bad argument \"" + args[firstWindow] + "\": must be name of window");
        }
        int i = firstWindow;
        while (i < args.length && args[i].startsWith(".")) {
            SwkWidget window = (SwkWidget)Widgets.get(interp, args[i]);
            if (window == null) {
                throw new TclException(interp, "bad window path name \"" + args[i] + "\"");
            }
            lastWindow = i++;
        }
        if (lastWindow < firstWindow) {
            throw new TclNumArgsException(interp, 2, argv, "window");
        }
        return lastWindow;
    }

    void getSpecialArgs(Interp interp, String[] args, int lastWindow, Vector window1Special, StringBuffer strippedArgs) throws TclException {
        int firstArg = lastWindow + 1;
        int lastArg = args.length - 1;
        for (int i = firstArg; i <= lastArg; i += 2) {
            if (args[i].equals("-in")) {
                if (!Widgets.exists(interp, args[i + 1].toString())) {
                    throw new TclException(interp, "bad window path name \"" + args[i + 1] + "\"");
                }
                window1Special.add(args[i]);
                window1Special.add(args[i + 1]);
                continue;
            }
            if (strippedArgs.length() != 0) {
                strippedArgs.append(" ");
            }
            strippedArgs.append(args[i] + " {" + args[i + 1] + "}");
        }
    }

    void placeConfigure(Interp interp, TclObject[] argv, int firstWindow) throws TclException {
        String[] args = new String[argv.length];
        for (int i = 0; i < argv.length; ++i) {
            args[i] = argv[i].toString().intern();
        }
        int lastArg = argv.length - 1;
        int lastWindow = this.initPlaceingWindow(interp, argv, args, firstWindow);
        int firstArg = lastWindow + 1;
        int nArgs = lastArg - firstArg + 1;
        if (nArgs % 2 != 0) {
            throw new TclException(interp, "extra option \"" + argv[lastArg].toString() + "\" (option with no value?)");
        }
        Vector window1Special = new Vector();
        StringBuffer strippedArgs = new StringBuffer();
        this.getSpecialArgs(interp, args, lastWindow, window1Special, strippedArgs);
        PlacerLayout.checkPlaceArgs(interp, strippedArgs.toString(), null);
        new Configure().exec(window1Special, args, strippedArgs.toString(), firstWindow, lastWindow);
    }

    String getParent(Interp interp, String widgetName) throws TclException {
        if (!Widgets.exists(interp, widgetName)) {
            throw new TclException(interp, "bad window path name \"" + widgetName + "\"");
        }
        String masterName = null;
        int lastDot = widgetName.lastIndexOf(".");
        if (lastDot == 0) {
            masterName = ".";
        } else {
            if (lastDot == -1) {
                throw new TclException(interp, "bad window path name \"" + widgetName + "\"");
            }
            masterName = widgetName.substring(0, lastDot);
        }
        return masterName;
    }

    class Configure
    extends UpdateOnEventThread {
        String specialWindowName = null;
        String parentName = null;
        Container parent = null;
        String option = null;
        String strippedArgs = null;
        Vector window1Special = null;
        int firstWindow = 0;
        int lastWindow = 0;
        String[] args = null;

        Configure() {
        }

        void exec(Vector window1Special, String[] args, String strippedArgs, int firstWindow, int lastWindow) {
            this.args = args;
            this.window1Special = window1Special;
            this.strippedArgs = strippedArgs;
            this.firstWindow = firstWindow;
            this.lastWindow = lastWindow;
            this.execOnThread();
        }

        void doSpecial() throws TclException {
            if (this.window1Special.size() > 0) {
                for (int j = 0; j < this.window1Special.size(); j += 2) {
                    this.option = (String)this.window1Special.elementAt(j);
                    this.specialWindowName = (String)this.window1Special.elementAt(j + 1);
                    if (!this.option.equals("-in")) continue;
                    this.parentName = (String)this.window1Special.elementAt(j + 1);
                    this.parent = Widgets.getContainer(PlaceCmd.this.interp, this.parentName);
                }
                block1: for (int i = this.firstWindow; i <= this.lastWindow; ++i) {
                    String windowName = this.args[i];
                    if (windowName.equals(this.specialWindowName)) continue;
                    SwkWidget window = (SwkWidget)Widgets.get(PlaceCmd.this.interp, windowName);
                    int nMembers = this.parent.getComponentCount();
                    for (int iWin = 0; iWin < nMembers; ++iWin) {
                        Component comp = this.parent.getComponent(iWin);
                        if (comp != (Component)((Object)window)) continue;
                        this.parent.remove((Component)((Object)window));
                        continue block1;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addWindows() throws TclException {
            String window1 = this.args[this.firstWindow];
            for (int i = this.firstWindow; i <= this.lastWindow; ++i) {
                int PlacePosition = -1;
                String windowName = this.args[i];
                if (windowName.equals(this.parentName)) {
                    throw new TclException(PlaceCmd.this.interp, "can't Place \"" + windowName + "\" inside itself");
                }
                if (this.window1Special.size() <= 0) {
                    this.parentName = PlaceCmd.this.getParent(PlaceCmd.this.interp, windowName);
                    this.parent = Widgets.getContainer(PlaceCmd.this.interp, this.parentName);
                }
                SwkWidget window = (SwkWidget)Widgets.get(PlaceCmd.this.interp, windowName);
                if (window instanceof JWindow || window instanceof JFrame) {
                    throw new TclException(PlaceCmd.this.interp, "can't Place \"" + windowName + "\": it's a top-level window");
                }
                LayoutManager layoutManager = this.parent.getLayout();
                PlacerLayout Place = null;
                if (!(layoutManager instanceof PlacerLayout)) {
                    this.parent.removeAll();
                    Place = new PlacerLayout(PlaceCmd.this.interp);
                    this.parent.setLayout(Place);
                } else {
                    Place = (PlacerLayout)layoutManager;
                }
                try {
                    Place.setIgnoreNextRemove(true);
                    this.parent.add((Component)((Object)window), this.strippedArgs.toString(), PlacePosition);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                finally {
                    Place.setIgnoreNextRemove(false);
                }
            }
            LayoutHandler.addLayoutRequest(PlaceCmd.this.interp, this.parent);
        }

        public void run() {
            try {
                this.doSpecial();
                this.addWindows();
            }
            catch (TclException tclE) {
                PlaceCmd.this.interp.backgroundError();
            }
            this.parent.repaint();
        }
    }

    class Forget
    extends UpdateOnEventThread {
        String[] names = null;

        Forget() {
        }

        void exec(String[] names) {
            this.names = names;
            this.execOnThread();
        }

        public void run() {
            try {
                for (int i = 0; i < this.names.length; ++i) {
                    Container parent;
                    LayoutManager layoutManager;
                    String parentName;
                    if (!Widgets.exists(PlaceCmd.this.interp, this.names[i]) || (parentName = Widgets.parent(PlaceCmd.this.interp, this.names[i])).equals("") || !((layoutManager = (parent = Widgets.getContainer(PlaceCmd.this.interp, parentName)).getLayout()) instanceof PlacerLayout)) continue;
                    SwkWidget window = (SwkWidget)Widgets.get(PlaceCmd.this.interp, this.names[i]);
                    parent.remove((Component)((Object)window));
                    Widgets.relayoutContainer(parent);
                    parent.repaint();
                }
            }
            catch (TclException tclException) {
                // empty catch block
            }
        }
    }

    class Slaves
    extends GetValueOnEventThread {
        String item = null;
        String[] names = null;

        Slaves() {
        }

        String[] exec(String item) {
            this.item = item;
            this.execOnThread();
            return this.names;
        }

        public void run() {
            Container parent = null;
            try {
                parent = Widgets.getContainer(PlaceCmd.this.interp, this.item);
            }
            catch (TclException tclE) {
                PlaceCmd.this.interp.backgroundError();
                return;
            }
            int nMembers = parent.getComponentCount();
            this.names = new String[nMembers];
            for (int i = 0; i < nMembers; ++i) {
                Component comp = parent.getComponent(i);
                this.names[i] = comp.getName();
            }
        }
    }

    class Info
    extends GetValueOnEventThread {
        String result = null;
        String item = null;
        SwkWidget window = null;
        String parentName = null;
        Container parent = null;

        Info() {
        }

        String exec(SwkWidget window, String item) {
            this.item = item;
            this.window = window;
            try {
                this.parentName = Widgets.parent(PlaceCmd.this.interp, item);
                this.parent = Widgets.getContainer(PlaceCmd.this.interp, this.parentName);
            }
            catch (TclException tclE) {
                return null;
            }
            this.execOnThread();
            return this.result;
        }

        public void run() {
            if (this.parent != null) {
                LayoutManager layoutManager = this.parent.getLayout();
                if (!(layoutManager instanceof PlacerLayout)) {
                    return;
                }
                PlacerLayout placer = (PlacerLayout)layoutManager;
                String settings = placer.getComponentSettings((Component)((Object)this.window));
                this.result = settings.toString() + " -in " + this.parentName;
            }
        }
    }
}

