/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank.canvas;

import com.onemoonscientific.swank.BindCmd;
import com.onemoonscientific.swank.FocusCmd;
import com.onemoonscientific.swank.ImageSelection;
import com.onemoonscientific.swank.ResourceObject;
import com.onemoonscientific.swank.Setter;
import com.onemoonscientific.swank.SwankUtil;
import com.onemoonscientific.swank.SwkBinding;
import com.onemoonscientific.swank.SwkBorder;
import com.onemoonscientific.swank.SwkChangeListener;
import com.onemoonscientific.swank.SwkComponentListener;
import com.onemoonscientific.swank.SwkFocusListener;
import com.onemoonscientific.swank.SwkIndex;
import com.onemoonscientific.swank.SwkKeyCommandListener;
import com.onemoonscientific.swank.SwkKeyListener;
import com.onemoonscientific.swank.SwkMouseListener;
import com.onemoonscientific.swank.SwkMouseMotionListener;
import com.onemoonscientific.swank.SwkWidget;
import com.onemoonscientific.swank.Widgets;
import com.onemoonscientific.swank.canvas.BindEvent;
import com.onemoonscientific.swank.canvas.HitShape;
import com.onemoonscientific.swank.canvas.SwkCanvasWidgetCmd;
import com.onemoonscientific.swank.canvas.SwkImageCanvas;
import com.onemoonscientific.swank.canvas.SwkShape;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.IllegalComponentStateException;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferStrategy;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import tcl.lang.Interp;
import tcl.lang.TclBoolean;
import tcl.lang.TclEvent;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwkCanvas
extends JPanel
implements SwkWidget,
Printable,
Scrollable {
    static Hashtable resourceDB = null;
    String name = null;
    String className = null;
    LinkedList children = null;
    ArrayList<SwkBinding> virtualBindings = null;
    int active = 0;
    boolean created = false;
    TclObject tclObject = null;
    final Interp interp;
    Insets emptyBorderInsets = new Insets(0, 0, 0, 0);
    Vector tagList = new Vector();
    Dimension minimumSize = null;
    String jhelptarget = "";
    Color insertBackground;
    int insertWidth = 0;
    int insertBorderWidth = 0;
    int insertOffTime = 0;
    int insertOnTime = 0;
    float[] anchor = new float[]{0.0f, 0.0f};
    int borderWidth = 0;
    Color highlightBackground = Color.white;
    Color highlightColor = Color.red;
    int highlightThickness;
    int padx;
    int pady;
    String relief = null;
    String xScrollCommand = null;
    String yScrollCommand = null;
    Graphics g1 = null;
    BasicStroke stroke = new BasicStroke();
    double zoom = 1.0;
    AffineTransform canvasTransform = new AffineTransform();
    Hashtable transformerHash = new Hashtable();
    Point2D transMouse = new Point2D.Double();
    Point2D origMouse = new Point2D.Double();
    static ScheduledThreadPoolExecutor schedExecutor = new ScheduledThreadPoolExecutor(10);
    ScheduledFuture futureUpdate = null;
    FontRenderContext fRC = null;
    int lastShapeId = 0;
    HitShape hitShape = null;
    int handle = -1;
    SwkShape currentShape = null;
    Point currentPt = new Point(0, 0);
    String currentTag = null;
    String previousTag = null;
    TclObject[] currentTags = null;
    TclObject[] previousTags = null;
    LinkedHashMap focusHash = null;
    LinkedHashMap mouseHash = null;
    LinkedHashMap mouseMotionHash = null;
    LinkedHashMap keyHash = null;
    Hashtable tagHash = new Hashtable();
    Vector tagVec = new Vector();
    SwkImageCanvas swkImageCanvas = null;
    BufferedImage bufOffscreen = null;
    Graphics2D g2Offscreen = null;
    boolean changed = false;
    Cursor previousCursor = null;
    int swkwidth = 1;
    int swkheight = 1;
    SwkMouseListener mouseListener = null;
    SwkKeyListener keyListener = null;
    SwkKeyCommandListener keyCommandListener = null;
    SwkFocusListener focusListener = null;
    SwkComponentListener componentListener = null;
    SwkChangeListener changeListener = null;
    SwkMouseMotionListener mouseMotionListener = null;
    int mouseX = 0;
    int mouseY = 0;
    static String[] validCmds = new String[]{"-anchor", "-autoscrolls", "-background", "-bd", "-bg", "-border", "-borderwidth", "-class", "-cursor", "-enabled", "-fg", "-focusable", "-focuscycleroot", "-focustraversalkeysenabled", "-focustraversalpolicyprovider", "-font", "-foreground", "-height", "-highlightbackground", "-highlightcolor", "-highlightthickness", "-insertbackground", "-insertborderwidth", "-insertofftime", "-insertontime", "-insertwidth", "-jhelptarget", "-opaque", "-padx", "-pady", "-relief", "-requestfocusenabled", "-scrollregion", "-tooltiptext", "-verifyinputwhenfocustarget", "-visible", "-width", "-xscrollcommand", "-yscrollcommand"};
    private static final int OPT_ANCHOR = 0;
    private static final int OPT_AUTOSCROLLS = 1;
    private static final int OPT_BACKGROUND = 2;
    private static final int OPT_BD = 3;
    private static final int OPT_BG = 4;
    private static final int OPT_BORDER = 5;
    private static final int OPT_BORDERWIDTH = 6;
    private static final int OPT_CLASS = 7;
    private static final int OPT_CURSOR = 8;
    private static final int OPT_ENABLED = 9;
    private static final int OPT_FG = 10;
    private static final int OPT_FOCUSABLE = 11;
    private static final int OPT_FOCUSCYCLEROOT = 12;
    private static final int OPT_FOCUSTRAVERSALKEYSENABLED = 13;
    private static final int OPT_FOCUSTRAVERSALPOLICYPROVIDER = 14;
    private static final int OPT_FONT = 15;
    private static final int OPT_FOREGROUND = 16;
    private static final int OPT_HEIGHT = 17;
    private static final int OPT_HIGHLIGHTBACKGROUND = 18;
    private static final int OPT_HIGHLIGHTCOLOR = 19;
    private static final int OPT_HIGHLIGHTTHICKNESS = 20;
    private static final int OPT_INSERTBACKGROUND = 21;
    private static final int OPT_INSERTBORDERWIDTH = 22;
    private static final int OPT_INSERTOFFTIME = 23;
    private static final int OPT_INSERTONTIME = 24;
    private static final int OPT_INSERTWIDTH = 25;
    private static final int OPT_JHELPTARGET = 26;
    private static final int OPT_OPAQUE = 27;
    private static final int OPT_PADX = 28;
    private static final int OPT_PADY = 29;
    private static final int OPT_RELIEF = 30;
    private static final int OPT_REQUESTFOCUSENABLED = 31;
    private static final int OPT_SCROLLREGION = 32;
    private static final int OPT_TOOLTIPTEXT = 33;
    private static final int OPT_VERIFYINPUTWHENFOCUSTARGET = 34;
    private static final int OPT_VISIBLE = 35;
    private static final int OPT_WIDTH = 36;
    private static final int OPT_XSCROLLCOMMAND = 37;
    private static final int OPT_YSCROLLCOMMAND = 38;
    static TreeMap validCmdsTM = new TreeMap();

    synchronized void startTimer(int delay) {
        if (this.futureUpdate == null || this.futureUpdate.isDone()) {
            UpdateTask updateTask = new UpdateTask();
            this.futureUpdate = schedExecutor.schedule(updateTask, (long)delay, TimeUnit.MILLISECONDS);
        }
    }

    public SwkCanvas(Interp interp, String name, String className) {
        this.name = name.intern();
        this.interp = interp;
        if (resourceDB == null) {
            resourceDB = new Hashtable();
            SwkCanvas.initResources();
        }
        this.swkImageCanvas = new SwkImageCanvas(interp, name, className);
        this.swkImageCanvas.setComponent(this);
        this.addKeyListener(new KeyListener(){

            public void keyTyped(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                Point point = MouseInfo.getPointerInfo().getLocation();
                point = SwkCanvas.this.swkImageCanvas.transformPosition(point.x, point.y);
                SwkCanvas.this.currentTags = SwkCanvas.this.getTagFromKeyEvent(point.x, point.y);
                if (SwkCanvas.this.currentTags == null) {
                    return;
                }
                for (int i = 0; i < SwkCanvas.this.currentTags.length; ++i) {
                    SwkCanvas.this.currentTag = SwkCanvas.this.getTagOrIDFromTagID(SwkCanvas.this.currentTags[i].toString());
                    SwkCanvas.this.processKey(e, 0);
                }
            }

            public void keyReleased(KeyEvent e) {
                Point point = MouseInfo.getPointerInfo().getLocation();
                point = SwkCanvas.this.swkImageCanvas.transformPosition(point.x, point.y);
                SwkCanvas.this.currentTags = SwkCanvas.this.getTagFromKeyEvent(point.x, point.y);
                if (SwkCanvas.this.currentTags == null) {
                    return;
                }
                for (int i = 0; i < SwkCanvas.this.currentTags.length; ++i) {
                    SwkCanvas.this.currentTag = SwkCanvas.this.getTagOrIDFromTagID(SwkCanvas.this.currentTags[i].toString());
                    SwkCanvas.this.processKey(e, 1);
                }
            }
        });
        this.addMouseListener(new MouseListener(){

            public void mousePressed(MouseEvent mEvent) {
                SwkCanvas.this.swkImageCanvas.transformMouse(mEvent);
                SwkCanvas.this.currentTags = SwkCanvas.this.getTagFromEvent(mEvent);
                if (SwkCanvas.this.currentTags == null) {
                    return;
                }
                for (int i = 0; i < SwkCanvas.this.currentTags.length; ++i) {
                    SwkCanvas.this.currentTag = SwkCanvas.this.getTagOrIDFromTagID(SwkCanvas.this.currentTags[i].toString());
                    SwkCanvas.this.processMouse(mEvent, 2, 0);
                }
            }

            public void mouseReleased(MouseEvent mEvent) {
                SwkCanvas.this.swkImageCanvas.transformMouse(mEvent);
                SwkCanvas.this.previousTags = SwkCanvas.this.currentTags;
                SwkCanvas.this.currentTags = SwkCanvas.this.getTagFromEvent(mEvent);
                if (SwkCanvas.this.currentTags == null) {
                    SwkCanvas.this.currentTag = null;
                    SwkCanvas.this.swkImageCanvas.setEventCurrentShape(null);
                }
                SwkCanvas.this.checkForMouseExit(mEvent);
                if (SwkCanvas.this.currentTags == null) {
                    return;
                }
                for (int i = 0; i < SwkCanvas.this.currentTags.length; ++i) {
                    SwkCanvas.this.currentTag = SwkCanvas.this.getTagOrIDFromTagID(SwkCanvas.this.currentTags[i].toString());
                    SwkCanvas.this.processMouse(mEvent, 2, 1);
                }
            }

            public void mouseClicked(MouseEvent mEvent) {
                SwkCanvas.this.swkImageCanvas.transformMouse(mEvent);
                SwkCanvas.this.currentTags = SwkCanvas.this.getTagFromEvent(mEvent);
                if (SwkCanvas.this.currentTags == null) {
                    return;
                }
                for (int i = 0; i < SwkCanvas.this.currentTags.length; ++i) {
                    SwkCanvas.this.currentTag = SwkCanvas.this.getTagOrIDFromTagID(SwkCanvas.this.currentTags[i].toString());
                    SwkCanvas.this.processMouse(mEvent, 2, 2);
                }
            }

            public void mouseEntered(MouseEvent mEvent) {
                SwkCanvas.this.swkImageCanvas.transformMouse(mEvent);
            }

            public void mouseExited(MouseEvent mEvent) {
                SwkCanvas.this.swkImageCanvas.transformMouse(mEvent);
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            public void mouseDragged(MouseEvent mEvent) {
                SwkCanvas.this.swkImageCanvas.transformMouse(mEvent);
                SwkCanvas.this.processMouseMotion(mEvent);
            }

            public void mouseMoved(MouseEvent mEvent) {
                SwkCanvas.this.swkImageCanvas.transformMouse(mEvent);
                SwkCanvas.this.processMouseMotion(mEvent);
            }
        });
        this.setTransferHandler(new ImageSelection());
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent fEvent) {
                FocusCmd.setFocusWindow(SwkCanvas.this.getName());
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mEvent) {
                mEvent.getComponent().requestFocus();
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent mEvent) {
                SwkCanvas.this.mouseX = mEvent.getX();
                SwkCanvas.this.mouseY = mEvent.getY();
            }

            public void mouseDragged(MouseEvent mEvent) {
                SwkCanvas.this.mouseX = mEvent.getX();
                SwkCanvas.this.mouseY = mEvent.getY();
            }
        });
        this.tagList.add(name);
        this.tagList.add(className);
        this.tagList.add("swank");
        this.tagList.add("all");
    }

    public static void getWidgetOptions(Interp interp) throws TclException {
        TclObject result = TclList.newInstance();
        int n = validCmds.length;
        for (int i = 0; i < n; ++i) {
            TclList.append((Interp)interp, (TclObject)result, (TclObject)TclString.newInstance((String)validCmds[i]));
        }
        interp.setResult(result);
    }

    public static void getWidgetCmds(Interp interp) throws TclException {
        TclObject result = TclList.newInstance();
        String[] validCmds = SwkCanvasWidgetCmd.getValidCmds();
        int n = validCmds.length;
        for (int i = 0; i < n; ++i) {
            TclList.append((Interp)interp, (TclObject)result, (TclObject)TclString.newInstance((String)validCmds[i]));
        }
        interp.setResult(result);
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
        int result = 1;
        if (pageIndex == 0) {
            Graphics2D g2 = (Graphics2D)g;
            double pX = pageFormat.getImageableX();
            double pY = pageFormat.getImageableY();
            double pW = pageFormat.getImageableWidth();
            double pH = pageFormat.getImageableHeight();
            Dimension dimSize = this.getSize();
            double sx = 1.0;
            double sy = 1.0;
            if ((double)dimSize.width > pW) {
                sx = pW / (double)dimSize.width;
                sy = pW / (double)dimSize.width;
            }
            if ((double)dimSize.height * sx > pH) {
                sy = sx * pH / ((double)dimSize.height * sx);
                sx = sx * pH / ((double)dimSize.height * sx);
            }
            g2.translate(pX, pY);
            g2.scale(sx, sy);
            boolean wasBuffered = SwankUtil.disableDoubleBuffering(this);
            this.swkImageCanvas.setSize(this.getSize());
            this.swkImageCanvas.paintComponent(g, null);
            SwankUtil.restoreDoubleBuffering(this, wasBuffered);
            result = 0;
        }
        return result;
    }

    @Override
    public Vector getTagList() {
        return this.tagList;
    }

    @Override
    public void setTagList(Interp interp, TclObject tagListObj) throws TclException {
        TclObject[] tagObjs = TclList.getElements((Interp)interp, (TclObject)tagListObj);
        this.tagList.setSize(0);
        for (int i = 0; i < tagObjs.length; ++i) {
            this.tagList.add(tagObjs[i].toString());
        }
    }

    @Override
    public void setVirtualBindings(ArrayList<SwkBinding> bindings) {
        this.virtualBindings = bindings;
    }

    @Override
    public ArrayList<SwkBinding> getVirtualBindings() {
        return this.virtualBindings;
    }

    @Override
    public Insets getEmptyBorderInsets() {
        return this.emptyBorderInsets;
    }

    @Override
    public LinkedList getChildrenList() {
        return this.children;
    }

    @Override
    public void initChildrenList() {
        this.children = new LinkedList();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setJHelpTarget(String jhelptarget) {
        this.jhelptarget = jhelptarget;
        SwankUtil.setJHelpTarget(this, jhelptarget);
    }

    public String getJHelpTarget() {
        return this.jhelptarget;
    }

    public void setInsertBackground(Color insertBackground) {
        this.insertBackground = insertBackground;
    }

    public Color getInsertBackground() {
        return this.insertBackground;
    }

    public void setInsertWidth(int insertWidth) {
        this.insertWidth = insertWidth;
    }

    public int getInsertWidth() {
        return this.insertWidth;
    }

    public void setInsertBorderWidth(int insertBorderWidth) {
        this.insertBorderWidth = insertBorderWidth;
    }

    public int getInsertBorderWidth() {
        return this.insertBorderWidth;
    }

    public void setInsertOffTime(int insertOffTime) {
        this.insertOffTime = insertOffTime;
    }

    public int getInsertOffTime() {
        return this.insertOffTime;
    }

    public void setInsertOnTime(int insertOnTime) {
        this.insertOnTime = insertOnTime;
    }

    public int getInsertOnTime() {
        return this.insertOnTime;
    }

    public void setScrollRegion(int[][] scrollRegion) {
        this.swkImageCanvas.scrollRegion[0][0] = scrollRegion[0][0];
        this.swkImageCanvas.scrollRegion[0][1] = scrollRegion[0][1];
        this.swkImageCanvas.scrollRegion[1][0] = scrollRegion[1][0];
        this.swkImageCanvas.scrollRegion[1][1] = scrollRegion[1][1];
    }

    public int[][] getScrollRegion() {
        return this.swkImageCanvas.scrollRegion;
    }

    public void setAnchor(float[] anchor) {
        this.anchor = anchor;
    }

    public float[] getAnchor() {
        return this.anchor;
    }

    public void setBorderWidth(double borderWidth) {
        this.borderWidth = (int)borderWidth;
        if (!(this.getBorder() instanceof SwkBorder)) {
            this.setBorder(new SwkBorder());
        }
    }

    @Override
    public int getBorderWidth() {
        return this.borderWidth;
    }

    public void setHighlightBackground(Color highlightBackground) {
        this.highlightBackground = highlightBackground;
    }

    public Color getHighlightBackground() {
        return this.highlightBackground;
    }

    public void setHighlightColor(Color highlightColor) {
        this.highlightColor = highlightColor;
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public void setHighlightThickness(int highlightThickness) {
        this.highlightThickness = highlightThickness;
    }

    public int getHighlightThickness() {
        return this.highlightThickness;
    }

    public void setPadx(int padx) {
        this.emptyBorderInsets.left = this.padx = padx;
        this.emptyBorderInsets.right = this.padx;
        this.minimumSize = null;
    }

    public int getPadx() {
        return this.padx;
    }

    public void setPady(int pady) {
        this.emptyBorderInsets.top = this.pady = pady;
        this.emptyBorderInsets.bottom = this.pady;
        this.minimumSize = null;
    }

    public int getPady() {
        return this.pady;
    }

    public void setRelief(String relief) {
        if (!(this.getBorder() instanceof SwkBorder)) {
            this.setBorder(new SwkBorder());
        }
        this.relief = relief.intern();
    }

    @Override
    public String getRelief() {
        if (this.relief == null) {
            this.relief = "";
        }
        return this.relief;
    }

    public void setXScrollCommand(String xScrollCommand) {
        this.xScrollCommand = xScrollCommand.intern();
    }

    public String getXScrollCommand() {
        return this.xScrollCommand;
    }

    public void setYScrollCommand(String yScrollCommand) {
        this.yScrollCommand = yScrollCommand.intern();
    }

    public String getYScrollCommand() {
        return this.yScrollCommand;
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        this.fRC = g2.getFontRenderContext();
        Dimension dimSize = this.getSize();
        int w = dimSize.width;
        int h = dimSize.height;
        if (w <= 0 || h <= 0) {
            return;
        }
        this.swkImageCanvas.setSize(this.getSize());
        this.swkImageCanvas.paintComponent(g, this.bufOffscreen);
        this.changed = false;
    }

    public BufferStrategy getBufferStrategy() {
        BufferStrategy bufferStrategy = null;
        Component comp = Widgets.getFrameOrWindow(this.getParent());
        if (comp instanceof Window) {
            bufferStrategy = ((Window)comp).getBufferStrategy();
        }
        return bufferStrategy;
    }

    public SwkImageCanvas getSwkImageCanvas() {
        return this.swkImageCanvas;
    }

    public void setZoom(double newZoom) {
        this.zoom = newZoom;
    }

    public double getZoom() {
        return this.zoom;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        Dimension dim = new Dimension(this.swkwidth, this.swkheight);
        try {
            JViewport viewport = Widgets.getViewport(this);
            if (viewport != null) {
                Dimension vdim = viewport.getSize();
                if (this.swkwidth < vdim.width) {
                    dim.width = vdim.width;
                }
                if (this.swkheight < vdim.height) {
                    dim.height = vdim.height;
                }
            }
        }
        catch (TclException tclException) {
            // empty catch block
        }
        return dim;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int direction, int orientation) {
        return 1;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int direction, int orientation) {
        return 1;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public void setHandleCursor(Cursor cursor) {
        if (this.previousCursor == null) {
            this.previousCursor = this.getCursor();
        }
        super.setCursor(cursor);
    }

    @Override
    public void setCursor(Cursor cursor) {
        this.previousCursor = cursor;
        super.setCursor(cursor);
    }

    void processMouseMotion(MouseEvent mEvent) {
        this.previousTags = this.currentTags;
        int buttonMask = 28;
        int mods = mEvent.getModifiers();
        if ((mods & buttonMask) == 0) {
            this.currentTags = this.getTagFromEvent(mEvent);
            this.checkForMouseExit(mEvent);
            this.hitShape = new HitShape(this.swkImageCanvas.getLastShapeScanned(), this.swkImageCanvas.getHandle());
            if (this.hitShape != null && this.hitShape.handle >= 0 && this.hitShape.swkShape != null) {
                this.setHandleCursor(this.hitShape.swkShape.getHandleCursor(this.hitShape.handle));
            } else if (this.previousCursor != null) {
                this.setHandleCursor(this.previousCursor);
            }
            this.checkForMouseEnter(mEvent);
        }
        if (this.currentTags != null) {
            for (int i = 0; i < this.currentTags.length; ++i) {
                this.currentTag = this.getTagOrIDFromTagID(this.currentTags[i].toString());
                this.processMouse(mEvent, 4, 9);
            }
        }
    }

    void checkForMouseExit(MouseEvent mEvent) {
        block4: {
            boolean stillPresent;
            block3: {
                stillPresent = true;
                if (this.currentTags != null || this.previousTags == null) break block3;
                for (int i = 0; i < this.previousTags.length; ++i) {
                    this.previousTag = this.getTagOrIDFromTagID(this.previousTags[i].toString());
                    this.processMouse(mEvent, 2, 4);
                }
                break block4;
            }
            if (this.currentTags == null || this.previousTags == null) break block4;
            for (int i = 0; i < this.previousTags.length; ++i) {
                this.previousTag = this.previousTags[i].toString();
                stillPresent = false;
                for (int j = 0; j < this.currentTags.length; ++j) {
                    String thisTag = this.currentTags[j].toString();
                    if (!this.previousTags[i].toString().equals(thisTag)) continue;
                    stillPresent = true;
                    break;
                }
                if (stillPresent) continue;
                this.previousTag = this.getTagOrIDFromTagID(this.previousTag);
                this.processMouse(mEvent, 2, 4);
            }
        }
    }

    void checkForMouseEnter(MouseEvent mEvent) {
        block4: {
            boolean wasPresent;
            block3: {
                wasPresent = true;
                if (this.currentTags == null || this.previousTags != null) break block3;
                for (int i = 0; i < this.currentTags.length; ++i) {
                    this.currentTag = this.getTagOrIDFromTagID(this.currentTags[i].toString());
                    this.processMouse(mEvent, 2, 3);
                }
                break block4;
            }
            if (this.currentTags == null || this.previousTags == null) break block4;
            for (int i = 0; i < this.currentTags.length; ++i) {
                String thisTag = this.currentTags[i].toString();
                wasPresent = false;
                for (int j = 0; j < this.previousTags.length; ++j) {
                    if (!this.previousTags[j].toString().equals(thisTag)) continue;
                    wasPresent = true;
                    break;
                }
                if (wasPresent) continue;
                this.currentTag = this.getTagOrIDFromTagID(thisTag);
                this.processMouse(mEvent, 2, 3);
            }
        }
    }

    public void processKey(KeyEvent e, int subtype) {
        BindEvent bEvent = new BindEvent(this.interp, this, e, 3, subtype, this.currentTag, this.previousTag, this.hitShape);
        this.interp.getNotifier().queueEvent((TclEvent)bEvent, 0);
    }

    public void processMouse(MouseEvent e, int type, int subtype) {
        BindEvent bEvent = new BindEvent(this.interp, this, e, type, subtype, this.currentTag, this.previousTag, this.hitShape);
        this.interp.getNotifier().queueEvent((TclEvent)bEvent, 0);
    }

    public void processEvent(EventObject eventObject, int type, int subtype, String currentTag, String previousTag, HitShape eventCurrentShape) {
        if (eventObject instanceof KeyEvent) {
            this.processKeyEvent((KeyEvent)eventObject, type, subtype, currentTag, previousTag, eventCurrentShape);
        } else {
            this.processMouseEvent(eventObject, type, subtype, currentTag, previousTag, eventCurrentShape);
        }
    }

    public void processKeyEvent(KeyEvent e, int type, int subtype, String currentTag, String previousTag, HitShape eventCurrentShape) {
        boolean debug = false;
        int mods = e.getModifiersEx();
        char keyChar = e.getKeyChar();
        if (Character.isISOControl(keyChar)) {
            keyChar = (char)(keyChar + 96);
        }
        int keyCode = e.getKeyCode();
        if (!debug || keyChar == '\uffff') {
            // empty if block
        }
        if (Character.isISOControl(keyChar)) {
            keyChar = (char)(keyChar + 64);
        }
        KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(e);
        boolean nativeProcessEvent = true;
        boolean breakOut = false;
        if (e.isConsumed()) {
            return;
        }
        this.swkImageCanvas.setEventCurrentShape(eventCurrentShape);
        ArrayList<SwkBinding> bindings = this.getBindings(currentTag, type, subtype);
        if (bindings == null) {
            return;
        }
        SwkBinding lastBinding = null;
        for (int i = 0; i < bindings.size(); ++i) {
            SwkBinding binding = bindings.get(i);
            if (binding.subtype != subtype || binding.subtype == 0 && binding.detail == 0 || !(binding.subtype == 1 && binding.detail == 0 || binding.subtype == 11 && binding.detail == 0) && (binding.keyStroke != null ? binding.detail != keyCode || binding.mod != mods : binding.detail != keyChar || binding.mod != mods && (binding.mod | 0x40) != mods)) continue;
            if (binding.command != null && binding.command.length() != 0) {
                try {
                    BindCmd.doCmd(this.interp, binding.command, e, eventCurrentShape);
                }
                catch (TclException tclE) {
                    if (tclE.getCompletionCode() == 3) {
                        e.consume();
                        return;
                    }
                    this.interp.addErrorInfo("\n    (\"binding\" script)");
                    this.interp.backgroundError();
                }
            }
            lastBinding = binding;
        }
    }

    ArrayList<SwkBinding> getBindings(String checkTag, int type, int subtype) {
        ArrayList bindings = null;
        if (type == 1) {
            if (checkTag != null && this.focusHash != null) {
                bindings = (ArrayList)this.focusHash.get(checkTag);
            }
        } else if (type == 2) {
            if (subtype == 4) {
                if (checkTag != null && this.mouseHash != null) {
                    bindings = (ArrayList)this.mouseHash.get(checkTag);
                }
            } else if (checkTag != null && this.mouseHash != null) {
                bindings = (ArrayList)this.mouseHash.get(checkTag);
            }
        } else if (type == 4) {
            if (checkTag != null && this.mouseMotionHash != null) {
                bindings = (ArrayList)this.mouseMotionHash.get(checkTag);
            }
        } else if (type == 3 && checkTag != null && this.keyHash != null) {
            bindings = (ArrayList)this.keyHash.get(checkTag);
        }
        return bindings;
    }

    public void processMouseEvent(EventObject eventObject, int type, int subtype, String currentTag, String previousTag, HitShape eventCurrentShape) {
        InputEvent iE = (InputEvent)eventObject;
        if (iE.isConsumed()) {
            return;
        }
        this.swkImageCanvas.setEventCurrentShape(eventCurrentShape);
        ArrayList<SwkBinding> bindings = null;
        bindings = subtype == 4 ? this.getBindings(previousTag, type, subtype) : this.getBindings(currentTag, type, subtype);
        if (bindings == null) {
            return;
        }
        MouseEvent mE = null;
        int mods = iE.getModifiersEx();
        int buttons = 0;
        if (iE instanceof MouseEvent) {
            mE = (MouseEvent)iE;
            buttons = mE.getButton();
        }
        SwkBinding lastBinding = null;
        for (int i = 0; i < bindings.size(); ++i) {
            SwkBinding binding = bindings.get(i);
            if (binding.subtype != subtype) continue;
            if (subtype != 3 && subtype != 4) {
                if (type == 2 && mE.getClickCount() > 0 && binding.count > mE.getClickCount() || (type != 4 ? type == 2 && !SwkMouseMotionListener.checkButtons(binding.detail, buttons) : !SwkMouseMotionListener.checkButtonState(mE, binding.mod, mods))) continue;
                if (!SwkMouseMotionListener.checkMods(binding.mod, mods)) continue;
            }
            if (binding.sameButClick(lastBinding)) continue;
            if (binding.command != null && binding.command.length() != 0) {
                try {
                    BindCmd.doCmd(this.interp, binding.command, iE, eventCurrentShape);
                }
                catch (TclException tclE) {
                    if (tclE.getCompletionCode() == 3) {
                        iE.consume();
                        return;
                    }
                    this.interp.addErrorInfo("\n    (\"binding\" script)");
                    this.interp.backgroundError();
                }
            }
            lastBinding = binding;
        }
    }

    String getTagOrIDFromTagID(String tagID) {
        int spacePos = tagID.indexOf(" ");
        if (spacePos == -1) {
            return tagID;
        }
        return tagID.substring(0, spacePos);
    }

    public TclObject[] getTagFromEvent(MouseEvent mEvent) {
        this.currentTag = null;
        return this.swkImageCanvas.scanCanvasForTags(mEvent.getX(), mEvent.getY());
    }

    public TclObject[] getTagFromKeyEvent(int x, int y) {
        this.currentTag = null;
        return this.swkImageCanvas.scanCanvasForTags(x, y);
    }

    public void removeBindingsForTag(String tagName) {
        this.focusHash.remove(tagName);
        this.mouseHash.remove(tagName);
        this.mouseMotionHash.remove(tagName);
        this.keyHash.remove(tagName);
    }

    public void setupBinding(Interp interp, SwkBinding newBinding, String tagName) {
        ArrayList<SwkBinding> bindVec = null;
        if (newBinding.type == 1) {
            if (this.focusHash == null) {
                this.focusHash = new LinkedHashMap();
                bindVec = new ArrayList<SwkBinding>(2);
                this.focusHash.put(tagName, bindVec);
            } else {
                bindVec = (ArrayList<SwkBinding>)this.focusHash.get(tagName);
                if (bindVec == null) {
                    bindVec = new ArrayList<SwkBinding>(2);
                    this.focusHash.put(tagName, bindVec);
                }
            }
        } else if (newBinding.type == 2) {
            if (this.mouseHash == null) {
                this.mouseHash = new LinkedHashMap();
                bindVec = new ArrayList(2);
                this.mouseHash.put(tagName, bindVec);
            } else {
                bindVec = (ArrayList<SwkBinding>)this.mouseHash.get(tagName);
                if (bindVec == null) {
                    bindVec = new ArrayList<SwkBinding>(2);
                    this.mouseHash.put(tagName, bindVec);
                }
            }
        } else if (newBinding.type == 4) {
            if (this.mouseMotionHash == null) {
                this.mouseMotionHash = new LinkedHashMap();
                bindVec = new ArrayList(2);
                this.mouseMotionHash.put(tagName, bindVec);
            } else {
                bindVec = (ArrayList<SwkBinding>)this.mouseMotionHash.get(tagName);
                if (bindVec == null) {
                    bindVec = new ArrayList<SwkBinding>(2);
                    this.mouseMotionHash.put(tagName, bindVec);
                }
            }
        } else if (newBinding.type == 3) {
            if (this.keyHash == null) {
                this.keyHash = new LinkedHashMap();
                bindVec = new ArrayList(2);
                this.keyHash.put(tagName, bindVec);
            } else {
                bindVec = (ArrayList<SwkBinding>)this.keyHash.get(tagName);
                if (bindVec == null) {
                    bindVec = new ArrayList(2);
                    this.keyHash.put(tagName, bindVec);
                }
            }
        }
        if (bindVec != null) {
            if (!newBinding.add) {
                for (int i = 0; i < bindVec.size(); ++i) {
                    SwkBinding binding = (SwkBinding)bindVec.get(i);
                    if (!binding.equals(newBinding)) continue;
                    bindVec.add(i, newBinding);
                    return;
                }
            }
            bindVec.add(newBinding);
        }
    }

    public void drawBox(int x1, int y1, int width, int height) {
        Graphics g = this.getGraphics();
        g.setXORMode(this.getBackground());
        g.drawRect(x1, y1, width, height);
        g.dispose();
    }

    public void copyImageToClipboard(Clipboard clipboard) {
        TransferHandler handler = this.getTransferHandler();
        handler.exportToClipboard(this, clipboard, 1);
    }

    public Image paintImage() {
        Dimension d = this.getSize();
        Image offscreen = this.createImage(d.width, d.height);
        Graphics2D offgraphics = (Graphics2D)offscreen.getGraphics();
        boolean wasBuffered = SwankUtil.disableDoubleBuffering(this);
        this.paint(offgraphics);
        offgraphics.dispose();
        SwankUtil.restoreDoubleBuffering(this, wasBuffered);
        return offscreen;
    }

    FontRenderContext getFontRenderContext() {
        return this.fRC;
    }

    @Override
    public Dimension getMinimumSize() {
        int[][] scrollRegion = this.getScrollRegion();
        Dimension dSize = new Dimension(scrollRegion[1][0] - scrollRegion[0][0], scrollRegion[1][1] - scrollRegion[0][1]);
        if (dSize.width < this.swkwidth) {
            dSize.width = this.swkwidth;
        }
        if (dSize.height < this.swkheight) {
            dSize.height = this.swkheight;
        }
        return dSize;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void setSwkHeight(int height) {
        this.swkheight = height;
    }

    public int getSwkHeight() {
        Dimension size = this.getSize();
        return size.height;
    }

    public void setSwkWidth(int width) {
        this.swkwidth = width;
    }

    public int getSwkWidth() {
        Dimension size = this.getSize();
        return size.width;
    }

    @Override
    public boolean isCreated() {
        return this.created;
    }

    @Override
    public void setCreated(boolean state) {
        this.created = state;
    }

    @Override
    public int getMouseX() {
        return this.mouseX;
    }

    @Override
    public int getMouseY() {
        return this.mouseY;
    }

    @Override
    public SwkMouseListener getMouseListener() {
        return this.mouseListener;
    }

    @Override
    public void setMouseListener(SwkMouseListener mouseListener) {
        this.mouseListener = mouseListener;
    }

    @Override
    public SwkFocusListener getFocusListener() {
        return this.focusListener;
    }

    @Override
    public void setFocusListener(SwkFocusListener focusListener) {
        this.focusListener = focusListener;
    }

    @Override
    public SwkComponentListener getComponentListener() {
        return this.componentListener;
    }

    @Override
    public void setComponentListener(SwkComponentListener componentListener) {
        this.componentListener = componentListener;
    }

    @Override
    public SwkChangeListener getChangeListener() {
        return this.changeListener;
    }

    @Override
    public void setChangeListener(SwkChangeListener changeListener) {
        this.changeListener = changeListener;
    }

    @Override
    public SwkKeyListener getKeyListener() {
        return this.keyListener;
    }

    @Override
    public void setKeyListener(SwkKeyListener keyListener) {
        this.keyListener = keyListener;
    }

    public SwkKeyCommandListener getKeyCommandListener() {
        return this.keyCommandListener;
    }

    public void setKeyCommandListener(SwkKeyCommandListener keyCommandListener) {
        this.keyCommandListener = keyCommandListener;
    }

    @Override
    public SwkMouseMotionListener getMouseMotionListener() {
        return this.mouseMotionListener;
    }

    @Override
    public void setMouseListener(SwkMouseMotionListener mouseMotionListener) {
        this.mouseMotionListener = mouseMotionListener;
    }

    public void setClassName(String className) {
        this.className = className.intern();
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public void close() throws TclException {
        this.swkImageCanvas.close();
    }

    void jgetAll(Interp interp) throws TclException {
        if (EventQueue.isDispatchThread()) {
            System.out.println("never  run on event thread");
        }
        JGetAll jgetAll = new JGetAll(this);
        try {
            SwingUtilities.invokeAndWait(jgetAll);
        }
        catch (InterruptedException iE) {
            throw new TclException(interp, iE.toString());
        }
        catch (Exception e) {
            throw new TclException(interp, e.toString());
        }
        this.getAllConfigurations(interp, jgetAll.roValues);
    }

    ArrayList getAllConfigurations() {
        int nCmds = validCmds.length;
        ArrayList<Object> results = new ArrayList<Object>();
        Enumeration e = resourceDB.keys();
        while (e.hasMoreElements()) {
            String keyName = (String)e.nextElement();
            ResourceObject ro = (ResourceObject)resourceDB.get(keyName);
            if (ro == null) continue;
            String value = this.jget(ro.optNum);
            results.add(keyName);
            results.add(ro);
            results.add(value);
        }
        return results;
    }

    void getAllConfigurations(Interp interp, ArrayList roValues) throws TclException {
        TclObject list2 = TclList.newInstance();
        int n = roValues.size();
        for (int i = 0; i < n; i += 3) {
            TclObject list1 = TclList.newInstance();
            String keyName = (String)roValues.get(i);
            ResourceObject ro = (ResourceObject)roValues.get(i + 1);
            String value = (String)roValues.get(i + 2);
            if (ro == null) continue;
            TclObject tObj = TclString.newInstance((String)keyName);
            TclList.append((Interp)interp, (TclObject)list1, (TclObject)tObj);
            TclList.append((Interp)interp, (TclObject)list1, (TclObject)TclString.newInstance((String)ro.resource));
            TclList.append((Interp)interp, (TclObject)list1, (TclObject)TclString.newInstance((String)ro.className));
            if (ro.defaultVal == null) {
                TclList.append((Interp)interp, (TclObject)list1, (TclObject)TclString.newInstance((String)""));
            } else {
                TclList.append((Interp)interp, (TclObject)list1, (TclObject)TclString.newInstance((String)ro.defaultVal));
            }
            if (value == null) {
                value = "";
            }
            TclList.append((Interp)interp, (TclObject)list1, (TclObject)TclString.newInstance((String)value));
            TclList.append((Interp)interp, (TclObject)list2, (TclObject)list1);
        }
        interp.setResult(list2);
    }

    @Override
    public void setValues(Setter setter, int opt) {
        switch (opt) {
            case 0: {
                this.setAnchor((float[])setter.oValue);
                break;
            }
            case 1: {
                this.setAutoscrolls(setter.bValue);
                break;
            }
            case 2: {
                this.setBackground((Color)setter.oValue);
                break;
            }
            case 3: {
                this.setBorderWidth(setter.dValue);
                break;
            }
            case 4: {
                this.setBackground((Color)setter.oValue);
                break;
            }
            case 5: {
                this.setBorderWidth(setter.dValue);
                break;
            }
            case 6: {
                this.setBorderWidth(setter.dValue);
                break;
            }
            case 7: {
                this.setClassName(setter.sValue);
                break;
            }
            case 8: {
                this.setCursor((Cursor)setter.oValue);
                break;
            }
            case 9: {
                this.setEnabled(setter.bValue);
                break;
            }
            case 10: {
                this.setForeground((Color)setter.oValue);
                break;
            }
            case 11: {
                this.setFocusable(setter.bValue);
                break;
            }
            case 12: {
                this.setFocusCycleRoot(setter.bValue);
                break;
            }
            case 13: {
                this.setFocusTraversalKeysEnabled(setter.bValue);
                break;
            }
            case 14: {
                this.setFocusTraversalPolicyProvider(setter.bValue);
                break;
            }
            case 15: {
                this.setFont((Font)setter.oValue);
                break;
            }
            case 16: {
                this.setForeground((Color)setter.oValue);
                break;
            }
            case 17: {
                this.setSwkHeight(setter.iValue);
                break;
            }
            case 18: {
                this.setHighlightBackground((Color)setter.oValue);
                break;
            }
            case 19: {
                this.setHighlightColor((Color)setter.oValue);
                break;
            }
            case 20: {
                this.setHighlightThickness(setter.iValue);
                break;
            }
            case 21: {
                this.setInsertBackground((Color)setter.oValue);
                break;
            }
            case 22: {
                this.setInsertBorderWidth(setter.iValue);
                break;
            }
            case 23: {
                this.setInsertOffTime(setter.iValue);
                break;
            }
            case 24: {
                this.setInsertOnTime(setter.iValue);
                break;
            }
            case 25: {
                this.setInsertWidth(setter.iValue);
                break;
            }
            case 26: {
                this.setJHelpTarget(setter.sValue);
                break;
            }
            case 27: {
                this.setOpaque(setter.bValue);
                break;
            }
            case 28: {
                this.setPadx(setter.iValue);
                break;
            }
            case 29: {
                this.setPady(setter.iValue);
                break;
            }
            case 30: {
                this.setRelief(setter.sValue);
                break;
            }
            case 31: {
                this.setRequestFocusEnabled(setter.bValue);
                break;
            }
            case 32: {
                this.setScrollRegion((int[][])setter.oValue);
                break;
            }
            case 33: {
                this.setToolTipText(setter.sValue);
                break;
            }
            case 34: {
                this.setVerifyInputWhenFocusTarget(setter.bValue);
                break;
            }
            case 35: {
                this.setVisible(setter.bValue);
                break;
            }
            case 36: {
                this.setSwkWidth(setter.iValue);
                break;
            }
            case 37: {
                this.setXScrollCommand(setter.sValue);
                break;
            }
            case 38: {
                this.setYScrollCommand(setter.sValue);
            }
        }
    }

    @Override
    public void configure(Interp interp, TclObject[] argv, int start) throws TclException {
        if (EventQueue.isDispatchThread()) {
            throw new RuntimeException("Configure on eventQueue");
        }
        if (argv.length <= start) {
            return;
        }
        ResourceObject ro = null;
        block41: for (int i = start; i < argv.length; i += 2) {
            if (i + 1 >= argv.length) {
                throw new TclException(interp, "value for \"" + argv[i].toString() + "\" missing");
            }
            ro = (ResourceObject)resourceDB.get(argv[i].toString());
            if (ro == null) {
                throw new TclException(interp, "unknown option \"" + argv[i].toString() + "\"");
            }
            int opt = SwkIndex.get(interp, argv[i], validCmdsTM, "option", 0);
            switch (opt) {
                case 0: {
                    float[] value = SwankUtil.getAnchor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block41;
                }
                case 1: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block41;
                }
                case 2: {
                    Color value = SwankUtil.getColor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block41;
                }
                case 3: {
                    double value = SwankUtil.getTkSizeD(interp, this, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block41;
                }
                case 4: {
                    Color value = SwankUtil.getColor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block41;
                }
                case 5: {
                    double value = SwankUtil.getTkSizeD(interp, this, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block41;
                }
                case 6: {
                    double value = SwankUtil.getTkSizeD(interp, this, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block41;
                }
                case 7: {
                    String value = argv[i + 1].toString();
                    new Setter(this, opt).exec(value);
                    continue block41;
                }
                case 8: {
                    Cursor value = SwankUtil.getCursor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block41;
                }
                case 9: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block41;
                }
                case 10: {
                    Color value = SwankUtil.getColor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block41;
                }
                case 11: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block41;
                }
                case 12: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block41;
                }
                case 13: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block41;
                }
                case 14: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block41;
                }
                case 15: {
                    Font value = SwankUtil.getFont(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block41;
                }
                case 16: {
                    Color value = SwankUtil.getColor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block41;
                }
                case 17: {
                    int value = SwankUtil.getTkSize(interp, (Component)this, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block41;
                }
                case 18: {
                    Color value = SwankUtil.getColor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block41;
                }
                case 19: {
                    Color value = SwankUtil.getColor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block41;
                }
                case 20: {
                    int value = SwankUtil.getTkSize(interp, (Component)this, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block41;
                }
                case 21: {
                    Color value = SwankUtil.getColor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block41;
                }
                case 22: {
                    int value = SwankUtil.getTkSize(interp, (Component)this, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block41;
                }
                case 23: {
                    int value = TclInteger.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block41;
                }
                case 24: {
                    int value = TclInteger.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block41;
                }
                case 25: {
                    int value = SwankUtil.getTkSize(interp, (Component)this, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block41;
                }
                case 26: {
                    String value = argv[i + 1].toString();
                    new Setter(this, opt).exec(value);
                    continue block41;
                }
                case 27: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block41;
                }
                case 28: {
                    int value = SwankUtil.getTkSize(interp, (Component)this, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block41;
                }
                case 29: {
                    int value = SwankUtil.getTkSize(interp, (Component)this, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block41;
                }
                case 30: {
                    String value = SwankUtil.getTkRelief(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block41;
                }
                case 31: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block41;
                }
                case 32: {
                    int[][] value = SwankUtil.getTkRectangleCorners(interp, this, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block41;
                }
                case 33: {
                    String value = argv[i + 1].toString();
                    new Setter(this, opt).exec(value);
                    continue block41;
                }
                case 34: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block41;
                }
                case 35: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block41;
                }
                case 36: {
                    int value = SwankUtil.getTkSize(interp, (Component)this, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block41;
                }
                case 37: {
                    String value = argv[i + 1].toString();
                    new Setter(this, opt).exec(value);
                    continue block41;
                }
                case 38: {
                    String value = argv[i + 1].toString();
                    new Setter(this, opt).exec(value);
                    continue block41;
                }
            }
        }
        SwankUtil.doWait();
        this.repaint();
    }

    String jget(int opt) {
        switch (opt) {
            case 0: {
                return SwankUtil.parseAnchor(this.getAnchor());
            }
            case 1: {
                return String.valueOf(this.getAutoscrolls());
            }
            case 2: {
                return SwankUtil.parseColor(this.getBackground());
            }
            case 3: {
                return SwankUtil.parseTkSize(this.getBorderWidth());
            }
            case 4: {
                return SwankUtil.parseColor(this.getBackground());
            }
            case 5: {
                return SwankUtil.parseTkSize(this.getBorderWidth());
            }
            case 6: {
                return SwankUtil.parseTkSize(this.getBorderWidth());
            }
            case 7: {
                return this.getClassName();
            }
            case 8: {
                return SwankUtil.parseCursor(this.getCursor());
            }
            case 9: {
                return this.isEnabled() ? "1" : "0";
            }
            case 10: {
                return SwankUtil.parseColor(this.getForeground());
            }
            case 11: {
                return this.isFocusable() ? "1" : "0";
            }
            case 12: {
                return this.isFocusCycleRoot() ? "1" : "0";
            }
            case 13: {
                return String.valueOf(this.getFocusTraversalKeysEnabled());
            }
            case 14: {
                return this.isFocusTraversalPolicyProvider() ? "1" : "0";
            }
            case 15: {
                return SwankUtil.parseFont(this.getFont());
            }
            case 16: {
                return SwankUtil.parseColor(this.getForeground());
            }
            case 17: {
                return SwankUtil.parseTkSize(this.getSwkHeight());
            }
            case 18: {
                return SwankUtil.parseColor(this.getHighlightBackground());
            }
            case 19: {
                return SwankUtil.parseColor(this.getHighlightColor());
            }
            case 20: {
                return SwankUtil.parseTkSize(this.getHighlightThickness());
            }
            case 21: {
                return SwankUtil.parseColor(this.getInsertBackground());
            }
            case 22: {
                return SwankUtil.parseTkSize(this.getInsertBorderWidth());
            }
            case 23: {
                return Integer.toString(this.getInsertOffTime());
            }
            case 24: {
                return Integer.toString(this.getInsertOnTime());
            }
            case 25: {
                return SwankUtil.parseTkSize(this.getInsertWidth());
            }
            case 26: {
                return this.getJHelpTarget();
            }
            case 27: {
                return this.isOpaque() ? "1" : "0";
            }
            case 28: {
                return SwankUtil.parseTkSize(this.getPadx());
            }
            case 29: {
                return SwankUtil.parseTkSize(this.getPady());
            }
            case 30: {
                return SwankUtil.parseTkRelief(this.getRelief());
            }
            case 31: {
                return this.isRequestFocusEnabled() ? "1" : "0";
            }
            case 32: {
                return SwankUtil.parseTkRectangleCorners(this.getScrollRegion());
            }
            case 33: {
                return this.getToolTipText();
            }
            case 34: {
                return String.valueOf(this.getVerifyInputWhenFocusTarget());
            }
            case 35: {
                return this.isVisible() ? "1" : "0";
            }
            case 36: {
                return SwankUtil.parseTkSize(this.getSwkWidth());
            }
            case 37: {
                return this.getXScrollCommand();
            }
            case 38: {
                return this.getYScrollCommand();
            }
        }
        return "";
    }

    String jget(Interp interp, TclObject arg) throws TclException {
        int opt = 0;
        try {
            opt = SwkIndex.get(interp, arg, validCmdsTM, "option", 0);
        }
        catch (TclException tclE) {
            throw new TclException(interp, "unknown option \"" + arg + "\"");
        }
        String result = "";
        if (!EventQueue.isDispatchThread()) {
            JGet jget = new JGet(this, opt);
            try {
                SwingUtilities.invokeAndWait(jget);
            }
            catch (InterruptedException iE) {
                throw new TclException(interp, iE.toString());
            }
            catch (Exception e) {
                throw new TclException(interp, e.toString());
            }
            result = jget.result;
        } else {
            result = this.jget(opt);
        }
        return result;
    }

    void setResourceDefaults() throws TclException {
        if (!EventQueue.isDispatchThread()) {
            ResourceDefaultsSetter resourceDefaultsSetter = new ResourceDefaultsSetter(this.interp, this);
            try {
                SwingUtilities.invokeAndWait(resourceDefaultsSetter);
            }
            catch (InterruptedException iE) {
                throw new TclException(this.interp, iE.toString());
            }
            catch (Exception e) {
                throw new TclException(this.interp, e.toString());
            }
        } else {
            this.setResourceDefaultsET();
        }
    }

    void setResourceDefaultsET() {
        Enumeration e = resourceDB.keys();
        while (e.hasMoreElements()) {
            ResourceObject ro;
            String keyName = (String)e.nextElement();
            if (keyName == null || (ro = (ResourceObject)resourceDB.get(keyName)) == null) continue;
            try {
                ro.defaultVal = this.jget(ro.optNum);
            }
            catch (IllegalComponentStateException icsE) {}
        }
    }

    private static void initResources() {
        ResourceObject resourceObject = null;
        resourceObject = new ResourceObject("anchor", "Anchor", 0);
        resourceDB.put("-anchor", resourceObject);
        resourceObject = new ResourceObject("autoscrolls", "Autoscrolls", 1);
        resourceDB.put("-autoscrolls", resourceObject);
        resourceObject = new ResourceObject("background", "Background", 2);
        resourceDB.put("-background", resourceObject);
        resourceObject = new ResourceObject("borderWidth", "BorderWidth", 3);
        resourceDB.put("-bd", resourceObject);
        resourceObject = new ResourceObject("background", "Background", 4);
        resourceDB.put("-bg", resourceObject);
        resourceObject = new ResourceObject("borderWidth", "BorderWidth", 5);
        resourceDB.put("-border", resourceObject);
        resourceObject = new ResourceObject("borderWidth", "BorderWidth", 6);
        resourceDB.put("-borderwidth", resourceObject);
        resourceObject = new ResourceObject("className", "ClassName", 7);
        resourceDB.put("-class", resourceObject);
        resourceObject = new ResourceObject("cursor", "Cursor", 8);
        resourceDB.put("-cursor", resourceObject);
        resourceObject = new ResourceObject("enabled", "Enabled", 9);
        resourceDB.put("-enabled", resourceObject);
        resourceObject = new ResourceObject("foreground", "Foreground", 10);
        resourceDB.put("-fg", resourceObject);
        resourceObject = new ResourceObject("focusable", "Focusable", 11);
        resourceDB.put("-focusable", resourceObject);
        resourceObject = new ResourceObject("focusCycleRoot", "FocusCycleRoot", 12);
        resourceDB.put("-focuscycleroot", resourceObject);
        resourceObject = new ResourceObject("focusTraversalKeysEnabled", "FocusTraversalKeysEnabled", 13);
        resourceDB.put("-focustraversalkeysenabled", resourceObject);
        resourceObject = new ResourceObject("focusTraversalPolicyProvider", "FocusTraversalPolicyProvider", 14);
        resourceDB.put("-focustraversalpolicyprovider", resourceObject);
        resourceObject = new ResourceObject("font", "Font", 15);
        resourceDB.put("-font", resourceObject);
        resourceObject = new ResourceObject("foreground", "Foreground", 16);
        resourceDB.put("-foreground", resourceObject);
        resourceObject = new ResourceObject("height", "Height", 17);
        resourceDB.put("-height", resourceObject);
        resourceObject = new ResourceObject("highlightBackground", "HighlightBackground", 18);
        resourceDB.put("-highlightbackground", resourceObject);
        resourceObject = new ResourceObject("highlightColor", "HighlightColor", 19);
        resourceDB.put("-highlightcolor", resourceObject);
        resourceObject = new ResourceObject("highlightThickness", "HighlightThickness", 20);
        resourceDB.put("-highlightthickness", resourceObject);
        resourceObject = new ResourceObject("insertBackground", "InsertBackground", 21);
        resourceDB.put("-insertbackground", resourceObject);
        resourceObject = new ResourceObject("insertBorderWidth", "InsertBorderWidth", 22);
        resourceDB.put("-insertborderwidth", resourceObject);
        resourceObject = new ResourceObject("insertOffTime", "InsertOffTime", 23);
        resourceDB.put("-insertofftime", resourceObject);
        resourceObject = new ResourceObject("insertOnTime", "InsertOnTime", 24);
        resourceDB.put("-insertontime", resourceObject);
        resourceObject = new ResourceObject("insertWidth", "InsertWidth", 25);
        resourceDB.put("-insertwidth", resourceObject);
        resourceObject = new ResourceObject("jHelpTarget", "JHelpTarget", 26);
        resourceDB.put("-jhelptarget", resourceObject);
        resourceObject = new ResourceObject("opaque", "Opaque", 27);
        resourceDB.put("-opaque", resourceObject);
        resourceObject = new ResourceObject("padx", "Padx", 28);
        resourceDB.put("-padx", resourceObject);
        resourceObject = new ResourceObject("pady", "Pady", 29);
        resourceDB.put("-pady", resourceObject);
        resourceObject = new ResourceObject("relief", "Relief", 30);
        resourceDB.put("-relief", resourceObject);
        resourceObject = new ResourceObject("requestFocusEnabled", "RequestFocusEnabled", 31);
        resourceDB.put("-requestfocusenabled", resourceObject);
        resourceObject = new ResourceObject("scrollRegion", "ScrollRegion", 32);
        resourceDB.put("-scrollregion", resourceObject);
        resourceObject = new ResourceObject("toolTipText", "ToolTipText", 33);
        resourceDB.put("-tooltiptext", resourceObject);
        resourceObject = new ResourceObject("verifyInputWhenFocusTarget", "VerifyInputWhenFocusTarget", 34);
        resourceDB.put("-verifyinputwhenfocustarget", resourceObject);
        resourceObject = new ResourceObject("visible", "Visible", 35);
        resourceDB.put("-visible", resourceObject);
        resourceObject = new ResourceObject("width", "Width", 36);
        resourceDB.put("-width", resourceObject);
        resourceObject = new ResourceObject("xScrollCommand", "XScrollCommand", 37);
        resourceDB.put("-xscrollcommand", resourceObject);
        resourceObject = new ResourceObject("yScrollCommand", "YScrollCommand", 38);
        resourceDB.put("-yscrollcommand", resourceObject);
    }

    static {
        for (int i = 0; i < validCmds.length; ++i) {
            validCmdsTM.put(validCmds[i], new Integer(i));
        }
    }

    class ResourceDefaultsSetter
    implements Runnable {
        Interp interp;
        SwkCanvas swkcanvas;

        ResourceDefaultsSetter(Interp interp, SwkCanvas swkcanvas) {
            this.interp = interp;
            this.swkcanvas = swkcanvas;
        }

        public void run() {
            SwkCanvas.this.setResourceDefaultsET();
        }
    }

    class JGet
    implements Runnable {
        SwkCanvas swkcanvas;
        int opt = 0;
        String result = "";

        JGet(SwkCanvas swkcanvas, int opt) {
            this.swkcanvas = swkcanvas;
            this.opt = opt;
        }

        public void run() {
            this.result = this.swkcanvas.jget(this.opt);
        }
    }

    class JGetAll
    implements Runnable {
        SwkCanvas swkcanvas;
        ArrayList roValues = null;

        JGetAll(SwkCanvas swkcanvas) {
            this.swkcanvas = swkcanvas;
        }

        public void run() {
            this.roValues = SwkCanvas.this.getAllConfigurations();
        }
    }

    class Tag {
        int id = -1;
        String name = null;
        Hashtable tagShapes = new Hashtable();

        Tag(String name) {
            this.name = name.intern();
            SwkCanvas.this.tagVec.addElement(this);
            this.id = SwkCanvas.this.tagVec.size() - 1;
        }
    }

    class UpdateTask
    implements Runnable {
        UpdateTask() {
        }

        public void run() {
            SwkCanvas.this.repaint();
        }
    }
}

