/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.labltk;

import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.primitives.otherlibs.labltk.TKSlot;
import org.ocamljava.runtime.values.Value;
import tcl.lang.TimerHandler;

@PrimitiveProvider(library="labltk", module="Tk", source="otherlibs/labltk/support/cltkTimer.c")
public final class CltkTimer {
    private CltkTimer() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"int", "Protocol.cbid"}, returnType="int")
    public static Value camltk_add_timer(Value milli, Value cbid) throws Fail.Exception {
        TKSlot slot = TKSlot.checkInit();
        int res = slot.createTimerHandler(milli.asCastedInt(), cbid.asLong());
        return Value.createLong((long)res);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"int"}, returnType="unit")
    public static Value camltk_rem_timer(Value token) throws Fail.Exception {
        TKSlot slot = TKSlot.checkInit();
        TimerHandler th = slot.getTimerHandler(token.asLong());
        if (th != null) {
            th.cancel();
        }
        return Value.UNIT;
    }
}

