/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.kernel;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.context.SignalsState;
import org.ocamljava.runtime.kernel.Channel;
import org.ocamljava.runtime.kernel.CodeRunner;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.kernel.OCamlJavaException;
import org.ocamljava.runtime.util.NoSignalSupport;
import org.ocamljava.runtime.util.Signal;
import org.ocamljava.runtime.util.SignalHandler;
import org.ocamljava.runtime.util.SignalKind;
import org.ocamljava.runtime.values.Value;

public final class Signals {
    private static final int[] SIGNALS_ID = new int[]{SignalKind.ABRT.getNo(), SignalKind.ALRM.getNo(), SignalKind.FPE.getNo(), SignalKind.HUP.getNo(), SignalKind.ILL.getNo(), SignalKind.INT.getNo(), SignalKind.KILL.getNo(), SignalKind.PIPE.getNo(), SignalKind.QUIT.getNo(), SignalKind.SEGV.getNo(), SignalKind.TERM.getNo(), SignalKind.USR1.getNo(), SignalKind.USR2.getNo(), SignalKind.CHLD.getNo(), SignalKind.CONT.getNo(), SignalKind.STOP.getNo(), SignalKind.TSTP.getNo(), SignalKind.TTIN.getNo(), SignalKind.TTOU.getNo(), SignalKind.VTALRM.getNo(), SignalKind.PROF.getNo()};
    private static final SignalHandler SIGNAL_HANDLER = new SignalHandler(){

        @Override
        public void handle(Signal signal) {
            assert (signal != null) : "null signal";
            Signals.enqueueSignal(signal);
        }
    };
    private static List<Integer> pendingSignals = new LinkedList<Integer>();
    private static final int PENDING_SIGNALS_MAX_LENGTH = 64;
    private static final Map<Integer, Set<Context>> INTERESTED = new HashMap<Integer, Set<Context>>();
    private static final Map<Integer, Signal> SIGNALS = new HashMap<Integer, Signal>();

    private Signals() {
    }

    public static int ocamlToSystemIdentifier(int n) {
        if (n < 0 && n >= -SIGNALS_ID.length) {
            return SIGNALS_ID[-n - 1];
        }
        return n;
    }

    public static int systemToOCamlIdentifier(int n) {
        int n2;
        int n3 = SIGNALS_ID.length;
        for (n2 = 0; n2 < n3 && n != SIGNALS_ID[n2]; ++n2) {
        }
        if (n2 < n3) {
            return -n2 - 1;
        }
        return n;
    }

    public static Set<Integer> decodeSignalSet(Value value) {
        assert (value != null) : "null s";
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (Value value2 = value; value2 != Value.EMPTY_LIST; value2 = value2.get1()) {
            hashSet.add(Signals.ocamlToSystemIdentifier(value2.get0().asCastedInt()));
        }
        return hashSet;
    }

    public static Value encodeSignalSet(Set<Integer> set) {
        assert (set != null) : "null s";
        Value value = Value.EMPTY_LIST;
        for (int n : set) {
            value = Value.createBlock(0, Value.createLong(Signals.systemToOCamlIdentifier(n)), value);
        }
        return value;
    }

    public static synchronized void registerContext(int n, Context context) {
        assert (context != null) : "null c";
        Integer n2 = n;
        Set<Context> set = INTERESTED.get(n2);
        if (set == null) {
            set = new HashSet<Context>();
            set.add(context);
            INTERESTED.put(n2, set);
            NoSignalSupport.handle(SIGNAL_HANDLER, SIGNALS.get(n2));
        } else {
            if (set.isEmpty()) {
                NoSignalSupport.handle(SIGNAL_HANDLER, SIGNALS.get(n2));
            }
            set.add(context);
        }
    }

    public static synchronized void unregisterContext(int n, Context context) {
        assert (context != null) : "null c";
        Integer n2 = n;
        Set<Context> set = INTERESTED.get(n2);
        if (set != null) {
            set.remove(context);
            if (set.isEmpty()) {
                NoSignalSupport.handle(NoSignalSupport.DEFAULT_HANDLER, SIGNALS.get(n2));
            }
        }
    }

    public static synchronized void unregisterContext(Context context) {
        assert (context != null) : "null c";
        for (Map.Entry<Integer, Set<Context>> entry : INTERESTED.entrySet()) {
            Integer n = entry.getKey();
            Set<Context> set = entry.getValue();
            set.remove(context);
            if (!set.isEmpty()) continue;
            NoSignalSupport.handle(NoSignalSupport.DEFAULT_HANDLER, SIGNALS.get(n));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void enqueueSignal(Signal signal) {
        assert (signal != null) : "null signal";
        if (signal.isValid()) {
            int n = signal.getNumber();
            Set<Context> set = INTERESTED.get(n);
            if (set != null) {
                for (Context context : set) {
                    if (context.isRuntimeBusy()) continue;
                    Value value = context.getSignalsState().getSignalHandler(n);
                    CodeRunner codeRunner = context.getThreadsState().getMainCodeRunner();
                    if (value == null || !value.isBlock() || codeRunner == null) continue;
                    try {
                        codeRunner.callback(value, Value.createLong(Signals.systemToOCamlIdentifier(n)));
                    }
                    catch (Fail.Exception | FalseExit exception) {
                        context.getSignalsState().setAsyncException(exception);
                        context.getThreadsState().getMainThread().interrupt();
                    }
                    catch (Fatal.Exception exception) {
                        Channel channel = context.getFilesState().getChannel(2);
                        Channel.tryWrite(channel, "Error in signal handler: exception " + exception.getMessage());
                    }
                    catch (OCamlJavaException oCamlJavaException) {
                        Channel channel = context.getFilesState().getChannel(2);
                        Channel.tryWrite(channel, "Error in signal handler: exception " + oCamlJavaException.getMessage());
                    }
                    return;
                }
            }
            pendingSignals.add(signal.getNumber());
            while (pendingSignals.size() > 64) {
                pendingSignals.remove(0);
            }
            List<Integer> list = pendingSignals;
            synchronized (list) {
                pendingSignals.notifyAll();
            }
        }
    }

    public static synchronized Set<Integer> getPendingSignals(Set<Integer> set) {
        assert (set != null) : "null m";
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (Integer n : pendingSignals) {
            if (!set.contains(n)) continue;
            hashSet.add(n);
        }
        return hashSet;
    }

    public static synchronized boolean processSignal(CodeRunner codeRunner) throws Fail.Exception, Fatal.Exception, FalseExit, OCamlJavaException {
        assert (codeRunner != null) : "null runner";
        Context context = codeRunner.getContext();
        Integer n = Signals.getPendingSignal(context);
        if (n != null) {
            Value value = context.getSignalsState().getSignalHandler(n);
            if (value != null && value.isBlock()) {
                codeRunner.callback(value, Value.createLong(Signals.systemToOCamlIdentifier(n)));
                return true;
            }
            return false;
        }
        return false;
    }

    private static synchronized Integer getPendingSignal(Context context) {
        assert (context != null) : "null ctxt";
        SignalsState signalsState = context.getSignalsState();
        Set<Integer> set = signalsState.getBlockedSignals();
        Set<Integer> set2 = signalsState.getIgnoredSignals();
        Iterator<Integer> iterator = pendingSignals.iterator();
        while (iterator.hasNext()) {
            Integer n = iterator.next();
            if (set.contains(n) || set2.contains(n) || !signalsState.getSignalHandler(n).isBlock()) continue;
            iterator.remove();
            return n;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized int waitForSignal(Context context, Set<Integer> set) throws FalseExit, Fail.Exception {
        assert (context != null) : "null ctxt";
        assert (set != null) : "null blocked";
        LinkedHashSet<Integer> linkedHashSet = new LinkedHashSet<Integer>();
        for (Integer n : SIGNALS.keySet()) {
            if (!set.contains(n) || INTERESTED.containsKey(n) && INTERESTED.get(n).contains(context)) continue;
            linkedHashSet.add(n);
            Signals.registerContext(n, context);
        }
        try {
            Integer n;
            int n2;
            do {
                List<Integer> list = pendingSignals;
                synchronized (list) {
                    pendingSignals.wait();
                }
            } while ((n2 = pendingSignals.size()) <= 0 || set.contains(n = pendingSignals.get(n2 - 1)));
            Iterator iterator = linkedHashSet.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return n;
                }
                int n3 = (Integer)iterator.next();
                Signals.unregisterContext(n3, context);
            }
        }
        catch (InterruptedException interruptedException) {
            Iterator iterator = linkedHashSet.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    FalseExit falseExit = FalseExit.createFromContext(context);
                    falseExit.fillInStackTrace();
                    throw falseExit;
                }
                int n = (Integer)iterator.next();
                Signals.unregisterContext(n, context);
            }
        }
    }

    static {
        for (SignalKind signalKind : SignalKind.values()) {
            Signal signal = new Signal(signalKind);
            if (!signal.isValid()) continue;
            Signal signal2 = SIGNALS.put(signal.getNumber(), signal);
            assert (signal2 == null) : "two signals with same integer id";
        }
    }
}

