/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank;

import com.onemoonscientific.swank.BindEvent;
import com.onemoonscientific.swank.GetValueOnEventThread;
import com.onemoonscientific.swank.SetStringVarEvent;
import com.onemoonscientific.swank.SwkListener;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.EventObject;
import javax.swing.JComboBox;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import tcl.lang.Interp;
import tcl.lang.TclEvent;
import tcl.lang.TclException;
import tcl.lang.TclObject;
import tcl.lang.TclString;
import tcl.lang.VarTrace;

public class SwkJComboBoxListener
implements ActionListener,
VarTrace,
SwkListener {
    Interp interp;
    String command = "";
    String value = "";
    String varName = "";
    final JComboBox component;
    boolean traceLock = false;
    boolean actionDisabled = false;

    SwkJComboBoxListener(Interp interp, Component component) {
        this.interp = interp;
        this.component = (JComboBox)component;
    }

    public void traceProc(Interp interp, String string1, String string2, int flags) throws TclException {
        if (EventQueue.isDispatchThread()) {
            System.out.println("SwkJComboBoxListener: traceProc on event thread");
        }
        this.setFromVar(interp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFromVar(Interp interp) throws TclException {
        if (EventQueue.isDispatchThread()) {
            System.out.println("Warning: ComboBoxListener setFrom Var on EventThread");
        }
        if (!this.traceLock) {
            try {
                String item;
                TclObject tobj = interp.getVar(this.varName, 1).duplicate();
                if (tobj != null && (item = tobj.toString().trim()).length() > 0) {
                    this.actionDisabled = true;
                    try {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                SwkJComboBoxListener.this.component.setSelectedItem(item);
                            }
                        });
                    }
                    catch (Exception e) {
                        System.out.println("coudn't set item in combo " + item);
                    }
                }
            }
            catch (TclException tclException) {
            }
            finally {
                this.actionDisabled = false;
            }
        }
        this.traceLock = false;
    }

    public void setVarName(Interp interp, String name) throws TclException {
        if (EventQueue.isDispatchThread()) {
            System.out.println("Warning: ComboBoxListener setFrom Var on EventThread");
        }
        if (this.varName != null && !this.varName.equals("")) {
            interp.untraceVar(this.varName, (VarTrace)this, 33);
        }
        if (name != null && name != "") {
            try {
                String item;
                TclObject tobj = interp.getVar(name, 1).duplicate();
                if (tobj != null && (item = tobj.toString().trim()).length() > 0) {
                    try {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                SwkJComboBoxListener.this.component.setSelectedItem(item);
                            }
                        });
                    }
                    catch (Exception e) {
                        System.out.println("coudn't set item in combo " + item);
                    }
                }
            }
            catch (TclException tclException) {
                int count = new GetItemCount().exec();
                String firstItem = "";
                if (count > 0) {
                    firstItem = new GetItemAt().exec(0);
                }
                TclObject tobj = TclString.newInstance((String)firstItem);
                interp.setVar(name, tobj, 1);
            }
            interp.traceVar(name, (VarTrace)this, 33);
        }
        this.varName = name;
        interp.resetResult();
    }

    public String getVarName() {
        return this.varName;
    }

    public void setValue(String name) {
        this.value = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setCommand(String name) {
        this.command = name;
    }

    public String getCommand() {
        return this.command;
    }

    public void keyReleased(JTextComponent editor, KeyEvent e) {
        String s1 = editor.getText();
        if (this.varName != null && !this.varName.equals("")) {
            SetStringVarEvent strEvent = new SetStringVarEvent(this.interp, this.varName, null, s1);
            this.traceLock = true;
            this.interp.getNotifier().queueEvent((TclEvent)strEvent, 0);
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getModifiers() == 0) {
            return;
        }
        String s1 = this.component.getSelectedItem().toString();
        if (this.varName != null && !this.varName.equals("")) {
            SetStringVarEvent strEvent = new SetStringVarEvent(this.interp, this.varName, null, s1);
            this.traceLock = true;
            this.interp.getNotifier().queueEvent((TclEvent)strEvent, 0);
        }
        BindEvent bEvent = new BindEvent(this.interp, this, e, 0);
        this.interp.getNotifier().queueEvent((TclEvent)bEvent, 0);
    }

    public void setVarValue() {
        Object obj;
        TclObject tobj = null;
        if (EventQueue.isDispatchThread()) {
            System.out.println("Warning: ComboBoxListener setVarValue on EventThread");
        }
        if (this.varName != null && this.varName.length() != 0 && (obj = this.component.getSelectedItem()) != null && (tobj = TclString.newInstance((String)obj.toString())) != null) {
            try {
                this.traceLock = true;
                this.interp.setVar(this.varName, tobj, 1);
            }
            catch (TclException tclException) {
                return;
            }
        }
    }

    public void setVarValue(String s1) {
        TclObject tobj = null;
        if (EventQueue.isDispatchThread()) {
            System.out.println("Warning: ComboBoxListener setVarValue on EventThread");
        }
        if (this.varName != null && this.varName.length() != 0 && s1 != null && (tobj = TclString.newInstance((String)s1)) != null) {
            try {
                this.traceLock = true;
                this.interp.setVar(this.varName, tobj, 1);
            }
            catch (TclException tclException) {
                return;
            }
        }
    }

    public void processEvent(EventObject eventObject, Object obj, int subtype) {
        ActionEvent e = (ActionEvent)eventObject;
        if (EventQueue.isDispatchThread()) {
            System.out.println("Warning: ComboBoxListener processEvent is on EventThread");
        }
        if (this.actionDisabled) {
            this.actionDisabled = false;
            return;
        }
        if (this.command != null && this.command.length() != 0) {
            try {
                this.interp.eval(this.command);
            }
            catch (TclException tclE) {
                this.interp.addErrorInfo("\n    (\"binding\" script)");
                this.interp.backgroundError();
            }
        }
    }

    class GetItemAt
    extends GetValueOnEventThread {
        String result;
        int index = 0;

        GetItemAt() {
        }

        String exec(int index) {
            this.index = index;
            this.execOnThread();
            return this.result;
        }

        public void run() {
            this.result = SwkJComboBoxListener.this.component.getItemAt(this.index).toString();
        }
    }

    class GetItemCount
    extends GetValueOnEventThread {
        int intResult;

        GetItemCount() {
        }

        int exec() {
            this.execOnThread();
            return this.intResult;
        }

        public void run() {
            this.intResult = SwkJComboBoxListener.this.component.getItemCount();
        }
    }
}

