/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank;

import com.onemoonscientific.swank.BindEvent;
import com.onemoonscientific.swank.SetStringVarEvent;
import com.onemoonscientific.swank.SwkJRadioButton;
import com.onemoonscientific.swank.SwkListener;
import com.onemoonscientific.swank.Widgets;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import javax.swing.ButtonGroup;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import tcl.lang.Interp;
import tcl.lang.TclEvent;
import tcl.lang.TclException;
import tcl.lang.TclObject;
import tcl.lang.TclString;
import tcl.lang.VarTrace;

public class SwkRadioButtonListener
implements ActionListener,
VarTrace,
SwkListener {
    Interp interp;
    String command = "";
    String value = "";
    String varName = "";
    JToggleButton component;
    boolean traceLock = false;

    SwkRadioButtonListener(Interp interp, Component component) {
        this.interp = interp;
        this.component = (JToggleButton)component;
    }

    public void traceProc(Interp interp, String string1, String string2, int flags) throws TclException {
        if (EventQueue.isDispatchThread()) {
            System.out.println("SwkRadioButtonListener: traceProc on event thread");
        }
        this.setFromVar(interp);
    }

    public void setFromVar(Interp interp) throws TclException {
        if (EventQueue.isDispatchThread()) {
            System.out.println("SwkRadioButtonListener: setFromVar on event thread");
        }
        if (!this.traceLock) {
            TclObject wObj = (TclObject)Widgets.getWidget(interp, this.component.getName());
            if (wObj == null) {
                return;
            }
            try {
                TclObject tobj = interp.getVar(this.varName, 1);
                if (tobj.toString().equals(this.value)) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            SwkRadioButtonListener.this.component.setSelected(true);
                        }
                    });
                }
            }
            catch (TclException tclException) {
                // empty catch block
            }
        }
        this.traceLock = false;
    }

    public void setVarName(Interp interp, String name) throws TclException {
        if (this.varName != null && !this.varName.equals("")) {
            ButtonGroup bgroup = (ButtonGroup)SwkJRadioButton.bgroupTable.get(this.varName);
            interp.untraceVar(this.varName, (VarTrace)this, 33);
            if (bgroup != null) {
                bgroup.remove(this.component);
            }
        }
        TclObject tObj = null;
        if (name != null && !name.equals("")) {
            try {
                tObj = interp.getVar(name, 1);
                final boolean state = tObj.toString().equals(this.value);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        SwkRadioButtonListener.this.component.setSelected(state);
                    }
                });
            }
            catch (TclException tclException) {
                interp.resetResult();
                tObj = TclString.newInstance((String)"");
                interp.setVar(name, tObj, 1);
            }
            ButtonGroup bgroup = (ButtonGroup)SwkJRadioButton.bgroupTable.get(name);
            if (bgroup == null) {
                bgroup = new ButtonGroup();
                SwkJRadioButton.bgroupTable.put(name, bgroup);
            }
            final ButtonGroup bgroup2 = bgroup;
            interp.traceVar(name, (VarTrace)this, 33);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    bgroup2.add(SwkRadioButtonListener.this.component);
                }
            });
        }
        this.varName = name.intern();
    }

    public String getVarName() {
        return this.varName;
    }

    public void setValue(String newValue) {
        this.value = newValue;
        if (this.varName != null && !this.varName.equals("")) {
            SetStringVarEvent strEvent = new SetStringVarEvent(this.interp, this.varName, null, newValue, true);
            this.interp.getNotifier().queueEvent((TclEvent)strEvent, 0);
        }
    }

    public String getValue() {
        return this.value;
    }

    public void setCommand(String name) {
        this.command = name.intern();
    }

    public String getCommand() {
        return this.command;
    }

    public void actionPerformed(ActionEvent e) {
        if (!EventQueue.isDispatchThread()) {
            System.out.println("SwkCheckButtonListener: actionPerformed not on event thread");
        }
        if (((SwkJRadioButton)this.component).isSelected()) {
            String myValue = this.value;
        } else {
            String myValue = "";
        }
        this.traceLock = true;
        if (this.varName != null && !this.varName.equals("")) {
            SetStringVarEvent strEvent = new SetStringVarEvent(this.interp, this.varName, null, this.value);
            this.interp.getNotifier().queueEvent((TclEvent)strEvent, 0);
        }
        BindEvent bEvent = new BindEvent(this.interp, this, e, 0);
        this.interp.getNotifier().queueEvent((TclEvent)bEvent, 0);
    }

    public void processEvent(EventObject eventObject, Object obj, int subtype) {
        ActionEvent e = (ActionEvent)eventObject;
        if (EventQueue.isDispatchThread()) {
            System.out.println("SwkRadioButtonListener: processEvent on event thread");
        }
        if (this.command != null && this.command.length() != 0) {
            try {
                this.interp.eval(this.command);
            }
            catch (TclException tclE) {
                this.interp.addErrorInfo("\n    (\"binding\" script)");
                this.interp.backgroundError();
            }
        }
    }
}

