/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank.canvas;

import com.onemoonscientific.swank.SwkException;
import com.onemoonscientific.swank.canvas.AnchorParameter;
import com.onemoonscientific.swank.canvas.ArrowParameter;
import com.onemoonscientific.swank.canvas.ArrowShapeParameter;
import com.onemoonscientific.swank.canvas.CanvasParameter;
import com.onemoonscientific.swank.canvas.CapstyleParameter;
import com.onemoonscientific.swank.canvas.DashParameter;
import com.onemoonscientific.swank.canvas.DashPhaseParameter;
import com.onemoonscientific.swank.canvas.EndstyleParameter;
import com.onemoonscientific.swank.canvas.FillParameter;
import com.onemoonscientific.swank.canvas.FontParameter;
import com.onemoonscientific.swank.canvas.ItemLine;
import com.onemoonscientific.swank.canvas.JoinstyleParameter;
import com.onemoonscientific.swank.canvas.NodeParameter;
import com.onemoonscientific.swank.canvas.SmoothParameter;
import com.onemoonscientific.swank.canvas.StartstyleParameter;
import com.onemoonscientific.swank.canvas.StateParameter;
import com.onemoonscientific.swank.canvas.SwkImageCanvas;
import com.onemoonscientific.swank.canvas.SwkShape;
import com.onemoonscientific.swank.canvas.TagsParameter;
import com.onemoonscientific.swank.canvas.TextInterface;
import com.onemoonscientific.swank.canvas.TextParameter;
import com.onemoonscientific.swank.canvas.TextParameters;
import com.onemoonscientific.swank.canvas.TextcolorParameter;
import com.onemoonscientific.swank.canvas.TransformerParameter;
import com.onemoonscientific.swank.canvas.WidthParameter;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;

public class ItemConnector
extends ItemLine
implements TextInterface {
    TextParameters textPar = TextParameters.getDefault();
    static CanvasParameter[] parameters = new CanvasParameter[]{new FillParameter(), new SmoothParameter(), new DashParameter(), new DashPhaseParameter(), new WidthParameter(), new TagsParameter(), new StateParameter(), new NodeParameter(), new TransformerParameter(), new CapstyleParameter(), new JoinstyleParameter(), new ArrowParameter(), new ArrowShapeParameter(), new EndstyleParameter(), new StartstyleParameter(), new TextParameter(), new FontParameter(), new AnchorParameter(), new TextcolorParameter()};
    String startCon = "";
    String endCon = "";
    double textX = 0.0;
    double textY = 0.0;

    ItemConnector(Shape shape, SwkImageCanvas canvas) {
        super(shape, canvas);
        this.storeCoords = new double[4];
    }

    public String getText() {
        return this.textPar.getText();
    }

    public void setText(String newValue) {
        this.textPar = TextParameters.setText(this.textPar, newValue);
    }

    public float[] getAnchor() {
        return this.textPar.getAnchor();
    }

    public void setAnchor(float[] newValue) {
        this.textPar = TextParameters.setAnchor(this.textPar, newValue);
    }

    public Font getFont() {
        return this.textPar.getFont();
    }

    public void setFont(Font newValue) {
        this.textPar = TextParameters.setFont(this.textPar, newValue);
    }

    public Color getTextColor() {
        return this.textPar.getTextColor();
    }

    public void setTextColor(Color newValue) {
        this.textPar = TextParameters.setTextColor(this.textPar, newValue);
    }

    public void paintShape(Graphics2D g2) {
        if (this.stroke != null) {
            g2.setStroke(this.stroke);
        } else {
            g2.setStroke(bstroke);
        }
        if (this.storeCoords == null) {
            return;
        }
        AffineTransform shapeTransform = this.getTransform();
        g2.setPaint(this.outline);
        this.applyCoordinates();
        if (this.endPointStyle1 == ItemLine.EndPointStyle.NONE && this.endPointStyle2 == ItemLine.EndPointStyle.NONE) {
            if (shapeTransform != null) {
                g2.draw(shapeTransform.createTransformedShape(this.shape));
            } else {
                g2.draw(this.shape);
            }
        } else {
            if (shapeTransform != null) {
                g2.draw(shapeTransform.createTransformedShape(this.shape));
            } else {
                g2.draw(this.shape);
            }
            if (this.firstArrowPath != null) {
                if (shapeTransform != null) {
                    // empty if block
                }
                g2.fill(this.firstArrowPath);
                g2.setStroke(bstroke);
                g2.draw(this.firstArrowPath);
            }
            if (this.lastArrowPath != null) {
                if (shapeTransform != null) {
                    // empty if block
                }
                g2.fill(this.lastArrowPath);
                g2.setStroke(bstroke);
                g2.draw(this.lastArrowPath);
            }
        }
        this.textPar.paint(g2, this.getCanvas().getFontRenderContext(), this, this.textX, this.textY);
    }

    public void coords(SwkImageCanvas canvas, double[] coords) throws SwkException {
        if (this.storeCoords == null || this.storeCoords.length != coords.length) {
            this.storeCoords = new double[coords.length];
        }
        System.arraycopy(coords, 0, this.storeCoords, 0, coords.length);
        this.applyCoordinates();
    }

    public void applyCoordinates() {
        double[] tempCoords;
        double[] shapePars = new double[]{this.arrowShapeA, this.arrowShapeB, this.arrowShapeC, this.width};
        AffineTransform aT = new AffineTransform();
        SwkShape shape1 = null;
        SwkShape shape2 = null;
        try {
            shape1 = this.canvas.getShape(this.startCon);
            shape2 = this.canvas.getShape(this.endCon);
        }
        catch (SwkException swkE) {
            System.out.println(swkE.getMessage());
            return;
        }
        if (shape1.shape == null || shape2.shape == null) {
            return;
        }
        Rectangle2D bounds1 = shape1.shape.getBounds2D();
        Rectangle2D bounds2 = shape2.shape.getBounds2D();
        double x1 = bounds1.getMinX() + bounds1.getWidth() * this.storeCoords[0];
        double y1 = bounds1.getMinY() + bounds1.getHeight() * this.storeCoords[1];
        double x2 = bounds2.getMinX() + bounds2.getWidth() * this.storeCoords[2];
        double y2 = bounds2.getMinY() + bounds2.getHeight() * this.storeCoords[3];
        boolean segmented = true;
        if (segmented) {
            if (x2 > x1 + 10.0) {
                double xm = (x1 + x2) / 2.0;
                double ym = (y1 + y2) / 2.0;
                double[] coords = new double[]{x1, y1, xm, y1, xm, y2, x2, y2};
                tempCoords = coords;
                this.textX = xm;
                this.textY = ym;
            } else {
                double dX = 15.0;
                double x1a = x1 + dX;
                double y1a = y1;
                double x2a = x2 - dX;
                double ym = (y1 + y2) / 2.0;
                double[] coords = new double[]{x1, y1, x1a, y1a, x1a, ym, x2a, ym, x2a, y2, x2, y2};
                tempCoords = coords;
                this.textX = (x1a + x2a) / 2.0;
                this.textY = ym;
            }
        } else {
            double[] coords;
            tempCoords = coords = new double[]{x1, y1, x2, y2};
            this.textX = (tempCoords[0] + tempCoords[2]) / 2.0;
            this.textY = (tempCoords[1] + tempCoords[3]) / 2.0;
        }
        if (this.smooth == null || this.smooth.equals("")) {
            this.genPath(tempCoords);
        } else {
            this.genSmoothPath(tempCoords);
        }
        this.shape = aT.createTransformedShape(this.gPath);
        if (this.endPointStyle1 != ItemLine.EndPointStyle.NONE || this.endPointStyle2 != ItemLine.EndPointStyle.NONE) {
            double[] arrowFirstCoords = null;
            double[] arrowLastCoords = null;
            if (this.endPointStyle1 != ItemLine.EndPointStyle.NONE) {
                arrowFirstCoords = this.endPointStyle1.addArrowFirst(shapePars, tempCoords);
                if (this.firstArrowPath == null) {
                    this.firstArrowPath = new GeneralPath();
                }
            } else {
                this.firstArrowPath = null;
            }
            if (this.endPointStyle2 != ItemLine.EndPointStyle.NONE) {
                arrowLastCoords = this.endPointStyle2.addArrowLast(shapePars, tempCoords);
                if (this.lastArrowPath == null) {
                    this.lastArrowPath = new GeneralPath();
                }
            } else {
                this.lastArrowPath = null;
            }
            if (this.smooth == null || this.smooth.equals("")) {
                this.genPath(tempCoords);
            } else {
                this.genSmoothPath(tempCoords);
            }
            this.shape = aT.createTransformedShape(this.gPath);
            if (this.endPointStyle1 != ItemLine.EndPointStyle.NONE) {
                if (this.endPointStyle1 == ItemLine.EndPointStyle.CIRCLE) {
                    this.addArrowPathCircle(this.firstArrowPath, arrowFirstCoords);
                } else {
                    this.addArrowPath(this.firstArrowPath, arrowFirstCoords);
                }
            }
            if (this.endPointStyle2 != ItemLine.EndPointStyle.NONE) {
                if (this.endPointStyle2 == ItemLine.EndPointStyle.CIRCLE) {
                    this.addArrowPathCircle(this.lastArrowPath, arrowLastCoords);
                } else {
                    this.addArrowPath(this.lastArrowPath, arrowLastCoords);
                }
            }
        }
    }
}

