/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank.canvas;

import com.onemoonscientific.swank.SwkException;
import com.onemoonscientific.swank.canvas.AnchorParameter;
import com.onemoonscientific.swank.canvas.CanvasParameter;
import com.onemoonscientific.swank.canvas.FillParameter;
import com.onemoonscientific.swank.canvas.FontParameter;
import com.onemoonscientific.swank.canvas.GradientParameter;
import com.onemoonscientific.swank.canvas.NodeParameter;
import com.onemoonscientific.swank.canvas.OutlineParameter;
import com.onemoonscientific.swank.canvas.RotateParameter;
import com.onemoonscientific.swank.canvas.SwkImageCanvas;
import com.onemoonscientific.swank.canvas.SwkShape;
import com.onemoonscientific.swank.canvas.TagsParameter;
import com.onemoonscientific.swank.canvas.TextInterface;
import com.onemoonscientific.swank.canvas.TextParameter;
import com.onemoonscientific.swank.canvas.TextParameters;
import com.onemoonscientific.swank.canvas.TransformerParameter;
import com.onemoonscientific.swank.canvas.WidthParameter;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JLabel;

public class ItemHTML
extends SwkShape
implements TextInterface {
    static CanvasParameter[] parameters = new CanvasParameter[]{new TextParameter(), new AnchorParameter(), new FontParameter(), new WidthParameter(), new FillParameter(), new GradientParameter(), new TagsParameter(), new TransformerParameter(), new OutlineParameter(), new RotateParameter(), new NodeParameter()};
    static Map parameterMap = new TreeMap();
    TextParameters textPar = TextParameters.getDefault();
    double x = 0.0;
    double y = 0.0;
    int[] ends = null;
    Rectangle2D.Double rect2D = new Rectangle2D.Double();
    JLabel jLabel = new JLabel();

    ItemHTML(Shape shape, SwkImageCanvas canvas) {
        super(shape, canvas);
        this.rect2D = (Rectangle2D.Double)shape;
        this.width = 0.0f;
        this.storeCoords = new double[4];
        this.setFont(new Font("Courier", 0, 12));
        this.fill = Color.WHITE;
        this.jLabel.setVerticalAlignment(1);
    }

    public void coords(SwkImageCanvas canvas, double[] coords) throws SwkException {
        if (coords.length != 4) {
            throw new SwkException("wrong # coordinates: expected 4, got " + coords.length);
        }
        if (this.storeCoords == null || this.storeCoords.length != coords.length) {
            this.storeCoords = new double[coords.length];
        }
        System.arraycopy(coords, 0, this.storeCoords, 0, coords.length);
        this.applyCoordinates();
    }

    public void applyCoordinates() {
        this.checkCoordinates(this.storeCoords);
        AffineTransform aT = new AffineTransform();
        aT.translate(-this.storeCoords[0], -this.storeCoords[1]);
        this.genGradient(aT);
        this.rect2D.setFrame(this.storeCoords[0], this.storeCoords[1], this.storeCoords[2] - this.storeCoords[0], this.storeCoords[3] - this.storeCoords[1]);
    }

    public void checkCoordinates(double[] coords) {
        double hold;
        if (coords == null || coords.length != 4) {
            return;
        }
        if (coords[0] > coords[2]) {
            hold = coords[0];
            coords[0] = coords[2];
            coords[2] = hold;
        }
        if (coords[1] > coords[3]) {
            hold = coords[1];
            coords[1] = coords[3];
            coords[3] = hold;
        }
    }

    public void paintShape(Graphics2D g2) {
        this.paint(g2, this.getCanvas().getFontRenderContext());
    }

    public CanvasParameter[] getParameters() {
        return parameters;
    }

    public Map getParameterMap() {
        return parameterMap;
    }

    public String getType() {
        return "htext";
    }

    public double getX() {
        return this.storeCoords[0];
    }

    public void setX(double x) {
        this.storeCoords[0] = x;
    }

    public double getY() {
        return this.storeCoords[1];
    }

    public void setY(double y) {
        this.storeCoords[1] = y;
    }

    public String getText() {
        return this.jLabel.getText();
    }

    public void setText(String text) {
        this.jLabel.setText(text);
    }

    public float[] getAnchor() {
        return this.textPar.getAnchor();
    }

    public void setAnchor(float[] newValue) {
        this.textPar = TextParameters.setAnchor(this.textPar, newValue);
    }

    public Font getFont() {
        return this.textPar.getFont();
    }

    public void setFont(Font newValue) {
        this.textPar = TextParameters.setFont(this.textPar, newValue);
    }

    public Color getTextColor() {
        return this.textPar.getTextColor();
    }

    public void setTextColor(Color newValue) {
        this.textPar = TextParameters.setTextColor(this.textPar, newValue);
    }

    public boolean hitShape(double x1, double y1) {
        boolean result = false;
        if (this.shape != null) {
            result = this.shape.contains(x1, y1);
        }
        return result;
    }

    public void paint(Graphics2D g2, FontRenderContext fRC) {
        if (this.getFont() != null) {
            g2.setFont(this.getFont());
        }
        AffineTransform aT = new AffineTransform();
        AffineTransform shapeTransform = this.getTransform();
        if (shapeTransform != null) {
            aT.setTransform(shapeTransform);
        }
        this.jLabel.setVisible(true);
        this.jLabel.setSize((int)this.rect2D.getWidth(), (int)this.rect2D.getHeight());
        g2.translate((int)this.rect2D.getX(), (int)this.rect2D.getY());
        if (this.getTexturePaint() != null) {
            g2.setPaint(this.getTexturePaint());
            g2.fillRect(0, 0, (int)this.rect2D.getWidth(), (int)this.rect2D.getHeight());
        } else if (this.getFillGradient() != null) {
            g2.setPaint(this.getFillGradient());
            g2.fillRect(0, 0, (int)this.rect2D.getWidth(), (int)this.rect2D.getHeight());
        } else if (this.getFill() != null) {
            g2.setPaint(this.getFill());
            g2.fillRect(0, 0, (int)this.rect2D.getWidth(), (int)this.rect2D.getHeight());
        }
        this.jLabel.setForeground(this.getTextColor());
        this.jLabel.paint(g2);
        g2.translate(-((int)this.rect2D.getX()), -((int)this.rect2D.getY()));
    }

    static {
        ItemHTML.initializeParameters(parameters, parameterMap);
    }
}

