/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.javalibs.javabase;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.AbstractCodeRunner;
import org.ocamljava.runtime.kernel.Channel;
import org.ocamljava.runtime.kernel.CodeRunner;
import org.ocamljava.runtime.kernel.NativeApply;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="[XXX]", module="[XXX]", source="XXX.c")
public final class Java {
    private Java() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"java'io'InputStream java_instance"}, returnType="in_channel")
    public static Value ocamljava_java_make_in_channel(Value is) {
        Channel ch = new Channel((InputStream)is.asCustom());
        CodeRunner cr = OCamlJavaThread.getCodeRunner();
        cr.getContext().getFilesState().addChannel(ch);
        return Value.createChannel(ch);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"java'io'OutputStream java_instance"}, returnType="out_channel")
    public static Value ocamljava_java_make_out_channel(Value os) {
        Channel ch = new Channel((OutputStream)os.asCustom());
        CodeRunner cr = OCamlJavaThread.getCodeRunner();
        cr.getContext().getFilesState().addChannel(ch);
        return Value.createChannel(ch);
    }

    public static Value ocamljava_java_make_single_proxy(String i, Value o) {
        ClassLoader cl = ClassLoader.getSystemClassLoader();
        Class<?> tmp = null;
        try {
            tmp = Class.forName(i);
        }
        catch (Throwable t) {
            // empty catch block
        }
        Class[] il = new Class[]{tmp};
        CodeRunner cr = OCamlJavaThread.getCodeRunner();
        SingleInvocationHandler ih = new SingleInvocationHandler(o, cr);
        Object res = Proxy.newProxyInstance(cl, il, (InvocationHandler)ih);
        return Value.createInstance(res);
    }

    private static Value convert(Object value, Class<?> type) {
        return Value.createInstance(value);
    }

    static class SingleInvocationHandler
    implements InvocationHandler {
        private Value instance;
        private CodeRunner runner;

        SingleInvocationHandler(Value i, CodeRunner cr) {
            assert (i != null) : "null i";
            assert (cr != null) : "null cr";
            this.instance = i;
            this.runner = cr;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Value tag = Value.createLong(-838801238L);
            Value clos = AbstractCodeRunner.getMethod(this.instance, tag.getRawValue());
            int len = args.length;
            Value[] params = new Value[len + 1];
            Class<?>[] types = method.getParameterTypes();
            params[0] = this.instance;
            for (int i = 0; i < len; ++i) {
                Value tmp;
                params[i + 1] = tmp = Java.convert(args[i], types[i]);
            }
            OCamlJavaThread.registerCodeRunner(Thread.currentThread(), this.runner);
            return NativeApply.apply(clos, params);
        }
    }
}

