/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.unix;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SocketChannel;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.kernel.Channel;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.primitives.otherlibs.unix.Unix;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="unix", module="Unix", source="otherlibs/unix/getpeername.c")
public final class Getpeername {
    private Getpeername() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Unix.file_descr"}, returnType="Unix.sockaddr")
    public static Value unix_getpeername(Value sock) throws Fail.Exception {
        Context ctxt = OCamlJavaThread.getCodeRunner().getContext();
        Channel ch = ctxt.getFilesState().getChannel(sock.asCastedInt());
        if (ch == null) {
            Unix.fail("getpeername", "invalid descriptor");
            return Value.UNIT;
        }
        SocketChannel s = ch.asSocket();
        DatagramChannel ds = ch.asDatagramSocket();
        try {
            if (s != null) {
                return Unix.createSockAddr((InetSocketAddress)s.getRemoteAddress());
            }
            if (ds != null) {
                return Unix.createSockAddr((InetSocketAddress)ds.getRemoteAddress());
            }
            Unix.fail("getpeername", "invalid descriptor");
            return Value.UNIT;
        }
        catch (IOException ioe) {
            Unix.fail("getpeername", ioe);
            return Value.UNIT;
        }
    }
}

