/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.context;

import java.io.File;
import org.ocamljava.runtime.context.CodeState;
import org.ocamljava.runtime.context.DebuggerState;
import org.ocamljava.runtime.context.FilesState;
import org.ocamljava.runtime.context.FinalizersState;
import org.ocamljava.runtime.context.GCState;
import org.ocamljava.runtime.context.SignalsState;
import org.ocamljava.runtime.context.ThreadsState;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.parameters.CommonParameters;

public abstract class Context {
    private final CommonParameters parameters;
    private final CodeState codeState;
    private final ThreadsState threadsState;
    private final FilesState filesState;
    private final GCState gcState;
    private final FinalizersState finalizersState;
    private final DebuggerState debuggerState;
    private final SignalsState signalsState;

    Context(CommonParameters p, boolean isNative, File dir) {
        assert (p != null) : "null p";
        assert (dir != null) : "null dir";
        this.parameters = p;
        this.codeState = new CodeState(this, p, isNative);
        this.threadsState = new ThreadsState(isNative);
        this.filesState = new FilesState(p, dir);
        this.gcState = new GCState();
        this.finalizersState = new FinalizersState(this);
        this.debuggerState = new DebuggerState();
        this.signalsState = new SignalsState(this);
    }

    public final CommonParameters getParameters() {
        return this.parameters;
    }

    public abstract void enterBlockingSection();

    public abstract void leaveBlockingSection() throws FalseExit, Fail.Exception;

    public abstract boolean tryLeaveBlockingSection();

    public abstract boolean isRuntimeBusy();

    public final CodeState getCodeState() {
        return this.codeState;
    }

    public final ThreadsState getThreadsState() {
        return this.threadsState;
    }

    public final FilesState getFilesState() {
        return this.filesState;
    }

    public final GCState getGCState() {
        return this.gcState;
    }

    public final FinalizersState getFinalizersState() {
        return this.finalizersState;
    }

    public final DebuggerState getDebuggerState() {
        return this.debuggerState;
    }

    public final SignalsState getSignalsState() {
        return this.signalsState;
    }
}

