/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.str;

import java.util.LinkedList;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.primitives.otherlibs.str.BacktrackPoint;
import org.ocamljava.runtime.util.EncodingUtils;
import org.ocamljava.runtime.util.IntegerUtils;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="str", module="Str", source="otherlibs/str/strstubs.c")
public final class Str {
    private static final long PROG = 0L;
    private static final long CPOOL = 1L;
    private static final long NORM_TABLE = 2L;
    private static final long NUM_GROUPS = 3L;
    private static final long NUM_REGISTERS = 4L;
    private static final long START_CHARS = 5L;
    private static final int CHAR = 0;
    private static final int CHARNORM = 1;
    private static final int STRING = 2;
    private static final int STRINGNORM = 3;
    private static final int CHARCLASS = 4;
    private static final int BOL = 5;
    private static final int EOL = 6;
    private static final int WORDBOUNDARY = 7;
    private static final int BEGGROUP = 8;
    private static final int ENDGROUP = 9;
    private static final int REFGROUP = 10;
    private static final int ACCEPT = 11;
    private static final int SIMPLEOPT = 12;
    private static final int SIMPLESTAR = 13;
    private static final int SIMPLEPLUS = 14;
    private static final int GOTO = 15;
    private static final int PUSHBACK = 16;
    private static final int SETMARK = 17;
    private static final int CHECKPROGRESS = 18;
    private static final int NO_GOTO = 0;
    private static final int GOTO_PREFIX_MATCH = 1;
    private static final int GOTO_BACKTRACK = 2;
    private static final int GOTO_PUSH = 3;
    private static final int GOTO_ACCEPT = 4;
    private static final int NULL = -1;
    private static final Value NULL_VALUE = Value.MINUS_ONE;
    private static final Object SLOT_GROUPS = new Object();
    private static final int END_OF_LINE = IntegerUtils.signedToUnsignedByte(EncodingUtils.convertCharToByte('\n'));
    private static final int[] RE_WORD_LETTERS = new int[]{0, 0, 0, 0, 0, 0, 255, 3, 254, 255, 255, 135, 254, 255, 255, 7, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 127, 255, 255, 255, 127, 255};

    private Str() {
    }

    private static boolean isWordLetter(int ch) {
        return (RE_WORD_LETTERS[ch >> 3] >> (ch & 7) & 1) != 0;
    }

    private static int opcode(int x) {
        return x & 0xFF;
    }

    private static int arg(int x) {
        return (int)(IntegerUtils.signedToUnsigned(x) >> 8);
    }

    private static int signedArg(int x) {
        return x >> 8;
    }

    private static boolean inBitSet(int[] s, int idx) {
        return (s[idx >> 3] >> (idx & 7) & 1) != 0;
    }

    private static boolean match(Context ctxt, Value re, int[] str, int idxStartTxt, int idx, int idxEndTxt, boolean acceptPartialMatch) throws Fatal.Exception {
        int idxTxt = idx;
        int nbGroups = re.get(3L).asCastedInt();
        ReGroup[] groups = new ReGroup[nbGroups];
        for (int i = 0; i < nbGroups; ++i) {
            groups[i] = new ReGroup();
        }
        int nbRegisters = re.get(4L).asCastedInt();
        int[] registers = new int[nbRegisters];
        for (int i = 0; i < nbRegisters; ++i) {
            registers[i] = -1;
        }
        ctxt.getCodeState().registerSlot(SLOT_GROUPS, groups);
        BacktrackPoint back = null;
        int pc = 0;
        LinkedList<BacktrackPoint> stack = new LinkedList<BacktrackPoint>();
        Value cpool = re.get(1L);
        Value normTable = re.get(2L);
        groups[0].idxStart = idxTxt;
        block34: while (true) {
            int instr = re.get0().get(pc++).asCastedInt();
            int gto = 0;
            block0 : switch (Str.opcode(instr)) {
                case 0: {
                    if (idxTxt == idxEndTxt) {
                        gto = 1;
                        break;
                    }
                    if (str[idxTxt] != Str.arg(instr)) {
                        gto = 2;
                        break;
                    }
                    ++idxTxt;
                    break;
                }
                case 1: {
                    if (idxTxt == idxEndTxt) {
                        gto = 1;
                        break;
                    }
                    if (normTable.getUnsignedByte(str[idxTxt]) != Str.arg(instr)) {
                        gto = 2;
                        break;
                    }
                    ++idxTxt;
                    break;
                }
                case 2: {
                    int c;
                    int[] s = cpool.get(Str.arg(instr)).getUnsignedBytes();
                    int i = 0;
                    int n = c = i < s.length ? s[i++] : 0;
                    while (c != 0) {
                        if (idxTxt == idxEndTxt) {
                            gto = 1;
                            break block0;
                        }
                        if (c != str[idxTxt]) {
                            gto = 2;
                            break block0;
                        }
                        ++idxTxt;
                        c = i < s.length ? s[i++] : 0;
                    }
                    break;
                }
                case 3: {
                    int c;
                    int[] s = cpool.get(Str.arg(instr)).getUnsignedBytes();
                    int i = 0;
                    int n = c = i < s.length ? s[i++] : 0;
                    while (c != 0) {
                        if (idxTxt == idxEndTxt) {
                            gto = 1;
                            break block0;
                        }
                        if (c != normTable.getUnsignedByte(str[idxTxt])) {
                            gto = 2;
                            break block0;
                        }
                        ++idxTxt;
                        c = i < s.length ? s[i++] : 0;
                    }
                    break;
                }
                case 4: {
                    if (idxTxt == idxEndTxt) {
                        gto = 1;
                        break;
                    }
                    int c = str[idxTxt];
                    if (!Str.inBitSet(cpool.get(Str.arg(instr)).getUnsignedBytes(), str[idxTxt])) {
                        gto = 2;
                        break;
                    }
                    ++idxTxt;
                    break;
                }
                case 5: {
                    if (idxTxt <= idxStartTxt || str[idxTxt - 1] == END_OF_LINE) break;
                    gto = 2;
                    break;
                }
                case 6: {
                    if (idxTxt >= idxEndTxt || str[idxTxt] == END_OF_LINE) break;
                    gto = 2;
                    break;
                }
                case 7: {
                    if (idxTxt == idxStartTxt) {
                        if (idxTxt == idxEndTxt) {
                            gto = 1;
                            break;
                        }
                        if (Str.isWordLetter(str[idxTxt])) break;
                        gto = 2;
                        break;
                    }
                    if (idxTxt == idxEndTxt) {
                        if (Str.isWordLetter(str[idxTxt - 1])) break;
                        gto = 2;
                        break;
                    }
                    if (Str.isWordLetter(str[idxTxt - 1]) != Str.isWordLetter(str[idxTxt])) break;
                    gto = 2;
                    break;
                }
                case 8: {
                    int groupNo = Str.arg(instr);
                    ReGroup group = groups[groupNo];
                    back = BacktrackPoint.makeUndo(groupNo << 2 | 1, group.idxStart);
                    group.idxStart = idxTxt;
                    gto = 3;
                    break;
                }
                case 9: {
                    int groupNo = Str.arg(instr);
                    ReGroup group = groups[groupNo];
                    back = BacktrackPoint.makeUndo(groupNo << 2 | 2, group.idxEnd);
                    group.idxEnd = idxTxt;
                    gto = 3;
                    break;
                }
                case 10: {
                    ReGroup group = groups[Str.arg(instr)];
                    if (group.idxStart == -1 || group.idxEnd == -1) {
                        gto = 2;
                        break;
                    }
                    for (int s = group.idxStart; s < group.idxEnd; ++s) {
                        if (idxTxt == idxEndTxt) {
                            gto = 1;
                            break block0;
                        }
                        if (str[s] != str[idxTxt]) {
                            gto = 2;
                            break block0;
                        }
                        ++idxTxt;
                    }
                    break;
                }
                case 11: {
                    gto = 4;
                    break;
                }
                case 12: {
                    int[] set = cpool.get(Str.arg(instr)).getUnsignedBytes();
                    if (idxTxt >= idxEndTxt) break;
                    int c = str[idxTxt];
                    if (!Str.inBitSet(set, str[idxTxt])) break;
                    ++idxTxt;
                    break;
                }
                case 13: {
                    int c;
                    int[] set = cpool.get(Str.arg(instr)).getUnsignedBytes();
                    while (idxTxt < idxEndTxt && Str.inBitSet(set, str[idxTxt])) {
                        c = str[idxTxt];
                        ++idxTxt;
                    }
                    if (idxTxt >= idxEndTxt) break;
                    c = str[idxTxt];
                    break;
                }
                case 14: {
                    int[] set = cpool.get(Str.arg(instr)).getUnsignedBytes();
                    if (idxTxt == idxEndTxt) {
                        gto = 1;
                        break;
                    }
                    int c = str[idxTxt];
                    if (!Str.inBitSet(set, str[idxTxt])) {
                        gto = 2;
                        break;
                    }
                    ++idxTxt;
                    while (idxTxt < idxEndTxt && Str.inBitSet(set, str[idxTxt])) {
                        c = str[idxTxt];
                        ++idxTxt;
                    }
                    if (idxTxt >= idxEndTxt) break;
                    c = str[idxTxt];
                    break;
                }
                case 15: {
                    pc += Str.signedArg(instr);
                    break;
                }
                case 16: {
                    back = BacktrackPoint.makePos(pc + Str.signedArg(instr), idxTxt);
                    gto = 3;
                    break;
                }
                case 17: {
                    int regNo = Str.arg(instr);
                    back = BacktrackPoint.makeUndo(regNo << 2 | 3, registers[regNo]);
                    registers[regNo] = idxTxt;
                    gto = 3;
                    break;
                }
                case 18: {
                    if (registers[Str.arg(instr)] != idxTxt) break;
                    gto = 2;
                    break;
                }
                default: {
                    Fatal.raise("impossible case in re_match");
                }
            }
            block40: while (true) {
                if (gto == 0) continue block34;
                switch (gto) {
                    case 3: {
                        stack.add(0, back);
                        gto = 0;
                        continue block40;
                    }
                    case 1: {
                        if (acceptPartialMatch) {
                            gto = 4;
                            continue block40;
                        }
                        gto = 2;
                        continue block40;
                    }
                    case 2: {
                        gto = 0;
                        block41: while (true) {
                            if (stack.size() == 0) {
                                return false;
                            }
                            BacktrackPoint pt = (BacktrackPoint)stack.remove(0);
                            if (pt.isPos()) {
                                pc = pt.getPc();
                                idxTxt = pt.getTxt();
                                continue block40;
                            }
                            int loc = pt.getLoc();
                            int val = pt.getVal();
                            switch (loc & 3) {
                                case 1: {
                                    groups[loc >> 2].idxStart = val;
                                    continue block41;
                                }
                                case 2: {
                                    groups[loc >> 2].idxEnd = val;
                                    continue block41;
                                }
                                case 3: {
                                    registers[loc >> 2] = val;
                                    continue block41;
                                }
                            }
                            if (!$assertionsDisabled) break;
                        }
                        throw new AssertionError((Object)"invalid backtrack tag");
                    }
                    case 4: {
                        stack.clear();
                        groups[0].idxEnd = idxTxt;
                        return true;
                    }
                }
                if (!$assertionsDisabled) break block34;
            }
            break;
        }
        throw new AssertionError((Object)"invalid goto");
    }

    private static Value allocGroups(Context ctxt, Value re) {
        ReGroup[] groups = (ReGroup[])ctxt.getCodeState().getSlot(SLOT_GROUPS);
        int n = re.get(3L).asCastedInt();
        Value res = Value.createBlock(0, n * 2);
        for (int i = 0; i < n; ++i) {
            ReGroup group = groups[i];
            if (group.idxStart == -1 || group.idxEnd == -1) {
                res.set(2 * i, NULL_VALUE);
                res.set(2 * i + 1, NULL_VALUE);
                continue;
            }
            res.set(2 * i, Value.createLong(group.idxStart));
            res.set(2 * i + 1, Value.createLong(group.idxEnd));
        }
        return res;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Str.regexp", "string", "int"}, returnType="int array")
    public static Value re_string_match(Value re, Value str, Value pos) throws Fail.Exception, Fatal.Exception {
        Context ctxt = OCamlJavaThread.getCodeRunner().getContext();
        int[] b = str.getUnsignedBytes();
        boolean idxStartTxt = false;
        int idxTxt = pos.asBoundedInt();
        int idxEndTxt = b.length;
        if (idxTxt < 0 || idxTxt > idxEndTxt) {
            Fail.invalidArgument("Str.string_match");
        }
        if (Str.match(ctxt, re, b, 0, idxTxt, idxEndTxt, false)) {
            return Str.allocGroups(ctxt, re);
        }
        return ctxt.getCodeState().getAtom(0);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Str.regexp", "string", "int"}, returnType="int array")
    public static Value re_partial_match(Value re, Value str, Value pos) throws Fail.Exception, Fatal.Exception {
        Context ctxt = OCamlJavaThread.getCodeRunner().getContext();
        int[] b = str.getUnsignedBytes();
        boolean idxStartTxt = false;
        int idxTxt = pos.asBoundedInt();
        int idxEndTxt = b.length;
        if (idxTxt < 0 || idxTxt > idxEndTxt) {
            Fail.invalidArgument("Str.string_partial_match");
        }
        if (Str.match(ctxt, re, b, 0, idxTxt, idxEndTxt, true)) {
            return Str.allocGroups(ctxt, re);
        }
        return ctxt.getCodeState().getAtom(0);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Str.regexp", "string", "int"}, returnType="int array")
    public static Value re_search_forward(Value re, Value str, Value startPos) throws Fail.Exception, Fatal.Exception {
        Context ctxt = OCamlJavaThread.getCodeRunner().getContext();
        int[] b = str.getUnsignedBytes();
        boolean idxStartTxt = false;
        int idxTxt = startPos.asBoundedInt();
        int idxEndTxt = b.length;
        if (idxTxt < 0 || idxTxt > idxEndTxt) {
            Fail.invalidArgument("Str.search_forward");
        }
        if (re.get(5L) == NULL_VALUE) {
            do {
                if (!Str.match(ctxt, re, b, 0, idxTxt, idxEndTxt, false)) continue;
                return Str.allocGroups(ctxt, re);
            } while (++idxTxt <= idxEndTxt);
            return ctxt.getCodeState().getAtom(0);
        }
        int[] startChars = re.get(1L).get(re.get(5L).asLong()).getUnsignedBytes();
        while (true) {
            if (idxTxt < idxEndTxt && startChars[b[idxTxt]] == 0) {
                ++idxTxt;
                continue;
            }
            if (Str.match(ctxt, re, b, 0, idxTxt, idxEndTxt, false)) {
                return Str.allocGroups(ctxt, re);
            }
            if (++idxTxt > idxEndTxt) break;
        }
        return ctxt.getCodeState().getAtom(0);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Str.regexp", "string", "int"}, returnType="int array")
    public static Value re_search_backward(Value re, Value str, Value startPos) throws Fail.Exception, Fatal.Exception {
        Context ctxt = OCamlJavaThread.getCodeRunner().getContext();
        int[] b = str.getUnsignedBytes();
        boolean idxStartTxt = false;
        int idxTxt = startPos.asBoundedInt();
        int idxEndTxt = b.length;
        if (idxTxt < 0 || idxTxt > idxEndTxt) {
            Fail.invalidArgument("Str.search_backward");
        }
        if (re.get(5L) == NULL_VALUE) {
            do {
                if (!Str.match(ctxt, re, b, 0, idxTxt, idxEndTxt, false)) continue;
                return Str.allocGroups(ctxt, re);
            } while (--idxTxt >= 0);
            return ctxt.getCodeState().getAtom(0);
        }
        int[] startChars = re.get(1L).get(re.get(5L).asLong()).getUnsignedBytes();
        while (true) {
            if (idxTxt > 0 && startChars[b[idxTxt]] == 0) {
                --idxTxt;
                continue;
            }
            if (Str.match(ctxt, re, b, 0, idxTxt, idxEndTxt, false)) {
                return Str.allocGroups(ctxt, re);
            }
            if (--idxTxt < 0) break;
        }
        return ctxt.getCodeState().getAtom(0);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string", "int array", "string"}, returnType="string")
    public static Value re_replacement_text(Value repl, Value groups, Value orig) throws Fail.Exception {
        int len = 0;
        String replString = repl.asString();
        int p = 0;
        int n = replString.length();
        String origin = orig.asString();
        block8: while (n > 0) {
            char c = replString.charAt(p++);
            --n;
            if (c != '\\') {
                ++len;
                continue;
            }
            if (n == 0) {
                Fail.failWith("Str.replace: illegal backslash sequence");
            }
            c = replString.charAt(p++);
            --n;
            switch (c) {
                case '\\': {
                    ++len;
                    continue block8;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    int d = (c - 48) * 2;
                    if ((long)d >= groups.sizeValues()) {
                        Fail.failWith("Str.replace: reference to unmatched group");
                    }
                    int start = groups.get(d).asCastedInt();
                    int end = groups.get(d + 1).asCastedInt();
                    if (start == -1) {
                        Fail.failWith("Str.replace: reference to unmatched group");
                    }
                    len += end - start;
                    continue block8;
                }
            }
            len += 2;
        }
        StringBuilder res = new StringBuilder(len);
        p = 0;
        n = replString.length();
        block9: while (n > 0) {
            char c = replString.charAt(p++);
            --n;
            if (c != '\\') {
                res.append(c);
                continue;
            }
            c = replString.charAt(p++);
            --n;
            switch (c) {
                case '\\': {
                    res.append('\\');
                    continue block9;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    int d = 2 * (c - 48);
                    int start = groups.get(d).asCastedInt();
                    int end = groups.get(d + 1).asCastedInt();
                    len = end - start;
                    res.append(origin.substring(start, len));
                    continue block9;
                }
            }
            res.append('\\');
            res.append(c);
        }
        return Value.createString(res.toString());
    }

    private static final class ReGroup {
        int idxStart = -1;
        int idxEnd = -1;

        private ReGroup() {
        }
    }
}

