/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.stdlib;

import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="stdlib", module="Printexc", source="byterun/backtrace.c")
public final class BackTrace {
    private BackTrace() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"bool"}, returnType="unit")
    public static Value caml_record_backtrace(Value flag) {
        OCamlJavaThread.getCodeRunner().getContext().getCodeState().setBacktraceActive(flag != Value.FALSE);
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="bool")
    public static Value caml_backtrace_status(Value unit) {
        return OCamlJavaThread.getCodeRunner().getContext().getCodeState().isBacktraceActive() ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="Printexc.loc_info array option")
    public static Value caml_get_exception_backtrace(Value unit) {
        return OCamlJavaThread.getCodeRunner().getExceptionBacktrace();
    }
}

