/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.values;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.util.IO;
import org.ocamljava.runtime.values.AbstractCustomOperations;
import org.ocamljava.runtime.values.CustomOperations;
import org.ocamljava.runtime.values.Value;

public final class PredefinedCustomOperations {
    public static final CustomOperations INT_32_OPS = new Int32Ops();
    public static final int INT_32_SIZE = 4;
    public static final CustomOperations INT_64_OPS = new Int64Ops();
    public static final int INT_64_SIZE = 8;
    public static final CustomOperations INT_NAT_OPS = new IntNatOps();
    public static final int INT_NAT_SIZE = 8;
    public static final CustomOperations CHANNEL_OPS = new ChannelOps();
    public static final int CHANNEL_SIZE = 65580;
    public static final CustomOperations JAVA_OPS = new JavaOps();
    public static final int JAVA_SIZE = 8;

    private PredefinedCustomOperations() {
    }

    private static final class JavaOps
    extends AbstractCustomOperations {
        private JavaOps() {
            super("java_instance", false, false, false, true, true);
        }

        @Override
        public long hash(Value v) {
            assert (v != null) : "null v";
            Object obj = v.asCustom();
            return obj == null ? 0L : (long)obj.hashCode();
        }

        @Override
        public CustomOperations.SerializationSizes serialize(DataOutput out, Value v) throws IOException {
            assert (out != null) : "null out";
            assert (v != null) : "null v";
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(v.asCustom());
            oos.close();
            int sz = baos.size();
            IO.write32s(out, sz);
            out.write(baos.toByteArray());
            baos.close();
            return new CustomOperations.SerializationSizes(sz, sz);
        }

        @Override
        public CustomOperations.DeserializedValue deserialize(DataInput in) throws IOException, Fail.Exception {
            int sz = IO.read32s(in);
            byte[] b = new byte[sz];
            in.readFully(b);
            ByteArrayInputStream bais = new ByteArrayInputStream(b);
            ObjectInputStream ois = new ObjectInputStream(bais);
            Object obj = null;
            try {
                obj = ois.readObject();
            }
            catch (ClassNotFoundException cnfe) {
                Fail.failWith("error in Java serialization (class not found)");
            }
            ois.close();
            bais.close();
            Value v = Value.createInstance(obj);
            return new CustomOperations.DeserializedValue(v, sz);
        }
    }

    private static final class ChannelOps
    extends AbstractCustomOperations {
        private ChannelOps() {
            super("_chan", false, false, false, true, false);
        }

        @Override
        public long hash(Value v) {
            assert (v != null) : "null v";
            return System.identityHashCode(v);
        }
    }

    private static final class IntNatOps
    extends AbstractCustomOperations {
        private IntNatOps() {
            super("_n", false, true, false, true, true);
        }

        @Override
        public int compare(Value v1, Value v2, AtomicBoolean unordered) {
            long l2;
            assert (v1 != null) : "null v1";
            assert (v2 != null) : "null v2";
            long l1 = v1.asNativeInt();
            if (l1 < (l2 = v2.asNativeInt())) {
                return -1;
            }
            if (l1 > l2) {
                return 1;
            }
            return 0;
        }

        @Override
        public long hash(Value v) {
            assert (v != null) : "null v";
            long l = v.asNativeInt();
            return l >> 32 ^ l >> 63 ^ l;
        }

        @Override
        public CustomOperations.SerializationSizes serialize(DataOutput out, Value v) throws IOException {
            assert (out != null) : "null out";
            assert (v != null) : "null v";
            long l = v.asNativeInt();
            if (l >= Integer.MIN_VALUE && l < 0x80000000L) {
                IO.write8u(out, 1);
                IO.write32s(out, (int)l);
            } else {
                IO.write8u(out, 2);
                IO.write64s(out, l);
            }
            return new CustomOperations.SerializationSizes(4L, 8L);
        }

        @Override
        public CustomOperations.DeserializedValue deserialize(DataInput in) throws IOException, Fail.Exception {
            assert (in != null) : "null in";
            switch (IO.read8u(in)) {
                case 1: {
                    return new CustomOperations.DeserializedValue(Value.createNativeInt(IO.read32s(in)), 8L);
                }
                case 2: {
                    return new CustomOperations.DeserializedValue(Value.createNativeInt(IO.read64s(in)), 8L);
                }
            }
            Fail.failWith("input_value: ill-formed native integer");
            return null;
        }
    }

    private static final class Int64Ops
    extends AbstractCustomOperations {
        private Int64Ops() {
            super("_j", false, true, false, true, true);
        }

        @Override
        public int compare(Value v1, Value v2, AtomicBoolean unordered) {
            long l2;
            assert (v1 != null) : "null v1";
            assert (v2 != null) : "null v2";
            long l1 = v1.asInt64();
            if (l1 < (l2 = v2.asInt64())) {
                return -1;
            }
            if (l1 > l2) {
                return 1;
            }
            return 0;
        }

        @Override
        public long hash(Value v) {
            assert (v != null) : "null v";
            long l = v.asInt64();
            return l >>> 32 ^ l & 0xFFFFFFFFL;
        }

        @Override
        public CustomOperations.SerializationSizes serialize(DataOutput out, Value v) throws IOException {
            assert (out != null) : "null out";
            assert (v != null) : "null v";
            IO.write64s(out, v.asInt64());
            return new CustomOperations.SerializationSizes(8L, 8L);
        }

        @Override
        public CustomOperations.DeserializedValue deserialize(DataInput in) throws IOException {
            assert (in != null) : "null in";
            return new CustomOperations.DeserializedValue(Value.createInt64(IO.read64s(in)), 8L);
        }
    }

    private static final class Int32Ops
    extends AbstractCustomOperations {
        private Int32Ops() {
            super("_i", false, true, false, true, true);
        }

        @Override
        public int compare(Value v1, Value v2, AtomicBoolean unordered) {
            int i2;
            assert (v1 != null) : "null v1";
            assert (v2 != null) : "null v2";
            int i1 = v1.asInt32();
            if (i1 < (i2 = v2.asInt32())) {
                return -1;
            }
            if (i1 > i2) {
                return 1;
            }
            return 0;
        }

        @Override
        public long hash(Value v) {
            assert (v != null) : "null v";
            return v.asInt32();
        }

        @Override
        public CustomOperations.SerializationSizes serialize(DataOutput out, Value v) throws IOException {
            assert (out != null) : "null out";
            assert (v != null) : "null v";
            IO.write32s(out, v.asInt32());
            return new CustomOperations.SerializationSizes(4L, 4L);
        }

        @Override
        public CustomOperations.DeserializedValue deserialize(DataInput in) throws IOException {
            assert (in != null) : "null in";
            return new CustomOperations.DeserializedValue(Value.createInt32(IO.read32s(in)), 4L);
        }
    }
}

