/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.kernel;

import org.ocamljava.runtime.values.Value;

public final class NativeComparisons {
    private NativeComparisons() {
    }

    public static boolean equalValues(Value v1, Value v2) {
        assert (v1 != null) : "null v1";
        assert (v2 != null) : "null v2";
        if (v1.isBlock()) {
            return v2.isBlock() ? v1 == v2 : false;
        }
        return v1.getRawValue() == v2.getRawValue();
    }

    public static boolean notEqualValues(Value v1, Value v2) {
        assert (v1 != null) : "null v1";
        assert (v2 != null) : "null v2";
        return !NativeComparisons.equalValues(v1, v2);
    }

    public static boolean lowerThanValue(Value v1, Value v2) {
        assert (v1 != null) : "null v1";
        assert (v2 != null) : "null v2";
        return Value.compare(v1, v2) < 0;
    }

    public static boolean lowerEqualValue(Value v1, Value v2) {
        assert (v1 != null) : "null v1";
        assert (v2 != null) : "null v2";
        return Value.compare(v1, v2) <= 0;
    }

    public static boolean greaterThanValue(Value v1, Value v2) {
        assert (v1 != null) : "null v1";
        assert (v2 != null) : "null v2";
        return Value.compare(v1, v2) > 0;
    }

    public static boolean greaterEqualValue(Value v1, Value v2) {
        assert (v1 != null) : "null v1";
        assert (v2 != null) : "null v2";
        return Value.compare(v1, v2) >= 0;
    }

    public static boolean isOutValue(Value v1, Value v2) {
        assert (v1 != null) : "null v1";
        assert (v2 != null) : "null v2";
        return Value.compareUnsigned(v1, v2) < 0;
    }
}

