/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.num;

import java.math.BigInteger;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.primitives.otherlibs.num.CustomNat;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="num", module="Nat", source="otherlibs/num/nat_stubs.c")
public final class Nat {
    static final int DIGIT_SIZE_IN_BYTES = 8;
    private static final int BNG_BITS_PER_DIGIT = 64;
    private static final int BNG_BITS_PER_HALF_DIGIT = 32;
    private static final BigInteger BNG_LOW_HALF_MASK = Nat.createDigit(0xFFFFFFFFL);
    private static final BigInteger BNG_DIGIT_MASK = Nat.createDigit(-1L);
    private static final BigInteger MAX_LONG = Nat.createDigit(0x3FFFFFFFFFFFFFFFL);

    private Nat() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="unit")
    public static Value initialize_nat(Value unit) {
        OCamlJavaThread.getCodeRunner().getContext().getCodeState().registerCustom(CustomNat.OPS);
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"int"}, returnType="Nat.nat")
    public static Value create_nat(Value size) {
        int sz = size.asCastedInt();
        long[] b = new long[sz + 1];
        return Value.createCustom(CustomNat.OPS, sz * 8, b);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat"}, returnType="int")
    public static Value length_nat(Value nat) {
        return Value.createLong(nat.getWoSize() - 1L);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "int"}, returnType="unit")
    public static Value set_to_zero_nat(Value nat, Value ofs, Value len) {
        long[] b = (long[])nat.asCustom();
        int o = ofs.asCastedInt();
        int l = len.asCastedInt();
        for (int i = 0; i < l; ++i) {
            b[o + i] = 0L;
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "Nat.nat", "int", "int"}, returnType="unit")
    public static Value blit_nat(Value nat1, Value ofs1, Value nat2, Value ofs2, Value len) {
        System.arraycopy((long[])nat2.asCustom(), ofs2.asCastedInt(), (long[])nat1.asCustom(), ofs1.asCastedInt(), len.asCastedInt());
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "int"}, returnType="unit")
    public static Value set_digit_nat(Value nat, Value ofs, Value digit) {
        ((long[])nat.asCustom())[ofs.asCastedInt()] = digit.asLong();
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int"}, returnType="int")
    public static Value nth_digit_nat(Value nat, Value ofs) {
        return Value.createLong(((long[])nat.asCustom())[ofs.asCastedInt()]);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "nativeint"}, returnType="unit")
    public static Value set_digit_nat_native(Value nat, Value ofs, Value digit) {
        ((long[])nat.asCustom())[ofs.asCastedInt()] = digit.asNativeInt();
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int"}, returnType="nativeint")
    public static Value nth_digit_nat_native(Value nat, Value ofs) {
        return Value.createNativeInt(((long[])nat.asCustom())[ofs.asCastedInt()]);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "int"}, returnType="int")
    public static Value num_digits_nat(Value nat, Value ofs, Value len) {
        long[] b = (long[])nat.asCustom();
        int o = ofs.asCastedInt();
        int l = len.asCastedInt();
        while (l != 0) {
            if (b[o + l - 1] != 0L) {
                return Value.createLong(l);
            }
            --l;
        }
        return Value.ONE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int"}, returnType="int")
    public static Value num_leading_zero_bits_in_digit(Value nat, Value ofs) {
        return Value.createLong(Nat.numLeadingZeroBitsInDigit(((long[])nat.asCustom())[ofs.asCastedInt()]));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int"}, returnType="bool")
    public static Value is_digit_int(Value nat, Value ofs) {
        BigInteger d = Nat.createDigit(((long[])nat.asCustom())[ofs.asCastedInt()]);
        return d.compareTo(MAX_LONG) <= 0 ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int"}, returnType="bool")
    public static Value is_digit_zero(Value nat, Value ofs) {
        return ((long[])nat.asCustom())[ofs.asCastedInt()] == 0L ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int"}, returnType="bool")
    public static Value is_digit_normalized(Value nat, Value ofs) {
        return (((long[])nat.asCustom())[ofs.asCastedInt()] & Long.MIN_VALUE) != 0L ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int"}, returnType="bool")
    public static Value is_digit_odd(Value nat, Value ofs) {
        return (((long[])nat.asCustom())[ofs.asCastedInt()] & 1L) != 0L ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "int", "int"}, returnType="int")
    public static Value incr_nat(Value nat, Value ofs, Value len, Value carry) {
        long[] b = (long[])nat.asCustom();
        int o = ofs.asCastedInt();
        int l = len.asCastedInt();
        if (carry == Value.ZERO || l == 0) {
            return carry;
        }
        do {
            int n = o++;
            b[n] = b[n] + 1L;
            if (b[n] == 0L) continue;
            return Value.ZERO;
        } while (--l != 0);
        return Value.ONE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "int", "Nat.nat", "int", "int", "int"}, returnType="int")
    public static Value add_nat(Value nat1, Value ofs1, Value len1, Value nat2, Value ofs2, Value len2, Value carry) {
        long[] b1 = (long[])nat1.asCustom();
        long[] b2 = (long[])nat2.asCustom();
        int o1 = ofs1.asCastedInt();
        int o2 = ofs2.asCastedInt();
        int l1 = len1.asCastedInt();
        int l2 = len2.asCastedInt();
        long c = carry.asLong();
        l1 -= l2;
        while (l2 > 0) {
            BigInteger tmp1 = Nat.createDigit(b1[o1]);
            BigInteger tmp2 = Nat.addDigit(tmp1, Nat.createDigit(b2[o2]));
            BigInteger tmp3 = Nat.addDigit(tmp2, Nat.createDigit(c));
            c = (tmp2.compareTo(tmp1) < 0 ? 1 : 0) + (tmp3.compareTo(tmp2) < 0 ? 1 : 0);
            b1[o1] = tmp3.longValue();
            --l2;
            ++o1;
            ++o2;
        }
        if (c == 0L || l1 == 0) {
            return Value.createLong(c);
        }
        do {
            int n = o1++;
            b1[n] = b1[n] + 1L;
            if (b1[n] == 0L) continue;
            return Value.ZERO;
        } while (--l1 != 0);
        return Value.ONE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "int", "Nat.nat", "int", "int", "int"}, returnType="int")
    public static Value add_nat_native(Value nat1, Value ofs1, Value len1, Value nat2, Value ofs2, Value len2, Value carry) {
        return Nat.add_nat(nat1, ofs1, len1, nat2, ofs2, len2, carry);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "int"}, returnType="unit")
    public static Value complement_nat(Value nat, Value ofs, Value len) {
        long[] b = (long[])nat.asCustom();
        int o = ofs.asCastedInt();
        int l = len.asCastedInt();
        for (int i = 0; i < l; ++i) {
            b[i + o] = b[i + o] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "int", "int"}, returnType="int")
    public static Value decr_nat(Value nat, Value ofs, Value len, Value carry) {
        long[] b = (long[])nat.asCustom();
        int o = ofs.asCastedInt();
        int l = len.asCastedInt();
        long c = 1L ^ carry.asLong();
        if (c == 0L || l == 0) {
            return carry;
        }
        do {
            int n = o++;
            long l2 = b[n];
            b[n] = l2 - 1L;
            if (l2 == 0L) continue;
            return Value.ONE;
        } while (--l != 0);
        return Value.ZERO;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "int", "Nat.nat", "int", "int", "int"}, returnType="int")
    public static Value sub_nat(Value nat1, Value ofs1, Value len1, Value nat2, Value ofs2, Value len2, Value carry) {
        return Value.createLong(Nat.subNat((long[])nat1.asCustom(), ofs1.asCastedInt(), len1.asCastedInt(), (long[])nat2.asCustom(), ofs2.asCastedInt(), len2.asCastedInt(), Nat.createDigit(carry.asLong())));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "int", "Nat.nat", "int", "int", "int"}, returnType="int")
    public static Value sub_nat_native(Value nat1, Value ofs1, Value len1, Value nat2, Value ofs2, Value len2, Value carry) {
        return Nat.sub_nat(nat1, ofs1, len1, nat2, ofs2, len2, carry);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "int", "Nat.nat", "int", "int", "Nat.nat", "int"}, returnType="int")
    public static Value mult_digit_nat(Value nat1, Value ofs1, Value len1, Value nat2, Value ofs2, Value len2, Value nat3, Value ofs3) {
        return Value.createLong(Nat.multDigitNat((long[])nat1.asCustom(), ofs1.asCastedInt(), len1.asCastedInt(), (long[])nat2.asCustom(), ofs2.asCastedInt(), len2.asCastedInt(), (long[])nat3.asCustom(), ofs3.asCastedInt()));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "int", "Nat.nat", "int", "int", "Nat.nat", "int"}, returnType="int")
    public static Value mult_digit_nat_native(Value nat1, Value ofs1, Value len1, Value nat2, Value ofs2, Value len2, Value nat3, Value ofs3) {
        return Nat.mult_digit_nat(nat1, ofs1, len1, nat2, ofs2, len2, nat3, ofs3);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "int", "Nat.nat", "int", "int", "Nat.nat", "int", "int"}, returnType="int")
    public static Value mult_nat(Value nat1, Value ofs1, Value len1, Value nat2, Value ofs2, Value len2, Value nat3, Value ofs3, Value len3) {
        long[] b1 = (long[])nat1.asCustom();
        long[] b2 = (long[])nat2.asCustom();
        long[] b3 = (long[])nat3.asCustom();
        int o1 = ofs1.asCastedInt();
        int o2 = ofs2.asCastedInt();
        int o3 = ofs3.asCastedInt();
        int l1 = len1.asCastedInt();
        int l2 = len2.asCastedInt();
        int l3 = len3.asCastedInt();
        BigInteger carry = Nat.createDigit(0L);
        while (l3 > 0) {
            carry = Nat.addDigit(carry, Nat.createDigit(Nat.multDigitNat(b1, o1, l1, b2, o2, l2, b3, o3)));
            --l3;
            ++o3;
            --l1;
            ++o1;
        }
        return Value.createLong(carry.longValue());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "int", "Nat.nat", "int", "int", "Nat.nat", "int", "int"}, returnType="int")
    public static Value mult_nat_native(Value nat1, Value ofs1, Value len1, Value nat2, Value ofs2, Value len2, Value nat3, Value ofs3, Value len3) {
        return Nat.mult_nat(nat1, ofs1, len1, nat2, ofs2, len2, nat3, ofs3, len3);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "int", "Nat.nat", "int", "int"}, returnType="int")
    public static Value square_nat(Value nat1, Value ofs1, Value len1, Value nat2, Value ofs2, Value len2) {
        long[] b1 = (long[])nat1.asCustom();
        long[] b2 = (long[])nat2.asCustom();
        int o1 = ofs1.asCastedInt();
        int o2 = ofs2.asCastedInt();
        int l1 = len1.asCastedInt();
        int l2 = len2.asCastedInt();
        BigInteger carry1 = BigInteger.ZERO;
        for (int i = 1; i < l2; ++i) {
            int aofs = 2 * i - 1;
            carry1 = Nat.addDigit(carry1, Nat.createDigit(Nat.multDigitNat(b1, o1 + aofs, l1 - aofs, b2, o2 + i, l2 - i, b2, o2 + i - 1)));
        }
        carry1 = carry1.shiftLeft(1).and(BNG_DIGIT_MASK).or(Nat.createDigit(Nat.shiftLeft(b1, o1, l1, 1)).and(BNG_DIGIT_MASK));
        BigInteger carry2 = BigInteger.ZERO;
        for (int i = 0; i < l2; ++i) {
            BigInteger d = Nat.createDigit(b2[o2 + i]);
            BigInteger p11 = Nat.multDigit(d.and(BNG_LOW_HALF_MASK), d.and(BNG_LOW_HALF_MASK));
            BigInteger p12 = Nat.multDigit(d.and(BNG_LOW_HALF_MASK), d.shiftRight(32));
            BigInteger p21 = Nat.multDigit(d.shiftRight(32), d.and(BNG_LOW_HALF_MASK));
            BigInteger p22 = Nat.multDigit(d.shiftRight(32), d.shiftRight(32));
            BigInteger ph = Nat.addDigit(p22, Nat.addDigit(p12.shiftRight(32), p21.shiftRight(32)));
            BigInteger tmp1 = p11;
            BigInteger tmp2 = Nat.addDigit(tmp1, p12.shiftLeft(32).and(BNG_DIGIT_MASK));
            ph = Nat.addDigit(ph, tmp2.compareTo(tmp1) < 0 ? BigInteger.ONE : BigInteger.ZERO);
            BigInteger tmp3 = Nat.addDigit(tmp2, p21.shiftLeft(32).and(BNG_DIGIT_MASK));
            ph = Nat.addDigit(ph, tmp3.compareTo(tmp2) < 0 ? BigInteger.ONE : BigInteger.ZERO);
            BigInteger pl = tmp3;
            BigInteger tmp12 = Nat.createDigit(b1[o1]);
            BigInteger tmp22 = Nat.addDigit(tmp12, pl);
            BigInteger tmp32 = Nat.addDigit(tmp22, carry2);
            carry2 = Nat.addDigit(tmp22.compareTo(tmp12) < 0 ? BigInteger.ONE : BigInteger.ZERO, tmp32.compareTo(tmp22) < 0 ? BigInteger.ONE : BigInteger.ZERO);
            b1[o1] = tmp32.longValue();
            tmp12 = Nat.createDigit(b1[++o1]);
            tmp22 = Nat.addDigit(tmp12, ph);
            tmp32 = Nat.addDigit(tmp22, carry2);
            carry2 = Nat.addDigit(tmp22.compareTo(tmp12) < 0 ? BigInteger.ONE : BigInteger.ZERO, tmp32.compareTo(tmp22) < 0 ? BigInteger.ONE : BigInteger.ZERO);
            b1[o1] = tmp32.longValue();
            ++o1;
        }
        if ((l1 -= 2 * l2) > 0 && carry2.compareTo(BigInteger.ZERO) != 0) {
            do {
                int n = o1++;
                b1[n] = b1[n] + 1L;
                if (b1[n] == 0L) continue;
                carry2 = BigInteger.ZERO;
                break;
            } while (--l1 != 0);
        }
        return Value.createLong(Nat.addDigit(carry1, carry2).longValue());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "int", "Nat.nat", "int", "int"}, returnType="int")
    public static Value square_nat_native(Value nat1, Value ofs1, Value len1, Value nat2, Value ofs2, Value len2) {
        return Nat.square_nat(nat1, ofs1, len1, nat2, ofs2, len2);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "int", "Nat.nat", "int", "int"}, returnType="unit")
    public static Value shift_left_nat(Value nat1, Value ofs1, Value len1, Value nat2, Value ofs2, Value nbits) {
        ((long[])nat2.asCustom())[ofs2.asCastedInt()] = Nat.shiftLeft((long[])nat1.asCustom(), ofs1.asCastedInt(), len1.asCastedInt(), nbits.asCastedInt());
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "int", "Nat.nat", "int", "int"}, returnType="unit")
    public static Value shift_left_nat_native(Value nat1, Value ofs1, Value len1, Value nat2, Value ofs2, Value nbits) {
        return Nat.shift_left_nat(nat1, ofs1, len1, nat2, ofs2, nbits);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "Nat.nat", "int", "Nat.nat", "int", "int", "Nat.nat", "int"}, returnType="unit")
    public static Value div_digit_nat(Value natq, Value ofsq, Value natr, Value ofsr, Value nat1, Value ofs1, Value len1, Value nat2, Value ofs2) {
        long[] a = (long[])natq.asCustom();
        int aOfs = ofsq.asCastedInt();
        long[] b = (long[])nat1.asCustom();
        int bOfs = ofs1.asCastedInt();
        int len = len1.asCastedInt();
        long tmp = ((long[])nat2.asCustom())[ofs2.asCastedInt()];
        int shift = Nat.numLeadingZeroBitsInDigit(tmp);
        BigInteger d = Nat.createDigit(tmp);
        d = d.shiftLeft(shift).and(BNG_DIGIT_MASK);
        Nat.shiftLeft(b, bOfs, len, shift);
        BigInteger rem = Nat.divRemNormDigit(a, aOfs, b, bOfs, len, d);
        Nat.shiftRight(b, bOfs, len, shift);
        ((long[])natr.asCustom())[ofsr.asCastedInt()] = rem.shiftRight(shift).longValue();
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "Nat.nat", "int", "Nat.nat", "int", "int", "Nat.nat", "int"}, returnType="unit")
    public static Value div_digit_nat_native(Value natq, Value ofsq, Value natr, Value ofsr, Value nat1, Value ofs1, Value len1, Value nat2, Value ofs2) {
        return Nat.div_digit_nat(natq, ofsq, natr, ofsr, nat1, ofs1, len1, nat2, ofs2);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "int", "Nat.nat", "int", "int"}, returnType="unit")
    public static Value div_nat(Value nat1, Value ofs1, Value len1, Value nat2, Value ofs2, Value len2) {
        long[] n = (long[])nat1.asCustom();
        long[] d = (long[])nat2.asCustom();
        int nOfs = ofs1.asCastedInt();
        int dOfs = ofs2.asCastedInt();
        int nLen = len1.asCastedInt();
        int dLen = len2.asCastedInt();
        int shift = Nat.numLeadingZeroBitsInDigit(d[dOfs + dLen - 1]);
        Nat.shiftLeft(n, nOfs, nLen, shift);
        Nat.shiftLeft(d, dOfs, dLen, shift);
        if (dLen == 1) {
            n[nOfs] = Nat.divRemNormDigit(n, nOfs + 1, n, nOfs, nLen, Nat.createDigit(d[dOfs])).longValue();
        } else {
            BigInteger topDen = Nat.createDigit(d[dOfs + dLen - 1]);
            for (int j = nLen - 1; j >= dLen; --j) {
                BigInteger quo;
                int i = j - dLen;
                if (Nat.addDigit(topDen, BigInteger.ONE).compareTo(BigInteger.ZERO) == 0) {
                    quo = Nat.createDigit(n[nOfs + j]);
                } else {
                    BigInteger nh = Nat.createDigit(n[nOfs + j]);
                    BigInteger nl = Nat.createDigit(n[nOfs + j - 1]);
                    BigInteger dd = Nat.addDigit(topDen, BigInteger.ONE);
                    BigInteger dl = dd.and(BNG_LOW_HALF_MASK);
                    BigInteger dh = dd.shiftRight(32);
                    BigInteger qh = Nat.divDigit(nh, Nat.addDigit(dh, BigInteger.ONE));
                    BigInteger nsaved = nl.and(BNG_LOW_HALF_MASK);
                    BigInteger ph = Nat.multDigit(qh, dh);
                    BigInteger pl = Nat.multDigit(qh, dl);
                    nh = Nat.subtractDigit(nh, ph);
                    nl = nl.shiftRight(32).or(nh.shiftLeft(32)).and(BNG_DIGIT_MASK);
                    nh = nh.shiftRight(32);
                    nh = Nat.subtractDigit(nh, nl.compareTo(pl) < 0 ? BigInteger.ONE : BigInteger.ZERO);
                    nl = Nat.subtractDigit(nl, pl);
                    while (nh.compareTo(BigInteger.ZERO) != 0 || nl.compareTo(dd) >= 0) {
                        nh = Nat.subtractDigit(nh, nl.compareTo(dd) < 0 ? BigInteger.ONE : BigInteger.ZERO);
                        nl = Nat.subtractDigit(nl, dd);
                        qh = Nat.addDigit(qh, BigInteger.ONE);
                    }
                    BigInteger ql = Nat.divDigit(nl, Nat.addDigit(dh, BigInteger.ONE));
                    ph = Nat.multDigit(ql, dh);
                    pl = Nat.multDigit(ql, dl);
                    nl = Nat.subtractDigit(nl, ph);
                    nh = nl.shiftRight(32);
                    nh = Nat.subtractDigit(nh, (nl = nl.shiftLeft(32).or(nsaved).and(BNG_DIGIT_MASK)).compareTo(pl) < 0 ? BigInteger.ONE : BigInteger.ZERO);
                    nl = Nat.subtractDigit(nl, pl);
                    while (nh.compareTo(BigInteger.ZERO) != 0 || nl.compareTo(dd) >= 0) {
                        nh = Nat.subtractDigit(nh, nl.compareTo(dd) < 0 ? BigInteger.ONE : BigInteger.ZERO);
                        nl = Nat.subtractDigit(nl, dd);
                        ql = Nat.addDigit(ql, BigInteger.ONE);
                    }
                    quo = qh.shiftLeft(32).or(ql).and(BNG_DIGIT_MASK);
                }
                n[nOfs + j] = Nat.subtractDigit(Nat.createDigit(n[nOfs + j]), Nat.multSubDigit(n, nOfs + i, dLen, d, dOfs, dLen, quo)).longValue();
                while (n[nOfs + j] != 0L || Nat.compareNat(n, nOfs + i, dLen, d, dOfs, dLen) >= 0) {
                    quo = Nat.addDigit(quo, BigInteger.ONE);
                    n[nOfs + j] = Nat.subtractDigit(Nat.createDigit(n[nOfs + j]), BigInteger.ONE.xor(Nat.createDigit(Nat.subNat(n, nOfs + i, dLen, d, dOfs, dLen, BigInteger.ZERO))).and(BNG_DIGIT_MASK)).longValue();
                }
                n[nOfs + j] = quo.longValue();
            }
        }
        Nat.shiftRight(n, nOfs, dLen, shift);
        Nat.shiftRight(d, dOfs, dLen, shift);
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "int", "Nat.nat", "int", "int"}, returnType="unit")
    public static Value div_nat_native(Value nat1, Value ofs1, Value len1, Value nat2, Value ofs2, Value len2) {
        return Nat.div_nat(nat1, ofs1, len1, nat2, ofs2, len2);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "int", "Nat.nat", "int", "int"}, returnType="unit")
    public static Value shift_right_nat(Value nat1, Value ofs1, Value len1, Value nat2, Value ofs2, Value nbits) {
        ((long[])nat2.asCustom())[ofs2.asCastedInt()] = Nat.shiftRight((long[])nat1.asCustom(), ofs1.asCastedInt(), len1.asCastedInt(), nbits.asCastedInt());
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "int", "Nat.nat", "int", "int"}, returnType="unit")
    public static Value shift_right_nat_native(Value nat1, Value ofs1, Value len1, Value nat2, Value ofs2, Value nbits) {
        return Nat.shift_right_nat(nat1, ofs1, len1, nat2, ofs2, nbits);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "Nat.nat", "int"}, returnType="int")
    public static Value compare_digits_nat(Value nat1, Value ofs1, Value nat2, Value ofs2) {
        BigInteger d1 = Nat.createDigit(((long[])nat1.asCustom())[ofs1.asCastedInt()]);
        BigInteger d2 = Nat.createDigit(((long[])nat2.asCustom())[ofs2.asCastedInt()]);
        return Value.createLong(d1.compareTo(d2));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "int", "Nat.nat", "int", "int", "int"}, returnType="int")
    public static Value compare_nat(Value nat1, Value ofs1, Value len1, Value nat2, Value ofs2, Value len2) {
        return Value.createLong(Nat.compareNat((long[])nat1.asCustom(), ofs1.asCastedInt(), len1.asCastedInt(), (long[])nat2.asCustom(), ofs2.asCastedInt(), len2.asCastedInt()));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "int", "Nat.nat", "int", "int", "int"}, returnType="int")
    public static Value compare_nat_native(Value nat1, Value ofs1, Value len1, Value nat2, Value ofs2, Value len2) {
        return Nat.compare_nat(nat1, ofs1, len1, nat2, ofs2, len2);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "Nat.nat", "int"}, returnType="unit")
    public static Value land_digit_nat(Value nat1, Value ofs1, Value nat2, Value ofs2) {
        long[] lArray = (long[])nat1.asCustom();
        int n = ofs1.asCastedInt();
        lArray[n] = lArray[n] & ((long[])nat2.asCustom())[ofs2.asCastedInt()];
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "Nat.nat", "int"}, returnType="unit")
    public static Value lor_digit_nat(Value nat1, Value ofs1, Value nat2, Value ofs2) {
        long[] lArray = (long[])nat1.asCustom();
        int n = ofs1.asCastedInt();
        lArray[n] = lArray[n] | ((long[])nat2.asCustom())[ofs2.asCastedInt()];
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "Nat.nat", "int"}, returnType="unit")
    public static Value lxor_digit_nat(Value nat1, Value ofs1, Value nat2, Value ofs2) {
        long[] lArray = (long[])nat1.asCustom();
        int n = ofs1.asCastedInt();
        lArray[n] = lArray[n] ^ ((long[])nat2.asCustom())[ofs2.asCastedInt()];
        return Value.UNIT;
    }

    private static int numLeadingZeroBitsInDigit(long digit) {
        long d = digit;
        int n = 64;
        if ((d & 0xFFFFFFFF00000000L) != 0L) {
            n -= 32;
            d >>>= 32;
        }
        if ((d & 0xFFFF0000L) != 0L) {
            n -= 16;
            d >>>= 16;
        }
        if ((d & 0xFF00L) != 0L) {
            n -= 8;
            d >>>= 8;
        }
        if ((d & 0xF0L) != 0L) {
            n -= 4;
            d >>>= 4;
        }
        if ((d & 0xCL) != 0L) {
            n -= 2;
            d >>>= 2;
        }
        if ((d & 2L) != 0L) {
            --n;
            d >>>= 1;
        }
        return n - (int)d;
    }

    private static int compareNat(long[] b1, int ofs1, int len1, long[] b2, int ofs2, int len2) {
        int l1;
        int o1 = ofs1;
        int o2 = ofs2;
        int l2 = len2;
        for (l1 = len1; l1 > 0 && b1[o1 + l1 - 1] == 0L; --l1) {
        }
        while (l2 > 0 && b2[o2 + l2 - 1] == 0L) {
            --l2;
        }
        if (l1 > l2) {
            return 1;
        }
        if (l1 < l2) {
            return -1;
        }
        while (l1 > 0) {
            BigInteger db;
            BigInteger da;
            int res;
            if ((res = (da = Nat.createDigit(b1[o1 + --l1])).compareTo(db = Nat.createDigit(b2[o2 + l1]))) == 0) continue;
            return res;
        }
        return 0;
    }

    private static long subNat(long[] b1, int ofs1, int len1, long[] b2, int ofs2, int len2, BigInteger carry) {
        int o1 = ofs1;
        int o2 = ofs2;
        int l1 = len1;
        int l2 = len2;
        BigInteger c = BigInteger.ONE.xor(carry).and(BNG_DIGIT_MASK);
        l1 -= l2;
        while (l2 > 0) {
            BigInteger tmp1 = Nat.createDigit(b1[o1]);
            BigInteger tmp2 = Nat.createDigit(b2[o2]);
            BigInteger tmp3 = Nat.subtractDigit(tmp1, tmp2);
            b1[o1] = Nat.subtractDigit(tmp3, c).longValue();
            c = Nat.addDigit(tmp1.compareTo(tmp2) < 0 ? BigInteger.ONE : BigInteger.ZERO, tmp3.compareTo(c) < 0 ? BigInteger.ONE : BigInteger.ZERO);
            --l2;
            ++o1;
            ++o2;
        }
        if (c.compareTo(BigInteger.ZERO) == 0 || l1 == 0) {
            return carry.longValue();
        }
        do {
            int n = o1++;
            long l = b1[n];
            b1[n] = l - 1L;
            if (l == 0L) continue;
            return 1L;
        } while (--l1 != 0);
        return 0L;
    }

    private static long multDigitNat(long[] b1, int ofs1, int len1, long[] b2, int ofs2, int len2, long[] b3, int o3) {
        int l1 = len1;
        int l2 = len2;
        int o1 = ofs1;
        int o2 = ofs2;
        BigInteger d = Nat.createDigit(b3[o3]);
        l1 -= l2;
        BigInteger out = BigInteger.ZERO;
        while (l2 > 0) {
            BigInteger bd = Nat.createDigit(b2[o2]);
            BigInteger p11 = Nat.multDigit(bd.and(BNG_LOW_HALF_MASK), d.and(BNG_LOW_HALF_MASK));
            BigInteger p12 = Nat.multDigit(bd.and(BNG_LOW_HALF_MASK), d.shiftRight(32));
            BigInteger p21 = Nat.multDigit(bd.shiftRight(32), d.and(BNG_LOW_HALF_MASK));
            BigInteger p22 = Nat.multDigit(bd.shiftRight(32), d.shiftRight(32));
            BigInteger ph = Nat.addDigit(p22, Nat.addDigit(p12.shiftRight(32), p21.shiftRight(32)));
            BigInteger tmp1 = p11;
            BigInteger tmp2 = Nat.addDigit(tmp1, p12.shiftLeft(32).and(BNG_DIGIT_MASK));
            ph = Nat.addDigit(ph, tmp2.compareTo(tmp1) < 0 ? BigInteger.ONE : BigInteger.ZERO);
            BigInteger tmp3 = Nat.addDigit(tmp2, p21.shiftLeft(32).and(BNG_DIGIT_MASK));
            ph = Nat.addDigit(ph, tmp3.compareTo(tmp2) < 0 ? BigInteger.ONE : BigInteger.ZERO);
            BigInteger pl = tmp3;
            BigInteger tmp12 = Nat.createDigit(b1[o1]);
            BigInteger tmp22 = Nat.addDigit(tmp12, pl);
            ph = Nat.addDigit(ph, tmp22.compareTo(tmp12) < 0 ? BigInteger.ONE : BigInteger.ZERO);
            BigInteger tmp32 = Nat.addDigit(tmp22, out);
            ph = Nat.addDigit(ph, tmp32.compareTo(tmp22) < 0 ? BigInteger.ONE : BigInteger.ZERO);
            b1[o1] = tmp32.longValue();
            out = ph;
            --l2;
            ++o1;
            ++o2;
        }
        if (l1 == 0) {
            return out.longValue();
        }
        BigInteger carry = BigInteger.ZERO;
        BigInteger tmp1 = Nat.createDigit(b1[o1]);
        BigInteger tmp2 = Nat.addDigit(tmp1, out);
        carry = tmp2.compareTo(tmp1) < 0 ? BigInteger.ONE : BigInteger.ZERO;
        b1[o1] = tmp2.longValue();
        ++o1;
        if (carry.compareTo(BigInteger.ZERO) == 0 || --l1 == 0) {
            return carry.longValue();
        }
        do {
            int n = o1++;
            b1[n] = b1[n] + 1L;
            if (b1[n] == 0L) continue;
            return 0L;
        } while (--l1 != 0);
        return 1L;
    }

    private static long shiftLeft(long[] b, int ofs, int len, int shift) {
        int o = ofs;
        int shift2 = 64 - shift;
        long carry = 0L;
        if (shift > 0) {
            int l = len;
            while (l > 0) {
                long d = b[o];
                b[o] = d << shift | carry;
                carry = d >>> shift2;
                --l;
                ++o;
            }
        }
        return carry;
    }

    private static long shiftRight(long[] b, int ofs, int len, int shift) {
        int l = len;
        int shift2 = 64 - shift;
        long carry = 0L;
        if (shift > 0) {
            int o = ofs + l - 1;
            while (l > 0) {
                long d = b[o];
                b[o] = d >>> shift | carry;
                carry = d << shift2;
                --l;
                --o;
            }
        }
        return carry;
    }

    private static BigInteger divRemNormDigit(long[] a, int aOfs, long[] b, int bOfs, int len, BigInteger d) {
        BigInteger topDigit = Nat.createDigit(b[bOfs + len - 1]);
        for (int i = len - 2; i >= 0; --i) {
            BigInteger nh = topDigit;
            BigInteger nl = Nat.createDigit(b[bOfs + i]);
            BigInteger dl = d.and(BNG_LOW_HALF_MASK);
            BigInteger dh = d.shiftRight(32);
            BigInteger qh = Nat.divDigit(nh, Nat.addDigit(dh, BigInteger.ONE));
            BigInteger nsaved = nl.and(BNG_LOW_HALF_MASK);
            BigInteger ph = Nat.multDigit(qh, dh);
            BigInteger pl = Nat.multDigit(qh, dl);
            nh = Nat.subtractDigit(nh, ph);
            nl = nl.shiftRight(32).or(nh.shiftLeft(32)).and(BNG_DIGIT_MASK);
            nh = nh.shiftRight(32);
            nh = Nat.subtractDigit(nh, nl.compareTo(pl) < 0 ? BigInteger.ONE : BigInteger.ZERO);
            nl = Nat.subtractDigit(nl, pl);
            while (nh.compareTo(BigInteger.ZERO) != 0 || nl.compareTo(d) >= 0) {
                nh = Nat.subtractDigit(nh, nl.compareTo(d) < 0 ? BigInteger.ONE : BigInteger.ZERO);
                nl = Nat.subtractDigit(nl, d);
                qh = Nat.addDigit(qh, BigInteger.ONE);
            }
            BigInteger ql = Nat.divDigit(nl, dh.add(BigInteger.ONE));
            ph = Nat.multDigit(ql, dh);
            pl = Nat.multDigit(ql, dl);
            nl = Nat.subtractDigit(nl, ph);
            nh = nl.shiftRight(32);
            nh = Nat.subtractDigit(nh, (nl = nl.shiftLeft(32).or(nsaved).and(BNG_DIGIT_MASK)).compareTo(pl) < 0 ? BigInteger.ONE : BigInteger.ZERO);
            nl = Nat.subtractDigit(nl, pl);
            while (nh.compareTo(BigInteger.ZERO) != 0 || nl.compareTo(d) >= 0) {
                nh = Nat.subtractDigit(nh, nl.compareTo(d) < 0 ? BigInteger.ONE : BigInteger.ZERO);
                nl = Nat.subtractDigit(nl, d);
                ql = Nat.addDigit(ql, BigInteger.ONE);
            }
            BigInteger quo = qh.shiftLeft(32).or(ql).and(BNG_DIGIT_MASK);
            BigInteger rem = nl;
            a[aOfs + i] = quo.longValue();
            topDigit = rem;
        }
        return topDigit;
    }

    private static BigInteger multSubDigit(long[] a, int ofs1, int len1, long[] b, int ofs2, int len2, BigInteger d) {
        int aLen = len1;
        int bLen = len2;
        int aOfs = ofs1;
        int bOfs = ofs2;
        aLen -= bLen;
        BigInteger out = BigInteger.ZERO;
        while (bLen > 0) {
            BigInteger bd = Nat.createDigit(b[bOfs]);
            BigInteger p11 = Nat.multDigit(bd.and(BNG_LOW_HALF_MASK), d.and(BNG_LOW_HALF_MASK));
            BigInteger p12 = Nat.multDigit(bd.and(BNG_LOW_HALF_MASK), d.shiftRight(32));
            BigInteger p21 = Nat.multDigit(bd.shiftRight(32), d.and(BNG_LOW_HALF_MASK));
            BigInteger p22 = Nat.multDigit(bd.shiftRight(32), d.shiftRight(32));
            BigInteger ph = Nat.addDigit(p22, Nat.addDigit(p12.shiftRight(32), p21.shiftRight(32)));
            BigInteger tmp1 = p11;
            BigInteger tmp2 = Nat.addDigit(tmp1, p12.shiftLeft(32).and(BNG_DIGIT_MASK));
            ph = Nat.addDigit(ph, tmp2.compareTo(tmp1) < 0 ? BigInteger.ONE : BigInteger.ZERO);
            BigInteger tmp3 = Nat.addDigit(tmp2, p21.shiftLeft(32).and(BNG_DIGIT_MASK));
            ph = Nat.addDigit(ph, tmp3.compareTo(tmp2) < 0 ? BigInteger.ONE : BigInteger.ZERO);
            BigInteger pl = tmp3;
            BigInteger tmp12 = Nat.createDigit(a[aOfs]);
            BigInteger tmp22 = pl;
            BigInteger tmp32 = out;
            BigInteger tmp4 = Nat.subtractDigit(tmp12, tmp22);
            a[aOfs] = Nat.subtractDigit(tmp4, tmp32).longValue();
            out = ph = Nat.addDigit(ph, Nat.addDigit(tmp12.compareTo(tmp22) < 0 ? BigInteger.ONE : BigInteger.ZERO, tmp4.compareTo(tmp32) < 0 ? BigInteger.ONE : BigInteger.ZERO));
            --bLen;
            ++aOfs;
            ++bOfs;
        }
        if (aLen == 0) {
            return out;
        }
        BigInteger tmp1 = Nat.createDigit(a[aOfs]);
        BigInteger tmp2 = out;
        a[aOfs] = Nat.subtractDigit(tmp1, tmp2).longValue();
        BigInteger carry = tmp1.compareTo(tmp2) < 0 ? BigInteger.ONE : BigInteger.ZERO;
        ++aOfs;
        if (carry.compareTo(BigInteger.ZERO) == 0 || --aLen == 0) {
            return carry;
        }
        do {
            int n = aOfs++;
            long l = a[n];
            a[n] = l - 1L;
            if (l == 0L) continue;
            return BigInteger.ZERO;
        } while (--aLen != 0);
        return BigInteger.ONE;
    }

    private static BigInteger createDigit(long x) {
        byte[] b = new byte[8];
        long tmp = x;
        for (int i = 0; i < 8; ++i) {
            b[7 - i] = (byte)(tmp & 0xFFL);
            tmp >>= 8;
        }
        return new BigInteger(1, b);
    }

    private static BigInteger addDigit(BigInteger x, BigInteger y) {
        BigInteger res = x.add(y);
        return res.and(BNG_DIGIT_MASK);
    }

    private static BigInteger multDigit(BigInteger x, BigInteger y) {
        BigInteger res = x.multiply(y);
        return res.and(BNG_DIGIT_MASK);
    }

    private static BigInteger subtractDigit(BigInteger x, BigInteger y) {
        BigInteger res = x.subtract(y);
        return res.and(BNG_DIGIT_MASK);
    }

    private static BigInteger divDigit(BigInteger x, BigInteger y) {
        BigInteger res = x.divide(y);
        return res.and(BNG_DIGIT_MASK);
    }
}

