/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.unix;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.primitives.otherlibs.unix.Unix;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="unix", module="Unix", source="otherlibs/unix/readlink.c")
public final class Readlink {
    private Readlink() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string"}, returnType="string")
    public static Value unix_readlink(Value path) throws Fail.Exception {
        Context ctxt = OCamlJavaThread.getCodeRunner().getContext();
        try {
            Path res = Files.readSymbolicLink(ctxt.getFilesState().getRealFile(path).toPath());
            return Value.createString(res.toAbsolutePath().toString());
        }
        catch (IOException ioe) {
            Unix.fail("readlink", ioe);
            return Value.UNIT;
        }
    }
}

