/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.unix;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.channels.SocketChannel;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.kernel.Channel;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.primitives.otherlibs.unix.Unix;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="unix", module="Unix", source="otherlibs/unix/shutdown.c")
public final class Shutdown {
    private static final int SHUTDOWN_RECEIVE = 0;
    private static final int SHUTDOWN_SEND = 1;
    private static final int SHUTDOWN_ALL = 2;

    private Shutdown() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Unix.file_descr", "Unix.shutdown_command"}, returnType="unit")
    public static Value unix_shutdown(Value socket, Value cmd) throws Fail.Exception, FalseExit {
        Context ctxt = OCamlJavaThread.getCodeRunner().getContext();
        Channel ch = ctxt.getFilesState().getChannel(socket.asCastedInt());
        if (ch == null) {
            Unix.fail("shutdown", "invalid descriptor");
            return Value.UNIT;
        }
        SocketChannel s = ch.asSocket();
        if (s != null) {
            try {
                switch (cmd.asCastedInt()) {
                    case 0: {
                        s.shutdownInput();
                        break;
                    }
                    case 1: {
                        s.shutdownOutput();
                        break;
                    }
                    case 2: {
                        s.shutdownOutput();
                        s.shutdownInput();
                        break;
                    }
                    default: {
                        assert (false) : "invalid shutdown command";
                    }
                }
            }
            catch (InterruptedIOException iioe) {
                FalseExit fe = FalseExit.createFromContext(ctxt);
                fe.fillInStackTrace();
                throw fe;
            }
            catch (IOException ioe) {
                Unix.fail("shutdown", ioe);
            }
        } else {
            Unix.fail("shutdown", "invalid descriptor");
        }
        return Value.UNIT;
    }
}

