/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.unix;

import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.kernel.CodeRunner;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.primitives.otherlibs.unix.Unix;
import org.ocamljava.runtime.util.SignalKind;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="unix", module="Unix", source="otherlibs/unix/itimer.c")
public final class Itimer {
    private static final Object[] SLOTS = new Object[]{new Object(), new Object(), new Object()};
    private static final SignalKind[] SIGNALS = new SignalKind[]{SignalKind.ALRM, SignalKind.VTALRM, SignalKind.PROF};

    private Itimer() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.PARTIAL, comment={"All three timers are based on real time."}, parameterTypes={"Unix.interval_timer", "Unix.interval_timer_status"}, returnType="Unix.interval_timer_status")
    public static Value unix_setitimer(Value which, Value newVal) {
        long resValue;
        long resInterval;
        CodeRunner runner = OCamlJavaThread.getCodeRunner();
        Context ctxt = runner.getContext();
        long interval = (long)(newVal.getDouble0() * 1000.0);
        long value = (long)(newVal.getDouble1() * 1000.0);
        int w = which.asCastedInt();
        Unix.AlarmThread old = (Unix.AlarmThread)ctxt.getCodeState().getSlot(SLOTS[w]);
        if (old != null) {
            resInterval = old.getInterval();
            resValue = old.unactivate();
        } else {
            resInterval = 0L;
            resValue = 0L;
        }
        if (value != 0L) {
            ctxt.getCodeState().registerSlot(SLOTS[w], new Unix.AlarmThread(runner, value, interval, SIGNALS[w]));
        }
        return Itimer.createStatus(resInterval, resValue);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Unix.interval_timer"}, returnType="Unix.interval_timer_status")
    public static Value unix_getitimer(Value which) {
        long resValue;
        long resInterval;
        Context ctxt = OCamlJavaThread.getCodeRunner().getContext();
        Unix.AlarmThread old = (Unix.AlarmThread)ctxt.getCodeState().getSlot(SLOTS[which.asCastedInt()]);
        if (old != null) {
            resInterval = old.getInterval();
            resValue = old.getValue();
        } else {
            resInterval = 0L;
            resValue = 0L;
        }
        return Itimer.createStatus(resInterval, resValue);
    }

    private static Value createStatus(long interval, long value) {
        return Value.createDoubleArray((double)interval / 1000.0, (double)value / 1000.0);
    }
}

