/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.unix;

import java.io.IOException;
import java.io.InterruptedIOException;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.kernel.Channel;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.primitives.otherlibs.unix.Unix;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="unix", module="Unix", source="otherlibs/unix/write.c")
public final class Write {
    private Write() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Unix.file_descr", "string", "int", "int"}, returnType="int")
    public static Value unix_write(Value fd, Value buf, Value vofs, Value vlen) throws Fail.Exception, FalseExit {
        Context ctxt = OCamlJavaThread.getCodeRunner().getContext();
        Channel ch = ctxt.getFilesState().getChannel(fd.asCastedInt());
        if (ch == null) {
            Unix.fail("write", "invalid descriptor");
            return Value.UNIT;
        }
        int ofs = vofs.asCastedInt();
        int len = vlen.asCastedInt();
        byte[] buff = buf.getBytesForModification();
        ctxt.enterBlockingSection();
        try {
            ch.write(buff, ofs, len);
            ch.flush();
            ctxt.leaveBlockingSection();
        }
        catch (InterruptedIOException iioe) {
            FalseExit fe = FalseExit.createFromContext(ctxt);
            fe.fillInStackTrace();
            throw fe;
        }
        catch (IOException ioe) {
            ctxt.leaveBlockingSection();
            Unix.fail("write", ioe);
        }
        return vlen;
    }

    @Primitive(compatibility=PrimitiveCompatibility.PARTIAL, comment={"Exact synonym of [unix_write]."}, parameterTypes={"Unix.file_descr", "string", "int", "int"}, returnType="int")
    public static Value unix_single_write(Value fd, Value buf, Value vofs, Value vlen) throws Fail.Exception, FalseExit {
        return Write.unix_write(fd, buf, vofs, vlen);
    }
}

