/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.unix;

import java.io.IOException;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.DatagramChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.Channel;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.primitives.otherlibs.unix.Unix;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="unix", module="Unix", source="otherlibs/unix/sockopt.c")
public final class Sockopt {
    private static final int SO_DEBUG = 0;
    private static final int SO_BROADCAST = 1;
    private static final int SO_REUSEADDR = 2;
    private static final int SO_KEEPALIVE = 3;
    private static final int SO_DONTROUTE = 4;
    private static final int SO_OOBINLINE = 5;
    private static final int SO_ACCEPTCONN = 6;
    private static final int TCP_NODELAY = 7;
    private static final int IPV6_V6ONLY = 8;
    private static final int SO_SNDBUF = 0;
    private static final int SO_RCVBUF = 1;
    private static final int SO_ERROR = 2;
    private static final int SO_TYPE = 3;
    private static final int SO_RCVLOWAT = 4;
    private static final int SO_SNDLOWAT = 5;
    private static final int OPTION_TYPE_BOOL = 0;
    private static final int OPTION_TYPE_INT = 1;
    private static final int OPTION_TYPE_LINGER = 2;
    private static final int OPTION_TYPE_TIMEVAL = 3;
    private static final int OPTION_TYPE_UNIX_ERROR = 4;
    private static final String[] GET_FUNC_NAMES = new String[]{"getsockopt", "getsockopt_int", "getsockopt_optint", "getsockopt_float", "getsockopt_error"};
    private static final String[] SET_FUNC_NAMES = new String[]{"setsockopt", "setsockopt_int", "setsockopt_optint", "setsockopt_float", "setsockopt_error"};

    private Sockopt() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.PARTIAL, comment={"Only supports [SO_KEEPALIVE], [SO_REUSEADDR],", "[SO_BROADCAST], [TCP_NODELAY], [SO_SNDBUF],", "and [SO_RCVBUF]. Does not support [SO_OOBINLINE],", "[SO_ACCEPTCONN], [SO_DONTROUTE], [SO_DEBUG],", "[IPV6_ONLY], [SO_ERROR], [SO_TYPE], [SO_RCVLOWAT],", "[SO_SNDLOWAT], [SO_RCVTIMEO], and [SO_SNDTIMEO]."}, parameterTypes={"('opt, 'v) Unix.SO.t", "Unix.file_descr", "'opt"}, returnType="'v")
    public static Value unix_getsockopt(Value type, Value socket, Value option) throws Fail.Exception {
        String name = GET_FUNC_NAMES[type.asCastedInt()];
        Channel ch = OCamlJavaThread.getCodeRunner().getContext().getFilesState().getChannel(socket.asCastedInt());
        if (ch == null) {
            Unix.fail(name, "invalid descriptor");
            return Value.UNIT;
        }
        SocketChannel s = ch.asSocket();
        DatagramChannel ds = ch.asDatagramSocket();
        ServerSocketChannel srv = ch.asServerSocket();
        if (s == null && ds == null && srv == null) {
            Unix.fail(name, "invalid descriptor");
            return Value.UNIT;
        }
        try {
            switch (type.asCastedInt()) {
                case 0: {
                    switch (option.asCastedInt()) {
                        case 1: {
                            if (ds != null) {
                                return ds.getOption(StandardSocketOptions.SO_BROADCAST) != false ? Value.TRUE : Value.FALSE;
                            }
                            Unix.fail("getsockopt", "unsupported socket option");
                            return Value.UNIT;
                        }
                        case 2: {
                            if (s != null) {
                                return s.getOption(StandardSocketOptions.SO_REUSEADDR) != false ? Value.TRUE : Value.FALSE;
                            }
                            if (ds != null) {
                                return ds.getOption(StandardSocketOptions.SO_REUSEADDR) != false ? Value.TRUE : Value.FALSE;
                            }
                            if (srv != null) {
                                return srv.getOption(StandardSocketOptions.SO_REUSEADDR) != false ? Value.TRUE : Value.FALSE;
                            }
                            return Value.UNIT;
                        }
                        case 3: {
                            if (s != null) {
                                return s.getOption(StandardSocketOptions.SO_KEEPALIVE) != false ? Value.TRUE : Value.FALSE;
                            }
                            Unix.fail("getsockopt", "unsupported socket option");
                            return Value.UNIT;
                        }
                        case 7: {
                            if (s != null) {
                                return s.getOption(StandardSocketOptions.TCP_NODELAY) != false ? Value.TRUE : Value.FALSE;
                            }
                            Unix.fail("getsockopt", "unsupported socket option");
                            return Value.UNIT;
                        }
                        case 0: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 8: {
                            Unix.fail("getsockopt", "unsupported socket option");
                            return Value.UNIT;
                        }
                    }
                    assert (false) : "invalid socket option";
                    return Value.UNIT;
                }
                case 1: {
                    switch (option.asCastedInt()) {
                        case 0: {
                            if (s != null) {
                                return Value.createLong(s.getOption(StandardSocketOptions.SO_SNDBUF).intValue());
                            }
                            if (ds != null) {
                                return Value.createLong(ds.getOption(StandardSocketOptions.SO_SNDBUF).intValue());
                            }
                            Unix.fail("getsockopt_int", "unsupported socket option");
                            return Value.UNIT;
                        }
                        case 1: {
                            if (s != null) {
                                return Value.createLong(s.getOption(StandardSocketOptions.SO_RCVBUF).intValue());
                            }
                            if (srv != null) {
                                return Value.createLong(srv.getOption(StandardSocketOptions.SO_RCVBUF).intValue());
                            }
                            if (ds != null) {
                                return Value.createLong(ds.getOption(StandardSocketOptions.SO_RCVBUF).intValue());
                            }
                            return Value.UNIT;
                        }
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: {
                            Unix.fail("getsockopt_int", "unsupported socket option");
                            return Value.UNIT;
                        }
                    }
                    assert (false) : "invalid socket option";
                    return Value.UNIT;
                }
                case 2: {
                    if (option != Value.ZERO) {
                        Unix.fail("getsockopt_optint", "unsupported socket option");
                        return Value.UNIT;
                    }
                    if (s != null) {
                        int val = s.getOption(StandardSocketOptions.SO_LINGER);
                        if (val < 0) {
                            return Value.ZERO;
                        }
                        return Value.createBlock(0, Value.createLong(val));
                    }
                    Unix.fail("getsockopt_optint", "unsupported socket option");
                    return Value.UNIT;
                }
                case 3: {
                    Unix.fail("getsockopt_float", "unsupported socket option");
                    return Value.UNIT;
                }
                case 4: {
                    Unix.fail("getsockopt_error", "unsupported socket option");
                    return Value.UNIT;
                }
            }
            assert (false) : "invalid socket option";
            return Value.UNIT;
        }
        catch (IOException ioe) {
            Unix.fail(name, ioe);
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.PARTIAL, comment={"Only supports [SO_KEEPALIVE], [SO_REUSEADDR],", "[SO_BROADCAST], [SO_SNDBUF], and [SO_RCVBUF].", "Does not support [SO_OOBINLINE], [SO_ACCEPTCONN],", "[SO_DONTROUTE], [SO_DEBUG], [SO_ERROR], [SO_TYPE],", "[SO_RCVLOWAT], and [SO_SNDLOWAT]."}, parameterTypes={"('opt, 'v) Unix.SO.t", "Unix.file_descr", "'opt", "'v"}, returnType="unix")
    public static Value unix_setsockopt(Value type, Value socket, Value option, Value status) throws Fail.Exception {
        String name = SET_FUNC_NAMES[type.asCastedInt()];
        Channel ch = OCamlJavaThread.getCodeRunner().getContext().getFilesState().getChannel(socket.asCastedInt());
        if (ch == null) {
            Unix.fail("setsockopt_bool", "invalid descriptor");
            return Value.UNIT;
        }
        SocketChannel s = ch.asSocket();
        DatagramChannel ds = ch.asDatagramSocket();
        ServerSocketChannel srv = ch.asServerSocket();
        if (s == null && ds == null && srv == null) {
            Unix.fail(name, "invalid descriptor");
            return Value.UNIT;
        }
        try {
            switch (type.asCastedInt()) {
                case 0: {
                    switch (option.asCastedInt()) {
                        case 1: {
                            if (ds != null) {
                                ds.setOption((SocketOption)StandardSocketOptions.SO_BROADCAST, status != Value.FALSE ? Boolean.TRUE : Boolean.FALSE);
                            } else {
                                Unix.fail("setsockopt_bool", "unsupported socket option");
                            }
                            return Value.UNIT;
                        }
                        case 2: {
                            if (s != null) {
                                s.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, status != Value.FALSE ? Boolean.TRUE : Boolean.FALSE);
                            }
                            if (ds != null) {
                                ds.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, status != Value.FALSE ? Boolean.TRUE : Boolean.FALSE);
                            }
                            if (srv != null) {
                                srv.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, status != Value.FALSE ? Boolean.TRUE : Boolean.FALSE);
                            }
                            return Value.UNIT;
                        }
                        case 3: {
                            if (s != null) {
                                s.setOption((SocketOption)StandardSocketOptions.SO_KEEPALIVE, status != Value.FALSE ? Boolean.TRUE : Boolean.FALSE);
                            } else {
                                Unix.fail("setsockopt_bool", "unsupported socket option");
                            }
                            return Value.UNIT;
                        }
                        case 7: {
                            if (s != null) {
                                s.setOption((SocketOption)StandardSocketOptions.TCP_NODELAY, status != Value.FALSE ? Boolean.TRUE : Boolean.FALSE);
                                return Value.UNIT;
                            }
                            Unix.fail("setsockopt_bool", "unsupported socket option");
                            return Value.UNIT;
                        }
                        case 0: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 8: {
                            Unix.fail("setsockopt_bool", "unsupported socket option");
                            return Value.UNIT;
                        }
                    }
                    assert (false) : "invalid socket option";
                    return Value.UNIT;
                }
                case 1: {
                    switch (option.asCastedInt()) {
                        case 0: {
                            if (s != null) {
                                s.setOption((SocketOption)StandardSocketOptions.SO_SNDBUF, (Object)status.asCastedInt());
                                break;
                            }
                            if (ds != null) {
                                ds.setOption((SocketOption)StandardSocketOptions.SO_SNDBUF, (Object)status.asCastedInt());
                                break;
                            }
                            Unix.fail("setsockopt_int", "unsupported socket option");
                            return Value.UNIT;
                        }
                        case 1: {
                            if (s != null) {
                                s.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Object)status.asCastedInt());
                            }
                            if (srv != null) {
                                srv.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Object)status.asCastedInt());
                            }
                            if (ds == null) break;
                            ds.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Object)status.asCastedInt());
                            break;
                        }
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: {
                            Unix.fail("setsockopt_int", "unsupported socket option");
                            break;
                        }
                        default: {
                            assert (false) : "invalid socket option";
                            break;
                        }
                    }
                    return Value.UNIT;
                }
                case 2: {
                    if (option != Value.ZERO) {
                        Unix.fail("setsockopt_optint", "unsupported socket option");
                        return Value.UNIT;
                    }
                    if (s != null) {
                        if (status.isBlock()) {
                            s.setOption((SocketOption)StandardSocketOptions.SO_LINGER, (Object)status.get0().asCastedInt());
                        } else {
                            s.setOption((SocketOption)StandardSocketOptions.SO_LINGER, (Object)-1);
                        }
                        return Value.UNIT;
                    }
                    Unix.fail("setsockopt_optint", "invalid descriptor");
                    return Value.UNIT;
                }
                case 3: {
                    Unix.fail("setsockopt_float", "unsupported socket option");
                    return Value.UNIT;
                }
                case 4: {
                    Unix.fail("setsockopt_error", "unsupported socket option");
                    return Value.UNIT;
                }
            }
            assert (false) : "invalid socket option";
            return Value.UNIT;
        }
        catch (IOException ioe) {
            Unix.fail(name, ioe);
            return Value.UNIT;
        }
    }
}

