/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.systhreads;

import java.io.PrintStream;
import java.util.concurrent.atomic.AtomicLong;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.CodeState;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.kernel.Channel;
import org.ocamljava.runtime.kernel.CodeRunner;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.kernel.Misc;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.kernel.Signals;
import org.ocamljava.runtime.primitives.otherlibs.systhreads.Condition;
import org.ocamljava.runtime.primitives.otherlibs.systhreads.CustomCondition;
import org.ocamljava.runtime.primitives.otherlibs.systhreads.CustomMutex;
import org.ocamljava.runtime.primitives.otherlibs.systhreads.Mutex;
import org.ocamljava.runtime.primitives.otherlibs.systhreads.ThreadStatus;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="systhreads", module="Thread", source="otherlibs/systhreads/st_stubs.c")
public final class St_stubs {
    private static final Object SLOT_ID = new Object();
    private static final long IDENT = 0L;
    private static final long START_CLOSURE = 1L;
    private static final long TERMINATED = 2L;

    private St_stubs() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="unit")
    public static Value caml_thread_initialize(Value unit) {
        Context ctxt = OCamlJavaThread.getCodeRunner().getContext();
        CodeState codeState = ctxt.getCodeState();
        Object id = codeState.getSlot(SLOT_ID);
        if (id == null) {
            codeState.registerSlot(SLOT_ID, new AtomicLong(1L));
            OCamlJavaThread ct = (OCamlJavaThread)Thread.currentThread();
            CodeRunner cr = ct.getRunner();
            Value descr = Value.createBlock(0, 3L);
            descr.set(0L, Value.ZERO);
            descr.set(1L, Value.UNIT);
            descr.set(2L, ThreadStatus.createValue(new ThreadStatus(cr, ct)));
            cr.setThreadStatus(descr);
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="unit")
    public static Value caml_thread_cleanup(Value unit) {
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"(unit -> unit)"}, returnType="Thread.t")
    public static Value caml_thread_new(Value clos) {
        Value descr;
        CodeRunner runner = OCamlJavaThread.getCodeRunner();
        Context ctxt = runner.getContext();
        long id = ((AtomicLong)ctxt.getCodeState().getSlot(SLOT_ID)).getAndIncrement();
        Value descrValue = descr = Value.createBlock(0, 3L);
        CodeRunner cr = runner.createNewThread(descrValue);
        cr.setup(clos, Value.UNIT);
        ThreadStatus ts = new ThreadStatus(cr, null);
        descr.set(0L, Value.createLong(id));
        descr.set(1L, clos);
        descr.set(2L, ThreadStatus.createValue(ts));
        ts.getThread().start();
        return descr;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="Thread.t")
    public static Value caml_thread_self(Value unit) throws Fail.Exception {
        Context ctxt = OCamlJavaThread.getCodeRunner().getContext();
        if (ctxt.getCodeState().getSlot(SLOT_ID) == null) {
            Fail.invalidArgument("Thread.self: not initialized");
            return Value.UNIT;
        }
        return ((OCamlJavaThread)Thread.currentThread()).getRunner().getThreadStatus();
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Thread.t"}, returnType="int")
    public static Value caml_thread_id(Value th) {
        return th.get(0L);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"exn"}, returnType="unit")
    public static Value caml_thread_uncaught_exception(Value exn) throws FalseExit, Fail.Exception {
        CodeRunner cr = ((OCamlJavaThread)Thread.currentThread()).getRunner();
        Context ctxt = OCamlJavaThread.getCodeRunner().getContext();
        Value globalData = ctxt.getCodeState().getGlobalData();
        Channel err = ctxt.getFilesState().getChannel(2);
        StringBuilder sb = new StringBuilder();
        sb.append("Thread ");
        sb.append(cr.getThreadStatus().get(0L).asLong());
        sb.append(" killed on uncaught exception ");
        sb.append(Misc.convertException(exn, globalData));
        sb.append('\n');
        Channel.tryWrite(err, sb.toString());
        if (ctxt.getCodeState().isBacktraceActive()) {
            cr.printExceptionBacktrace(new PrintStream(err.newOutputStream(), true));
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="unit")
    public static Value caml_thread_exit(Value unit) throws Fail.Exception {
        Context ctxt = OCamlJavaThread.getCodeRunner().getContext();
        if (ctxt.getCodeState().getSlot(SLOT_ID) == null) {
            Fail.invalidArgument("Thread.exit: not initialized");
        } else {
            CodeRunner cr = ((OCamlJavaThread)Thread.currentThread()).getRunner();
            ((ThreadStatus)cr.getThreadStatus().get(2L).asCustom()).terminate();
            ctxt.enterBlockingSection();
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="unit")
    public static Value caml_thread_yield(Value th) throws FalseExit, Fail.Exception {
        Context ctxt = OCamlJavaThread.getCodeRunner().getContext();
        ctxt.enterBlockingSection();
        Thread.yield();
        ctxt.leaveBlockingSection();
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Thread.t"}, returnType="unit")
    public static Value caml_thread_join(Value th) throws Fail.Exception, FalseExit {
        Context ctxt = OCamlJavaThread.getCodeRunner().getContext();
        ctxt.enterBlockingSection();
        ((ThreadStatus)th.get(2L).asCustom()).waitTerm(ctxt);
        ctxt.leaveBlockingSection();
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="Mutex.t")
    public static Value caml_mutex_new(Value unit) {
        return Value.createCustom(CustomMutex.OPS, 1L, new Mutex());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Mutex.t"}, returnType="unit")
    public static Value caml_mutex_lock(Value wrapper) throws Fail.Exception, FalseExit {
        Context ctxt = OCamlJavaThread.getCodeRunner().getContext();
        Mutex mut = (Mutex)wrapper.asCustom();
        if (mut.tryLock()) {
            return Value.UNIT;
        }
        ctxt.enterBlockingSection();
        mut.lock(ctxt);
        ctxt.leaveBlockingSection();
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Mutex.t"}, returnType="unit")
    public static Value caml_mutex_unlock(Value wrapper) {
        ((Mutex)wrapper.asCustom()).unlock();
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Thread.t"}, returnType="bool")
    public static Value caml_mutex_try_lock(Value wrapper) {
        return ((Mutex)wrapper.asCustom()).tryLock() ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="Condition.t")
    public static Value caml_condition_new(Value unit) {
        return Value.createCustom(CustomCondition.OPS, 1L, new Condition());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Condition.t", "Mutex.t"}, returnType="unit")
    public static Value caml_condition_wait(Value wcond, Value wmut) throws Fail.Exception, FalseExit {
        Context ctxt = OCamlJavaThread.getCodeRunner().getContext();
        Mutex mut = (Mutex)wmut.asCustom();
        Condition cond = (Condition)wcond.asCustom();
        cond.wait(ctxt, mut);
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Condition.t"}, returnType="unit")
    public static Value caml_condition_signal(Value wrapper) {
        Condition cond = (Condition)wrapper.asCustom();
        cond.signal();
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Condition.t"}, returnType="unit")
    public static Value caml_condition_broadcast(Value wrapper) {
        Condition cond = (Condition)wrapper.asCustom();
        cond.broadcast();
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Unix.sigprocmask_command", "int list"}, returnType="int list")
    public static Value caml_thread_sigmask(Value cmd, Value sigs) {
        Context ctxt = OCamlJavaThread.getCodeRunner().getContext();
        return Signals.encodeSignalSet(ctxt.getSignalsState().blockSignals(cmd.asCastedInt(), Signals.decodeSignalSet(sigs)));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"int list"}, returnType="int")
    public static Value caml_wait_signal(Value sigs) throws FalseExit, Fail.Exception {
        Context ctxt = OCamlJavaThread.getCodeRunner().getContext();
        ctxt.enterBlockingSection();
        int res = ctxt.getSignalsState().waitSignal(Signals.decodeSignalSet(sigs));
        ctxt.leaveBlockingSection();
        return Value.createLong(Signals.systemToOCamlIdentifier(res));
    }
}

