/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.graph;

import java.awt.Toolkit;
import java.io.IOException;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.primitives.otherlibs.graph.GraphSlot;
import org.ocamljava.runtime.util.Beep;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="graph", module="Graphics", source="otherlibs/graph/sound.c")
public final class Sound {
    private static final int BUFFER_SIZE = 1024;
    private static final float SAMPLE_RATE = 44100.0f;

    private Sound() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"int", "int"}, returnType="unit")
    public static Value caml_gr_sound(Value freq, Value duration) throws Fail.Exception {
        GraphSlot.checkGraph();
        Context ctxt = OCamlJavaThread.getCodeRunner().getContext();
        if (ctxt.getParameters().isJavaxSoundUsed()) {
            try {
                Beep bip = new Beep(44100.0f, freq.asLong(), duration.asLong());
                DataLine.Info info = new DataLine.Info(SourceDataLine.class, bip.getFormat());
                SourceDataLine line = (SourceDataLine)AudioSystem.getLine(info);
                line.open(bip.getFormat());
                line.start();
                byte[] data = new byte[1024];
                while (bip.available() > 0) {
                    int read = bip.read(data);
                    for (int written = line.write(data, 0, read); written < read; written += line.write(data, written, read - written)) {
                    }
                }
                line.drain();
                line.close();
            }
            catch (LineUnavailableException lue) {
                Toolkit.getDefaultToolkit().beep();
            }
            catch (IOException iOException) {}
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
        return Value.UNIT;
    }
}

