/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.stdlib;

import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="stdlib", module="Lexing", source="byterun/lexing.c")
public final class Lexing {
    private static final long REFILL_BUFF = 0L;
    private static final long LEX_BUFFER = 1L;
    private static final long LEX_BUFFER_LEN = 2L;
    private static final long LEX_ABS_POS = 3L;
    private static final long LEX_START_POS = 4L;
    private static final long LEX_CURR_POS = 5L;
    private static final long LEX_LAST_POS = 6L;
    private static final long LEX_LAST_ACTION = 7L;
    private static final long LEX_EOF_REACHED = 8L;
    private static final long LEX_MEM = 9L;
    private static final long LEX_START_P = 10L;
    private static final long LEX_CURR_P = 11L;
    private static final long LEX_BASE = 0L;
    private static final long LEX_BACKTRK = 1L;
    private static final long LEX_DEFAULT = 2L;
    private static final long LEX_TRANS = 3L;
    private static final long LEX_CHECK = 4L;
    private static final long LEX_BASE_CODE = 5L;
    private static final long LEX_BACKTRK_CODE = 6L;
    private static final long LEX_DEFAULT_CODE = 7L;
    private static final long LEX_TRANS_CODE = 8L;
    private static final long LEX_CHECK_CODE = 9L;
    private static final long LEX_CODE = 10L;
    private static final int NO_CHAR = 256;
    private static final int NO_DEST = 255;
    private static final int NO_SRC = 255;

    private Lexing() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Lexing.lex_tables", "int", "Lexing.lexbuf"}, returnType="int")
    public static Value caml_lex_engine(Value table, Value start, Value buff) throws Fail.Exception {
        int state = start.asCastedInt();
        if (state >= 0) {
            buff.set(6L, buff.get(5L));
            buff.set(4L, buff.get(5L));
            buff.set(7L, Value.MINUS_ONE);
        } else {
            state = -state - 1;
        }
        int base;
        while ((base = Lexing.getShort(table.get(0L), state)) >= 0) {
            int c;
            int backtrk = Lexing.getShort(table.get(1L), state);
            if (backtrk >= 0) {
                buff.set(6L, buff.get(5L));
                buff.set(7L, Value.createLong(backtrk));
            }
            if (buff.get(5L).asLong() >= buff.get(2L).asLong()) {
                if (buff.get(8L) == Value.FALSE) {
                    return Value.createLong(-state - 1);
                }
                c = 256;
            } else {
                int idx = buff.get(5L).asCastedInt();
                c = buff.get(1L).getUnsignedByte(idx);
                buff.set(5L, Value.createLong(idx + 1));
            }
            state = Lexing.getShort(table.get(4L), base + c) == state ? Lexing.getShort(table.get(3L), base + c) : Lexing.getShort(table.get(2L), state);
            if (state < 0) {
                buff.set(5L, buff.get(6L));
                if (buff.get(7L) == Value.MINUS_ONE) {
                    Fail.failWith("lexing: empty token");
                    continue;
                }
                return buff.get(7L);
            }
            if (c != 256) continue;
            buff.set(8L, Value.FALSE);
        }
        return Value.createLong(-base - 1);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Lexing.lex_tables", "int", "Lexing.lexbuf"}, returnType="int")
    public static Value caml_new_lex_engine(Value table, Value start, Value buff) throws Fail.Exception {
        int state = start.asCastedInt();
        if (state >= 0) {
            buff.set(6L, buff.get(5L));
            buff.set(4L, buff.get(5L));
            buff.set(7L, Value.MINUS_ONE);
        } else {
            state = -state - 1;
        }
        while (true) {
            int c;
            int base;
            if ((base = Lexing.getShort(table.get(0L), state)) < 0) {
                int pcOff = Lexing.getShort(table.get(5L), state);
                Lexing.runTag(table.get(10L), pcOff, buff.get(9L));
                return Value.createLong(-base - 1);
            }
            int backtrk = Lexing.getShort(table.get(1L), state);
            if (backtrk >= 0) {
                int pcOff = Lexing.getShort(table.get(6L), state);
                Lexing.runTag(table.get(10L), pcOff, buff.get(9L));
                buff.set(6L, buff.get(5L));
                buff.set(7L, Value.createLong(backtrk));
            }
            if (buff.get(5L).asLong() >= buff.get(2L).asLong()) {
                if (buff.get(8L) == Value.FALSE) {
                    return Value.createLong(-state - 1);
                }
                c = 256;
            } else {
                int idx = buff.get(5L).asCastedInt();
                c = buff.get(1L).getUnsignedByte(idx);
                buff.set(5L, Value.createLong(idx + 1));
            }
            int pstate = state;
            state = Lexing.getShort(table.get(4L), base + c) == state ? Lexing.getShort(table.get(3L), base + c) : Lexing.getShort(table.get(2L), state);
            if (state < 0) {
                buff.set(5L, buff.get(6L));
                if (buff.get(7L).asLong() == -1L) {
                    Fail.failWith("lexing: empty token");
                    continue;
                }
                return buff.get(7L);
            }
            int baseCode = Lexing.getShort(table.get(5L), pstate);
            int pcOff = Lexing.getShort(table.get(9L), baseCode + c) == pstate ? Lexing.getShort(table.get(8L), baseCode + c) : Lexing.getShort(table.get(7L), pstate);
            if (pcOff > 0) {
                Lexing.runMem(table.get(10L), pcOff, buff.get(9L), buff.get(5L));
            }
            if (c != 256) continue;
            buff.set(8L, Value.FALSE);
        }
    }

    static int getShort(Value v, int n) {
        return v.getUnsignedByte(2 * n) + (v.getByte(2 * n + 1) << 8);
    }

    private static void runMem(Value v, int ofs, Value mem, Value currPos) {
        int pc = ofs;
        int dst;
        while ((dst = v.getUnsignedByte(pc++)) != 255) {
            int src;
            if ((src = v.getUnsignedByte(pc++)) == 255) {
                mem.set(dst, currPos);
                continue;
            }
            mem.set(dst, mem.get(src));
        }
        return;
    }

    private static void runTag(Value v, int ofs, Value mem) {
        int pc = ofs;
        int dst;
        while ((dst = v.getUnsignedByte(pc++)) != 255) {
            int src;
            if ((src = v.getUnsignedByte(pc++)) == 255) {
                mem.set(dst, Value.MINUS_ONE);
                continue;
            }
            mem.set(dst, mem.get(src));
        }
        return;
    }
}

