/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.support.scripting;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptContext;
import org.ocamljava.runtime.support.scripting.OCamlBindings;
import org.ocamljava.runtime.util.InputStreamFromReader;
import org.ocamljava.runtime.util.PrintStreamToWriter;
import org.ocamljava.runtime.values.Value;

public final class OCamlContext
implements ScriptContext {
    private static final List<Integer> SCOPES = Collections.unmodifiableList(Arrays.asList(100, 200));
    private static OCamlBindings globalScope = null;
    private OCamlBindings engineScope;
    private PrintStream stdOut;
    private PrintStream stdErr;
    private InputStream stdIn;
    private Writer writer;
    private Writer errorWriter;
    private Reader reader;

    public OCamlContext(PrintStream out, PrintStream err, InputStream in) {
        assert (out != null) : "null out";
        assert (err != null) : "null err";
        assert (in != null) : "null in";
        this.engineScope = new OCamlBindings();
        this.stdOut = out;
        this.stdErr = err;
        this.stdIn = in;
        this.writer = new PrintWriter(out, true);
        this.errorWriter = new PrintWriter(err, true);
        this.reader = new InputStreamReader(in);
    }

    public OCamlContext() {
        this(System.out, System.err, System.in);
    }

    public OCamlContext(OCamlContext that, OCamlBindings b) {
        assert (that != null) : "null that";
        assert (b != null) : "null b";
        this.engineScope = b;
        this.stdOut = that.stdOut;
        this.stdErr = that.stdErr;
        this.stdIn = that.stdIn;
        this.writer = that.writer;
        this.errorWriter = that.errorWriter;
        this.reader = that.reader;
    }

    @Override
    public Object getAttribute(String name) throws IllegalArgumentException, NullPointerException {
        if (name == null) {
            throw new NullPointerException("null name");
        }
        if (this.engineScope.containsKey(name)) {
            return this.engineScope.get(name);
        }
        if (globalScope != null && globalScope.containsKey(name)) {
            return globalScope.get(name);
        }
        return null;
    }

    @Override
    public Object getAttribute(String name, int scope) throws IllegalArgumentException, NullPointerException {
        if (name == null) {
            throw new NullPointerException("null name");
        }
        switch (scope) {
            case 100: {
                return this.engineScope.get(name);
            }
            case 200: {
                if (globalScope != null) {
                    return globalScope.get(name);
                }
                return null;
            }
        }
        throw new IllegalArgumentException("invalid scope");
    }

    @Override
    public int getAttributesScope(String name) throws NullPointerException {
        if (name == null) {
            throw new NullPointerException("null name");
        }
        if (this.engineScope.containsKey(name)) {
            return 100;
        }
        if (globalScope != null && globalScope.containsKey(name)) {
            return 200;
        }
        return -1;
    }

    Map<String, Value> getBindings() {
        HashMap<String, Value> res = new HashMap<String, Value>();
        if (globalScope != null) {
            for (String key : globalScope.keySet()) {
                res.put(key, globalScope.getValue(key));
            }
        }
        for (String key : this.engineScope.keySet()) {
            res.put(key, this.engineScope.getValue(key));
        }
        return res;
    }

    @Override
    public Bindings getBindings(int scope) throws IllegalArgumentException {
        switch (scope) {
            case 100: {
                return this.engineScope;
            }
            case 200: {
                return globalScope;
            }
        }
        throw new IllegalArgumentException("invalid scope");
    }

    InputStream getStdIn() {
        return this.stdIn;
    }

    PrintStream getStdOut() {
        return this.stdOut;
    }

    PrintStream getStdErr() {
        return this.stdErr;
    }

    @Override
    public Writer getErrorWriter() {
        return this.errorWriter;
    }

    @Override
    public Reader getReader() {
        return this.reader;
    }

    @Override
    public List<Integer> getScopes() {
        return SCOPES;
    }

    @Override
    public Writer getWriter() {
        return this.writer;
    }

    @Override
    public Object removeAttribute(String name, int scope) throws IllegalArgumentException, NullPointerException {
        if (name == null) {
            throw new NullPointerException("null name");
        }
        switch (scope) {
            case 100: {
                return this.engineScope.remove(name);
            }
            case 200: {
                if (globalScope != null) {
                    return globalScope.remove(name);
                }
                return null;
            }
        }
        throw new IllegalArgumentException("invalid scope");
    }

    @Override
    public void setAttribute(String name, Object value, int scope) throws IllegalArgumentException, NullPointerException {
        if (name == null) {
            throw new NullPointerException("null name");
        }
        switch (scope) {
            case 100: {
                this.engineScope.put(name, value);
                break;
            }
            case 200: {
                if (globalScope == null) break;
                globalScope.put(name, value);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid scope");
            }
        }
    }

    @Override
    public void setBindings(Bindings bindings, int scope) throws IllegalArgumentException, NullPointerException {
        switch (scope) {
            case 100: {
                if (bindings == null) {
                    throw new NullPointerException("null bindings for engine scope");
                }
                this.engineScope = OCamlBindings.instance(bindings);
                break;
            }
            case 200: {
                globalScope = OCamlBindings.instance(bindings);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid scope");
            }
        }
    }

    @Override
    public void setErrorWriter(Writer writer) {
        if (writer != null) {
            this.errorWriter = writer;
            this.stdErr = new PrintStreamToWriter(writer);
        }
    }

    @Override
    public void setReader(Reader reader) {
        if (reader != null) {
            this.reader = reader;
            this.stdIn = new InputStreamFromReader(reader);
        }
    }

    @Override
    public void setWriter(Writer writer) {
        if (writer != null) {
            this.writer = writer;
            this.stdOut = new PrintStreamToWriter(writer);
        }
    }

    static OCamlContext instance(ScriptContext sc) {
        assert (sc != null) : "null sc";
        if (sc instanceof OCamlContext) {
            return (OCamlContext)sc;
        }
        OCamlContext res = new OCamlContext();
        res.setErrorWriter(sc.getErrorWriter());
        res.setReader(sc.getReader());
        res.setWriter(sc.getWriter());
        res.setBindings(sc.getBindings(100), 100);
        res.setBindings(sc.getBindings(200), 200);
        return res;
    }
}

