/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.unix;

import java.io.IOException;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.kernel.Channel;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.primitives.otherlibs.unix.Unix;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="unix", module="Unix", source="otherlibs/unix/fcntl.c")
public final class Fcntl {
    private Fcntl() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Unix.file_descr"}, returnType="unit")
    public static Value unix_set_nonblock(Value fd) throws Fail.Exception {
        Context ctxt = OCamlJavaThread.getCodeRunner().getContext();
        Channel ch = ctxt.getFilesState().getChannel(fd.asCastedInt());
        if (ch == null) {
            Unix.fail("read", "invalid descriptor");
        }
        try {
            ch.configureBlocking(false);
        }
        catch (IOException ioe) {
            Unix.fail("set_nonblock", ioe);
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Unix.file_descr"}, returnType="unit")
    public static Value unix_clear_nonblock(Value fd) throws Fail.Exception {
        Context ctxt = OCamlJavaThread.getCodeRunner().getContext();
        Channel ch = ctxt.getFilesState().getChannel(fd.asCastedInt());
        if (ch == null) {
            Unix.fail("read", "invalid descriptor");
        }
        try {
            ch.configureBlocking(true);
        }
        catch (IOException ioe) {
            Unix.fail("clear_nonblock", ioe);
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.NOT_IMPLEMENTED, parameterTypes={"Unix.file_descr"}, returnType="unit")
    public static Value unix_set_close_on_exec(Value fd) throws Fail.Exception {
        Fail.invalidArgument("Unix.set_close_on_exec not implemented");
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.NOT_IMPLEMENTED, parameterTypes={"Unix.file_descr"}, returnType="unit")
    public static Value unix_clear_close_on_exec(Value fd) throws Fail.Exception {
        Fail.invalidArgument("Unix.clear_close_on_exec not implemented");
        return Value.UNIT;
    }
}

