/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.support.wrappers;

import org.ocamljava.runtime.support.wrappers.ToValue;
import org.ocamljava.runtime.values.Value;

public final class Float
implements ToValue {
    public static final Float ZERO = new Float(0.0);
    public static final Float ONE = new Float(1.0);
    public static final Float MINUS_ONE = new Float(-1.0);
    private final double value;

    public Float(double v) {
        this.value = v;
    }

    public double get() {
        return this.value;
    }

    @Override
    public Value toValue() {
        return Value.createDouble(this.value);
    }

    public int hashCode() {
        return new Double(this.value).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Float) {
            Float that = (Float)obj;
            return Double.doubleToRawLongBits(this.value) == Double.doubleToRawLongBits(that.value);
        }
        return false;
    }

    public String toString() {
        return Double.toString(this.value);
    }
}

