/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.util;

import org.ocamljava.runtime.kernel.Fatal;

public final class IntegerUtils {
    private static final int BYTE_CARDINAL = 256;
    private static final int SHORT_CARDINAL = 65536;
    private static final long INTEGER_CARDINAL = 0x100000000L;

    private IntegerUtils() {
    }

    public static long signedToUnsigned(int x) {
        return (long)x & 0xFFFFFFFFL;
    }

    public static int unsignedToSigned(long x) {
        assert (x >= 0L && x < 0x100000000L) : "x should be in 0..INTEGER_CARDINAL-1";
        return (int)x;
    }

    public static int signedToUnsignedByte(int x) {
        assert (x >= -128 && x <= 127) : "x should be in Byte.MIN_VALUE..Byte.MAX_VALUE";
        return x & 0xFF;
    }

    public static int unsignedToSignedByte(int x) {
        assert (x >= 0 && x < 256) : "x should be in 0..BYTE_CARDINAL-1";
        return (byte)x;
    }

    public static int signedToUnsignedShort(int x) {
        assert (x >= Short.MIN_VALUE && x <= Short.MAX_VALUE) : "x should be in Short.MIN_VALUE..Short.MAX_VALUE";
        return x & 0xFFFF;
    }

    public static int unsignedToSignedShort(int x) {
        assert (x >= 0 && x < 65536) : "x should be in 0..SHORT_CARDINAL-1";
        return (short)x;
    }

    public static int ensure32s(long v) throws Fatal.Exception {
        if (v >= Integer.MIN_VALUE && v <= Integer.MAX_VALUE) {
            return (int)v;
        }
        Fatal.raise64bitElement();
        return 0;
    }
}

