/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.stdlib;

import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="stdlib", module="Array", source="byterun/array.c")
public final class Array {
    private Array() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a array", "int"}, returnType="'a")
    public static Value caml_array_get_addr(Value array, Value index) throws Fail.Exception {
        long idx = index.asLong();
        if (idx < 0L || idx >= array.sizeValues()) {
            Fail.arrayBoundError();
        }
        return array.get(idx);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float array", "int"}, returnType="float")
    public static Value caml_array_get_float(Value array, Value index) throws Fail.Exception {
        long idx = index.asLong();
        if (idx < 0L || idx >= array.sizeDoubles()) {
            Fail.arrayBoundError();
        }
        return Value.createDouble(array.getDouble(idx));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a array", "int"}, returnType="'a")
    public static Value caml_array_get(Value array, Value index) throws Fail.Exception {
        if (array.isDoubleArray()) {
            return Array.caml_array_get_float(array, index);
        }
        return Array.caml_array_get_addr(array, index);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a array", "int", "'a"}, returnType="unit")
    public static Value caml_array_set_addr(Value array, Value index, Value val) throws Fail.Exception {
        long idx = index.asLong();
        if (idx < 0L || idx >= array.sizeValues()) {
            Fail.arrayBoundError();
        }
        array.set(idx, val);
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float array", "int", "float"}, returnType="unit")
    public static Value caml_array_set_float(Value array, Value index, Value val) throws Fail.Exception {
        long idx = index.asLong();
        if (idx < 0L || idx >= array.sizeDoubles()) {
            Fail.arrayBoundError();
        }
        array.setDouble(idx, val.asDouble());
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a array", "int", "'a"}, returnType="unit")
    public static Value caml_array_set(Value array, Value index, Value val) throws Fail.Exception {
        if (array.isDoubleArray()) {
            return Array.caml_array_set_float(array, index, val);
        }
        return Array.caml_array_set_addr(array, index, val);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float array", "int"}, returnType="float")
    public static Value caml_array_unsafe_get_float(Value array, Value index) {
        return Value.createDouble(array.getDouble(index.asLong()));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a array", "int"}, returnType="'a")
    public static Value caml_array_unsafe_get(Value array, Value index) {
        if (array.isDoubleArray()) {
            return Array.caml_array_unsafe_get_float(array, index);
        }
        return array.get(index.asLong());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a array", "int", "'a"}, returnType="unit")
    public static Value caml_array_unsafe_set_addr(Value array, Value index, Value val) {
        array.set(index.asLong(), val);
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a array", "int", "'a"}, returnType="unit")
    public static Value caml_array_unsafe_set_float(Value array, Value index, Value val) {
        array.setDouble(index.asLong(), val.asDouble());
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a array", "int", "'a"}, returnType="unit")
    public static Value caml_array_unsafe_set(Value array, Value index, Value val) {
        if (array.isDoubleArray()) {
            return Array.caml_array_unsafe_set_float(array, index, val);
        }
        return Array.caml_array_unsafe_set_addr(array, index, val);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"int", "'a"}, returnType="'a array")
    public static Value caml_make_vect(Value len, Value init) throws Fail.Exception {
        long size = len.asLong();
        if (size == 0L) {
            return CurrentContext.getCodeState().getAtom(0);
        }
        if (init.isDouble()) {
            double d = init.asDouble();
            if (size * 1L > 0x3FFFFFFFFFFFFFL) {
                Fail.invalidArgument("Array.make");
            }
            Value res = Value.createDoubleArray(size);
            int i = 0;
            while ((long)i < size) {
                res.setDouble(i, d);
                ++i;
            }
            return res;
        }
        if (size > 0x3FFFFFFFFFFFFFL) {
            Fail.invalidArgument("Array.make");
        }
        Value res = Value.createBlock(0, size);
        int i = 0;
        while ((long)i < size) {
            res.set(i, init);
            ++i;
        }
        return res;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a array"}, returnType="'a array")
    public static Value caml_make_array(Value init) {
        long size = init.getWoSize();
        if (size == 0L) {
            return init;
        }
        Value v = init.get0();
        if (v.isLong() || !v.isDouble()) {
            return init;
        }
        Value res = Value.createDoubleArray(size);
        for (long i = 0L; i < size; ++i) {
            res.setDouble(i, init.get(i).asDouble());
        }
        return res;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a array", "int", "'a array", "int", "int"}, returnType="unit")
    public static Value caml_array_blit(Value a1, Value ofs1, Value a2, Value ofs2, Value n) {
        a1.blitArray(ofs1.asLong(), a2, ofs2.asLong(), n.asLong());
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a array", "int", "int"}, returnType="'a array")
    public static Value caml_array_sub(Value a, Value ofs, Value len) {
        return a.subArray(ofs.asLong(), len.asLong());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a array", "'a array"}, returnType="'a array")
    public static Value caml_array_append(Value a1, Value a2) {
        return Array.concat(new Value[]{a1, a2});
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a array list"}, returnType="'a array")
    public static Value caml_array_concat(Value al) {
        int len = 0;
        Value l = al;
        while (l.isBlock()) {
            ++len;
            l = l.get1();
        }
        Value[] arrays = new Value[len];
        int i = 0;
        l = al;
        while (l.isBlock()) {
            arrays[i++] = l.get0();
            l = l.get1();
        }
        return Array.concat(arrays);
    }

    private static Value concat(Value[] arrays) {
        boolean isDoubleArray = false;
        boolean isLongBlock = true;
        long totalLen = 0L;
        int len = arrays.length;
        for (int i = 0; i < len; ++i) {
            Value a = arrays[i];
            if (a.isDoubleArray()) {
                isDoubleArray = true;
                isLongBlock = false;
                totalLen += a.sizeDoubles();
                continue;
            }
            if (a.isLongBlock()) {
                totalLen += a.sizeLongs();
                continue;
            }
            isLongBlock = false;
            totalLen += a.sizeValues();
        }
        if (isDoubleArray) {
            if (totalLen < Value.MAX_INTEGER) {
                double[] values = new double[(int)totalLen];
                int ofs = 0;
                for (int i = 0; i < len; ++i) {
                    Value a = arrays[i];
                    a.copyDoublesIntoArray(values, ofs);
                    ofs = (int)((long)ofs + (a.isDoubleArray() ? a.sizeDoubles() : a.sizeValues()));
                }
                return Value.createDoubleArray(values);
            }
            Value res = Value.createDoubleArray(totalLen);
            long ofs = 0L;
            for (int i = 0; i < len; ++i) {
                Value a = arrays[i];
                long l = a.isDoubleArray() ? a.sizeDoubles() : a.sizeValues();
                for (long j = 0L; j < l; ++j) {
                    res.setDouble(ofs + j, a.getDouble(j));
                }
                ofs += l;
            }
            return res;
        }
        if (isLongBlock) {
            if (totalLen < Value.MAX_INTEGER) {
                long[] values = new long[(int)totalLen];
                int ofs = 0;
                for (int i = 0; i < len; ++i) {
                    Value a = arrays[i];
                    a.copyRawLongsIntoArray(values, ofs);
                    ofs = (int)((long)ofs + (a.isLongBlock() ? a.sizeLongs() : a.sizeValues()));
                }
                return Value.createLongBlock(0, values);
            }
            Value res = Value.createLongBlock(0, totalLen);
            long ofs = 0L;
            for (int i = 0; i < len; ++i) {
                Value a = arrays[i];
                long l = a.isLongBlock() ? a.sizeLongs() : a.sizeValues();
                for (long j = 0L; j < l; ++j) {
                    res.setRawLong(ofs + j, a.getRawLong(j));
                }
                ofs += l;
            }
            return res;
        }
        if (totalLen < Value.MAX_INTEGER) {
            Value[] values = new Value[(int)totalLen];
            int ofs = 0;
            for (int i = 0; i < len; ++i) {
                Value a = arrays[i];
                a.copyValuesIntoArray(values, ofs);
                ofs = (int)((long)ofs + (a.isDoubleArray() ? a.sizeDoubles() : a.sizeValues()));
            }
            return Value.createBlock(0, values);
        }
        Value res = Value.createBlock(0, totalLen);
        long ofs = 0L;
        for (int i = 0; i < len; ++i) {
            Value a = arrays[i];
            long l = a.isDoubleArray() ? a.sizeDoubles() : a.sizeValues();
            for (long j = 0L; j < l; ++j) {
                res.set(ofs + j, a.get(j));
            }
            ofs += l;
        }
        return res;
    }
}

