/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.javalibs.concurrent;

import java.util.concurrent.atomic.AtomicLongArray;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="concurrent", module="AtomicInt64Array", source="")
public final class AtomicInt64Array {
    private AtomicInt64Array() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"int32"}, returnType="AtomicInt64Array.t")
    public static Value ocamljava_atomicint64array_make(Value length) throws Fail.Exception {
        try {
            return Value.createInstance(new AtomicLongArray(length.asInt32()));
        }
        catch (Throwable t) {
            Fail.failWith("AtomicInt64Array.make");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt64Array.t", "int32", "int64"}, returnType="int64")
    public static Value ocamljava_atomicint64array_add_and_get(Value obj, Value i, Value delta) throws Fail.Exception {
        try {
            AtomicLongArray inst = (AtomicLongArray)obj.asCustom();
            long res = inst.addAndGet(i.asInt32(), delta.asInt64());
            return Value.createInt64(res);
        }
        catch (Throwable t) {
            Fail.arrayBoundError();
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt64Array.t", "int32", "int64", "int64"}, returnType="bool")
    public static Value ocamljava_atomicint64array_compare_and_set(Value obj, Value i, Value expect, Value update) throws Fail.Exception {
        try {
            AtomicLongArray inst = (AtomicLongArray)obj.asCustom();
            boolean res = inst.compareAndSet(i.asInt32(), expect.asInt64(), update.asInt64());
            return res ? Value.TRUE : Value.FALSE;
        }
        catch (Throwable t) {
            Fail.arrayBoundError();
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt64Array.t", "int32"}, returnType="int64")
    public static Value ocamljava_atomicint64array_decrement_and_get(Value obj, Value i) throws Fail.Exception {
        try {
            AtomicLongArray inst = (AtomicLongArray)obj.asCustom();
            long res = inst.decrementAndGet(i.asInt32());
            return Value.createInt64(res);
        }
        catch (Throwable t) {
            Fail.arrayBoundError();
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt64Array.t", "int32"}, returnType="int64")
    public static Value ocamljava_atomicint64array_get(Value obj, Value i) throws Fail.Exception {
        try {
            AtomicLongArray inst = (AtomicLongArray)obj.asCustom();
            long res = inst.get(i.asInt32());
            return Value.createInt64(res);
        }
        catch (Throwable t) {
            Fail.arrayBoundError();
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt64Array.t", "int32", "int64"}, returnType="int64")
    public static Value ocamljava_atomicint64array_get_and_add(Value obj, Value i, Value delta) throws Fail.Exception {
        try {
            AtomicLongArray inst = (AtomicLongArray)obj.asCustom();
            long res = inst.getAndAdd(i.asInt32(), delta.asInt64());
            return Value.createInt64(res);
        }
        catch (Throwable t) {
            Fail.arrayBoundError();
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt64Array.t", "int32"}, returnType="int64")
    public static Value ocamljava_atomicint64array_get_and_decrement(Value obj, Value i) throws Fail.Exception {
        try {
            AtomicLongArray inst = (AtomicLongArray)obj.asCustom();
            long res = inst.getAndDecrement(i.asInt32());
            return Value.createInt64(res);
        }
        catch (Throwable t) {
            Fail.arrayBoundError();
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt64Array.t", "int32"}, returnType="int64")
    public static Value ocamljava_atomicint64array_get_and_increment(Value obj, Value i) throws Fail.Exception {
        try {
            AtomicLongArray inst = (AtomicLongArray)obj.asCustom();
            long res = inst.getAndIncrement(i.asInt32());
            return Value.createInt64(res);
        }
        catch (Throwable t) {
            Fail.arrayBoundError();
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt64Array.t", "int32", "int64"}, returnType="int64")
    public static Value ocamljava_atomicint64array_get_and_set(Value obj, Value i, Value newValue) throws Fail.Exception {
        try {
            AtomicLongArray inst = (AtomicLongArray)obj.asCustom();
            long res = inst.getAndSet(i.asInt32(), newValue.asInt64());
            return Value.createInt64(res);
        }
        catch (Throwable t) {
            Fail.arrayBoundError();
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt64Array.t", "int32"}, returnType="int64")
    public static Value ocamljava_atomicint64array_increment_and_get(Value obj, Value i) throws Fail.Exception {
        try {
            AtomicLongArray inst = (AtomicLongArray)obj.asCustom();
            long res = inst.incrementAndGet(i.asInt32());
            return Value.createInt64(res);
        }
        catch (Throwable t) {
            Fail.arrayBoundError();
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt64Array.t", "int32", "int64"}, returnType="unit")
    public static Value ocamljava_atomicint64array_lazy_set(Value obj, Value i, Value newValue) throws Fail.Exception {
        try {
            AtomicLongArray inst = (AtomicLongArray)obj.asCustom();
            inst.lazySet(i.asInt32(), newValue.asInt64());
            return Value.UNIT;
        }
        catch (Throwable t) {
            Fail.arrayBoundError();
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt64Array.t"}, returnType="int32")
    public static Value ocamljava_atomicint64array_length(Value obj) {
        AtomicLongArray inst = (AtomicLongArray)obj.asCustom();
        int res = inst.length();
        return Value.createInt32(res);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt64Array.t", "int32", "int64"}, returnType="unit")
    public static Value ocamljava_atomicint64array_set(Value obj, Value i, Value newValue) throws Fail.Exception {
        try {
            AtomicLongArray inst = (AtomicLongArray)obj.asCustom();
            inst.set(i.asInt32(), newValue.asInt64());
            return Value.UNIT;
        }
        catch (Throwable t) {
            Fail.arrayBoundError();
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt64Array.t", "int32", "int64", "int64"}, returnType="bool")
    public static Value ocamljava_atomicint64array_weak_compare_and_set(Value obj, Value i, Value expect, Value update) throws Fail.Exception {
        try {
            AtomicLongArray inst = (AtomicLongArray)obj.asCustom();
            boolean res = inst.weakCompareAndSet(i.asInt32(), expect.asInt64(), update.asInt64());
            return res ? Value.TRUE : Value.FALSE;
        }
        catch (Throwable t) {
            Fail.arrayBoundError();
            return Value.UNIT;
        }
    }
}

