/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.values;

import org.ocamljava.runtime.values.AbstractCustomValue;
import org.ocamljava.runtime.values.BlockValue;
import org.ocamljava.runtime.values.PredefinedCustomOperations;
import org.ocamljava.runtime.values.Value;

public final class NativeIntValue
extends AbstractCustomValue {
    private static final long SIZE = Value.wosize(8L);
    private long nativeint;

    NativeIntValue(long v) {
        super(PredefinedCustomOperations.INT_NAT_OPS, SIZE);
        this.nativeint = v;
    }

    @Override
    public long asNativeInt() {
        return this.nativeint;
    }

    @Override
    public void setNativeInt(long v) {
        this.nativeint = v;
    }

    @Override
    public void copy(BlockValue src) {
        this.nativeint = src.asNativeInt();
    }

    @Override
    public NativeIntValue duplicate() {
        return new NativeIntValue(this.nativeint);
    }

    @Override
    public void copyValuesIntoArray(Value[] dest) {
    }

    @Override
    public void copyValuesIntoArray(Value[] dest, int destOfs) {
    }

    @Override
    public void copyDoublesIntoArray(double[] dest, int destOfs) {
    }

    @Override
    public void copyRawLongsIntoArray(long[] dest, int destOfs) {
    }

    @Override
    public Value subArray(long ofs, long len) {
        assert (false) : "subArray called on a non-array value";
        return Value.createBlock(0, 0L);
    }

    @Override
    public void blitArray(long srcOfs, Value dest, long destOfs, long len) {
    }

    public int hashCode() {
        return (int)this.nativeint;
    }

    public boolean equals(Object obj) {
        if (obj instanceof NativeIntValue) {
            NativeIntValue that = (NativeIntValue)obj;
            return this.nativeint == that.nativeint;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("NativeIntValue(");
        sb.append(this.nativeint);
        sb.append(")");
        return sb.toString();
    }
}

