/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.unix;

import java.io.IOException;
import java.io.InterruptedIOException;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.context.FilesState;
import org.ocamljava.runtime.kernel.Channel;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.primitives.otherlibs.unix.Unix;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="unix", module="Unix", source="otherlibs/unix/dup2.c")
public final class Dup2 {
    private Dup2() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Unix.file_descr", "Unix.file_descr"}, returnType="unit")
    public static Value unix_dup2(Value fd1, Value fd2) throws Fail.Exception, FalseExit {
        Channel ch;
        FilesState fs = CurrentContext.getFilesState();
        Channel old = fs.removeChannel(fd2.asCastedInt());
        if (old != null) {
            try {
                old.setFD(-1);
                old.close();
            }
            catch (InterruptedIOException iioe) {
                FalseExit fe = FalseExit.createFromContext(CurrentContext.get());
                fe.fillInStackTrace();
                throw fe;
            }
            catch (IOException ioe) {
                Unix.fail("dup2", ioe);
            }
        }
        if ((ch = fs.getChannel(fd1.asCastedInt())) == null) {
            Unix.fail("dup2", "invalid descriptor");
            return Value.UNIT;
        }
        fs.setChannel(fd2.asCastedInt(), ch);
        return Value.UNIT;
    }
}

