/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.bigarray;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.primitives.otherlibs.bigarray.MemArray;
import org.ocamljava.runtime.primitives.stdlib.Hash;
import org.ocamljava.runtime.util.IO;
import org.ocamljava.runtime.util.IntegerUtils;
import org.ocamljava.runtime.values.AbstractCustomOperations;
import org.ocamljava.runtime.values.CustomOperations;
import org.ocamljava.runtime.values.Value;

final class CustomBigArray
extends AbstractCustomOperations {
    static final CustomOperations OPS = new CustomBigArray();
    private static final long FLAG_MASK = 511L;

    private CustomBigArray() {
        super("_bigarray", true, true, false, true, true);
    }

    @Override
    public void finalize(Value v) {
        MemArray b = (MemArray)v.asCustom();
        switch ((int)(b.getFlags() & 0x600L)) {
            case 0: {
                break;
            }
            case 512: {
                assert (false) : "unsupported";
                break;
            }
            case 1024: {
                b.unMap();
                break;
            }
            default: {
                assert (false) : "invalid bigarray kind";
                break;
            }
        }
    }

    @Override
    public int compare(Value v1, Value v2, AtomicBoolean unordered) {
        MemArray b1 = (MemArray)v1.asCustom();
        MemArray b2 = (MemArray)v2.asCustom();
        long flags1 = b1.getFlags() & 0x1FFL;
        long flags2 = b2.getFlags() & 0x1FFL;
        int[] dim1 = b1.getDims();
        int[] dim2 = b2.getDims();
        if (flags1 != flags2) {
            return (int)(flags2 - flags1);
        }
        if (dim1.length != dim2.length) {
            return dim2.length - dim1.length;
        }
        for (int i = 0; i < dim1.length; ++i) {
            int d1 = dim1[i];
            int d2 = dim2[i];
            if (d1 == d2) continue;
            return d1 < d2 ? -1 : 1;
        }
        int numElems = (int)b1.getNumElems();
        ByteBuffer d1 = b1.getData();
        ByteBuffer d2 = b2.getData();
        switch ((int)(flags1 & 0xFFL)) {
            case 0: 
            case 10: {
                int mult32 = (flags1 & 0xFFL) == 10L ? 2 : 1;
                for (int i = 0; i < numElems * mult32; ++i) {
                    float e2;
                    float e1 = d1.getFloat(i * 4);
                    if (e1 < (e2 = d2.getFloat(i * 4))) {
                        return -1;
                    }
                    if (e1 > e2) {
                        return 1;
                    }
                    if (e1 == e2) continue;
                    unordered.set(true);
                    if (e1 == e1) {
                        return 1;
                    }
                    if (e2 != e2) continue;
                    return -1;
                }
                return 0;
            }
            case 1: 
            case 11: {
                int mult64 = (flags1 & 0xFFL) == 11L ? 2 : 1;
                for (int i = 0; i < numElems * mult64; ++i) {
                    double e2;
                    double e1 = d1.getDouble(i * 8);
                    if (e1 < (e2 = d2.getDouble(i * 8))) {
                        return -1;
                    }
                    if (e1 > e2) {
                        return 1;
                    }
                    if (e1 == e2) continue;
                    unordered.set(true);
                    if (e1 == e1) {
                        return 1;
                    }
                    if (e2 != e2) continue;
                    return -1;
                }
                return 0;
            }
            case 2: {
                for (int i = 0; i < numElems; ++i) {
                    byte e2;
                    byte e1 = d1.get(i * 1);
                    if (e1 < (e2 = d2.get(i * 1))) {
                        return -1;
                    }
                    if (e1 <= e2) continue;
                    return 1;
                }
                return 0;
            }
            case 3: {
                for (int i = 0; i < numElems; ++i) {
                    int e2;
                    int e1 = IntegerUtils.signedToUnsignedByte(d1.get(i * 1));
                    if (e1 < (e2 = IntegerUtils.signedToUnsignedByte(d2.get(i * 1)))) {
                        return -1;
                    }
                    if (e1 <= e2) continue;
                    return 1;
                }
                return 0;
            }
            case 4: {
                for (int i = 0; i < numElems; ++i) {
                    short e2;
                    short e1 = d1.getShort(i * 2);
                    if (e1 < (e2 = d2.getShort(i * 2))) {
                        return -1;
                    }
                    if (e1 <= e2) continue;
                    return 1;
                }
                return 0;
            }
            case 5: {
                for (int i = 0; i < numElems; ++i) {
                    int e2;
                    int e1 = IntegerUtils.signedToUnsignedShort(d1.getShort(i * 2));
                    if (e1 < (e2 = IntegerUtils.signedToUnsignedShort(d2.getShort(i * 2)))) {
                        return -1;
                    }
                    if (e1 <= e2) continue;
                    return 1;
                }
                return 0;
            }
            case 7: 
            case 9: {
                for (int i = 0; i < numElems; ++i) {
                    long e2;
                    long e1 = d1.getLong(i * 8);
                    if (e1 < (e2 = d2.getLong(i * 8))) {
                        return -1;
                    }
                    if (e1 <= e2) continue;
                    return 1;
                }
                return 0;
            }
            case 6: 
            case 8: {
                for (int i = 0; i < numElems; ++i) {
                    int e2;
                    int e1 = d1.getInt(i * 4);
                    if (e1 < (e2 = d2.getInt(i * 4))) {
                        return -1;
                    }
                    if (e1 <= e2) continue;
                    return 1;
                }
                return 0;
            }
        }
        assert (false) : "invalid elements kind";
        return 0;
    }

    @Override
    public long hash(Value v) {
        MemArray b = (MemArray)v.asCustom();
        ByteBuffer data = b.getData();
        int numElems = (int)b.getNumElems();
        int h = 0;
        int baKind = (int)(b.getFlags() & 0xFFL);
        block0 : switch (baKind) {
            case 2: 
            case 3: {
                int w;
                if (numElems > 256) {
                    numElems = 256;
                }
                int i = 0;
                while (i + 4 <= numElems) {
                    w = IntegerUtils.signedToUnsignedByte(data.get((i + 0) * 1)) | IntegerUtils.signedToUnsignedByte(data.get((i + 1) * 1)) << 8 | IntegerUtils.signedToUnsignedByte(data.get((i + 2) * 1)) << 16 | IntegerUtils.signedToUnsignedByte(data.get((i + 3) * 1)) << 24;
                    h = Hash.caml_hash_mix_uint32(h, w);
                    i += 4;
                }
                switch (numElems & 3) {
                    case 0: {
                        w = 0;
                        break block0;
                    }
                    case 1: {
                        w = IntegerUtils.signedToUnsignedByte(data.get((i + 0) * 1));
                        break block0;
                    }
                    case 2: {
                        w = IntegerUtils.signedToUnsignedByte(data.get((i + 0) * 1)) | IntegerUtils.signedToUnsignedByte(data.get((i + 1) * 1)) << 8;
                        break block0;
                    }
                    case 3: {
                        w = IntegerUtils.signedToUnsignedByte(data.get((i + 0) * 1)) | IntegerUtils.signedToUnsignedByte(data.get((i + 1) * 1)) << 8 | IntegerUtils.signedToUnsignedByte(data.get((i + 2) * 1)) << 16;
                        break block0;
                    }
                }
                assert (false) : "should not happen";
                break;
            }
            case 4: 
            case 5: {
                if (numElems > 128) {
                    numElems = 128;
                }
                int i = 0;
                while (i + 2 <= numElems) {
                    int w = IntegerUtils.signedToUnsignedShort(data.getShort(i * 2)) | IntegerUtils.signedToUnsignedShort(data.getShort((i + 1) * 2)) << 16;
                    h = Hash.caml_hash_mix_uint32(h, w);
                    i += 2;
                }
                if ((numElems & 1) == 0) break;
                h = Hash.caml_hash_mix_uint32(h, IntegerUtils.signedToUnsignedShort(data.getShort(i * 2)));
                break;
            }
            case 6: {
                if (numElems > 64) {
                    numElems = 64;
                }
                for (int i = 0; i < numElems; ++i) {
                    h = Hash.caml_hash_mix_uint32(h, data.getInt(i * 4));
                }
                break;
            }
            case 8: 
            case 9: {
                if (numElems > 64) {
                    numElems = 64;
                }
                for (int i = 0; i < numElems; ++i) {
                    h = Hash.caml_hash_mix_intnat(h, data.getLong(i * 8));
                }
                break;
            }
            case 7: {
                if (numElems > 32) {
                    numElems = 32;
                }
                for (int i = 0; i < numElems; ++i) {
                    h = Hash.caml_hash_mix_int64(h, data.getLong(i * 8));
                }
                break;
            }
            case 0: 
            case 10: {
                if (baKind == 10) {
                    numElems *= 2;
                }
                if (numElems > 64) {
                    numElems = 64;
                }
                for (int i = 0; i < numElems; ++i) {
                    h = Hash.caml_hash_mix_float(h, data.getFloat(i * 4));
                }
                break;
            }
            case 1: 
            case 11: {
                if (baKind == 11) {
                    numElems *= 2;
                }
                if (numElems > 32) {
                    numElems = 32;
                }
                for (int i = 0; i < numElems; ++i) {
                    h = Hash.caml_hash_mix_double(h, data.getDouble(i * 8));
                }
                break;
            }
            default: {
                assert (false) : "invalid bigarray kind";
                break;
            }
        }
        return h;
    }

    @Override
    public CustomOperations.SerializationSizes serialize(DataOutput out, Value v) throws IOException {
        int i;
        MemArray b = (MemArray)v.asCustom();
        ByteBuffer data = b.getData();
        int[] dims = b.getDims();
        IO.write32s(out, dims.length);
        IO.write32s(out, (int)(b.getFlags() & 0x1FFL));
        int numElems = 1;
        for (i = 0; i < dims.length; ++i) {
            int d = dims[i];
            IO.write32s(out, d);
            numElems *= d;
        }
        switch ((int)(b.getFlags() & 0xFFL)) {
            case 2: 
            case 3: {
                for (i = 0; i < numElems; ++i) {
                    IO.write8s(out, data.get(i * 1));
                }
                break;
            }
            case 4: 
            case 5: {
                for (i = 0; i < numElems; ++i) {
                    IO.write16s(out, data.getShort(i * 2));
                }
                break;
            }
            case 0: 
            case 6: {
                for (i = 0; i < numElems; ++i) {
                    IO.write32s(out, data.getInt(i * 4));
                }
                break;
            }
            case 10: {
                for (i = 0; i < numElems * 2; ++i) {
                    IO.write32s(out, data.getInt(i * 4));
                }
                break;
            }
            case 1: 
            case 7: {
                for (i = 0; i < numElems; ++i) {
                    IO.write64s(out, data.getLong(i * 8));
                }
                break;
            }
            case 11: {
                for (i = 0; i < numElems * 2; ++i) {
                    IO.write64s(out, data.getLong(i * 8));
                }
                break;
            }
            case 8: {
                int j;
                for (i = 0; i < numElems && data.getLong(i * 8) >= -4611686018427387904L && data.getLong(i * 8) <= 0x3FFFFFFFFFFFFFFFL; ++i) {
                }
                if (i == numElems) {
                    IO.write8u(out, 0);
                    for (j = 0; j < numElems; ++j) {
                        IO.write32s(out, (int)data.getLong(i * 8));
                    }
                } else {
                    IO.write8u(out, 1);
                    for (j = 0; j < numElems; ++j) {
                        IO.write64s(out, data.getLong(i * 8));
                    }
                }
                break;
            }
            case 9: {
                int j;
                for (i = 0; i < numElems && data.getLong(i * 8) >= Integer.MIN_VALUE && data.getLong(i * 8) <= Integer.MAX_VALUE; ++i) {
                }
                if (i == numElems) {
                    IO.write8u(out, 0);
                    for (j = 0; j < numElems; ++j) {
                        IO.write32s(out, (int)data.getLong(i * 8));
                    }
                } else {
                    IO.write8u(out, 1);
                    for (j = 0; j < numElems; ++j) {
                        IO.write64s(out, data.getLong(i * 8));
                    }
                }
                break;
            }
            default: {
                assert (false) : "invalid bigarray kind";
                break;
            }
        }
        return new CustomOperations.SerializationSizes(4 + dims.length * 4, 4 + dims.length * 8);
    }

    @Override
    public CustomOperations.DeserializedValue deserialize(DataInput in) throws Fail.Exception, Fatal.Exception, IOException {
        int numDims = IntegerUtils.ensure32s(IO.read32u(in));
        int flags = IO.read32s(in);
        int[] dim = new int[numDims];
        long numElems = 1L;
        for (int i = 0; i < numDims; ++i) {
            int d;
            dim[i] = d = IntegerUtils.ensure32s(IO.read32u(in));
            numElems *= (long)d;
        }
        if ((flags & 0xFF) > 11) {
            Fail.failWith("input_value: bad bigarray kind");
        }
        MemArray b = new MemArray(flags, dim, null);
        ByteBuffer data = b.getData();
        switch ((int)(b.getFlags() & 0xFFL)) {
            case 2: 
            case 3: {
                int i = 0;
                while ((long)i < numElems) {
                    data.put(i * 1, (byte)IO.read8s(in));
                    ++i;
                }
                break;
            }
            case 4: 
            case 5: {
                int i = 0;
                while ((long)i < numElems) {
                    data.putShort(i * 2, (short)IO.read16s(in));
                    ++i;
                }
                break;
            }
            case 0: 
            case 6: {
                int i = 0;
                while ((long)i < numElems) {
                    data.putInt(i * 4, IO.read32s(in));
                    ++i;
                }
                break;
            }
            case 10: {
                int i = 0;
                while ((long)i < numElems * 2L) {
                    data.putInt(i * 4, IO.read32s(in));
                    ++i;
                }
                break;
            }
            case 1: 
            case 7: {
                int i = 0;
                while ((long)i < numElems) {
                    data.putLong(i * 8, IO.read64s(in));
                    ++i;
                }
                break;
            }
            case 11: {
                int i = 0;
                while ((long)i < numElems * 2L) {
                    data.putLong(i * 8, IO.read64s(in));
                    ++i;
                }
                break;
            }
            case 8: 
            case 9: {
                int i;
                if (IO.read8u(in) == 0) {
                    i = 0;
                    while ((long)i < numElems) {
                        data.putLong(i * 8, IO.read32s(in));
                        ++i;
                    }
                } else {
                    i = 0;
                    while ((long)i < numElems) {
                        data.putLong(i * 8, IO.read64s(in));
                        ++i;
                    }
                }
                break;
            }
            default: {
                assert (false) : "invalid elements kind";
                break;
            }
        }
        int sz = 20 + (b.getNumDims() - 1) * 8;
        Value v = Value.createCustom(OPS, sz, b);
        return new CustomOperations.DeserializedValue(v, sz);
    }
}

