/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.unix;

import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="unix", module="Unix", source="otherlibs/unix/times.c")
public final class Times {
    private Times() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.PARTIAL, comment={"In the returned record, [tms_utime] field is set to", "the time elapsed since execution start", "({cf}. [Sys.time]), other fields are set to zero", "(equivalent to Win32 implementation)."}, parameterTypes={"unit"}, returnType="Unix.process_times")
    public static Value unix_times(Value unit) {
        long now = System.currentTimeMillis();
        long start = CurrentContext.getCodeState().getStart();
        return Value.createDoubleArray((double)(now - start) / 1000.0, 0.0, 0.0, 0.0);
    }
}

