/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.values;

import java.util.Arrays;
import org.ocamljava.runtime.values.BlockValue;
import org.ocamljava.runtime.values.Value;

public final class InfixBlockValue
extends BlockValue {
    private BlockValue parent;
    private Value[] values = new Value[1];

    InfixBlockValue(int tag) {
        super(249, tag);
        this.values[0] = Value.createCodeOffset(0L);
    }

    @Override
    public void setParent(BlockValue b) {
        this.parent = b;
    }

    @Override
    public BlockValue getParent() {
        return this.parent;
    }

    @Override
    public Value get(long idx) throws ArrayIndexOutOfBoundsException {
        long i;
        if (idx == 0L) {
            return this.values[0];
        }
        BlockValue p = this.parent;
        if (p == null) {
            throw new ArrayIndexOutOfBoundsException(Long.toString(idx));
        }
        long len = p.sizeValues();
        for (i = 0L; !(i >= len || p.get(i).isBlock() && this == p.get(i)); ++i) {
        }
        return p.get(i + idx);
    }

    @Override
    public Value get(int idx) throws ArrayIndexOutOfBoundsException {
        return this.get((long)idx);
    }

    @Override
    public void set(long idx, Value x) throws ArrayIndexOutOfBoundsException {
        if (idx == 0L) {
            this.values[0] = x;
        } else {
            long i;
            BlockValue p = this.parent;
            if (p == null) {
                throw new ArrayIndexOutOfBoundsException(Long.toString(idx));
            }
            long len = p.sizeValues();
            for (i = 0L; !(i >= len || p.get(i).isBlock() && this == p.get(i)); ++i) {
            }
            long index = i + idx;
            p.set(index, x);
            if (x.isLong() && index + 1L < len && p.get(index + 1L).isBlock() && p.get(index + 1L).asBlock().getTag() == 249) {
                p.get(index + 1L).asBlock().setHeader(x.asLong());
            }
            if (x.isBlock() && x.asBlock().getTag() == 249 && index - 1L >= 0L) {
                p.set(index - 1L, Value.createFromRawValue(x.getHeader()));
            }
        }
    }

    @Override
    public void set(int idx, Value x) throws ArrayIndexOutOfBoundsException {
        this.set((long)idx, x);
    }

    @Override
    public void setHeader(long hd) {
        BlockValue p = this.parent;
        if (p != null) {
            long i;
            long len = p.sizeValues();
            for (i = 0L; !(i >= len || p.get(i).isBlock() && this == p.get(i)); ++i) {
            }
            if (i - 1L >= 0L) {
                p.set(i - 1L, Value.createFromRawValue(hd));
            }
        }
        this.header = hd;
    }

    @Override
    protected void truncateInstance(long sz) {
    }

    @Override
    public void copy(BlockValue src) {
        InfixBlockValue that = (InfixBlockValue)src;
        this.parent = that.parent;
        this.values[0] = that.values[0];
    }

    @Override
    public InfixBlockValue duplicate() {
        InfixBlockValue res = new InfixBlockValue((int)this.getWoSize());
        res.parent = this.parent;
        res.values[0] = this.values[0].duplicate();
        return res;
    }

    @Override
    public void copyValuesIntoArray(Value[] dest) {
        int len = (int)Math.min(Integer.MAX_VALUE, this.sizeValues());
        for (int i = 0; i < len; ++i) {
            dest[i] = this.get(i);
        }
    }

    @Override
    public void copyValuesIntoArray(Value[] dest, int destOfs) {
        int len = (int)Math.min(Integer.MAX_VALUE, this.sizeValues());
        for (int i = 0; i < len; ++i) {
            dest[destOfs + i] = this.get(i);
        }
    }

    @Override
    public void copyDoublesIntoArray(double[] dest, int destOfs) {
        int len = (int)Math.min(Integer.MAX_VALUE, this.sizeValues());
        for (int i = 0; i < len; ++i) {
            dest[destOfs + i] = this.get(i).asDouble();
        }
    }

    @Override
    public void copyRawLongsIntoArray(long[] dest, int destOfs) {
        int len = (int)Math.min(Integer.MAX_VALUE, this.sizeValues());
        for (int i = 0; i < len; ++i) {
            dest[destOfs + i] = this.get(i).getRawValue();
        }
    }

    @Override
    public Value subArray(long ofs, long len) {
        assert (false) : "subArray called on a non-array value";
        return Value.createBlock(0, 0L);
    }

    @Override
    public void blitArray(long srcOfs, Value dest, long destOfs, long len) {
        if (destOfs < srcOfs) {
            for (long i = 0L; i < len; ++i) {
                dest.set(destOfs + i, this.get(srcOfs + i));
            }
        } else {
            for (long i = len - 1L; i >= 0L; --i) {
                dest.set(destOfs + i, this.get(srcOfs + i));
            }
        }
    }

    public int hashCode() {
        int res = this.parent.hashCode();
        int len = Math.min(32, this.values.length);
        for (int i = 0; i < len; ++i) {
            res += this.values[i].hashCode();
        }
        return res;
    }

    public boolean equals(Object obj) {
        if (obj instanceof InfixBlockValue) {
            InfixBlockValue that = (InfixBlockValue)obj;
            return this.parent.equals(that.parent) && Arrays.equals(this.values, that.values);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("InfixBlockValue(");
        sb.append(this.parent == null ? "null" : this.parent.toString());
        int len = this.values.length;
        for (int i = 0; i < len; ++i) {
            sb.append(", ");
            Value v = this.values[i];
            sb.append(v == null ? "null" : v.toString());
        }
        sb.append(")");
        return sb.toString();
    }
}

