/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.unix;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SocketChannel;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.Channel;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.primitives.otherlibs.unix.Unix;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="unix", module="Unix", source="otherlibs/unix/sendrecv.c")
public final class Sendrecv {
    private Sendrecv() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.PARTIAL, comment={"Flags are ignored."}, parameterTypes={"Unix.file_descr", "string", "int", "int", "Unix.msg_flag list"}, returnType="int")
    public static Value unix_recv(Value socket, Value buff, Value ofs, Value len, Value flags) throws Fail.Exception, FalseExit {
        try {
            Channel ch = CurrentContext.getFilesState().getChannel(socket.asCastedInt());
            if (ch == null) {
                Unix.fail("recv", "invalid descriptor");
                return Value.UNIT;
            }
            SocketChannel s = ch.asSocket();
            DatagramChannel ds = ch.asDatagramSocket();
            if (s != null) {
                CurrentContext.enterBlockingSection();
                int res = ch.read(buff.getBytesForModification(), ofs.asCastedInt(), len.asCastedInt());
                CurrentContext.leaveBlockingSection();
                return Value.createLong(res);
            }
            if (ds != null) {
                ByteBuffer b = ByteBuffer.wrap(buff.getBytesForModification(), ofs.asCastedInt(), len.asCastedInt());
                CurrentContext.enterBlockingSection();
                ds.receive(b);
                CurrentContext.leaveBlockingSection();
                return Value.createLong(b.position());
            }
            Unix.fail("recv", "invalid descriptor");
            return Value.UNIT;
        }
        catch (InterruptedIOException iioe) {
            FalseExit fe = FalseExit.createFromContext(CurrentContext.get());
            fe.fillInStackTrace();
            throw fe;
        }
        catch (IOException ioe) {
            CurrentContext.leaveBlockingSection();
            Unix.fail("recv", ioe);
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.PARTIAL, comment={"Flags are ignored."}, parameterTypes={"Unix.file_descr", "string", "int", "int", "Unix.msg_flag list"}, returnType="int")
    public static Value unix_send(Value socket, Value buff, Value ofs, Value len, Value flags) throws Fail.Exception, FalseExit {
        try {
            Channel ch = CurrentContext.getFilesState().getChannel(socket.asCastedInt());
            if (ch == null) {
                Unix.fail("send", "invalid descriptor");
                return Value.UNIT;
            }
            SocketChannel s = ch.asSocket();
            DatagramChannel ds = ch.asDatagramSocket();
            if (s != null) {
                CurrentContext.enterBlockingSection();
                int res = s.write(ByteBuffer.wrap(buff.getBytes(), ofs.asCastedInt(), len.asCastedInt()));
                CurrentContext.leaveBlockingSection();
                return Value.createLong(res);
            }
            if (ds != null) {
                ByteBuffer b = ByteBuffer.wrap(buff.getBytes(), ofs.asCastedInt(), len.asCastedInt());
                CurrentContext.enterBlockingSection();
                ds.send(b, ds.getRemoteAddress());
                CurrentContext.leaveBlockingSection();
                return Value.createLong(b.position());
            }
            Unix.fail("send", "invalid descriptor");
            return Value.UNIT;
        }
        catch (InterruptedIOException iioe) {
            FalseExit fe = FalseExit.createFromContext(CurrentContext.get());
            fe.fillInStackTrace();
            throw fe;
        }
        catch (IOException ioe) {
            CurrentContext.leaveBlockingSection();
            Unix.fail("send", ioe);
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.PARTIAL, comment={"Flags are ignored."}, parameterTypes={"Unix.file_descr", "string", "int", "int", "Unix.msg_flag list"}, returnType="int * Unix.sockaddr")
    public static Value unix_recvfrom(Value socket, Value buff, Value ofs, Value len, Value flags) throws Fail.Exception, FalseExit {
        Channel ch = CurrentContext.getFilesState().getChannel(socket.asCastedInt());
        if (ch == null) {
            Unix.fail("recvfrom", "invalid descriptor");
            return Value.UNIT;
        }
        DatagramChannel ds = ch.asDatagramSocket();
        if (ds == null) {
            Unix.fail("recvfrom", "invalid descriptor");
            return Value.UNIT;
        }
        try {
            CurrentContext.enterBlockingSection();
            ByteBuffer b = ByteBuffer.wrap(buff.getBytesForModification(), ofs.asCastedInt(), len.asCastedInt());
            SocketAddress addr = ds.receive(b);
            CurrentContext.leaveBlockingSection();
            return Value.createBlock(0, Value.createLong(b.position()), Unix.createSockAddr((InetSocketAddress)addr));
        }
        catch (InterruptedIOException iioe) {
            FalseExit fe = FalseExit.createFromContext(CurrentContext.get());
            fe.fillInStackTrace();
            throw fe;
        }
        catch (IOException ioe) {
            CurrentContext.leaveBlockingSection();
            Unix.fail("recvfrom", ioe);
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.PARTIAL, comment={"Flags are ignored."}, parameterTypes={"Unix.file_descr", "string", "int", "int", "Unix.msg_flag list", "Unix.sockaddr"}, returnType="int")
    public static Value unix_sendto(Value socket, Value buff, Value ofs, Value len, Value flags, Value dest) throws Fail.Exception, FalseExit {
        InetSocketAddress addr;
        try {
            addr = new InetSocketAddress(InetAddress.getByAddress(dest.get0().getBytes()), dest.get1().asCastedInt());
        }
        catch (IOException ioe) {
            Unix.fail("sendto", ioe);
            return Value.UNIT;
        }
        Channel ch = CurrentContext.getFilesState().getChannel(socket.asCastedInt());
        if (ch == null) {
            Unix.fail("sendto", "invalid descriptor");
            return Value.UNIT;
        }
        DatagramChannel ds = ch.asDatagramSocket();
        if (ds == null) {
            Unix.fail("sendto", "invalid descriptor");
            return Value.UNIT;
        }
        CurrentContext.enterBlockingSection();
        try {
            ds.send(ByteBuffer.wrap(buff.getBytes(), ofs.asCastedInt(), len.asCastedInt()), addr);
            CurrentContext.leaveBlockingSection();
            return len;
        }
        catch (InterruptedIOException iioe) {
            FalseExit fe = FalseExit.createFromContext(CurrentContext.get());
            fe.fillInStackTrace();
            throw fe;
        }
        catch (IOException ioe) {
            CurrentContext.leaveBlockingSection();
            Unix.fail("sendto", ioe);
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.PARTIAL, comment={"Flags are ignored."}, parameterTypes={"Unix.file_descr", "string", "int", "int", "Unix.msg_flag list", "Unix.sockaddr"}, returnType="int")
    public static Value unix_sendto_native(Value socket, Value buff, Value ofs, Value len, Value flags, Value dest) throws Fail.Exception, FalseExit {
        return Sendrecv.unix_sendto(socket, buff, ofs, len, flags, dest);
    }
}

