/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.kernel;

import org.ocamljava.runtime.kernel.AbstractNativeRunner;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.values.Value;

public final class Misc {
    private static final long MATCH_FAILURE_EXCEPTION = 7L;
    private static final long ASSERT_FAILURE_EXCEPTION = 10L;
    private static final long UNDEFINED_RECURSIVE_MODULE_EXCEPTION = 11L;

    private Misc() {
    }

    private static boolean isSpecialException(Value exception, Value globalData) {
        if (globalData != null) {
            return exception == globalData.get(7L) || exception == globalData.get(10L) || exception == globalData.get(11L);
        }
        AbstractNativeRunner runner = (AbstractNativeRunner)OCamlJavaThread.getCodeRunner();
        return exception == runner.getGlobalFromInstance("caml_exn_Match_failure") || exception == runner.getGlobalFromInstance("caml_exn_Assert_failure") || exception == runner.getGlobalFromInstance("caml_exn_Undefined_recursive_module");
    }

    public static String convertException(Value exception, Value globalData) {
        assert (exception != null) : "null exception";
        StringBuilder sb = new StringBuilder();
        sb.append(exception.get0().get0().asString());
        if (exception.sizeValues() >= 2L) {
            int start;
            Value bucket;
            if (exception.sizeValues() == 2L && exception.get1().isBlock() && exception.get1().getTag() == 0 && Misc.isSpecialException(exception.get0(), globalData)) {
                bucket = exception.get1();
                start = 0;
            } else {
                bucket = exception;
                start = 1;
            }
            sb.append('(');
            int sz = (int)bucket.sizeValues();
            for (int i = start; i < sz; ++i) {
                Value v;
                if (i > start) {
                    sb.append(", ");
                }
                if ((v = bucket.get(i)).isLong()) {
                    sb.append(v.asLong());
                    continue;
                }
                if (v.isBlock() && v.getTag() == 252) {
                    sb.append('\"');
                    sb.append(v.asString());
                    sb.append('\"');
                    continue;
                }
                sb.append('_');
            }
            sb.append(')');
        }
        return sb.toString();
    }

    public static int convertFlagList(Value list, int[] flags) {
        assert (list != null) : "null list";
        assert (flags != null) : "null flags";
        int res = 0;
        for (Value lst = list; lst != Value.EMPTY_LIST; lst = lst.get1()) {
            res |= flags[lst.get0().asCastedInt()];
        }
        return res;
    }
}

