/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.support.toplevel;

import java.io.InputStream;
import java.net.URL;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicReference;
import org.ocamljava.runtime.context.FileHook;

final class ThreadedFileHook
extends Thread
implements FileHook {
    private final BlockingQueue<AtomicReference<Request>> parameters = new LinkedBlockingQueue<AtomicReference<Request>>(1);
    private final BlockingQueue<AtomicReference<Response>> results = new LinkedBlockingQueue<AtomicReference<Response>>(1);

    ThreadedFileHook() {
    }

    @Override
    public void run() {
        try {
            while (true) {
                Request req;
                if ((req = this.parameters.take().get()).url) {
                    this.results.put(new AtomicReference<Response>(new Response(this.getClass().getResource(req.file))));
                    continue;
                }
                this.results.put(new AtomicReference<Response>(new Response(this.getClass().getResourceAsStream(req.file))));
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    @Override
    public InputStream getInputStream(String file) {
        try {
            this.parameters.put(new AtomicReference<Request>(new Request(false, file)));
            return this.results.take().get().inputStream;
        }
        catch (InterruptedException ie) {
            return null;
        }
    }

    @Override
    public URL getURL(String file) {
        try {
            this.parameters.put(new AtomicReference<Request>(new Request(true, file)));
            return this.results.take().get().url;
        }
        catch (InterruptedException ie) {
            return null;
        }
    }

    private static final class Response {
        private final InputStream inputStream;
        private final URL url;

        private Response(InputStream i) {
            this.inputStream = i;
            this.url = null;
        }

        private Response(URL u) {
            this.inputStream = null;
            this.url = u;
        }
    }

    private static final class Request {
        private final boolean url;
        private final String file;

        private Request(boolean u, String f) {
            assert (f != null) : "null f";
            this.url = u;
            this.file = f;
        }
    }
}

