/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.support.applet;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Component;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.kernel.AbstractNativeRunner;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.primitives.otherlibs.graph.GraphSlot;
import org.ocamljava.runtime.values.BlockValue;
import org.ocamljava.runtime.values.Value;

final class AppletRunner
implements Runnable {
    private final Applet applet;
    private Thread thread;
    private AbstractNativeRunner runner;

    AppletRunner(Applet a) {
        assert (a != null) : "null a";
        this.applet = a;
    }

    void setRunner(AbstractNativeRunner r) {
        assert (r != null) : "null r";
        this.runner = r;
    }

    private final Value getCallback(String cb) {
        return this.runner.getContext().getCodeState().getCallback(cb);
    }

    private final void callback(String cb) {
        assert (cb != null) : "null cb";
        try {
            Value closure = this.runner.getContext().getCodeState().getCallback(cb);
            this.runner.callback(closure, Value.createInstance(this.applet));
        }
        catch (Throwable t) {
            this.applet.showStatus(t.toString());
        }
    }

    final String getAppletInfo() {
        Value cb = this.getCallback("ocamljava java.applet.getAppletInfo");
        return cb != null ? cb.asString() : null;
    }

    final String[][] getParameterInfo() {
        Value cb = this.getCallback("ocamljava java.applet.getParameterInfo");
        if (cb != null) {
            BlockValue bl = cb.asBlock();
            int len = (int)bl.sizeValues();
            String[][] res = new String[len][3];
            for (int i = 0; i < len; ++i) {
                BlockValue b = bl.get(i).asBlock();
                res[i][0] = b.get0().asString();
                res[i][1] = b.get1().asString();
                res[i][2] = b.get2().asString();
            }
            return res;
        }
        return null;
    }

    final void init(boolean graphics) {
        if (graphics) {
            Context ctxt = this.runner.getContext();
            String geometry = this.applet.getParameter("width") + "x" + this.applet.getParameter("height");
            GraphSlot slot = new GraphSlot(ctxt.getParameters(), "applet", geometry);
            Canvas canvas = slot.getCanvas();
            this.applet.setLayout(new BorderLayout());
            this.applet.add((Component)canvas, "Center");
            canvas.requestFocus();
            ctxt.getCodeState().registerSlot(GraphSlot.SLOT, slot);
        }
        OCamlJavaThread.registerCodeRunner(Thread.currentThread(), this.runner);
        this.callback("ocamljava java.applet.init");
    }

    final void start() {
        this.callback("ocamljava java.applet.start");
        if (this.thread == null) {
            this.thread = new Thread(this);
            this.thread.start();
            OCamlJavaThread.registerCodeRunner(this.thread, this.runner);
        } else {
            try {
                this.runner.getContext().leaveBlockingSection();
            }
            catch (Throwable t) {
                this.applet.showStatus(t.toString());
            }
            this.thread.resume();
        }
    }

    final void stop() {
        if (this.thread != null) {
            this.thread.suspend();
            this.runner.getContext().enterBlockingSection();
        }
        this.callback("ocamljava java.applet.stop");
    }

    final void destroy() {
        if (this.thread != null) {
            this.thread.stop();
            this.runner.getContext().enterBlockingSection();
        }
        this.callback("ocamljava java.applet.destroy");
    }

    @Override
    public final void run() {
        this.callback("ocamljava java.applet.run");
    }
}

