/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.stdlib;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.LinkedList;
import java.util.List;
import org.ocamljava.runtime.annotations.parameters.Parameters;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.context.FilesState;
import org.ocamljava.runtime.kernel.ByteCodeRunner;
import org.ocamljava.runtime.kernel.Channel;
import org.ocamljava.runtime.kernel.Debugger;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.kernel.Interpreter;
import org.ocamljava.runtime.kernel.Misc;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.parameters.ByteCodeParameters;
import org.ocamljava.runtime.parameters.CommonParameters;
import org.ocamljava.runtime.util.MemoryInputStream;
import org.ocamljava.runtime.util.RandomAccessInputStream;
import org.ocamljava.runtime.util.ShellUtils;
import org.ocamljava.runtime.util.StreamCopyThread;
import org.ocamljava.runtime.values.CustomOperations;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="stdlib", module="Sys", source="byterun/sys.c")
public final class Sys {
    private static final int[] SYS_OPEN_FLAGS = new int[]{0, 1, 9, 512, 1024, 2048, 0, 0, 4};
    private static final Value WORD_SIZE = Value.createLong(64L);
    private static final double MILLISECS_PER_SEC = 1000.0;

    private Sys() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, comment={"According to interpreter parameters, either true", "(JVM shutdown) or false (stop of the interpreted program) exit.", "False exit is needed to allow several interpreted programs", "to coexist within the same JVM", "(as the end of one of these programs should not entail", "exit from JVM and hence stop other programs as well)."}, parameterTypes={"int"}, returnType="'a")
    public static Value caml_sys_exit(Value retCode) throws Fail.Exception, FalseExit, Fatal.Exception {
        Context ctxt = CurrentContext.get();
        if (!ctxt.getCodeState().isNative()) {
            Debugger.handleEvent((ByteCodeRunner)OCamlJavaThread.getCodeRunner(), Debugger.EventKind.PROGRAM_EXIT);
        }
        if (ctxt.getParameters().isExitStoppingJVM()) {
            System.exit(retCode.asCastedInt());
            return Value.UNIT;
        }
        ctxt.getThreadsState().getThreadGroup().interrupt();
        ctxt.getThreadsState().interruptAdditionalThreads();
        throw new FalseExit(ctxt, retCode.asCastedInt());
    }

    @Primitive(compatibility=PrimitiveCompatibility.PARTIAL, comment={"Only supports filenames handled by Java."}, parameterTypes={"string", "Pervasives.open_flag list", "int"}, returnType="int")
    public static Value caml_sys_open(Value path, Value flags, Value perm) throws Fail.Exception, FalseExit {
        Context context = CurrentContext.get();
        int flg = Misc.convertFlagList(flags, SYS_OPEN_FLAGS);
        if (context.getFilesState().getFileHook() != null) {
            try {
                MemoryInputStream res;
                InputStream emb = context.getFilesState().getFileHook().getInputStream(context.getFilesState().resourceNameFromPath(path));
                if (emb != null && (res = new RandomAccessInputStream(emb).createInputStream()) != null) {
                    if ((flg & 0x609) != 0) {
                        Sys.sysError(path.asString(), "unable to open embedded file in write mode");
                    }
                    return Value.createLong(context.getFilesState().addChannel(new Channel(res)));
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        File file = context.getFilesState().getRealFile(path);
        int perms = perm.asCastedInt();
        try {
            CurrentContext.enterBlockingSection();
            Value res = Value.createLong(context.getFilesState().addChannel(new Channel(file, flg, perms)));
            CurrentContext.leaveBlockingSection();
            return res;
        }
        catch (InterruptedIOException iioe) {
            FalseExit fe = FalseExit.createFromContext(context);
            fe.fillInStackTrace();
            throw fe;
        }
        catch (IOException ioe) {
            CurrentContext.leaveBlockingSection();
            Sys.sysError(path.asString(), ioe.toString());
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a"}, returnType="unit")
    public static Value caml_sys_close(Value fd) throws FalseExit, Fail.Exception {
        try {
            CurrentContext.getFilesState().closeChannel(fd.asCastedInt());
        }
        catch (InterruptedIOException iioe) {
            FalseExit fe = FalseExit.createFromContext(CurrentContext.get());
            fe.fillInStackTrace();
            throw fe;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string"}, returnType="bool")
    public static Value caml_sys_file_exists(Value name) {
        FilesState fs;
        block7: {
            fs = CurrentContext.getFilesState();
            if (fs.getFileHook() != null) {
                try {
                    InputStream tmp = fs.getInputStreamForPath(name);
                    if (tmp == null) break block7;
                    try {
                        tmp.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return Value.TRUE;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        try {
            return fs.getRealFile(name).exists() ? Value.TRUE : Value.FALSE;
        }
        catch (SecurityException se) {
            return Value.FALSE;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string"}, returnType="bool")
    public static Value caml_sys_is_directory(Value name) {
        FilesState fs;
        block9: {
            fs = CurrentContext.getFilesState();
            if (fs.getFileHook() != null) {
                try {
                    Value res;
                    InputStream tmp = fs.getInputStreamForPath(name);
                    if (tmp == null) break block9;
                    try {
                        tmp.read();
                        res = Value.FALSE;
                    }
                    catch (Exception e) {
                        res = Value.TRUE;
                    }
                    try {
                        tmp.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    return res;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        try {
            return fs.getRealFile(name).isDirectory() ? Value.TRUE : Value.FALSE;
        }
        catch (SecurityException se) {
            return Value.FALSE;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string"}, returnType="unit")
    public static Value caml_sys_remove(Value name) throws Fail.Exception {
        try {
            if (!CurrentContext.getFilesState().getRealFile(name).delete()) {
                Sys.sysError(name.asString(), "unable to delete file");
            }
            return Value.UNIT;
        }
        catch (SecurityException se) {
            Sys.sysError(name.asString(), se.toString());
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string", "string"}, returnType="unit")
    public static Value caml_sys_rename(Value oldName, Value newName) throws Fail.Exception {
        FilesState fs = CurrentContext.getFilesState();
        try {
            if (!fs.getRealFile(oldName).renameTo(fs.getRealFile(newName))) {
                Sys.sysError(null, "unable to rename file");
            }
            return Value.UNIT;
        }
        catch (SecurityException se) {
            Sys.sysError(null, se.toString());
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string"}, returnType="unit")
    public static Value caml_sys_chdir(Value path) throws Fail.Exception {
        FilesState fs = CurrentContext.getFilesState();
        try {
            File f = fs.getRealFile(path);
            if (f.isDirectory()) {
                fs.setPwd(f);
            } else {
                Sys.sysError(path.asString(), "not a directory");
            }
        }
        catch (SecurityException se) {
            Sys.sysError(path.asString(), se.toString());
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="string")
    public static Value caml_sys_getcwd(Value unit) throws Fail.Exception, FalseExit {
        try {
            return Value.createString(CurrentContext.getFilesState().getPwd().getCanonicalPath());
        }
        catch (InterruptedIOException iioe) {
            FalseExit fe = FalseExit.createFromContext(CurrentContext.get());
            fe.fillInStackTrace();
            throw fe;
        }
        catch (IOException | SecurityException e) {
            Sys.sysError(null, e.toString());
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string"}, returnType="string")
    public static Value caml_sys_getenv(Value var) throws Fail.Exception {
        String res = null;
        try {
            res = System.getenv(var.asString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (res == null) {
            Fail.raiseNotFound();
        }
        return Value.createString(res);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, comment={"[exe_name] is the empty string when the interpreter", "is constructed from a stream that is not a file."}, parameterTypes={"unit"}, returnType="string * string array")
    public static Value caml_sys_get_argv(Value unit) {
        String[] args = CurrentContext.getParameters().getArguments();
        return Value.createBlock(0, Value.createString(CurrentContext.getCodeState().getFile()), args.length > 0 ? Value.createStringArray(args) : CurrentContext.getCodeState().getAtom(0));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string"}, returnType="int")
    public static Value caml_sys_system_command(Value cmd) throws Fail.Exception, FalseExit {
        FalseExit fe;
        String command = cmd.asString();
        List<String> tokens = ShellUtils.parseCommandLine(command);
        if (tokens.size() > 0 && tokens.get(0).charAt(0) == '(') {
            StringBuilder sb = new StringBuilder();
            for (String t : tokens) {
                sb.append(t);
                sb.append(" ");
            }
            tokens.clear();
            tokens.add("sh");
            tokens.add("-c");
            tokens.add(sb.toString());
        }
        String redir = tokens.size() >= 2 ? tokens.get(tokens.size() - 2) : "";
        String redirIn = null;
        String redirOut = null;
        String redirErr = null;
        boolean redirOutAppend = false;
        while (redir != null && (redir.equals(">") || redir.equals(">>") || redir.equals("2>") || redir.equals("<"))) {
            if (redir.equals(">")) {
                redirOut = tokens.remove(tokens.size() - 1);
                redirOutAppend = false;
            } else if (redir.equals(">>")) {
                redirOut = tokens.remove(tokens.size() - 1);
                redirOutAppend = true;
            } else if (redir.equals("2>")) {
                redirErr = tokens.remove(tokens.size() - 1);
            } else if (redir.equals("<")) {
                redirIn = tokens.remove(tokens.size() - 1);
            } else {
                assert (false) : "invalid case";
                tokens.remove(tokens.size() - 1);
            }
            tokens.remove(tokens.size() - 1);
            redir = tokens.size() >= 2 ? tokens.get(tokens.size() - 2) : "";
        }
        String tmpExecutable = tokens.size() >= 1 ? tokens.get(0) : null;
        String executable = tmpExecutable != null && !tmpExecutable.contains("/") ? "/usr/local/bin/" + tmpExecutable : null;
        FilesState fs = CurrentContext.getFilesState();
        if (fs.getFileHook() != null && executable != null) {
            String resource = fs.resourceNameFromPath(Value.createString(executable));
            InputStream is = fs.getFileHook().getInputStream(resource);
            if (is != null) {
                try {
                    OutputStream err;
                    OutputStream out;
                    InputStream in;
                    RandomAccessInputStream rais = new RandomAccessInputStream(is);
                    LinkedList<String> tokensCopy = new LinkedList<String>(tokens);
                    int size = tokensCopy.size();
                    String[] args = new String[size];
                    tokensCopy.toArray(args);
                    if (redirIn != null) {
                        Value f = Value.createString(redirIn);
                        in = new FileInputStream(fs.getRealFile(f));
                    } else {
                        Channel parentIn = fs.getChannel(0);
                        InputStream inputStream = in = parentIn != null ? parentIn.newInputStream() : System.in;
                    }
                    if (redirOut != null) {
                        Value f = Value.createString(redirOut);
                        out = new FileOutputStream(fs.getRealFile(f), redirOutAppend);
                    } else {
                        Channel parentOut = fs.getChannel(1);
                        OutputStream outputStream = out = parentOut != null ? parentOut.newOutputStream() : System.out;
                    }
                    if (redirErr != null) {
                        Value f = Value.createString(redirErr);
                        err = new FileOutputStream(fs.getRealFile(f));
                    } else {
                        Channel parentErr = fs.getChannel(2);
                        err = parentErr != null ? parentErr.newOutputStream() : System.err;
                    }
                    ByteCodeParameters params = Parameters.defaultByteCodeParameters();
                    params = Parameters.setFile(params, executable);
                    params = Parameters.setUnparsedElements(params, args);
                    params = Parameters.setBooleanParameter(params, CommonParameters.BooleanParameterID.STOP_JVM, false);
                    params = Parameters.setInputStreamParameter(params, CommonParameters.InputStreamParameterID.IN, in);
                    params = Parameters.setPrintStreamParameter(params, CommonParameters.PrintStreamParameterID.OUT, (PrintStream)(out instanceof PrintStream ? out : new PrintStream(out, true)));
                    params = Parameters.setPrintStreamParameter(params, CommonParameters.PrintStreamParameterID.ERR, (PrintStream)(err instanceof PrintStream ? err : new PrintStream(err, true)));
                    params = Parameters.setBooleanParameter(params, CommonParameters.BooleanParameterID.UNIX_EMULATION, true);
                    params = Parameters.setBooleanParameter(params, CommonParameters.BooleanParameterID.EMBEDDED, true);
                    params = Parameters.setStringParameter(params, CommonParameters.StringParameterID.EMBEDDED_BASE, "org.ocamljava.runtime.primitives.stdlib.Sys");
                    Interpreter interp = new Interpreter(params, fs.getPwd(), rais, new CustomOperations[0]);
                    Value exit = interp.execute();
                    return exit.isLong() ? exit : Value.MINUS_ONE;
                }
                catch (Exception e) {
                    return Value.MINUS_ONE;
                }
            }
        }
        try {
            Value f;
            ProcessBuilder pb = new ProcessBuilder(tokens);
            pb.directory(fs.getPwd());
            CurrentContext.enterBlockingSection();
            Process p = pb.start();
            if (redirOut != null) {
                f = Value.createString(redirOut);
                new StreamCopyThread(new FileOutputStream(fs.getRealFile(f), redirOutAppend), p.getInputStream()).start();
            } else {
                Channel out = fs.getChannel(1);
                if (out != null) {
                    new StreamCopyThread(out.newOutputStream(), p.getInputStream()).start();
                }
            }
            if (redirErr != null) {
                f = Value.createString(redirErr);
                new StreamCopyThread(new FileOutputStream(fs.getRealFile(f)), p.getErrorStream()).start();
            } else {
                Channel err = fs.getChannel(2);
                if (err != null) {
                    new StreamCopyThread(err.newOutputStream(), p.getErrorStream()).start();
                }
            }
            if (redirIn != null) {
                f = Value.createString(redirIn);
                new StreamCopyThread(p.getOutputStream(), new FileInputStream(fs.getRealFile(f))).start();
            } else {
                Channel in = fs.getChannel(0);
                if (in != null) {
                    new StreamCopyThread(p.getOutputStream(), in.newInputStream()).start();
                }
            }
            int res = p.waitFor();
            CurrentContext.leaveBlockingSection();
            return Value.createLong(res);
        }
        catch (SecurityException se) {
            CurrentContext.leaveBlockingSection();
            Sys.sysError(command, se.toString());
        }
        catch (InterruptedIOException iioe) {
            fe = FalseExit.createFromContext(CurrentContext.get());
            fe.fillInStackTrace();
            throw fe;
        }
        catch (IOException ioe) {
            CurrentContext.leaveBlockingSection();
            Sys.sysError(command, ioe.toString());
        }
        catch (IllegalArgumentException iae) {
            Sys.sysError(command, iae.toString());
        }
        catch (InterruptedException ie) {
            fe = FalseExit.createFromContext(CurrentContext.get());
            fe.fillInStackTrace();
            throw fe;
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, comment={"Returns the (real) time elapsed since start, not the", "time used by the program."}, parameterTypes={"unit"}, returnType="float")
    public static Value caml_sys_time(Value unit) {
        long start = CurrentContext.getCodeState().getStart();
        long now = System.currentTimeMillis();
        return Value.createDouble((double)(now - start) / 1000.0);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, comment={"Returns [System.currentTimeMillis() / 1000]."}, parameterTypes={"unit"}, returnType="int array")
    public static Value caml_sys_random_seed(Value unit) {
        int i;
        int[] data = new int[16];
        int n = 0;
        try {
            FileInputStream fis = new FileInputStream("/dev/urandom");
            byte[] bytes = new byte[12];
            int nb = fis.read(bytes);
            for (i = 0; i < nb; ++i) {
                data[n++] = bytes[i];
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
        long now = System.currentTimeMillis();
        data[n++] = (int)(now % 1000L);
        data[n++] = (int)(now / 1000L);
        Value res = Value.createBlock(0, n);
        for (i = 0; i < n; ++i) {
            res.set(i, Value.createLong(data[i]));
        }
        return res;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, comment={"Returns [''Java''], [''Unix''], [''Cygwin''],", "[''Win32''] or [''MacOS''] according to interpreter", "parameters. [''Unix''], [''Cygwin''], [''Win32''] or", "[''MacOS''] needed for [Graphics]. Size is 64."}, parameterTypes={"unit"}, returnType="string * int * bool")
    public static Value caml_sys_get_config(Value unit) {
        return Value.createBlock(0, Value.createString(CurrentContext.getParameters().getOS()), WORD_SIZE, Value.TRUE);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string"}, returnType="string array")
    public static Value caml_sys_read_directory(Value path) throws Fail.Exception {
        try {
            String[] f = CurrentContext.getFilesState().getRealFile(path).list();
            if (f == null || f.length == 0) {
                return CurrentContext.getCodeState().getAtom(0);
            }
            return Value.createStringArray(f);
        }
        catch (SecurityException se) {
            Sys.sysError(path.asString(), se.toString());
            return Value.UNIT;
        }
    }

    static void sysError(String arg, String ex) throws Fail.Exception {
        if (arg == null) {
            Fail.raiseSysError(ex);
        } else {
            StringBuilder sb = new StringBuilder(arg);
            sb.append(": ");
            sb.append(ex);
            Fail.raiseSysError(sb.toString());
        }
    }

    static void sysIOError(String arg, String ex) throws Fail.Exception {
        Sys.sysError(arg, ex);
    }
}

