/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.stdlib;

import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.primitives.stdlib.Str;
import org.ocamljava.runtime.values.BlockValue;
import org.ocamljava.runtime.values.CustomOperations;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="stdlib", module="Pervasives", source="byterun/compare.c")
public final class Compare {
    public static final long LESS = -1L;
    public static final Value LESS_VALUE = Value.createLong(-1L);
    public static final long EQUAL = 0L;
    public static final Value EQUAL_VALUE = Value.createLong(0L);
    public static final long GREATER = 1L;
    public static final Value GREATER_VALUE = Value.createLong(1L);
    public static final long UNORDERED = Long.MIN_VALUE;
    public static final Value UNORDERED_VALUE = Value.createLong(Long.MIN_VALUE);

    private Compare() {
    }

    private static long compareDoubles(double d1, double d2, boolean total) {
        if (!Double.isNaN(d1) && !Double.isNaN(d2)) {
            if (d1 < d2) {
                return -1L;
            }
            if (d1 > d2) {
                return 1L;
            }
            return 0L;
        }
        if (!total) {
            return Long.MIN_VALUE;
        }
        if (!Double.isNaN(d1) && Double.isNaN(d2)) {
            return 1L;
        }
        if (Double.isNaN(d1) && !Double.isNaN(d2)) {
            return -1L;
        }
        return 0L;
    }

    private static long compare(Value val1, Value val2, boolean total) throws Fail.Exception {
        Value v1 = val1;
        Value v2 = val2;
        LinkedList<Value> stack = new LinkedList<Value>();
        block17: while (true) {
            int cmpCust;
            AtomicBoolean unordered;
            CustomOperations ops;
            if ((v1 == v2 || v1.isLong() && v2.isLong() && v1.asLong() == v2.asLong()) && total) {
                if (stack.isEmpty()) {
                    return 0L;
                }
                v2 = (Value)stack.remove(0);
                v1 = (Value)stack.remove(0);
                continue;
            }
            if (v1.isLong()) {
                if (v1 == v2 || v2.isLong() && v1.asLong() == v2.asLong()) {
                    if (stack.isEmpty()) {
                        return 0L;
                    }
                    v2 = (Value)stack.remove(0);
                    v1 = (Value)stack.remove(0);
                    continue;
                }
                if (v2.isLong()) {
                    return v1.asLong() - v2.asLong();
                }
                switch (v2.getTag()) {
                    case 250: {
                        v2 = v2.get0();
                        continue block17;
                    }
                    case 255: {
                        ops = v2.getCustomOperations();
                        if (ops.isComparableWithLong()) break;
                        unordered = new AtomicBoolean();
                        cmpCust = ops.compareExt(v1, v2, unordered);
                        if (unordered.get() && !total) {
                            return Long.MIN_VALUE;
                        }
                        if (cmpCust != 0) {
                            return cmpCust;
                        }
                        if (stack.isEmpty()) {
                            return 0L;
                        }
                        v2 = (Value)stack.remove(0);
                        v1 = (Value)stack.remove(0);
                        continue block17;
                    }
                }
                return -1L;
            }
            if (v2.isLong()) {
                switch (v1.getTag()) {
                    case 250: {
                        v1 = v1.get0();
                        continue block17;
                    }
                    case 255: {
                        ops = v1.getCustomOperations();
                        if (ops.isComparableWithLong()) break;
                        unordered = new AtomicBoolean();
                        cmpCust = ops.compareExt(v1, v2, unordered);
                        if (unordered.get() && !total) {
                            return Long.MIN_VALUE;
                        }
                        if (cmpCust != 0) {
                            return cmpCust;
                        }
                        if (stack.isEmpty()) {
                            return 0L;
                        }
                        v2 = (Value)stack.remove(0);
                        v1 = (Value)stack.remove(0);
                        continue block17;
                    }
                }
                if (v1.getTag() == 250) {
                    v1 = v1.get0();
                    continue;
                }
                return 1L;
            }
            BlockValue b1 = v1.asBlock();
            BlockValue b2 = v2.asBlock();
            int t1 = b1.getTag();
            int t2 = b2.getTag();
            if (t1 == 250) {
                v1 = b1.get0();
                continue;
            }
            if (t2 == 250) {
                v2 = b2.get0();
                continue;
            }
            if (t1 != t2) {
                return t1 - t2;
            }
            switch (t1) {
                case 252: {
                    long cmpStr;
                    if (v1 == v2 || (cmpStr = (long)Str.compare(b1, b2)) == 0L) break;
                    return cmpStr;
                }
                case 253: {
                    long cmpDbl = Compare.compareDoubles(b1.asDouble(), b2.asDouble(), total);
                    if (cmpDbl == 0L) break;
                    return cmpDbl;
                }
                case 254: {
                    long sz1 = b1.sizeDoubles();
                    long sz2 = b2.sizeDoubles();
                    if (sz1 != sz2) {
                        return sz1 - sz2;
                    }
                    for (long i = 0L; i < sz1; ++i) {
                        long cmpDblElem = Compare.compareDoubles(b1.getDouble(i), b2.getDouble(i), total);
                        if (cmpDblElem == 0L) continue;
                        return cmpDblElem;
                    }
                    break;
                }
                case 251: {
                    Fail.invalidArgument("equal: abstract value");
                    break;
                }
                case 247: 
                case 249: {
                    Fail.invalidArgument("equal: functional value");
                    break;
                }
                case 248: {
                    long oid1 = b1.get1().asLong();
                    long oid2 = b2.get1().asLong();
                    if (oid1 == oid2) break;
                    return oid1 - oid2;
                }
                case 255: {
                    CustomOperations ops2 = b1.getCustomOperations();
                    if (!ops2.isComparable()) {
                        Fail.invalidArgument("equal: abstract value");
                    }
                    if (!ops2.getClass().equals(b2.getCustomOperations().getClass())) {
                        int res = ops2.getIdentifier().compareTo(b2.getCustomOperations().getIdentifier());
                        if (res < 0) {
                            return -1L;
                        }
                        if (res > 0) {
                            return 1L;
                        }
                        return 0L;
                    }
                    AtomicBoolean unordered2 = new AtomicBoolean();
                    long cmpCust2 = ops2.compare(v1, v2, unordered2);
                    if (unordered2.get() && !total) {
                        return Long.MIN_VALUE;
                    }
                    if (cmpCust2 == 0L) break;
                    return cmpCust2;
                }
                default: {
                    long bsz1 = b1.sizeValues();
                    long bsz2 = b2.sizeValues();
                    if (bsz1 != bsz2) {
                        return bsz1 - bsz2;
                    }
                    if (bsz1 == 0L) break;
                    for (long i = bsz1 - 1L; i >= 1L; --i) {
                        stack.add(0, b1.get(i));
                        stack.add(0, b2.get(i));
                    }
                    v1 = b1.get0();
                    v2 = b2.get0();
                    continue block17;
                }
            }
            if (stack.isEmpty()) {
                return 0L;
            }
            v2 = (Value)stack.remove(0);
            v1 = (Value)stack.remove(0);
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a", "'a"}, returnType="int")
    public static Value caml_compare(Value v1, Value v2) throws Fail.Exception {
        return Value.createLong(Long.signum(Compare.compare(v1, v2, true)));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a", "'a"}, returnType="bool")
    public static Value caml_equal(Value v1, Value v2) throws Fail.Exception {
        if (v1 == v2) {
            return Value.TRUE;
        }
        return Compare.compare(v1, v2, false) == 0L ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a", "'a"}, returnType="bool")
    public static Value caml_notequal(Value v1, Value v2) throws Fail.Exception {
        if (v1 == v2) {
            return Value.FALSE;
        }
        return Compare.compare(v1, v2, false) != 0L ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a", "'a"}, returnType="bool")
    public static Value caml_lessthan(Value v1, Value v2) throws Fail.Exception {
        return Compare.compare(v1, v2, false) < 0L ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a", "'a"}, returnType="bool")
    public static Value caml_lessequal(Value v1, Value v2) throws Fail.Exception {
        return Compare.compare(v1, v2, false) <= 0L ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a", "'a"}, returnType="bool")
    public static Value caml_greaterthan(Value v1, Value v2) throws Fail.Exception {
        return Compare.compare(v1, v2, false) > 0L ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a", "'a"}, returnType="bool")
    public static Value caml_greaterequal(Value v1, Value v2) throws Fail.Exception {
        return Compare.compare(v1, v2, false) >= 0L ? Value.TRUE : Value.FALSE;
    }
}

