/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.values;

import java.lang.invoke.MethodHandle;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.Channel;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.values.AbstractValue;
import org.ocamljava.runtime.values.BasicBlockValue;
import org.ocamljava.runtime.values.BasicBlockValue0;
import org.ocamljava.runtime.values.BasicBlockValue1;
import org.ocamljava.runtime.values.BasicBlockValue2;
import org.ocamljava.runtime.values.BasicBlockValue3;
import org.ocamljava.runtime.values.BasicBlockValue4;
import org.ocamljava.runtime.values.BasicBlockValue5;
import org.ocamljava.runtime.values.BasicBlockValue6;
import org.ocamljava.runtime.values.BasicBlockValue7;
import org.ocamljava.runtime.values.BasicBlockValue8;
import org.ocamljava.runtime.values.BlockValue;
import org.ocamljava.runtime.values.CustomOperations;
import org.ocamljava.runtime.values.CustomValue;
import org.ocamljava.runtime.values.DoubleArrayValue;
import org.ocamljava.runtime.values.DoubleArrayValue0;
import org.ocamljava.runtime.values.DoubleArrayValue1;
import org.ocamljava.runtime.values.DoubleArrayValue2;
import org.ocamljava.runtime.values.DoubleArrayValue3;
import org.ocamljava.runtime.values.DoubleArrayValue4;
import org.ocamljava.runtime.values.DoubleArrayValue5;
import org.ocamljava.runtime.values.DoubleArrayValue6;
import org.ocamljava.runtime.values.DoubleArrayValue7;
import org.ocamljava.runtime.values.DoubleArrayValue8;
import org.ocamljava.runtime.values.DoubleValue;
import org.ocamljava.runtime.values.InfixBlockValue;
import org.ocamljava.runtime.values.Int32Value;
import org.ocamljava.runtime.values.Int64Value;
import org.ocamljava.runtime.values.LargeBasicBlockValue;
import org.ocamljava.runtime.values.LargeDoubleArrayValue;
import org.ocamljava.runtime.values.LargeLongBlockValue;
import org.ocamljava.runtime.values.LargeStringValue;
import org.ocamljava.runtime.values.LargeWeakBlockValue;
import org.ocamljava.runtime.values.LongBlockValue;
import org.ocamljava.runtime.values.LongBlockValue0;
import org.ocamljava.runtime.values.LongBlockValue1;
import org.ocamljava.runtime.values.LongBlockValue2;
import org.ocamljava.runtime.values.LongBlockValue3;
import org.ocamljava.runtime.values.LongBlockValue4;
import org.ocamljava.runtime.values.LongBlockValue5;
import org.ocamljava.runtime.values.LongBlockValue6;
import org.ocamljava.runtime.values.LongBlockValue7;
import org.ocamljava.runtime.values.LongBlockValue8;
import org.ocamljava.runtime.values.LongValue;
import org.ocamljava.runtime.values.MethodHandleValue;
import org.ocamljava.runtime.values.NativeIntValue;
import org.ocamljava.runtime.values.OffsetValue;
import org.ocamljava.runtime.values.PredefinedCustomOperations;
import org.ocamljava.runtime.values.StringValue;
import org.ocamljava.runtime.values.WeakBlockValue;

public abstract class Value {
    public static final int LONG_SIZE = 8;
    public static final Value UNIT;
    public static final Value FALSE;
    public static final Value TRUE;
    public static final Value EMPTY_LIST;
    public static final Value ZERO;
    public static final Value ONE;
    public static final Value TWO;
    public static final Value THREE;
    public static final Value FOUR;
    public static final Value FIVE;
    public static final Value SIX;
    public static final Value SEVEN;
    public static final Value EIGHT;
    public static final Value MINUS_ONE;
    public static final Value MINUS_TWO;
    public static final long MAX_LONG = 0x3FFFFFFFFFFFFFFFL;
    public static final long MIN_LONG = -4611686018427387904L;
    public static final long MIN_CACHED_VALUE = -128L;
    public static final long MAX_CACHED_VALUE = 255L;
    public static final long MIN_RAW_CACHED_VALUE = -255L;
    public static final long MAX_RAW_CACHED_VALUE = 511L;
    public static final int MAX_HASH_ELEMENTS = 32;
    private static final long UNIT_AS_LONG = 0L;
    private static final long FALSE_AS_LONG = 0L;
    private static final long TRUE_AS_LONG = 1L;
    private static final long EMPTY_LIST_AS_LONG = 0L;
    private static final LongValue[] CACHED_VALUES;
    private static final LongValue[] RAW_CACHED_VALUES;
    public static long MAX_INTEGER;
    public static long MIN_INTEGER;
    private static final long INTEGER_CARDINALITY;

    public static Value createLong(long v) {
        if (v >= -128L && v <= 255L) {
            return CACHED_VALUES[(int)(v - -128L)];
        }
        long w = v << 1;
        return new LongValue(w >> 1, w | 1L);
    }

    public static Value createCodeOffset(long ofs) {
        return new OffsetValue(ofs << 1 >> 1);
    }

    public static Value createFromRawValue(long value) {
        if ((value & 1L) != 0L) {
            return Value.createLong(value >> 1);
        }
        return new OffsetValue(value >> 1);
    }

    public static Value createFromRawLong(long value) {
        if (value >= -255L && value <= 511L) {
            LongValue res = RAW_CACHED_VALUES[(int)(value - -255L)];
            assert (res != null) : "null res";
            return res;
        }
        assert ((value & 1L) != 0L) : "invalid value";
        return new LongValue(value >> 1, value);
    }

    public static Value createString(long len) {
        if (len < MAX_INTEGER) {
            return new StringValue((int)len);
        }
        return new LargeStringValue(len);
    }

    public static Value createString(long len, String s) {
        if (len < MAX_INTEGER) {
            return new StringValue((long)((int)len), s);
        }
        return new LargeStringValue(len, s);
    }

    public static Value createString(long len, byte[] s) {
        if (len < MAX_INTEGER) {
            return new StringValue((long)((int)len), s);
        }
        return new LargeStringValue(len, s);
    }

    public static Value createString(byte[] s) {
        return new StringValue(s);
    }

    public static Value createString(String s) {
        return new StringValue(s);
    }

    public static Value createInt(long x) {
        return Value.createLong(x);
    }

    public static Value createInt32(int x) {
        return new Int32Value(x);
    }

    public static Value createNativeInt(long x) {
        return new NativeIntValue(x);
    }

    public static Value createInt64(long x) {
        return new Int64Value(x);
    }

    public static Value createChannel(Channel ch) {
        assert (ch != null) : "null ch";
        return Value.createCustom(PredefinedCustomOperations.CHANNEL_OPS, 65580L, ch);
    }

    public static Value createInstance(Object obj) {
        return Value.createCustom(PredefinedCustomOperations.JAVA_OPS, 8L, obj);
    }

    public static Value createStringArray(String[] s) {
        assert (s != null) : "null s";
        int len = s.length;
        Value res = Value.createBlock(0, len);
        for (int i = 0; i < len; ++i) {
            res.set(i, Value.createString(s[i]));
        }
        return res;
    }

    public static Value createCustom(CustomOperations ops, long sz, Object o) {
        CustomValue res = new CustomValue(ops, sz, o);
        if (ops.isFinalized()) {
            CurrentContext.getFinalizersState().addFinalizer(res);
        }
        return res;
    }

    public static Value createCustom(CustomOperations ops, long sz) {
        return Value.createCustom(ops, sz, null);
    }

    public static Value createAbstract(long sz, Object o) {
        return new AbstractValue(sz, o);
    }

    public static Value createBlock(int tag, long sz) {
        if (sz < MAX_INTEGER) {
            int s = (int)sz;
            switch (s) {
                case 0: {
                    return new BasicBlockValue0(tag);
                }
                case 1: {
                    return new BasicBlockValue1(tag, ZERO);
                }
                case 2: {
                    return new BasicBlockValue2(tag, ZERO, ZERO);
                }
                case 3: {
                    return new BasicBlockValue3(tag, ZERO, ZERO, ZERO);
                }
                case 4: {
                    return new BasicBlockValue4(tag, ZERO, ZERO, ZERO, ZERO);
                }
                case 5: {
                    return new BasicBlockValue5(tag, ZERO, ZERO, ZERO, ZERO, ZERO);
                }
                case 6: {
                    return new BasicBlockValue6(tag, ZERO, ZERO, ZERO, ZERO, ZERO, ZERO);
                }
                case 7: {
                    return new BasicBlockValue7(tag, ZERO, ZERO, ZERO, ZERO, ZERO, ZERO, ZERO);
                }
                case 8: {
                    return new BasicBlockValue8(tag, ZERO, ZERO, ZERO, ZERO, ZERO, ZERO, ZERO, ZERO);
                }
            }
            return new BasicBlockValue(tag, s);
        }
        return new LargeBasicBlockValue(tag, sz);
    }

    public static Value createBlock(int tag) {
        return new BasicBlockValue0(tag);
    }

    public static Value createBlock(int tag, Value v0) {
        return new BasicBlockValue1(tag, v0);
    }

    public static Value createBlock(int tag, Value v0, Value v1) {
        return new BasicBlockValue2(tag, v0, v1);
    }

    public static Value createBlock(int tag, Value v0, Value v1, Value v2) {
        return new BasicBlockValue3(tag, v0, v1, v2);
    }

    public static Value createBlock(int tag, Value v0, Value v1, Value v2, Value v3) {
        return new BasicBlockValue4(tag, v0, v1, v2, v3);
    }

    public static Value createBlock(int tag, Value v0, Value v1, Value v2, Value v3, Value v4) {
        return new BasicBlockValue5(tag, v0, v1, v2, v3, v4);
    }

    public static Value createBlock(int tag, Value v0, Value v1, Value v2, Value v3, Value v4, Value v5) {
        return new BasicBlockValue6(tag, v0, v1, v2, v3, v4, v5);
    }

    public static Value createBlock(int tag, Value v0, Value v1, Value v2, Value v3, Value v4, Value v5, Value v6) {
        return new BasicBlockValue7(tag, v0, v1, v2, v3, v4, v5, v6);
    }

    public static Value createBlock(int tag, Value v0, Value v1, Value v2, Value v3, Value v4, Value v5, Value v6, Value v7) {
        return new BasicBlockValue8(tag, v0, v1, v2, v3, v4, v5, v6, v7);
    }

    public static Value createBlock(int tag, Value[] values) {
        int len = values.length;
        switch (len) {
            case 0: {
                return new BasicBlockValue0(tag);
            }
            case 1: {
                return new BasicBlockValue1(tag, values[0]);
            }
            case 2: {
                return new BasicBlockValue2(tag, values[0], values[1]);
            }
            case 3: {
                return new BasicBlockValue3(tag, values[0], values[1], values[2]);
            }
            case 4: {
                return new BasicBlockValue4(tag, values[0], values[1], values[2], values[3]);
            }
            case 5: {
                return new BasicBlockValue5(tag, values[0], values[1], values[2], values[3], values[4]);
            }
            case 6: {
                return new BasicBlockValue6(tag, values[0], values[1], values[2], values[3], values[4], values[5]);
            }
            case 7: {
                return new BasicBlockValue7(tag, values[0], values[1], values[2], values[3], values[4], values[5], values[6]);
            }
            case 8: {
                return new BasicBlockValue8(tag, values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]);
            }
        }
        return new BasicBlockValue(tag, values);
    }

    public abstract Value get(long var1) throws ArrayIndexOutOfBoundsException;

    public abstract Value get(int var1) throws ArrayIndexOutOfBoundsException;

    public abstract Value get0();

    public abstract Value get1();

    public abstract Value get2();

    public abstract Value get3();

    public abstract Value get4();

    public abstract Value get5();

    public abstract Value get6();

    public abstract Value get7();

    public abstract void set(long var1, Value var3) throws ArrayIndexOutOfBoundsException;

    public abstract void set(int var1, Value var2) throws ArrayIndexOutOfBoundsException;

    public abstract void set0(Value var1);

    public abstract void set1(Value var1);

    public abstract void set2(Value var1);

    public abstract void set3(Value var1);

    public abstract void set4(Value var1);

    public abstract void set5(Value var1);

    public abstract void set6(Value var1);

    public abstract void set7(Value var1);

    public abstract long sizeValues();

    public static Value createDoubleArray(long sz) {
        if (sz < MAX_INTEGER) {
            int s = (int)sz;
            switch (s) {
                case 0: {
                    return new DoubleArrayValue0();
                }
                case 1: {
                    return new DoubleArrayValue1();
                }
                case 2: {
                    return new DoubleArrayValue2();
                }
                case 3: {
                    return new DoubleArrayValue3();
                }
                case 4: {
                    return new DoubleArrayValue4();
                }
                case 5: {
                    return new DoubleArrayValue5();
                }
                case 6: {
                    return new DoubleArrayValue6();
                }
                case 7: {
                    return new DoubleArrayValue7();
                }
                case 8: {
                    return new DoubleArrayValue8();
                }
            }
            return new DoubleArrayValue(s);
        }
        return new LargeDoubleArrayValue(sz);
    }

    public static Value createDoubleArray() {
        return new DoubleArrayValue0();
    }

    public static Value createDoubleArray(double v0) {
        return new DoubleArrayValue1(v0);
    }

    public static Value createDoubleArray(double v0, double v1) {
        return new DoubleArrayValue2(v0, v1);
    }

    public static Value createDoubleArray(double v0, double v1, double v2) {
        return new DoubleArrayValue3(v0, v1, v2);
    }

    public static Value createDoubleArray(double v0, double v1, double v2, double v3) {
        return new DoubleArrayValue4(v0, v1, v2, v3);
    }

    public static Value createDoubleArray(double v0, double v1, double v2, double v3, double v4) {
        return new DoubleArrayValue5(v0, v1, v2, v3, v4);
    }

    public static Value createDoubleArray(double v0, double v1, double v2, double v3, double v4, double v5) {
        return new DoubleArrayValue6(v0, v1, v2, v3, v4, v5);
    }

    public static Value createDoubleArray(double v0, double v1, double v2, double v3, double v4, double v5, double v6) {
        return new DoubleArrayValue7(v0, v1, v2, v3, v4, v5, v6);
    }

    public static Value createDoubleArray(double v0, double v1, double v2, double v3, double v4, double v5, double v6, double v7) {
        return new DoubleArrayValue8(v0, v1, v2, v3, v4, v5, v6, v7);
    }

    public static Value createDoubleArray(double[] values) {
        int len = values.length;
        switch (len) {
            case 0: {
                return new DoubleArrayValue0();
            }
            case 1: {
                return new DoubleArrayValue1(values[0]);
            }
            case 2: {
                return new DoubleArrayValue2(values[0], values[1]);
            }
            case 3: {
                return new DoubleArrayValue3(values[0], values[1], values[2]);
            }
            case 4: {
                return new DoubleArrayValue4(values[0], values[1], values[2], values[3]);
            }
            case 5: {
                return new DoubleArrayValue5(values[0], values[1], values[2], values[3], values[4]);
            }
            case 6: {
                return new DoubleArrayValue6(values[0], values[1], values[2], values[3], values[4], values[5]);
            }
            case 7: {
                return new DoubleArrayValue7(values[0], values[1], values[2], values[3], values[4], values[5], values[6]);
            }
            case 8: {
                return new DoubleArrayValue8(values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]);
            }
        }
        return new DoubleArrayValue(values);
    }

    public abstract double getDouble(long var1) throws ArrayIndexOutOfBoundsException;

    public abstract double getDouble(int var1) throws ArrayIndexOutOfBoundsException;

    public abstract double getDouble0();

    public abstract double getDouble1();

    public abstract double getDouble2();

    public abstract double getDouble3();

    public abstract double getDouble4();

    public abstract double getDouble5();

    public abstract double getDouble6();

    public abstract double getDouble7();

    public abstract void setDouble(long var1, double var3) throws ArrayIndexOutOfBoundsException;

    public abstract void setDouble(int var1, double var2) throws ArrayIndexOutOfBoundsException;

    public abstract void setDouble0(double var1);

    public abstract void setDouble1(double var1);

    public abstract void setDouble2(double var1);

    public abstract void setDouble3(double var1);

    public abstract void setDouble4(double var1);

    public abstract void setDouble5(double var1);

    public abstract void setDouble6(double var1);

    public abstract void setDouble7(double var1);

    public abstract long sizeDoubles();

    public abstract double getGenericDouble(long var1) throws ArrayIndexOutOfBoundsException;

    public abstract double getGenericDouble(int var1) throws ArrayIndexOutOfBoundsException;

    public abstract double getGenericDouble0();

    public abstract double getGenericDouble1();

    public abstract double getGenericDouble2();

    public abstract double getGenericDouble3();

    public abstract double getGenericDouble4();

    public abstract double getGenericDouble5();

    public abstract double getGenericDouble6();

    public abstract double getGenericDouble7();

    public abstract void setGenericDouble(long var1, double var3) throws ArrayIndexOutOfBoundsException;

    public abstract void setGenericDouble(int var1, double var2) throws ArrayIndexOutOfBoundsException;

    public abstract void setGenericDouble0(double var1);

    public abstract void setGenericDouble1(double var1);

    public abstract void setGenericDouble2(double var1);

    public abstract void setGenericDouble3(double var1);

    public abstract void setGenericDouble4(double var1);

    public abstract void setGenericDouble5(double var1);

    public abstract void setGenericDouble6(double var1);

    public abstract void setGenericDouble7(double var1);

    public static Value createLongBlockFromSize(int tag, long sz) {
        if (sz < MAX_INTEGER) {
            int s = (int)sz;
            switch (s) {
                case 0: {
                    return new LongBlockValue0(tag);
                }
                case 1: {
                    return new LongBlockValue1(tag, 0L);
                }
                case 2: {
                    return new LongBlockValue2(tag, 0L, 0L);
                }
                case 3: {
                    return new LongBlockValue3(tag, 0L, 0L, 0L);
                }
                case 4: {
                    return new LongBlockValue4(tag, 0L, 0L, 0L, 0L);
                }
                case 5: {
                    return new LongBlockValue5(tag, 0L, 0L, 0L, 0L, 0L);
                }
                case 6: {
                    return new LongBlockValue6(tag, 0L, 0L, 0L, 0L, 0L, 0L);
                }
                case 7: {
                    return new LongBlockValue7(tag, 0L, 0L, 0L, 0L, 0L, 0L, 0L);
                }
                case 8: {
                    return new LongBlockValue8(tag, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L);
                }
            }
            return new LongBlockValue(tag, s);
        }
        return new LargeLongBlockValue(tag, sz);
    }

    public static Value createLongBlock(int tag) {
        return new LongBlockValue0(tag);
    }

    public static Value createLongBlock(int tag, long v0) {
        return new LongBlockValue1(tag, v0);
    }

    public static Value createLongBlock(int tag, long v0, long v1) {
        return new LongBlockValue2(tag, v0, v1);
    }

    public static Value createLongBlock(int tag, long v0, long v1, long v2) {
        return new LongBlockValue3(tag, v0, v1, v2);
    }

    public static Value createLongBlock(int tag, long v0, long v1, long v2, long v3) {
        return new LongBlockValue4(tag, v0, v1, v2, v3);
    }

    public static Value createLongBlock(int tag, long v0, long v1, long v2, long v3, long v4) {
        return new LongBlockValue5(tag, v0, v1, v2, v3, v4);
    }

    public static Value createLongBlock(int tag, long v0, long v1, long v2, long v3, long v4, long v5) {
        return new LongBlockValue6(tag, v0, v1, v2, v3, v4, v5);
    }

    public static Value createLongBlock(int tag, long v0, long v1, long v2, long v3, long v4, long v5, long v6) {
        return new LongBlockValue7(tag, v0, v1, v2, v3, v4, v5, v6);
    }

    public static Value createLongBlock(int tag, long v0, long v1, long v2, long v3, long v4, long v5, long v6, long v7) {
        return new LongBlockValue8(tag, v0, v1, v2, v3, v4, v5, v6, v7);
    }

    public static Value createLongBlock(int tag, long[] values) {
        int len = values.length;
        switch (len) {
            case 0: {
                return new LongBlockValue0(tag);
            }
            case 1: {
                return new LongBlockValue1(tag, values[0]);
            }
            case 2: {
                return new LongBlockValue2(tag, values[0], values[1]);
            }
            case 3: {
                return new LongBlockValue3(tag, values[0], values[1], values[2]);
            }
            case 4: {
                return new LongBlockValue4(tag, values[0], values[1], values[2], values[3]);
            }
            case 5: {
                return new LongBlockValue5(tag, values[0], values[1], values[2], values[3], values[4]);
            }
            case 6: {
                return new LongBlockValue6(tag, values[0], values[1], values[2], values[3], values[4], values[5]);
            }
            case 7: {
                return new LongBlockValue7(tag, values[0], values[1], values[2], values[3], values[4], values[5], values[6]);
            }
            case 8: {
                return new LongBlockValue8(tag, values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]);
            }
        }
        return new LongBlockValue(tag, values);
    }

    public abstract long getRawLong(long var1) throws ArrayIndexOutOfBoundsException;

    public abstract long getRawLong(int var1) throws ArrayIndexOutOfBoundsException;

    public abstract long getRawLong0();

    public abstract long getRawLong1();

    public abstract long getRawLong2();

    public abstract long getRawLong3();

    public abstract long getRawLong4();

    public abstract long getRawLong5();

    public abstract long getRawLong6();

    public abstract long getRawLong7();

    public abstract void setRawLong(long var1, long var3) throws ArrayIndexOutOfBoundsException;

    public abstract void setRawLong(int var1, long var2) throws ArrayIndexOutOfBoundsException;

    public abstract void setRawLong0(long var1);

    public abstract void setRawLong1(long var1);

    public abstract void setRawLong2(long var1);

    public abstract void setRawLong3(long var1);

    public abstract void setRawLong4(long var1);

    public abstract void setRawLong5(long var1);

    public abstract void setRawLong6(long var1);

    public abstract void setRawLong7(long var1);

    public abstract long sizeLongs();

    public static Value createDouble(double d) {
        return new DoubleValue(d);
    }

    public static Value createClosure(long sz) {
        Value res = Value.createBlock(247, sz);
        if (sz > 0L) {
            res.set(0L, Value.createCodeOffset(0L));
        }
        return res;
    }

    public static Value createClosure(long sz, long code) {
        Value res = Value.createBlock(247, sz);
        if (sz > 0L) {
            res.set(0L, Value.createCodeOffset(code));
        }
        return res;
    }

    public static Value createClosure(MethodHandle mh) {
        Value res = Value.createBlock(247, ZERO, ONE);
        res.set0(new MethodHandleValue(mh, res));
        return res;
    }

    public static Value createClosure(MethodHandle mh, int arity) {
        Value code = Value.createCodeOffset(arity < 0 ? -1L : (long)(-arity - 1));
        Value res = Value.createBlock(247, code, Value.createLong(arity), ZERO);
        res.set2(new MethodHandleValue(mh, res));
        return res;
    }

    public static Value createInfix(int tag) {
        return new InfixBlockValue(tag);
    }

    public static Value createAtom(int tag) {
        return new BasicBlockValue0(tag);
    }

    public static Value createWeakBlock(long sz) {
        if (sz < MAX_INTEGER) {
            return new WeakBlockValue((int)sz);
        }
        return new LargeWeakBlockValue(sz);
    }

    public abstract double asDouble();

    public abstract void setDouble(double var1);

    public abstract long getCode();

    public abstract void setCode(long var1);

    public abstract int getTag();

    public abstract long getHeader();

    public abstract long getWoSize();

    public abstract long getMagicNumber();

    public abstract void setTag(int var1);

    public abstract boolean isLong();

    public abstract boolean isCodeOffset();

    public abstract boolean isMethodHandle();

    public abstract boolean isBlock();

    public abstract boolean isDoubleArray();

    public abstract boolean isLongBlock();

    public abstract boolean isDouble();

    public abstract long getRawValue();

    public abstract long asLong();

    public abstract int asCastedInt();

    public abstract int asBoundedInt() throws Fatal.Exception;

    public abstract long asCodeOffset();

    public int getApplicationKind() {
        long ofs = this.asCodeOffset();
        if (ofs == -1L) {
            return 0;
        }
        if (ofs >= 0L) {
            return 1;
        }
        return 2;
    }

    public abstract BlockValue asBlock();

    public abstract String asString();

    public abstract byte[] getBytes();

    public abstract byte[] getBytesForModification();

    public abstract int[] getUnsignedBytes();

    public abstract byte getByte(long var1) throws ArrayIndexOutOfBoundsException;

    public abstract void setByte(long var1, byte var3) throws ArrayIndexOutOfBoundsException;

    public abstract int getUnsignedByte(long var1) throws ArrayIndexOutOfBoundsException;

    public abstract void setUnsignedByte(long var1, int var3) throws ArrayIndexOutOfBoundsException;

    public abstract long sizeBytes();

    public abstract long sizeBytesTagged();

    public abstract long sizeBytesMinusOneTagged();

    public abstract Value sizeBytesWrapped();

    public abstract Value getWeak(long var1) throws ArrayIndexOutOfBoundsException;

    public abstract void setWeak(long var1, Value var3) throws ArrayIndexOutOfBoundsException;

    public abstract long sizeWeakValues();

    public abstract int asInt32();

    public abstract void setInt32(int var1);

    public abstract long asNativeInt();

    public abstract void setNativeInt(long var1);

    public abstract long asInt64();

    public abstract void setInt64(long var1);

    public abstract CustomOperations getCustomOperations();

    public abstract Object asCustom();

    public abstract void setCustom(Object var1);

    public abstract void setParent(BlockValue var1);

    public abstract BlockValue getParent();

    public final Value setClosure(MethodHandle mh) {
        assert (mh != null) : "null mh";
        this.set0(new MethodHandleValue(mh, this));
        this.set1(ONE);
        return this;
    }

    public final Value setClosure(MethodHandle mh, int arity) {
        assert (mh != null) : "null mh";
        Value code = Value.createCodeOffset(arity < 0 ? -1L : (long)(-arity - 1));
        this.set0(code);
        this.set1(Value.createLong(arity));
        this.set2(new MethodHandleValue(mh, this));
        return this;
    }

    public final Value setInfix(MethodHandle mh, long idx) {
        assert (mh != null) : "null mh";
        Value infix = Value.createInfix((int)(idx + 1L));
        infix.setParent((BlockValue)this);
        infix.set0(new MethodHandleValue(mh, infix));
        this.set(idx, Value.createFromRawValue(infix.getTag()));
        this.set(idx + 1L, infix);
        this.set(idx + 2L, ONE);
        return this;
    }

    public final Value setInfix(MethodHandle mh, long idx, int arity) {
        assert (mh != null) : "null mh";
        Value code = Value.createCodeOffset(arity < 0 ? -1L : (long)(-arity - 1));
        Value infix = Value.createInfix((int)(idx + 1L));
        infix.setParent((BlockValue)this);
        infix.set0(code);
        this.set(idx, Value.createFromRawValue(infix.getTag()));
        this.set(idx + 1L, infix);
        this.set(idx + 2L, Value.createLong(arity));
        this.set(idx + 3L, (Value)new MethodHandleValue(mh, infix));
        return this;
    }

    public abstract void set(Value var1, long var2) throws ArrayIndexOutOfBoundsException;

    public abstract Value offset(long var1);

    public abstract long arrayLength();

    public abstract long arrayLengthTagged();

    public abstract long arrayLengthMinusOneTagged();

    public abstract Value arrayLengthWrapped();

    public abstract int switchTag();

    public abstract Value duplicate();

    public abstract void copyValuesIntoArray(Value[] var1);

    public abstract void copyValuesIntoArray(Value[] var1, int var2);

    public abstract void copyDoublesIntoArray(double[] var1, int var2);

    public abstract void copyRawLongsIntoArray(long[] var1, int var2);

    public abstract Value subArray(long var1, long var3);

    public abstract void blitArray(long var1, Value var3, long var4, long var6);

    private static int kind(Value v) {
        if (v.isBlock()) {
            return 0;
        }
        if (v.isLong()) {
            return 1;
        }
        return 2;
    }

    private static int kindTimes4(Value v) {
        if (v.isBlock()) {
            return 0;
        }
        if (v.isLong()) {
            return 4;
        }
        return 8;
    }

    public static int compare(Value v1, Value v2) {
        assert (v1 != null) : "null v1";
        assert (v2 != null) : "null v2";
        switch (Value.kindTimes4(v1) | Value.kind(v2)) {
            case 0: {
                long mn1 = v1.getMagicNumber();
                long mn2 = v2.getMagicNumber();
                return mn1 == mn2 ? 0 : (mn1 < mn2 ? 1 : -1);
            }
            case 1: {
                return -1;
            }
            case 2: {
                return -1;
            }
            case 3: {
                assert (false) : "should not happen";
                return -1;
            }
            case 4: {
                return 1;
            }
            case 5: {
                long l1 = v1.asLong();
                long l2 = v2.asLong();
                return l1 == l2 ? 0 : (l1 < l2 ? -1 : 1);
            }
            case 6: {
                return -1;
            }
            case 7: {
                assert (false) : "should not happen";
                return -1;
            }
            case 8: {
                return 1;
            }
            case 9: {
                return 1;
            }
            case 10: {
                long l1 = v1.asLong();
                long l2 = v2.asLong();
                return l1 == l2 ? 0 : (l1 < l2 ? -1 : 1);
            }
        }
        assert (false) : "should not happen";
        return -1;
    }

    public static int compareUnsigned(Value v1, Value v2) {
        long l2;
        int k2;
        assert (v1 != null) : "null v1";
        assert (v2 != null) : "null v2";
        int k1 = Value.kind(v1);
        if (k1 < (k2 = Value.kind(v2))) {
            return -1;
        }
        if (k1 > k2) {
            return 1;
        }
        if (k1 == 0) {
            long mn2;
            long mn1 = v1.getMagicNumber();
            return mn1 == (mn2 = v2.getMagicNumber()) ? 0 : (mn1 < mn2 ? 1 : -1);
        }
        if (k1 == 1) {
            long l22;
            long hi2;
            long l1 = v1.asLong();
            long hi1 = l1 >> 32 & 0xFFFFFFFFL;
            if (hi1 < (hi2 = (l22 = v2.asLong()) >> 32 & 0xFFFFFFFFL)) {
                return -1;
            }
            if (hi1 > hi2) {
                return 1;
            }
            long lo1 = l1 & 0xFFFFFFFFL;
            long lo2 = l22 & 0xFFFFFFFFL;
            return lo1 == lo2 ? 0 : (lo1 < lo2 ? -1 : 1);
        }
        long l1 = v1.asLong();
        return l1 == (l2 = v2.asLong()) ? 0 : (l1 < l2 ? -1 : 1);
    }

    public static int compareUsingMagicNumbers(Value v1, Value v2) {
        long mn2;
        assert (v1 != null) : "null v1";
        assert (v2 != null) : "null v2";
        assert (v1.isBlock()) : "v1 should be a block";
        assert (v2.isBlock()) : "v2 should be a block";
        long mn1 = v1.getMagicNumber();
        return mn1 == (mn2 = v2.getMagicNumber()) ? 0 : (mn1 < mn2 ? 1 : -1);
    }

    static long wosize(long words) {
        assert (words >= 0L) : "bytes should be >= 0";
        long valueSize = 8L;
        return 1L + (words + 8L - 1L) / 8L;
    }

    static {
        MAX_INTEGER = Integer.MAX_VALUE;
        MIN_INTEGER = Integer.MIN_VALUE;
        INTEGER_CARDINALITY = MAX_INTEGER - MIN_INTEGER + 1L;
        CACHED_VALUES = new LongValue[384];
        RAW_CACHED_VALUES = new LongValue[767];
        int r = -255;
        for (int i = -128; i <= 255; ++i) {
            LongValue lv;
            Value.CACHED_VALUES[i - -128] = lv = new LongValue(i, r);
            Value.RAW_CACHED_VALUES[r - -255] = lv;
            r += 2;
        }
        UNIT = Value.createLong(0L);
        FALSE = Value.createLong(0L);
        TRUE = Value.createLong(1L);
        EMPTY_LIST = Value.createLong(0L);
        ZERO = Value.createLong(0L);
        ONE = Value.createLong(1L);
        TWO = Value.createLong(2L);
        THREE = Value.createLong(3L);
        FOUR = Value.createLong(4L);
        FIVE = Value.createLong(5L);
        SIX = Value.createLong(6L);
        SEVEN = Value.createLong(7L);
        EIGHT = Value.createLong(8L);
        MINUS_ONE = Value.createLong(-1L);
        MINUS_TWO = Value.createLong(-2L);
    }
}

