/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.kernel;

import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.ocamljava.runtime.context.CodeState;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.kernel.DataFormat;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.Misc;
import org.ocamljava.runtime.util.EncodingUtils;
import org.ocamljava.runtime.util.IO;
import org.ocamljava.runtime.util.IntegerUtils;
import org.ocamljava.runtime.util.PlatformUtils;
import org.ocamljava.runtime.values.BlockValue;
import org.ocamljava.runtime.values.CustomOperations;
import org.ocamljava.runtime.values.Value;

public final class MarshalExtern
implements DataFormat {
    private static final int NO_SHARING = 1;
    private static final int CLOSURES = 2;
    private static final int[] EXTERN_FLAGS = new int[]{1, 2};

    private MarshalExtern() {
    }

    public static byte[] externValue(Context ctxt, Value v, Value flags) throws IOException, Fail.Exception {
        assert (ctxt != null) : "null ctxt";
        assert (v != null) : "null v";
        assert (flags != null) : "null flags";
        int fl = Misc.convertFlagList(flags, EXTERN_FLAGS);
        boolean ignoreSharing = (fl & 1) != 0;
        boolean closures = (fl & 2) != 0;
        LinkedList<Value> objTable = new LinkedList<Value>();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CustomOperations.SerializationSizes sizes = new CustomOperations.SerializationSizes();
        DataOutputStream out = new DataOutputStream(baos);
        IO.write32s(out, -2070567234);
        out.write(new byte[16]);
        MarshalExtern.externRec(ctxt, out, v, objTable, sizes, ignoreSharing, closures);
        byte[] res = baos.toByteArray();
        baos.close();
        ByteArrayOutputStream tmp = new ByteArrayOutputStream(16);
        DataOutputStream tmpOut = new DataOutputStream(tmp);
        tmpOut.writeInt(res.length - 20);
        tmpOut.writeInt(objTable.size());
        tmpOut.writeInt(IntegerUtils.unsignedToSigned(sizes.size32));
        tmpOut.writeInt(IntegerUtils.unsignedToSigned(sizes.size64));
        System.arraycopy(tmp.toByteArray(), 0, res, 4, 16);
        tmp.close();
        return res;
    }

    private static void externRec(Context ctxt, DataOutput out, Value val, List<Value> objTable, CustomOperations.SerializationSizes sizes, boolean ignoreSharing, boolean closures) throws IOException, Fail.Exception {
        assert (ctxt != null) : "null ctxt";
        assert (out != null) : "null out";
        assert (val != null) : "null val";
        assert (objTable != null) : "null objTable";
        assert (sizes != null) : "null sizes";
        Value v = val;
        LinkedList<StackItem> stack = new LinkedList<StackItem>();
        boolean nextItem = false;
        block8: while (true) {
            if (nextItem) {
                v = null;
                while (v == null && !stack.isEmpty()) {
                    StackItem top = (StackItem)stack.get(0);
                    v = top.nextItem();
                    if (v != null) continue;
                    stack.remove(0);
                }
                if (v == null) {
                    return;
                }
                nextItem = false;
            }
            if (v.isLong()) {
                long n = v.asLong();
                if (n >= 0L && n < 64L) {
                    IO.write8u(out, (int)n + 64);
                } else if (n >= -128L && n <= 127L) {
                    IO.write8u(out, 0);
                    IO.write8s(out, (int)n);
                } else if (n >= -32768L && n <= 32767L) {
                    IO.write8u(out, 1);
                    IO.write16s(out, (int)n);
                } else if (n < Integer.MIN_VALUE || n > Integer.MAX_VALUE) {
                    IO.write8u(out, 3);
                    IO.write64s(out, n);
                } else {
                    IO.write8u(out, 2);
                    IO.write32s(out, (int)n);
                }
                nextItem = true;
                continue;
            }
            if (v.isBlock()) {
                Value f;
                long hd = v.getHeader();
                int tag = v.getTag();
                long sz = v.getWoSize();
                if (tag == 250 && (!(f = v.get0()).isBlock() || ctxt.getCodeState().isAtom(f) || f.getTag() != 250 && f.getTag() != 246 && f.getTag() != 253)) {
                    v = f;
                    continue;
                }
                if (sz == 0L) {
                    if (tag < 16) {
                        IO.write8u(out, 128 + tag);
                    } else {
                        IO.write8u(out, 8);
                        IO.write32s(out, (int)hd);
                    }
                    nextItem = true;
                    continue;
                }
                if (!ignoreSharing && tag != 249) {
                    int idx = MarshalExtern.indexOf(objTable, v);
                    if (idx != -1) {
                        int ofs = objTable.size() - idx;
                        if (ofs < 256) {
                            IO.write8u(out, 4);
                            IO.write8u(out, ofs);
                        } else if (ofs < 65536) {
                            IO.write8u(out, 5);
                            IO.write16u(out, ofs);
                        } else {
                            IO.write8u(out, 6);
                            IO.write32s(out, ofs);
                        }
                        nextItem = true;
                        continue;
                    }
                    objTable.add(v);
                }
                switch (tag) {
                    case 252: {
                        int len = (int)v.sizeBytes();
                        if ((long)len < 32L) {
                            IO.write8u(out, 32 + len);
                        } else if ((long)len < 256L) {
                            IO.write8u(out, 9);
                            IO.write8u(out, len);
                        } else {
                            IO.write8u(out, 10);
                            IO.write32u(out, len);
                        }
                        out.write(v.getBytes());
                        sizes.size32 += (long)(1 + (len + 4) / 4);
                        sizes.size64 += (long)(1 + (len + 8) / 8);
                        break;
                    }
                    case 253: {
                        IO.write8u(out, CODE_DOUBLE_NATIVE);
                        if (PlatformUtils.isBigEndianPlatform()) {
                            IO.write64s(out, Double.doubleToRawLongBits(v.asDouble()));
                        } else {
                            IO.write64s(out, Long.reverseBytes(Double.doubleToRawLongBits(v.asDouble())));
                        }
                        sizes.size32 += 3L;
                        sizes.size64 += 2L;
                        break;
                    }
                    case 254: {
                        int i;
                        int nFloats = (int)v.sizeDoubles();
                        if (nFloats < 256) {
                            IO.write8u(out, CODE_DOUBLE_ARRAY8_NATIVE);
                            IO.write8u(out, nFloats);
                        } else {
                            IO.write8u(out, CODE_DOUBLE_ARRAY32_NATIVE);
                            IO.write32u(out, nFloats);
                        }
                        if (PlatformUtils.isBigEndianPlatform()) {
                            for (i = 0; i < nFloats; ++i) {
                                IO.write64s(out, Double.doubleToRawLongBits(v.getDouble(i)));
                            }
                        } else {
                            for (i = 0; i < nFloats; ++i) {
                                IO.write64s(out, Long.reverseBytes(Double.doubleToRawLongBits(v.getDouble(i))));
                            }
                        }
                        sizes.size32 += (long)(1 + nFloats * 2);
                        sizes.size64 += (long)(1 + nFloats);
                        break;
                    }
                    case 251: {
                        Fail.invalidArgument("output_value: abstract value (Abstract)");
                        break;
                    }
                    case 249: {
                        BlockValue infixBlock = v.asBlock();
                        IO.write8u(out, 17);
                        IO.write32s(out, (int)(8L * infixBlock.getWoSize()));
                        MarshalExtern.externRec(ctxt, out, infixBlock.getParent(), objTable, sizes, ignoreSharing, closures);
                        break;
                    }
                    case 255: {
                        CustomOperations ops = v.getCustomOperations();
                        if (!ops.isSerializable()) {
                            Fail.invalidArgument("output_value: abstract value (Custom)");
                        }
                        IO.write8u(out, 18);
                        out.write(EncodingUtils.convertStringToBytes(ops.getIdentifier()));
                        IO.write8u(out, 0);
                        CustomOperations.SerializationSizes tmpSizes = ops.serialize(out, v);
                        sizes.size32 += 2L + (tmpSizes.size32 + 3L >> 2);
                        sizes.size64 += 2L + (tmpSizes.size64 + 7L >> 3);
                        break;
                    }
                    default: {
                        if (tag < 16 && sz < 8L) {
                            IO.write8u(out, 128 + tag + ((int)sz << 4));
                        } else if (sz > Integer.MAX_VALUE) {
                            IO.write8u(out, 19);
                            IO.write64s(out, hd);
                        } else {
                            IO.write8u(out, 8);
                            IO.write32s(out, (int)hd);
                        }
                        sizes.size32 += 1L + sz;
                        sizes.size64 += 1L + sz;
                        Value field0 = v.get0();
                        if (sz > 1L) {
                            stack.add(0, new StackItem(v, 1L, sz));
                        }
                        v = field0;
                        continue block8;
                    }
                }
                nextItem = true;
                continue;
            }
            if (v.isCodeOffset()) {
                int ofs = (int)v.asCodeOffset();
                CodeState.Fragment fragment = ctxt.getCodeState().getFragment(ofs);
                if (!closures || fragment == null) {
                    Fail.invalidArgument("output_value: functional value");
                }
                IO.write8u(out, 16);
                IO.write32s(out, ofs - fragment.codeStart);
                out.write(fragment.codeDigest);
                nextItem = true;
                continue;
            }
            Fail.invalidArgument("output_value: abstract value (outside heap)");
        }
    }

    private static int indexOf(List<Value> objTable, Value v) {
        assert (objTable != null) : "null objTable";
        assert (v != null) : "null v";
        Iterator<Value> it = objTable.iterator();
        int idx = 0;
        while (it.hasNext()) {
            Value x = it.next();
            boolean xb = x.isBlock();
            boolean vb = v.isBlock();
            if (xb && vb && x == v || !xb && !vb && x.getRawValue() == v.getRawValue()) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    private static final class StackItem {
        private final Value value;
        private long next;
        private final long size;

        StackItem(Value v, long n, long sz) {
            this.value = v;
            this.next = n;
            this.size = sz;
        }

        Value nextItem() {
            if (this.next < this.size) {
                Value res = this.value.get(this.next);
                ++this.next;
                return res;
            }
            return null;
        }
    }
}

